@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.worklink.kotlin.inputs

import com.pulumi.aws.worklink.inputs.FleetNetworkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property securityGroupIds A list of security group IDs associated with access to the provided subnets.
 * **identity_provider** requires the following:
 * > **NOTE:** `identity_provider` cannot be removed without force recreating.
 * @property subnetIds A list of subnet IDs used for X-ENI connections from Amazon WorkLink rendering containers.
 * @property vpcId The VPC ID with connectivity to associated websites.
 */
public data class FleetNetworkArgs(
    public val securityGroupIds: Output<List<String>>,
    public val subnetIds: Output<List<String>>,
    public val vpcId: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.worklink.inputs.FleetNetworkArgs> {
    override fun toJava(): com.pulumi.aws.worklink.inputs.FleetNetworkArgs =
        com.pulumi.aws.worklink.inputs.FleetNetworkArgs.builder()
            .securityGroupIds(securityGroupIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetIds(subnetIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .vpcId(vpcId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FleetNetworkArgs].
 */
@PulumiTagMarker
public class FleetNetworkArgsBuilder internal constructor() {
    private var securityGroupIds: Output<List<String>>? = null

    private var subnetIds: Output<List<String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value A list of security group IDs associated with access to the provided subnets.
     * **identity_provider** requires the following:
     * > **NOTE:** `identity_provider` cannot be removed without force recreating.
     */
    @JvmName("fivbgojbyaxfhtka")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("fottmocotejmcgeb")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values A list of security group IDs associated with access to the provided subnets.
     * **identity_provider** requires the following:
     * > **NOTE:** `identity_provider` cannot be removed without force recreating.
     */
    @JvmName("gwcppratcpemxwdp")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value A list of subnet IDs used for X-ENI connections from Amazon WorkLink rendering containers.
     */
    @JvmName("digrypkeofgbqpbt")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("ywrsaivpsbewxeam")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values A list of subnet IDs used for X-ENI connections from Amazon WorkLink rendering containers.
     */
    @JvmName("jfxewoqhtkplwsym")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value The VPC ID with connectivity to associated websites.
     */
    @JvmName("cwjwniyyppeejpbn")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value A list of security group IDs associated with access to the provided subnets.
     * **identity_provider** requires the following:
     * > **NOTE:** `identity_provider` cannot be removed without force recreating.
     */
    @JvmName("nrarifmhxcwbwwcm")
    public suspend fun securityGroupIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values A list of security group IDs associated with access to the provided subnets.
     * **identity_provider** requires the following:
     * > **NOTE:** `identity_provider` cannot be removed without force recreating.
     */
    @JvmName("ipteuaywempodroj")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value A list of subnet IDs used for X-ENI connections from Amazon WorkLink rendering containers.
     */
    @JvmName("evdqipugdkqbjuid")
    public suspend fun subnetIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values A list of subnet IDs used for X-ENI connections from Amazon WorkLink rendering containers.
     */
    @JvmName("pussbghropqetkjn")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value The VPC ID with connectivity to associated websites.
     */
    @JvmName("lhowiwgivwqxvteo")
    public suspend fun vpcId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): FleetNetworkArgs = FleetNetworkArgs(
        securityGroupIds = securityGroupIds ?: throw PulumiNullFieldException("securityGroupIds"),
        subnetIds = subnetIds ?: throw PulumiNullFieldException("subnetIds"),
        vpcId = vpcId ?: throw PulumiNullFieldException("vpcId"),
    )
}
