@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.worklink.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property samlMetadata The SAML metadata document provided by the customer’s identity provider.
 * @property type The type of identity provider.
 */
public data class FleetIdentityProvider(
    public val samlMetadata: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.worklink.outputs.FleetIdentityProvider): FleetIdentityProvider = FleetIdentityProvider(
            samlMetadata = javaType.samlMetadata(),
            type = javaType.type(),
        )
    }
}
