@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.worklink.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property securityGroupIds A list of security group IDs associated with access to the provided subnets.
 * **identity_provider** requires the following:
 * > **NOTE:** `identity_provider` cannot be removed without force recreating.
 * @property subnetIds A list of subnet IDs used for X-ENI connections from Amazon WorkLink rendering containers.
 * @property vpcId The VPC ID with connectivity to associated websites.
 */
public data class FleetNetwork(
    public val securityGroupIds: List<String>,
    public val subnetIds: List<String>,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.worklink.outputs.FleetNetwork): FleetNetwork =
            FleetNetwork(
                securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
                subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
                vpcId = javaType.vpcId(),
            )
    }
}
