@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin

import com.pulumi.aws.workspaces.ConnectionAliasArgs.builder
import com.pulumi.aws.workspaces.kotlin.inputs.ConnectionAliasTimeoutsArgs
import com.pulumi.aws.workspaces.kotlin.inputs.ConnectionAliasTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS WorkSpaces Connection Alias.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.workspaces.ConnectionAlias("example", {connectionString: "testdomain.test"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.workspaces.ConnectionAlias("example", connection_string="testdomain.test")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Workspaces.ConnectionAlias("example", new()
 *     {
 *         ConnectionString = "testdomain.test",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/workspaces"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workspaces.NewConnectionAlias(ctx, "example", &workspaces.ConnectionAliasArgs{
 * 			ConnectionString: pulumi.String("testdomain.test"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.workspaces.ConnectionAlias;
 * import com.pulumi.aws.workspaces.ConnectionAliasArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ConnectionAlias("example", ConnectionAliasArgs.builder()
 *             .connectionString("testdomain.test")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:workspaces:ConnectionAlias
 *     properties:
 *       connectionString: testdomain.test
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import WorkSpaces Connection Alias using the connection alias ID. For example:
 * ```sh
 * $ pulumi import aws:workspaces/connectionAlias:ConnectionAlias example rft-8012925589
 * ```
 * @property connectionString The connection string specified for the connection alias. The connection string must be in the form of a fully qualified domain name (FQDN), such as www.example.com.
 * @property tags A map of tags assigned to the WorkSpaces Connection Alias. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timeouts
 */
public data class ConnectionAliasArgs(
    public val connectionString: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeouts: Output<ConnectionAliasTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.workspaces.ConnectionAliasArgs> {
    override fun toJava(): com.pulumi.aws.workspaces.ConnectionAliasArgs =
        com.pulumi.aws.workspaces.ConnectionAliasArgs.builder()
            .connectionString(connectionString?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ConnectionAliasArgs].
 */
@PulumiTagMarker
public class ConnectionAliasArgsBuilder internal constructor() {
    private var connectionString: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeouts: Output<ConnectionAliasTimeoutsArgs>? = null

    /**
     * @param value The connection string specified for the connection alias. The connection string must be in the form of a fully qualified domain name (FQDN), such as www.example.com.
     */
    @JvmName("fottrwjmddwaelyq")
    public suspend fun connectionString(`value`: Output<String>) {
        this.connectionString = value
    }

    /**
     * @param value A map of tags assigned to the WorkSpaces Connection Alias. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xhqpklkvqjawnfhe")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("dhoevrfomemgabpc")
    public suspend fun timeouts(`value`: Output<ConnectionAliasTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value The connection string specified for the connection alias. The connection string must be in the form of a fully qualified domain name (FQDN), such as www.example.com.
     */
    @JvmName("haxcxgqjvvhaqubo")
    public suspend fun connectionString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionString = mapped
    }

    /**
     * @param value A map of tags assigned to the WorkSpaces Connection Alias. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yilayxojlisklxwt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags assigned to the WorkSpaces Connection Alias. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bvpdfyqebjtbbcge")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("gdulrgichnqpqhpf")
    public suspend fun timeouts(`value`: ConnectionAliasTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("cnqrhbsuftkydveh")
    public suspend fun timeouts(argument: suspend ConnectionAliasTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionAliasTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): ConnectionAliasArgs = ConnectionAliasArgs(
        connectionString = connectionString,
        tags = tags,
        timeouts = timeouts,
    )
}
