@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin

import com.pulumi.aws.workspaces.DirectoryArgs.builder
import com.pulumi.aws.workspaces.kotlin.inputs.DirectorySelfServicePermissionsArgs
import com.pulumi.aws.workspaces.kotlin.inputs.DirectorySelfServicePermissionsArgsBuilder
import com.pulumi.aws.workspaces.kotlin.inputs.DirectoryWorkspaceAccessPropertiesArgs
import com.pulumi.aws.workspaces.kotlin.inputs.DirectoryWorkspaceAccessPropertiesArgsBuilder
import com.pulumi.aws.workspaces.kotlin.inputs.DirectoryWorkspaceCreationPropertiesArgs
import com.pulumi.aws.workspaces.kotlin.inputs.DirectoryWorkspaceCreationPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a WorkSpaces directory in AWS WorkSpaces Service.
 * > **NOTE:** AWS WorkSpaces service requires [`workspaces_DefaultRole`](https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role) IAM role to operate normally.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleVpc = new aws.ec2.Vpc("example", {cidrBlock: "10.0.0.0/16"});
 * const exampleA = new aws.ec2.Subnet("example_a", {
 *     vpcId: exampleVpc.id,
 *     availabilityZone: "us-east-1a",
 *     cidrBlock: "10.0.0.0/24",
 * });
 * const exampleB = new aws.ec2.Subnet("example_b", {
 *     vpcId: exampleVpc.id,
 *     availabilityZone: "us-east-1b",
 *     cidrBlock: "10.0.1.0/24",
 * });
 * const exampleDirectory = new aws.directoryservice.Directory("example", {
 *     name: "corp.example.com",
 *     password: "#S1ncerely",
 *     size: "Small",
 *     vpcSettings: {
 *         vpcId: exampleVpc.id,
 *         subnetIds: [
 *             exampleA.id,
 *             exampleB.id,
 *         ],
 *     },
 * });
 * const workspaces = aws.iam.getPolicyDocument({
 *     statements: [{
 *         actions: ["sts:AssumeRole"],
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["workspaces&#46;amazonaws&#46;com"],
 *         }],
 *     }],
 * });
 * const workspacesDefault = new aws.iam.Role("workspaces_default", {
 *     name: "workspaces_DefaultRole",
 *     assumeRolePolicy: workspaces.then(workspaces => workspaces.json),
 * });
 * const workspacesDefaultServiceAccess = new aws.iam.RolePolicyAttachment("workspaces_default_service_access", {
 *     role: workspacesDefault.name,
 *     policyArn: "arn:aws:iam::aws:policy/AmazonWorkSpacesServiceAccess",
 * });
 * const workspacesDefaultSelfServiceAccess = new aws.iam.RolePolicyAttachment("workspaces_default_self_service_access", {
 *     role: workspacesDefault.name,
 *     policyArn: "arn:aws:iam::aws:policy/AmazonWorkSpacesSelfServiceAccess",
 * });
 * const exampleC = new aws.ec2.Subnet("example_c", {
 *     vpcId: exampleVpc.id,
 *     availabilityZone: "us-east-1c",
 *     cidrBlock: "10.0.2.0/24",
 * });
 * const exampleD = new aws.ec2.Subnet("example_d", {
 *     vpcId: exampleVpc.id,
 *     availabilityZone: "us-east-1d",
 *     cidrBlock: "10.0.3.0/24",
 * });
 * const example = new aws.workspaces.Directory("example", {
 *     directoryId: exampleDirectory.id,
 *     subnetIds: [
 *         exampleC.id,
 *         exampleD.id,
 *     ],
 *     tags: {
 *         Example: "true",
 *     },
 *     selfServicePermissions: {
 *         changeComputeType: true,
 *         increaseVolumeSize: true,
 *         rebuildWorkspace: true,
 *         restartWorkspace: true,
 *         switchRunningMode: true,
 *     },
 *     workspaceAccessProperties: {
 *         deviceTypeAndroid: "ALLOW",
 *         deviceTypeChromeos: "ALLOW",
 *         deviceTypeIos: "ALLOW",
 *         deviceTypeLinux: "DENY",
 *         deviceTypeOsx: "ALLOW",
 *         deviceTypeWeb: "DENY",
 *         deviceTypeWindows: "DENY",
 *         deviceTypeZeroclient: "DENY",
 *     },
 *     workspaceCreationProperties: {
 *         customSecurityGroupId: exampleAwsSecurityGroup.id,
 *         defaultOu: "OU=AWS,DC=Workgroup,DC=Example,DC=com",
 *         enableInternetAccess: true,
 *         enableMaintenanceMode: true,
 *         userEnabledAsLocalAdministrator: true,
 *     },
 * }, {
 *     dependsOn: [
 *         workspacesDefaultServiceAccess,
 *         workspacesDefaultSelfServiceAccess,
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_vpc = aws.ec2.Vpc("example", cidr_block="10.0.0.0/16")
 * example_a = aws.ec2.Subnet("example_a",
 *     vpc_id=example_vpc.id,
 *     availability_zone="us-east-1a",
 *     cidr_block="10.0.0.0/24")
 * example_b = aws.ec2.Subnet("example_b",
 *     vpc_id=example_vpc.id,
 *     availability_zone="us-east-1b",
 *     cidr_block="10.0.1.0/24")
 * example_directory = aws.directoryservice.Directory("example",
 *     name="corp.example.com",
 *     password="#S1ncerely",
 *     size="Small",
 *     vpc_settings={
 *         "vpc_id": example_vpc.id,
 *         "subnet_ids": [
 *             example_a.id,
 *             example_b.id,
 *         ],
 *     })
 * workspaces = aws.iam.get_policy_document(statements=[{
 *     "actions": ["sts:AssumeRole"],
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["workspaces&#46;amazonaws&#46;com"],
 *     }],
 * }])
 * workspaces_default = aws.iam.Role("workspaces_default",
 *     name="workspaces_DefaultRole",
 *     assume_role_policy=workspaces.json)
 * workspaces_default_service_access = aws.iam.RolePolicyAttachment("workspaces_default_service_access",
 *     role=workspaces_default.name,
 *     policy_arn="arn:aws:iam::aws:policy/AmazonWorkSpacesServiceAccess")
 * workspaces_default_self_service_access = aws.iam.RolePolicyAttachment("workspaces_default_self_service_access",
 *     role=workspaces_default.name,
 *     policy_arn="arn:aws:iam::aws:policy/AmazonWorkSpacesSelfServiceAccess")
 * example_c = aws.ec2.Subnet("example_c",
 *     vpc_id=example_vpc.id,
 *     availability_zone="us-east-1c",
 *     cidr_block="10.0.2.0/24")
 * example_d = aws.ec2.Subnet("example_d",
 *     vpc_id=example_vpc.id,
 *     availability_zone="us-east-1d",
 *     cidr_block="10.0.3.0/24")
 * example = aws.workspaces.Directory("example",
 *     directory_id=example_directory.id,
 *     subnet_ids=[
 *         example_c.id,
 *         example_d.id,
 *     ],
 *     tags={
 *         "Example": "true",
 *     },
 *     self_service_permissions={
 *         "change_compute_type": True,
 *         "increase_volume_size": True,
 *         "rebuild_workspace": True,
 *         "restart_workspace": True,
 *         "switch_running_mode": True,
 *     },
 *     workspace_access_properties={
 *         "device_type_android": "ALLOW",
 *         "device_type_chromeos": "ALLOW",
 *         "device_type_ios": "ALLOW",
 *         "device_type_linux": "DENY",
 *         "device_type_osx": "ALLOW",
 *         "device_type_web": "DENY",
 *         "device_type_windows": "DENY",
 *         "device_type_zeroclient": "DENY",
 *     },
 *     workspace_creation_properties={
 *         "custom_security_group_id": example_aws_security_group["id"],
 *         "default_ou": "OU=AWS,DC=Workgroup,DC=Example,DC=com",
 *         "enable_internet_access": True,
 *         "enable_maintenance_mode": True,
 *         "user_enabled_as_local_administrator": True,
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[
 *             workspaces_default_service_access,
 *             workspaces_default_self_service_access,
 *         ]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleVpc = new Aws.Ec2.Vpc("example", new()
 *     {
 *         CidrBlock = "10.0.0.0/16",
 *     });
 *     var exampleA = new Aws.Ec2.Subnet("example_a", new()
 *     {
 *         VpcId = exampleVpc.Id,
 *         AvailabilityZone = "us-east-1a",
 *         CidrBlock = "10.0.0.0/24",
 *     });
 *     var exampleB = new Aws.Ec2.Subnet("example_b", new()
 *     {
 *         VpcId = exampleVpc.Id,
 *         AvailabilityZone = "us-east-1b",
 *         CidrBlock = "10.0.1.0/24",
 *     });
 *     var exampleDirectory = new Aws.DirectoryService.Directory("example", new()
 *     {
 *         Name = "corp.example.com",
 *         Password = "#S1ncerely",
 *         Size = "Small",
 *         VpcSettings = new Aws.DirectoryService.Inputs.DirectoryVpcSettingsArgs
 *         {
 *             VpcId = exampleVpc.Id,
 *             SubnetIds = new[]
 *             {
 *                 exampleA.Id,
 *                 exampleB.Id,
 *             },
 *         },
 *     });
 *     var workspaces = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "workspaces.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var workspacesDefault = new Aws.Iam.Role("workspaces_default", new()
 *     {
 *         Name = "workspaces_DefaultRole",
 *         AssumeRolePolicy = workspaces.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var workspacesDefaultServiceAccess = new Aws.Iam.RolePolicyAttachment("workspaces_default_service_access", new()
 *     {
 *         Role = workspacesDefault.Name,
 *         PolicyArn = "arn:aws:iam::aws:policy/AmazonWorkSpacesServiceAccess",
 *     });
 *     var workspacesDefaultSelfServiceAccess = new Aws.Iam.RolePolicyAttachment("workspaces_default_self_service_access", new()
 *     {
 *         Role = workspacesDefault.Name,
 *         PolicyArn = "arn:aws:iam::aws:policy/AmazonWorkSpacesSelfServiceAccess",
 *     });
 *     var exampleC = new Aws.Ec2.Subnet("example_c", new()
 *     {
 *         VpcId = exampleVpc.Id,
 *         AvailabilityZone = "us-east-1c",
 *         CidrBlock = "10.0.2.0/24",
 *     });
 *     var exampleD = new Aws.Ec2.Subnet("example_d", new()
 *     {
 *         VpcId = exampleVpc.Id,
 *         AvailabilityZone = "us-east-1d",
 *         CidrBlock = "10.0.3.0/24",
 *     });
 *     var example = new Aws.Workspaces.Directory("example", new()
 *     {
 *         DirectoryId = exampleDirectory.Id,
 *         SubnetIds = new[]
 *         {
 *             exampleC.Id,
 *             exampleD.Id,
 *         },
 *         Tags =
 *         {
 *             { "Example", "true" },
 *         },
 *         SelfServicePermissions = new Aws.Workspaces.Inputs.DirectorySelfServicePermissionsArgs
 *         {
 *             ChangeComputeType = true,
 *             IncreaseVolumeSize = true,
 *             RebuildWorkspace = true,
 *             RestartWorkspace = true,
 *             SwitchRunningMode = true,
 *         },
 *         WorkspaceAccessProperties = new Aws.Workspaces.Inputs.DirectoryWorkspaceAccessPropertiesArgs
 *         {
 *             DeviceTypeAndroid = "ALLOW",
 *             DeviceTypeChromeos = "ALLOW",
 *             DeviceTypeIos = "ALLOW",
 *             DeviceTypeLinux = "DENY",
 *             DeviceTypeOsx = "ALLOW",
 *             DeviceTypeWeb = "DENY",
 *             DeviceTypeWindows = "DENY",
 *             DeviceTypeZeroclient = "DENY",
 *         },
 *         WorkspaceCreationProperties = new Aws.Workspaces.Inputs.DirectoryWorkspaceCreationPropertiesArgs
 *         {
 *             CustomSecurityGroupId = exampleAwsSecurityGroup.Id,
 *             DefaultOu = "OU=AWS,DC=Workgroup,DC=Example,DC=com",
 *             EnableInternetAccess = true,
 *             EnableMaintenanceMode = true,
 *             UserEnabledAsLocalAdministrator = true,
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             workspacesDefaultServiceAccess,
 *             workspacesDefaultSelfServiceAccess,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/directoryservice"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ec2"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/workspaces"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleVpc, err := ec2.NewVpc(ctx, "example", &ec2.VpcArgs{
 * 			CidrBlock: pulumi.String("10.0.0.0/16"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleA, err := ec2.NewSubnet(ctx, "example_a", &ec2.SubnetArgs{
 * 			VpcId:            exampleVpc.ID(),
 * 			AvailabilityZone: pulumi.String("us-east-1a"),
 * 			CidrBlock:        pulumi.String("10.0.0.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleB, err := ec2.NewSubnet(ctx, "example_b", &ec2.SubnetArgs{
 * 			VpcId:            exampleVpc.ID(),
 * 			AvailabilityZone: pulumi.String("us-east-1b"),
 * 			CidrBlock:        pulumi.String("10.0.1.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleDirectory, err := directoryservice.NewDirectory(ctx, "example", &directoryservice.DirectoryArgs{
 * 			Name:     pulumi.String("corp.example.com"),
 * 			Password: pulumi.String("#S1ncerely"),
 * 			Size:     pulumi.String("Small"),
 * 			VpcSettings: &directoryservice.DirectoryVpcSettingsArgs{
 * 				VpcId: exampleVpc.ID(),
 * 				SubnetIds: pulumi.StringArray{
 * 					exampleA.ID(),
 * 					exampleB.ID(),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		workspaces, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Actions: []string{
 * 						"sts:AssumeRole",
 * 					},
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"workspaces.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		workspacesDefault, err := iam.NewRole(ctx, "workspaces_default", &iam.RoleArgs{
 * 			Name:             pulumi.String("workspaces_DefaultRole"),
 * 			AssumeRolePolicy: pulumi.String(workspaces.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		workspacesDefaultServiceAccess, err := iam.NewRolePolicyAttachment(ctx, "workspaces_default_service_access", &iam.RolePolicyAttachmentArgs{
 * 			Role:      workspacesDefault.Name,
 * 			PolicyArn: pulumi.String("arn:aws:iam::aws:policy/AmazonWorkSpacesServiceAccess"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		workspacesDefaultSelfServiceAccess, err := iam.NewRolePolicyAttachment(ctx, "workspaces_default_self_service_access", &iam.RolePolicyAttachmentArgs{
 * 			Role:      workspacesDefault.Name,
 * 			PolicyArn: pulumi.String("arn:aws:iam::aws:policy/AmazonWorkSpacesSelfServiceAccess"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleC, err := ec2.NewSubnet(ctx, "example_c", &ec2.SubnetArgs{
 * 			VpcId:            exampleVpc.ID(),
 * 			AvailabilityZone: pulumi.String("us-east-1c"),
 * 			CidrBlock:        pulumi.String("10.0.2.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleD, err := ec2.NewSubnet(ctx, "example_d", &ec2.SubnetArgs{
 * 			VpcId:            exampleVpc.ID(),
 * 			AvailabilityZone: pulumi.String("us-east-1d"),
 * 			CidrBlock:        pulumi.String("10.0.3.0/24"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = workspaces.NewDirectory(ctx, "example", &workspaces.DirectoryArgs{
 * 			DirectoryId: exampleDirectory.ID(),
 * 			SubnetIds: pulumi.StringArray{
 * 				exampleC.ID(),
 * 				exampleD.ID(),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Example": pulumi.String("true"),
 * 			},
 * 			SelfServicePermissions: &workspaces.DirectorySelfServicePermissionsArgs{
 * 				ChangeComputeType:  pulumi.Bool(true),
 * 				IncreaseVolumeSize: pulumi.Bool(true),
 * 				RebuildWorkspace:   pulumi.Bool(true),
 * 				RestartWorkspace:   pulumi.Bool(true),
 * 				SwitchRunningMode:  pulumi.Bool(true),
 * 			},
 * 			WorkspaceAccessProperties: &workspaces.DirectoryWorkspaceAccessPropertiesArgs{
 * 				DeviceTypeAndroid:    pulumi.String("ALLOW"),
 * 				DeviceTypeChromeos:   pulumi.String("ALLOW"),
 * 				DeviceTypeIos:        pulumi.String("ALLOW"),
 * 				DeviceTypeLinux:      pulumi.String("DENY"),
 * 				DeviceTypeOsx:        pulumi.String("ALLOW"),
 * 				DeviceTypeWeb:        pulumi.String("DENY"),
 * 				DeviceTypeWindows:    pulumi.String("DENY"),
 * 				DeviceTypeZeroclient: pulumi.String("DENY"),
 * 			},
 * 			WorkspaceCreationProperties: &workspaces.DirectoryWorkspaceCreationPropertiesArgs{
 * 				CustomSecurityGroupId:           pulumi.Any(exampleAwsSecurityGroup.Id),
 * 				DefaultOu:                       pulumi.String("OU=AWS,DC=Workgroup,DC=Example,DC=com"),
 * 				EnableInternetAccess:            pulumi.Bool(true),
 * 				EnableMaintenanceMode:           pulumi.Bool(true),
 * 				UserEnabledAsLocalAdministrator: pulumi.Bool(true),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			workspacesDefaultServiceAccess,
 * 			workspacesDefaultSelfServiceAccess,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ec2.Vpc;
 * import com.pulumi.aws.ec2.VpcArgs;
 * import com.pulumi.aws.ec2.Subnet;
 * import com.pulumi.aws.ec2.SubnetArgs;
 * import com.pulumi.aws.directoryservice.Directory;
 * import com.pulumi.aws.directoryservice.DirectoryArgs;
 * import com.pulumi.aws.directoryservice.inputs.DirectoryVpcSettingsArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.workspaces.Directory;
 * import com.pulumi.aws.workspaces.DirectoryArgs;
 * import com.pulumi.aws.workspaces.inputs.DirectorySelfServicePermissionsArgs;
 * import com.pulumi.aws.workspaces.inputs.DirectoryWorkspaceAccessPropertiesArgs;
 * import com.pulumi.aws.workspaces.inputs.DirectoryWorkspaceCreationPropertiesArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleVpc = new Vpc("exampleVpc", VpcArgs.builder()
 *             .cidrBlock("10.0.0.0/16")
 *             .build());
 *         var exampleA = new Subnet("exampleA", SubnetArgs.builder()
 *             .vpcId(exampleVpc.id())
 *             .availabilityZone("us-east-1a")
 *             .cidrBlock("10.0.0.0/24")
 *             .build());
 *         var exampleB = new Subnet("exampleB", SubnetArgs.builder()
 *             .vpcId(exampleVpc.id())
 *             .availabilityZone("us-east-1b")
 *             .cidrBlock("10.0.1.0/24")
 *             .build());
 *         var exampleDirectory = new Directory("exampleDirectory", DirectoryArgs.builder()
 *             .name("corp.example.com")
 *             .password("#S1ncerely")
 *             .size("Small")
 *             .vpcSettings(DirectoryVpcSettingsArgs.builder()
 *                 .vpcId(exampleVpc.id())
 *                 .subnetIds(
 *                     exampleA.id(),
 *                     exampleB.id())
 *                 .build())
 *             .build());
 *         final var workspaces = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .actions("sts:AssumeRole")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("workspaces.amazonaws.com")
 *                     .build())
 *                 .build())
 *             .build());
 *         var workspacesDefault = new Role("workspacesDefault", RoleArgs.builder()
 *             .name("workspaces_DefaultRole")
 *             .assumeRolePolicy(workspaces.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var workspacesDefaultServiceAccess = new RolePolicyAttachment("workspacesDefaultServiceAccess", RolePolicyAttachmentArgs.builder()
 *             .role(workspacesDefault.name())
 *             .policyArn("arn:aws:iam::aws:policy/AmazonWorkSpacesServiceAccess")
 *             .build());
 *         var workspacesDefaultSelfServiceAccess = new RolePolicyAttachment("workspacesDefaultSelfServiceAccess", RolePolicyAttachmentArgs.builder()
 *             .role(workspacesDefault.name())
 *             .policyArn("arn:aws:iam::aws:policy/AmazonWorkSpacesSelfServiceAccess")
 *             .build());
 *         var exampleC = new Subnet("exampleC", SubnetArgs.builder()
 *             .vpcId(exampleVpc.id())
 *             .availabilityZone("us-east-1c")
 *             .cidrBlock("10.0.2.0/24")
 *             .build());
 *         var exampleD = new Subnet("exampleD", SubnetArgs.builder()
 *             .vpcId(exampleVpc.id())
 *             .availabilityZone("us-east-1d")
 *             .cidrBlock("10.0.3.0/24")
 *             .build());
 *         var example = new Directory("example", DirectoryArgs.builder()
 *             .directoryId(exampleDirectory.id())
 *             .subnetIds(
 *                 exampleC.id(),
 *                 exampleD.id())
 *             .tags(Map.of("Example", true))
 *             .selfServicePermissions(DirectorySelfServicePermissionsArgs.builder()
 *                 .changeComputeType(true)
 *                 .increaseVolumeSize(true)
 *                 .rebuildWorkspace(true)
 *                 .restartWorkspace(true)
 *                 .switchRunningMode(true)
 *                 .build())
 *             .workspaceAccessProperties(DirectoryWorkspaceAccessPropertiesArgs.builder()
 *                 .deviceTypeAndroid("ALLOW")
 *                 .deviceTypeChromeos("ALLOW")
 *                 .deviceTypeIos("ALLOW")
 *                 .deviceTypeLinux("DENY")
 *                 .deviceTypeOsx("ALLOW")
 *                 .deviceTypeWeb("DENY")
 *                 .deviceTypeWindows("DENY")
 *                 .deviceTypeZeroclient("DENY")
 *                 .build())
 *             .workspaceCreationProperties(DirectoryWorkspaceCreationPropertiesArgs.builder()
 *                 .customSecurityGroupId(exampleAwsSecurityGroup.id())
 *                 .defaultOu("OU=AWS,DC=Workgroup,DC=Example,DC=com")
 *                 .enableInternetAccess(true)
 *                 .enableMaintenanceMode(true)
 *                 .userEnabledAsLocalAdministrator(true)
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(
 *                     workspacesDefaultServiceAccess,
 *                     workspacesDefaultSelfServiceAccess)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:workspaces:Directory
 *     properties:
 *       directoryId: ${exampleDirectory.id}
 *       subnetIds:
 *         - ${exampleC.id}
 *         - ${exampleD.id}
 *       tags:
 *         Example: true
 *       selfServicePermissions:
 *         changeComputeType: true
 *         increaseVolumeSize: true
 *         rebuildWorkspace: true
 *         restartWorkspace: true
 *         switchRunningMode: true
 *       workspaceAccessProperties:
 *         deviceTypeAndroid: ALLOW
 *         deviceTypeChromeos: ALLOW
 *         deviceTypeIos: ALLOW
 *         deviceTypeLinux: DENY
 *         deviceTypeOsx: ALLOW
 *         deviceTypeWeb: DENY
 *         deviceTypeWindows: DENY
 *         deviceTypeZeroclient: DENY
 *       workspaceCreationProperties:
 *         customSecurityGroupId: ${exampleAwsSecurityGroup.id}
 *         defaultOu: OU=AWS,DC=Workgroup,DC=Example,DC=com
 *         enableInternetAccess: true
 *         enableMaintenanceMode: true
 *         userEnabledAsLocalAdministrator: true
 *     options:
 *       dependson:
 *         - ${workspacesDefaultServiceAccess}
 *         - ${workspacesDefaultSelfServiceAccess}
 *   exampleDirectory:
 *     type: aws:directoryservice:Directory
 *     name: example
 *     properties:
 *       name: corp.example.com
 *       password: '#S1ncerely'
 *       size: Small
 *       vpcSettings:
 *         vpcId: ${exampleVpc.id}
 *         subnetIds:
 *           - ${exampleA.id}
 *           - ${exampleB.id}
 *   workspacesDefault:
 *     type: aws:iam:Role
 *     name: workspaces_default
 *     properties:
 *       name: workspaces_DefaultRole
 *       assumeRolePolicy: ${workspaces.json}
 *   workspacesDefaultServiceAccess:
 *     type: aws:iam:RolePolicyAttachment
 *     name: workspaces_default_service_access
 *     properties:
 *       role: ${workspacesDefault.name}
 *       policyArn: arn:aws:iam::aws:policy/AmazonWorkSpacesServiceAccess
 *   workspacesDefaultSelfServiceAccess:
 *     type: aws:iam:RolePolicyAttachment
 *     name: workspaces_default_self_service_access
 *     properties:
 *       role: ${workspacesDefault.name}
 *       policyArn: arn:aws:iam::aws:policy/AmazonWorkSpacesSelfServiceAccess
 *   exampleVpc:
 *     type: aws:ec2:Vpc
 *     name: example
 *     properties:
 *       cidrBlock: 10.0.0.0/16
 *   exampleA:
 *     type: aws:ec2:Subnet
 *     name: example_a
 *     properties:
 *       vpcId: ${exampleVpc.id}
 *       availabilityZone: us-east-1a
 *       cidrBlock: 10.0.0.0/24
 *   exampleB:
 *     type: aws:ec2:Subnet
 *     name: example_b
 *     properties:
 *       vpcId: ${exampleVpc.id}
 *       availabilityZone: us-east-1b
 *       cidrBlock: 10.0.1.0/24
 *   exampleC:
 *     type: aws:ec2:Subnet
 *     name: example_c
 *     properties:
 *       vpcId: ${exampleVpc.id}
 *       availabilityZone: us-east-1c
 *       cidrBlock: 10.0.2.0/24
 *   exampleD:
 *     type: aws:ec2:Subnet
 *     name: example_d
 *     properties:
 *       vpcId: ${exampleVpc.id}
 *       availabilityZone: us-east-1d
 *       cidrBlock: 10.0.3.0/24
 * variables:
 *   workspaces:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - actions:
 *               - sts:AssumeRole
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - workspaces.amazonaws.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ### IP Groups
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleIpGroup = new aws.workspaces.IpGroup("example", {name: "example"});
 * const example = new aws.workspaces.Directory("example", {
 *     directoryId: exampleAwsDirectoryServiceDirectory.id,
 *     ipGroupIds: [exampleIpGroup&#46;id],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_ip_group = aws.workspaces.IpGroup("example", name="example")
 * example = aws.workspaces.Directory("example",
 *     directory_id=example_aws_directory_service_directory["id"],
 *     ip_group_ids=[example_ip_group&#46;id])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleIpGroup = new Aws.Workspaces.IpGroup("example", new()
 *     {
 *         Name = "example",
 *     });
 *     var example = new Aws.Workspaces.Directory("example", new()
 *     {
 *         DirectoryId = exampleAwsDirectoryServiceDirectory.Id,
 *         IpGroupIds = new[]
 *         {
 *             exampleIpGroup.Id,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/workspaces"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleIpGroup, err := workspaces.NewIpGroup(ctx, "example", &workspaces.IpGroupArgs{
 * 			Name: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = workspaces.NewDirectory(ctx, "example", &workspaces.DirectoryArgs{
 * 			DirectoryId: pulumi.Any(exampleAwsDirectoryServiceDirectory.Id),
 * 			IpGroupIds: pulumi.StringArray{
 * 				exampleIpGroup.ID(),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.workspaces.IpGroup;
 * import com.pulumi.aws.workspaces.IpGroupArgs;
 * import com.pulumi.aws.workspaces.Directory;
 * import com.pulumi.aws.workspaces.DirectoryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleIpGroup = new IpGroup("exampleIpGroup", IpGroupArgs.builder()
 *             .name("example")
 *             .build());
 *         var example = new Directory("example", DirectoryArgs.builder()
 *             .directoryId(exampleAwsDirectoryServiceDirectory.id())
 *             .ipGroupIds(exampleIpGroup.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:workspaces:Directory
 *     properties:
 *       directoryId: ${exampleAwsDirectoryServiceDirectory.id}
 *       ipGroupIds:
 *         - ${exampleIpGroup.id}
 *   exampleIpGroup:
 *     type: aws:workspaces:IpGroup
 *     name: example
 *     properties:
 *       name: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Workspaces directory using the directory ID. For example:
 * ```sh
 * $ pulumi import aws:workspaces/directory:Directory main d-4444444444
 * ```
 * @property directoryId The directory identifier for registration in WorkSpaces service.
 * @property ipGroupIds The identifiers of the IP access control groups associated with the directory.
 * @property selfServicePermissions Permissions to enable or disable self-service capabilities. Defined below.
 * @property subnetIds The identifiers of the subnets where the directory resides.
 * @property tags A map of tags assigned to the WorkSpaces directory. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property workspaceAccessProperties Specifies which devices and operating systems users can use to access their WorkSpaces. Defined below.
 * @property workspaceCreationProperties Default properties that are used for creating WorkSpaces. Defined below.
 */
public data class DirectoryArgs(
    public val directoryId: Output<String>? = null,
    public val ipGroupIds: Output<List<String>>? = null,
    public val selfServicePermissions: Output<DirectorySelfServicePermissionsArgs>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workspaceAccessProperties: Output<DirectoryWorkspaceAccessPropertiesArgs>? = null,
    public val workspaceCreationProperties: Output<DirectoryWorkspaceCreationPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.workspaces.DirectoryArgs> {
    override fun toJava(): com.pulumi.aws.workspaces.DirectoryArgs =
        com.pulumi.aws.workspaces.DirectoryArgs.builder()
            .directoryId(directoryId?.applyValue({ args0 -> args0 }))
            .ipGroupIds(ipGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .selfServicePermissions(
                selfServicePermissions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workspaceAccessProperties(
                workspaceAccessProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .workspaceCreationProperties(
                workspaceCreationProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DirectoryArgs].
 */
@PulumiTagMarker
public class DirectoryArgsBuilder internal constructor() {
    private var directoryId: Output<String>? = null

    private var ipGroupIds: Output<List<String>>? = null

    private var selfServicePermissions: Output<DirectorySelfServicePermissionsArgs>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workspaceAccessProperties: Output<DirectoryWorkspaceAccessPropertiesArgs>? = null

    private var workspaceCreationProperties: Output<DirectoryWorkspaceCreationPropertiesArgs>? = null

    /**
     * @param value The directory identifier for registration in WorkSpaces service.
     */
    @JvmName("uswjjqofepalotnn")
    public suspend fun directoryId(`value`: Output<String>) {
        this.directoryId = value
    }

    /**
     * @param value The identifiers of the IP access control groups associated with the directory.
     */
    @JvmName("rmswkpisigtrahuc")
    public suspend fun ipGroupIds(`value`: Output<List<String>>) {
        this.ipGroupIds = value
    }

    @JvmName("pbxrqkiphnqjdjbb")
    public suspend fun ipGroupIds(vararg values: Output<String>) {
        this.ipGroupIds = Output.all(values.asList())
    }

    /**
     * @param values The identifiers of the IP access control groups associated with the directory.
     */
    @JvmName("pxgoskynvvkyrmsm")
    public suspend fun ipGroupIds(values: List<Output<String>>) {
        this.ipGroupIds = Output.all(values)
    }

    /**
     * @param value Permissions to enable or disable self-service capabilities. Defined below.
     */
    @JvmName("dwkxhlkdqfpaiwgt")
    public suspend fun selfServicePermissions(`value`: Output<DirectorySelfServicePermissionsArgs>) {
        this.selfServicePermissions = value
    }

    /**
     * @param value The identifiers of the subnets where the directory resides.
     */
    @JvmName("glknvspseeqmfmdu")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("rjoqeheiuhdactjm")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values The identifiers of the subnets where the directory resides.
     */
    @JvmName("dfddymxfrgpkkydc")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value A map of tags assigned to the WorkSpaces directory. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hgkdwcitllaugpdm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies which devices and operating systems users can use to access their WorkSpaces. Defined below.
     */
    @JvmName("xftrlvcyscnlshnv")
    public suspend fun workspaceAccessProperties(`value`: Output<DirectoryWorkspaceAccessPropertiesArgs>) {
        this.workspaceAccessProperties = value
    }

    /**
     * @param value Default properties that are used for creating WorkSpaces. Defined below.
     */
    @JvmName("pckgafaklwptpopn")
    public suspend fun workspaceCreationProperties(`value`: Output<DirectoryWorkspaceCreationPropertiesArgs>) {
        this.workspaceCreationProperties = value
    }

    /**
     * @param value The directory identifier for registration in WorkSpaces service.
     */
    @JvmName("xmrlmvqqataosjru")
    public suspend fun directoryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directoryId = mapped
    }

    /**
     * @param value The identifiers of the IP access control groups associated with the directory.
     */
    @JvmName("migwmytjcgkygvfu")
    public suspend fun ipGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipGroupIds = mapped
    }

    /**
     * @param values The identifiers of the IP access control groups associated with the directory.
     */
    @JvmName("fextvhmbgwkaugyb")
    public suspend fun ipGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipGroupIds = mapped
    }

    /**
     * @param value Permissions to enable or disable self-service capabilities. Defined below.
     */
    @JvmName("gkoxhrqxwvsqoift")
    public suspend fun selfServicePermissions(`value`: DirectorySelfServicePermissionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selfServicePermissions = mapped
    }

    /**
     * @param argument Permissions to enable or disable self-service capabilities. Defined below.
     */
    @JvmName("pxwvrfhfdcyopffp")
    public suspend fun selfServicePermissions(argument: suspend DirectorySelfServicePermissionsArgsBuilder.() -> Unit) {
        val toBeMapped = DirectorySelfServicePermissionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.selfServicePermissions = mapped
    }

    /**
     * @param value The identifiers of the subnets where the directory resides.
     */
    @JvmName("nrpvcgheextkpsth")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values The identifiers of the subnets where the directory resides.
     */
    @JvmName("iejlxutxkjcbxmmi")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value A map of tags assigned to the WorkSpaces directory. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nuqkuldqkuwnquux")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags assigned to the WorkSpaces directory. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fherarqlrbtbhwpo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Specifies which devices and operating systems users can use to access their WorkSpaces. Defined below.
     */
    @JvmName("xxqajxuskrplkggd")
    public suspend fun workspaceAccessProperties(`value`: DirectoryWorkspaceAccessPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceAccessProperties = mapped
    }

    /**
     * @param argument Specifies which devices and operating systems users can use to access their WorkSpaces. Defined below.
     */
    @JvmName("bvdhoddxphkhlysr")
    public suspend fun workspaceAccessProperties(argument: suspend DirectoryWorkspaceAccessPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DirectoryWorkspaceAccessPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.workspaceAccessProperties = mapped
    }

    /**
     * @param value Default properties that are used for creating WorkSpaces. Defined below.
     */
    @JvmName("feqnweinlswiatqn")
    public suspend fun workspaceCreationProperties(`value`: DirectoryWorkspaceCreationPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceCreationProperties = mapped
    }

    /**
     * @param argument Default properties that are used for creating WorkSpaces. Defined below.
     */
    @JvmName("wvwunmkohihjyjkn")
    public suspend fun workspaceCreationProperties(argument: suspend DirectoryWorkspaceCreationPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DirectoryWorkspaceCreationPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.workspaceCreationProperties = mapped
    }

    internal fun build(): DirectoryArgs = DirectoryArgs(
        directoryId = directoryId,
        ipGroupIds = ipGroupIds,
        selfServicePermissions = selfServicePermissions,
        subnetIds = subnetIds,
        tags = tags,
        workspaceAccessProperties = workspaceAccessProperties,
        workspaceCreationProperties = workspaceCreationProperties,
    )
}
