@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin

import com.pulumi.aws.workspaces.kotlin.outputs.IpGroupRule
import com.pulumi.aws.workspaces.kotlin.outputs.IpGroupRule.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [IpGroup].
 */
@PulumiTagMarker
public class IpGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IpGroupArgs = IpGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IpGroupArgsBuilder.() -> Unit) {
        val builder = IpGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IpGroup {
        val builtJavaResource = com.pulumi.aws.workspaces.IpGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IpGroup(builtJavaResource)
    }
}

/**
 * Provides an IP access control group in AWS WorkSpaces Service
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const contractors = new aws.workspaces.IpGroup("contractors", {
 *     name: "Contractors",
 *     description: "Contractors IP access control group",
 *     rules: [
 *         {
 *             source: "150.24.14.0/24",
 *             description: "NY",
 *         },
 *         {
 *             source: "125.191.14.85/32",
 *             description: "LA",
 *         },
 *         {
 *             source: "44.98.100.0/24",
 *             description: "STL",
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * contractors = aws.workspaces.IpGroup("contractors",
 *     name="Contractors",
 *     description="Contractors IP access control group",
 *     rules=[
 *         {
 *             "source": "150.24.14.0/24",
 *             "description": "NY",
 *         },
 *         {
 *             "source": "125.191.14.85/32",
 *             "description": "LA",
 *         },
 *         {
 *             "source": "44.98.100.0/24",
 *             "description": "STL",
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var contractors = new Aws.Workspaces.IpGroup("contractors", new()
 *     {
 *         Name = "Contractors",
 *         Description = "Contractors IP access control group",
 *         Rules = new[]
 *         {
 *             new Aws.Workspaces.Inputs.IpGroupRuleArgs
 *             {
 *                 Source = "150.24.14.0/24",
 *                 Description = "NY",
 *             },
 *             new Aws.Workspaces.Inputs.IpGroupRuleArgs
 *             {
 *                 Source = "125.191.14.85/32",
 *                 Description = "LA",
 *             },
 *             new Aws.Workspaces.Inputs.IpGroupRuleArgs
 *             {
 *                 Source = "44.98.100.0/24",
 *                 Description = "STL",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/workspaces"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workspaces.NewIpGroup(ctx, "contractors", &workspaces.IpGroupArgs{
 * 			Name:        pulumi.String("Contractors"),
 * 			Description: pulumi.String("Contractors IP access control group"),
 * 			Rules: workspaces.IpGroupRuleArray{
 * 				&workspaces.IpGroupRuleArgs{
 * 					Source:      pulumi.String("150.24.14.0/24"),
 * 					Description: pulumi.String("NY"),
 * 				},
 * 				&workspaces.IpGroupRuleArgs{
 * 					Source:      pulumi.String("125.191.14.85/32"),
 * 					Description: pulumi.String("LA"),
 * 				},
 * 				&workspaces.IpGroupRuleArgs{
 * 					Source:      pulumi.String("44.98.100.0/24"),
 * 					Description: pulumi.String("STL"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.workspaces.IpGroup;
 * import com.pulumi.aws.workspaces.IpGroupArgs;
 * import com.pulumi.aws.workspaces.inputs.IpGroupRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var contractors = new IpGroup("contractors", IpGroupArgs.builder()
 *             .name("Contractors")
 *             .description("Contractors IP access control group")
 *             .rules(
 *                 IpGroupRuleArgs.builder()
 *                     .source("150.24.14.0/24")
 *                     .description("NY")
 *                     .build(),
 *                 IpGroupRuleArgs.builder()
 *                     .source("125.191.14.85/32")
 *                     .description("LA")
 *                     .build(),
 *                 IpGroupRuleArgs.builder()
 *                     .source("44.98.100.0/24")
 *                     .description("STL")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   contractors:
 *     type: aws:workspaces:IpGroup
 *     properties:
 *       name: Contractors
 *       description: Contractors IP access control group
 *       rules:
 *         - source: 150.24.14.0/24
 *           description: NY
 *         - source: 125.191.14.85/32
 *           description: LA
 *         - source: 44.98.100.0/24
 *           description: STL
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import WorkSpaces IP groups using their GroupID. For example:
 * ```sh
 * $ pulumi import aws:workspaces/ipGroup:IpGroup example wsipg-488lrtl3k
 * ```
 */
public class IpGroup internal constructor(
    override val javaResource: com.pulumi.aws.workspaces.IpGroup,
) : KotlinCustomResource(javaResource, IpGroupMapper) {
    /**
     * The description of the IP group.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the IP group.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * One or more pairs specifying the IP group rule (in CIDR format) from which web requests originate.
     */
    public val rules: Output<List<IpGroupRule>>?
        get() = javaResource.rules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the WorkSpaces directory. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object IpGroupMapper : ResourceMapper<IpGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.workspaces.IpGroup::class == javaResource::class

    override fun map(javaResource: Resource): IpGroup = IpGroup(
        javaResource as
            com.pulumi.aws.workspaces.IpGroup,
    )
}

/**
 * @see [IpGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IpGroup].
 */
public suspend fun ipGroup(name: String, block: suspend IpGroupResourceBuilder.() -> Unit): IpGroup {
    val builder = IpGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IpGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ipGroup(name: String): IpGroup {
    val builder = IpGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
