@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin

import com.pulumi.aws.workspaces.IpGroupArgs.builder
import com.pulumi.aws.workspaces.kotlin.inputs.IpGroupRuleArgs
import com.pulumi.aws.workspaces.kotlin.inputs.IpGroupRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an IP access control group in AWS WorkSpaces Service
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const contractors = new aws.workspaces.IpGroup("contractors", {
 *     name: "Contractors",
 *     description: "Contractors IP access control group",
 *     rules: [
 *         {
 *             source: "150.24.14.0/24",
 *             description: "NY",
 *         },
 *         {
 *             source: "125.191.14.85/32",
 *             description: "LA",
 *         },
 *         {
 *             source: "44.98.100.0/24",
 *             description: "STL",
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * contractors = aws.workspaces.IpGroup("contractors",
 *     name="Contractors",
 *     description="Contractors IP access control group",
 *     rules=[
 *         {
 *             "source": "150.24.14.0/24",
 *             "description": "NY",
 *         },
 *         {
 *             "source": "125.191.14.85/32",
 *             "description": "LA",
 *         },
 *         {
 *             "source": "44.98.100.0/24",
 *             "description": "STL",
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var contractors = new Aws.Workspaces.IpGroup("contractors", new()
 *     {
 *         Name = "Contractors",
 *         Description = "Contractors IP access control group",
 *         Rules = new[]
 *         {
 *             new Aws.Workspaces.Inputs.IpGroupRuleArgs
 *             {
 *                 Source = "150.24.14.0/24",
 *                 Description = "NY",
 *             },
 *             new Aws.Workspaces.Inputs.IpGroupRuleArgs
 *             {
 *                 Source = "125.191.14.85/32",
 *                 Description = "LA",
 *             },
 *             new Aws.Workspaces.Inputs.IpGroupRuleArgs
 *             {
 *                 Source = "44.98.100.0/24",
 *                 Description = "STL",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/workspaces"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := workspaces.NewIpGroup(ctx, "contractors", &workspaces.IpGroupArgs{
 * 			Name:        pulumi.String("Contractors"),
 * 			Description: pulumi.String("Contractors IP access control group"),
 * 			Rules: workspaces.IpGroupRuleArray{
 * 				&workspaces.IpGroupRuleArgs{
 * 					Source:      pulumi.String("150.24.14.0/24"),
 * 					Description: pulumi.String("NY"),
 * 				},
 * 				&workspaces.IpGroupRuleArgs{
 * 					Source:      pulumi.String("125.191.14.85/32"),
 * 					Description: pulumi.String("LA"),
 * 				},
 * 				&workspaces.IpGroupRuleArgs{
 * 					Source:      pulumi.String("44.98.100.0/24"),
 * 					Description: pulumi.String("STL"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.workspaces.IpGroup;
 * import com.pulumi.aws.workspaces.IpGroupArgs;
 * import com.pulumi.aws.workspaces.inputs.IpGroupRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var contractors = new IpGroup("contractors", IpGroupArgs.builder()
 *             .name("Contractors")
 *             .description("Contractors IP access control group")
 *             .rules(
 *                 IpGroupRuleArgs.builder()
 *                     .source("150.24.14.0/24")
 *                     .description("NY")
 *                     .build(),
 *                 IpGroupRuleArgs.builder()
 *                     .source("125.191.14.85/32")
 *                     .description("LA")
 *                     .build(),
 *                 IpGroupRuleArgs.builder()
 *                     .source("44.98.100.0/24")
 *                     .description("STL")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   contractors:
 *     type: aws:workspaces:IpGroup
 *     properties:
 *       name: Contractors
 *       description: Contractors IP access control group
 *       rules:
 *         - source: 150.24.14.0/24
 *           description: NY
 *         - source: 125.191.14.85/32
 *           description: LA
 *         - source: 44.98.100.0/24
 *           description: STL
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import WorkSpaces IP groups using their GroupID. For example:
 * ```sh
 * $ pulumi import aws:workspaces/ipGroup:IpGroup example wsipg-488lrtl3k
 * ```
 * @property description The description of the IP group.
 * @property name The name of the IP group.
 * @property rules One or more pairs specifying the IP group rule (in CIDR format) from which web requests originate.
 * @property tags A map of tags assigned to the WorkSpaces directory. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class IpGroupArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val rules: Output<List<IpGroupRuleArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.workspaces.IpGroupArgs> {
    override fun toJava(): com.pulumi.aws.workspaces.IpGroupArgs =
        com.pulumi.aws.workspaces.IpGroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .rules(rules?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [IpGroupArgs].
 */
@PulumiTagMarker
public class IpGroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var rules: Output<List<IpGroupRuleArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The description of the IP group.
     */
    @JvmName("wljcttrnsdmudtfn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the IP group.
     */
    @JvmName("brxlxpefinnsmpls")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value One or more pairs specifying the IP group rule (in CIDR format) from which web requests originate.
     */
    @JvmName("jhebejeuxdcwvsod")
    public suspend fun rules(`value`: Output<List<IpGroupRuleArgs>>) {
        this.rules = value
    }

    @JvmName("urantypdwbkffong")
    public suspend fun rules(vararg values: Output<IpGroupRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values One or more pairs specifying the IP group rule (in CIDR format) from which web requests originate.
     */
    @JvmName("rfrnaocngwlbteii")
    public suspend fun rules(values: List<Output<IpGroupRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value A map of tags assigned to the WorkSpaces directory. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("asoyyycfpcitmhpk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The description of the IP group.
     */
    @JvmName("dekpsigwxvmrfgje")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the IP group.
     */
    @JvmName("igyptxdcyomqutyu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value One or more pairs specifying the IP group rule (in CIDR format) from which web requests originate.
     */
    @JvmName("bfmxwsamiqoqlykq")
    public suspend fun rules(`value`: List<IpGroupRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument One or more pairs specifying the IP group rule (in CIDR format) from which web requests originate.
     */
    @JvmName("xxcykjwweepkposf")
    public suspend fun rules(argument: List<suspend IpGroupRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IpGroupRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument One or more pairs specifying the IP group rule (in CIDR format) from which web requests originate.
     */
    @JvmName("cuhmgqogprvedbfq")
    public suspend fun rules(vararg argument: suspend IpGroupRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IpGroupRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument One or more pairs specifying the IP group rule (in CIDR format) from which web requests originate.
     */
    @JvmName("lslaslhhkkksqgof")
    public suspend fun rules(argument: suspend IpGroupRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpGroupRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values One or more pairs specifying the IP group rule (in CIDR format) from which web requests originate.
     */
    @JvmName("trawdxfabkokiutt")
    public suspend fun rules(vararg values: IpGroupRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param value A map of tags assigned to the WorkSpaces directory. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jfelbmthocannofj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags assigned to the WorkSpaces directory. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vpsnraqwoyndasag")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): IpGroupArgs = IpGroupArgs(
        description = description,
        name = name,
        rules = rules,
        tags = tags,
    )
}
