@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin

import com.pulumi.aws.workspaces.WorkspaceArgs.builder
import com.pulumi.aws.workspaces.kotlin.inputs.WorkspaceWorkspacePropertiesArgs
import com.pulumi.aws.workspaces.kotlin.inputs.WorkspaceWorkspacePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a workspace in [AWS Workspaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces.html) Service
 * > **NOTE:** AWS WorkSpaces service requires [`workspaces_DefaultRole`](https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role) IAM role to operate normally.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const valueWindows10 = aws.workspaces.getBundle({
 *     bundleId: "wsb-bh8rsxt14",
 * });
 * const workspaces = aws.kms.getKey({
 *     keyId: "alias/aws/workspaces",
 * });
 * const example = new aws.workspaces.Workspace("example", {
 *     directoryId: exampleAwsWorkspacesDirectory.id,
 *     bundleId: valueWindows10.then(valueWindows10 => valueWindows10.id),
 *     userName: "john.doe",
 *     rootVolumeEncryptionEnabled: true,
 *     userVolumeEncryptionEnabled: true,
 *     volumeEncryptionKey: workspaces.then(workspaces => workspaces.arn),
 *     workspaceProperties: {
 *         computeTypeName: "VALUE",
 *         userVolumeSizeGib: 10,
 *         rootVolumeSizeGib: 80,
 *         runningMode: "AUTO_STOP",
 *         runningModeAutoStopTimeoutInMinutes: 60,
 *     },
 *     tags: {
 *         Department: "IT",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * value_windows10 = aws.workspaces.get_bundle(bundle_id="wsb-bh8rsxt14")
 * workspaces = aws.kms.get_key(key_id="alias/aws/workspaces")
 * example = aws.workspaces.Workspace("example",
 *     directory_id=example_aws_workspaces_directory["id"],
 *     bundle_id=value_windows10.id,
 *     user_name="john.doe",
 *     root_volume_encryption_enabled=True,
 *     user_volume_encryption_enabled=True,
 *     volume_encryption_key=workspaces.arn,
 *     workspace_properties={
 *         "compute_type_name": "VALUE",
 *         "user_volume_size_gib": 10,
 *         "root_volume_size_gib": 80,
 *         "running_mode": "AUTO_STOP",
 *         "running_mode_auto_stop_timeout_in_minutes": 60,
 *     },
 *     tags={
 *         "Department": "IT",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var valueWindows10 = Aws.Workspaces.GetBundle.Invoke(new()
 *     {
 *         BundleId = "wsb-bh8rsxt14",
 *     });
 *     var workspaces = Aws.Kms.GetKey.Invoke(new()
 *     {
 *         KeyId = "alias/aws/workspaces",
 *     });
 *     var example = new Aws.Workspaces.Workspace("example", new()
 *     {
 *         DirectoryId = exampleAwsWorkspacesDirectory.Id,
 *         BundleId = valueWindows10.Apply(getBundleResult => getBundleResult.Id),
 *         UserName = "john.doe",
 *         RootVolumeEncryptionEnabled = true,
 *         UserVolumeEncryptionEnabled = true,
 *         VolumeEncryptionKey = workspaces.Apply(getKeyResult => getKeyResult.Arn),
 *         WorkspaceProperties = new Aws.Workspaces.Inputs.WorkspaceWorkspacePropertiesArgs
 *         {
 *             ComputeTypeName = "VALUE",
 *             UserVolumeSizeGib = 10,
 *             RootVolumeSizeGib = 80,
 *             RunningMode = "AUTO_STOP",
 *             RunningModeAutoStopTimeoutInMinutes = 60,
 *         },
 *         Tags =
 *         {
 *             { "Department", "IT" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/workspaces"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		valueWindows10, err := workspaces.GetBundle(ctx, &workspaces.GetBundleArgs{
 * 			BundleId: pulumi.StringRef("wsb-bh8rsxt14"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		workspaces, err := kms.LookupKey(ctx, &kms.LookupKeyArgs{
 * 			KeyId: "alias/aws/workspaces",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = workspaces.NewWorkspace(ctx, "example", &workspaces.WorkspaceArgs{
 * 			DirectoryId:                 pulumi.Any(exampleAwsWorkspacesDirectory.Id),
 * 			BundleId:                    pulumi.String(valueWindows10.Id),
 * 			UserName:                    pulumi.String("john.doe"),
 * 			RootVolumeEncryptionEnabled: pulumi.Bool(true),
 * 			UserVolumeEncryptionEnabled: pulumi.Bool(true),
 * 			VolumeEncryptionKey:         pulumi.String(workspaces.Arn),
 * 			WorkspaceProperties: &workspaces.WorkspaceWorkspacePropertiesArgs{
 * 				ComputeTypeName:                     pulumi.String("VALUE"),
 * 				UserVolumeSizeGib:                   pulumi.Int(10),
 * 				RootVolumeSizeGib:                   pulumi.Int(80),
 * 				RunningMode:                         pulumi.String("AUTO_STOP"),
 * 				RunningModeAutoStopTimeoutInMinutes: pulumi.Int(60),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Department": pulumi.String("IT"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.workspaces.WorkspacesFunctions;
 * import com.pulumi.aws.workspaces.inputs.GetBundleArgs;
 * import com.pulumi.aws.kms.KmsFunctions;
 * import com.pulumi.aws.kms.inputs.GetKeyArgs;
 * import com.pulumi.aws.workspaces.Workspace;
 * import com.pulumi.aws.workspaces.WorkspaceArgs;
 * import com.pulumi.aws.workspaces.inputs.WorkspaceWorkspacePropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var valueWindows10 = WorkspacesFunctions.getBundle(GetBundleArgs.builder()
 *             .bundleId("wsb-bh8rsxt14")
 *             .build());
 *         final var workspaces = KmsFunctions.getKey(GetKeyArgs.builder()
 *             .keyId("alias/aws/workspaces")
 *             .build());
 *         var example = new Workspace("example", WorkspaceArgs.builder()
 *             .directoryId(exampleAwsWorkspacesDirectory.id())
 *             .bundleId(valueWindows10.applyValue(getBundleResult -> getBundleResult.id()))
 *             .userName("john.doe")
 *             .rootVolumeEncryptionEnabled(true)
 *             .userVolumeEncryptionEnabled(true)
 *             .volumeEncryptionKey(workspaces.applyValue(getKeyResult -> getKeyResult.arn()))
 *             .workspaceProperties(WorkspaceWorkspacePropertiesArgs.builder()
 *                 .computeTypeName("VALUE")
 *                 .userVolumeSizeGib(10)
 *                 .rootVolumeSizeGib(80)
 *                 .runningMode("AUTO_STOP")
 *                 .runningModeAutoStopTimeoutInMinutes(60)
 *                 .build())
 *             .tags(Map.of("Department", "IT"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:workspaces:Workspace
 *     properties:
 *       directoryId: ${exampleAwsWorkspacesDirectory.id}
 *       bundleId: ${valueWindows10.id}
 *       userName: john.doe
 *       rootVolumeEncryptionEnabled: true
 *       userVolumeEncryptionEnabled: true
 *       volumeEncryptionKey: ${workspaces.arn}
 *       workspaceProperties:
 *         computeTypeName: VALUE
 *         userVolumeSizeGib: 10
 *         rootVolumeSizeGib: 80
 *         runningMode: AUTO_STOP
 *         runningModeAutoStopTimeoutInMinutes: 60
 *       tags:
 *         Department: IT
 * variables:
 *   valueWindows10:
 *     fn::invoke:
 *       Function: aws:workspaces:getBundle
 *       Arguments:
 *         bundleId: wsb-bh8rsxt14
 *   workspaces:
 *     fn::invoke:
 *       Function: aws:kms:getKey
 *       Arguments:
 *         keyId: alias/aws/workspaces
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Workspaces using their ID. For example:
 * ```sh
 * $ pulumi import aws:workspaces/workspace:Workspace example ws-9z9zmbkhv
 * ```
 * @property bundleId The ID of the bundle for the WorkSpace.
 * @property directoryId The ID of the directory for the WorkSpace.
 * @property rootVolumeEncryptionEnabled Indicates whether the data stored on the root volume is encrypted.
 * @property tags The tags for the WorkSpace. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property userName The user name of the user for the WorkSpace. This user name must exist in the directory for the WorkSpace.
 * @property userVolumeEncryptionEnabled Indicates whether the data stored on the user volume is encrypted.
 * @property volumeEncryptionKey The ARN of a symmetric AWS KMS customer master key (CMK) used to encrypt data stored on your WorkSpace. Amazon WorkSpaces does not support asymmetric CMKs.
 * @property workspaceProperties The WorkSpace properties.
 */
public data class WorkspaceArgs(
    public val bundleId: Output<String>? = null,
    public val directoryId: Output<String>? = null,
    public val rootVolumeEncryptionEnabled: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userName: Output<String>? = null,
    public val userVolumeEncryptionEnabled: Output<Boolean>? = null,
    public val volumeEncryptionKey: Output<String>? = null,
    public val workspaceProperties: Output<WorkspaceWorkspacePropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.workspaces.WorkspaceArgs> {
    override fun toJava(): com.pulumi.aws.workspaces.WorkspaceArgs =
        com.pulumi.aws.workspaces.WorkspaceArgs.builder()
            .bundleId(bundleId?.applyValue({ args0 -> args0 }))
            .directoryId(directoryId?.applyValue({ args0 -> args0 }))
            .rootVolumeEncryptionEnabled(rootVolumeEncryptionEnabled?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userName(userName?.applyValue({ args0 -> args0 }))
            .userVolumeEncryptionEnabled(userVolumeEncryptionEnabled?.applyValue({ args0 -> args0 }))
            .volumeEncryptionKey(volumeEncryptionKey?.applyValue({ args0 -> args0 }))
            .workspaceProperties(
                workspaceProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WorkspaceArgs].
 */
@PulumiTagMarker
public class WorkspaceArgsBuilder internal constructor() {
    private var bundleId: Output<String>? = null

    private var directoryId: Output<String>? = null

    private var rootVolumeEncryptionEnabled: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userName: Output<String>? = null

    private var userVolumeEncryptionEnabled: Output<Boolean>? = null

    private var volumeEncryptionKey: Output<String>? = null

    private var workspaceProperties: Output<WorkspaceWorkspacePropertiesArgs>? = null

    /**
     * @param value The ID of the bundle for the WorkSpace.
     */
    @JvmName("qpbbwgmwiakisawj")
    public suspend fun bundleId(`value`: Output<String>) {
        this.bundleId = value
    }

    /**
     * @param value The ID of the directory for the WorkSpace.
     */
    @JvmName("sutootyxgsxgsxnl")
    public suspend fun directoryId(`value`: Output<String>) {
        this.directoryId = value
    }

    /**
     * @param value Indicates whether the data stored on the root volume is encrypted.
     */
    @JvmName("tmdcjuycojonolbl")
    public suspend fun rootVolumeEncryptionEnabled(`value`: Output<Boolean>) {
        this.rootVolumeEncryptionEnabled = value
    }

    /**
     * @param value The tags for the WorkSpace. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("avnsnpnqbkknmyqw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The user name of the user for the WorkSpace. This user name must exist in the directory for the WorkSpace.
     */
    @JvmName("ksklifvhguabxxup")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value Indicates whether the data stored on the user volume is encrypted.
     */
    @JvmName("dusxnrmewgkjtkbh")
    public suspend fun userVolumeEncryptionEnabled(`value`: Output<Boolean>) {
        this.userVolumeEncryptionEnabled = value
    }

    /**
     * @param value The ARN of a symmetric AWS KMS customer master key (CMK) used to encrypt data stored on your WorkSpace. Amazon WorkSpaces does not support asymmetric CMKs.
     */
    @JvmName("taiboolqppdvogrm")
    public suspend fun volumeEncryptionKey(`value`: Output<String>) {
        this.volumeEncryptionKey = value
    }

    /**
     * @param value The WorkSpace properties.
     */
    @JvmName("vgvybqvayixgpggk")
    public suspend fun workspaceProperties(`value`: Output<WorkspaceWorkspacePropertiesArgs>) {
        this.workspaceProperties = value
    }

    /**
     * @param value The ID of the bundle for the WorkSpace.
     */
    @JvmName("vvqmhrpcssrqriwt")
    public suspend fun bundleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bundleId = mapped
    }

    /**
     * @param value The ID of the directory for the WorkSpace.
     */
    @JvmName("nnrfqchprojoldby")
    public suspend fun directoryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directoryId = mapped
    }

    /**
     * @param value Indicates whether the data stored on the root volume is encrypted.
     */
    @JvmName("yvpdypnydeexpjic")
    public suspend fun rootVolumeEncryptionEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rootVolumeEncryptionEnabled = mapped
    }

    /**
     * @param value The tags for the WorkSpace. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mgyqbtgojbkwlgtv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags for the WorkSpace. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hkysfuewjahkrtrn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The user name of the user for the WorkSpace. This user name must exist in the directory for the WorkSpace.
     */
    @JvmName("hjgvybdiaqohyyhm")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    /**
     * @param value Indicates whether the data stored on the user volume is encrypted.
     */
    @JvmName("iabdcphixpedpgbn")
    public suspend fun userVolumeEncryptionEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userVolumeEncryptionEnabled = mapped
    }

    /**
     * @param value The ARN of a symmetric AWS KMS customer master key (CMK) used to encrypt data stored on your WorkSpace. Amazon WorkSpaces does not support asymmetric CMKs.
     */
    @JvmName("qotubmqxkdvlveje")
    public suspend fun volumeEncryptionKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeEncryptionKey = mapped
    }

    /**
     * @param value The WorkSpace properties.
     */
    @JvmName("npnujfrfcryeeuwa")
    public suspend fun workspaceProperties(`value`: WorkspaceWorkspacePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceProperties = mapped
    }

    /**
     * @param argument The WorkSpace properties.
     */
    @JvmName("ltsuatxhspefulhp")
    public suspend fun workspaceProperties(argument: suspend WorkspaceWorkspacePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = WorkspaceWorkspacePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.workspaceProperties = mapped
    }

    internal fun build(): WorkspaceArgs = WorkspaceArgs(
        bundleId = bundleId,
        directoryId = directoryId,
        rootVolumeEncryptionEnabled = rootVolumeEncryptionEnabled,
        tags = tags,
        userName = userName,
        userVolumeEncryptionEnabled = userVolumeEncryptionEnabled,
        volumeEncryptionKey = volumeEncryptionKey,
        workspaceProperties = workspaceProperties,
    )
}
