@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin.inputs

import com.pulumi.aws.workspaces.inputs.DirectoryWorkspaceAccessPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deviceTypeAndroid Indicates whether users can use Android devices to access their WorkSpaces.
 * @property deviceTypeChromeos Indicates whether users can use Chromebooks to access their WorkSpaces.
 * @property deviceTypeIos Indicates whether users can use iOS devices to access their WorkSpaces.
 * @property deviceTypeLinux Indicates whether users can use Linux clients to access their WorkSpaces.
 * @property deviceTypeOsx Indicates whether users can use macOS clients to access their WorkSpaces.
 * @property deviceTypeWeb Indicates whether users can access their WorkSpaces through a web browser.
 * @property deviceTypeWindows Indicates whether users can use Windows clients to access their WorkSpaces.
 * @property deviceTypeZeroclient Indicates whether users can use zero client devices to access their WorkSpaces.
 */
public data class DirectoryWorkspaceAccessPropertiesArgs(
    public val deviceTypeAndroid: Output<String>? = null,
    public val deviceTypeChromeos: Output<String>? = null,
    public val deviceTypeIos: Output<String>? = null,
    public val deviceTypeLinux: Output<String>? = null,
    public val deviceTypeOsx: Output<String>? = null,
    public val deviceTypeWeb: Output<String>? = null,
    public val deviceTypeWindows: Output<String>? = null,
    public val deviceTypeZeroclient: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.workspaces.inputs.DirectoryWorkspaceAccessPropertiesArgs> {
    override fun toJava(): com.pulumi.aws.workspaces.inputs.DirectoryWorkspaceAccessPropertiesArgs =
        com.pulumi.aws.workspaces.inputs.DirectoryWorkspaceAccessPropertiesArgs.builder()
            .deviceTypeAndroid(deviceTypeAndroid?.applyValue({ args0 -> args0 }))
            .deviceTypeChromeos(deviceTypeChromeos?.applyValue({ args0 -> args0 }))
            .deviceTypeIos(deviceTypeIos?.applyValue({ args0 -> args0 }))
            .deviceTypeLinux(deviceTypeLinux?.applyValue({ args0 -> args0 }))
            .deviceTypeOsx(deviceTypeOsx?.applyValue({ args0 -> args0 }))
            .deviceTypeWeb(deviceTypeWeb?.applyValue({ args0 -> args0 }))
            .deviceTypeWindows(deviceTypeWindows?.applyValue({ args0 -> args0 }))
            .deviceTypeZeroclient(deviceTypeZeroclient?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DirectoryWorkspaceAccessPropertiesArgs].
 */
@PulumiTagMarker
public class DirectoryWorkspaceAccessPropertiesArgsBuilder internal constructor() {
    private var deviceTypeAndroid: Output<String>? = null

    private var deviceTypeChromeos: Output<String>? = null

    private var deviceTypeIos: Output<String>? = null

    private var deviceTypeLinux: Output<String>? = null

    private var deviceTypeOsx: Output<String>? = null

    private var deviceTypeWeb: Output<String>? = null

    private var deviceTypeWindows: Output<String>? = null

    private var deviceTypeZeroclient: Output<String>? = null

    /**
     * @param value Indicates whether users can use Android devices to access their WorkSpaces.
     */
    @JvmName("ynnydrwlmycrfbwq")
    public suspend fun deviceTypeAndroid(`value`: Output<String>) {
        this.deviceTypeAndroid = value
    }

    /**
     * @param value Indicates whether users can use Chromebooks to access their WorkSpaces.
     */
    @JvmName("ioyqdhkbmwopynyt")
    public suspend fun deviceTypeChromeos(`value`: Output<String>) {
        this.deviceTypeChromeos = value
    }

    /**
     * @param value Indicates whether users can use iOS devices to access their WorkSpaces.
     */
    @JvmName("xwpnvsrunmslrjws")
    public suspend fun deviceTypeIos(`value`: Output<String>) {
        this.deviceTypeIos = value
    }

    /**
     * @param value Indicates whether users can use Linux clients to access their WorkSpaces.
     */
    @JvmName("onogyspxelrohoyx")
    public suspend fun deviceTypeLinux(`value`: Output<String>) {
        this.deviceTypeLinux = value
    }

    /**
     * @param value Indicates whether users can use macOS clients to access their WorkSpaces.
     */
    @JvmName("evqiusjhogarooqn")
    public suspend fun deviceTypeOsx(`value`: Output<String>) {
        this.deviceTypeOsx = value
    }

    /**
     * @param value Indicates whether users can access their WorkSpaces through a web browser.
     */
    @JvmName("xbauovqdjtfjstvs")
    public suspend fun deviceTypeWeb(`value`: Output<String>) {
        this.deviceTypeWeb = value
    }

    /**
     * @param value Indicates whether users can use Windows clients to access their WorkSpaces.
     */
    @JvmName("qibvbmjpfwpduqan")
    public suspend fun deviceTypeWindows(`value`: Output<String>) {
        this.deviceTypeWindows = value
    }

    /**
     * @param value Indicates whether users can use zero client devices to access their WorkSpaces.
     */
    @JvmName("ticlttunhxhuoxgx")
    public suspend fun deviceTypeZeroclient(`value`: Output<String>) {
        this.deviceTypeZeroclient = value
    }

    /**
     * @param value Indicates whether users can use Android devices to access their WorkSpaces.
     */
    @JvmName("kbudvugacgwjmvvf")
    public suspend fun deviceTypeAndroid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceTypeAndroid = mapped
    }

    /**
     * @param value Indicates whether users can use Chromebooks to access their WorkSpaces.
     */
    @JvmName("lhypxfhvjptvxunf")
    public suspend fun deviceTypeChromeos(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceTypeChromeos = mapped
    }

    /**
     * @param value Indicates whether users can use iOS devices to access their WorkSpaces.
     */
    @JvmName("imbnlbhbogltupfo")
    public suspend fun deviceTypeIos(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceTypeIos = mapped
    }

    /**
     * @param value Indicates whether users can use Linux clients to access their WorkSpaces.
     */
    @JvmName("enfqcclvrkprftgq")
    public suspend fun deviceTypeLinux(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceTypeLinux = mapped
    }

    /**
     * @param value Indicates whether users can use macOS clients to access their WorkSpaces.
     */
    @JvmName("fdimvbbfhuxgmmmn")
    public suspend fun deviceTypeOsx(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceTypeOsx = mapped
    }

    /**
     * @param value Indicates whether users can access their WorkSpaces through a web browser.
     */
    @JvmName("fmojlpotwjtpgvye")
    public suspend fun deviceTypeWeb(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceTypeWeb = mapped
    }

    /**
     * @param value Indicates whether users can use Windows clients to access their WorkSpaces.
     */
    @JvmName("kxmotpptcyyhuiux")
    public suspend fun deviceTypeWindows(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceTypeWindows = mapped
    }

    /**
     * @param value Indicates whether users can use zero client devices to access their WorkSpaces.
     */
    @JvmName("umfkhrbqnawsyedq")
    public suspend fun deviceTypeZeroclient(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceTypeZeroclient = mapped
    }

    internal fun build(): DirectoryWorkspaceAccessPropertiesArgs =
        DirectoryWorkspaceAccessPropertiesArgs(
            deviceTypeAndroid = deviceTypeAndroid,
            deviceTypeChromeos = deviceTypeChromeos,
            deviceTypeIos = deviceTypeIos,
            deviceTypeLinux = deviceTypeLinux,
            deviceTypeOsx = deviceTypeOsx,
            deviceTypeWeb = deviceTypeWeb,
            deviceTypeWindows = deviceTypeWindows,
            deviceTypeZeroclient = deviceTypeZeroclient,
        )
}
