@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin.inputs

import com.pulumi.aws.workspaces.inputs.GetWorkspacePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getWorkspace.
 * @property directoryId ID of the directory for the WorkSpace. You have to specify `user_name` along with `directory_id`. You cannot combine this parameter with `workspace_id`.
 * @property tags Tags for the WorkSpace.
 * @property userName User name of the user for the WorkSpace. This user name must exist in the directory for the WorkSpace. You cannot combine this parameter with `workspace_id`.
 * @property workspaceId ID of the WorkSpace. You cannot combine this parameter with `directory_id`.
 */
public data class GetWorkspacePlainArgs(
    public val directoryId: String? = null,
    public val tags: Map<String, String>? = null,
    public val userName: String? = null,
    public val workspaceId: String? = null,
) : ConvertibleToJava<com.pulumi.aws.workspaces.inputs.GetWorkspacePlainArgs> {
    override fun toJava(): com.pulumi.aws.workspaces.inputs.GetWorkspacePlainArgs =
        com.pulumi.aws.workspaces.inputs.GetWorkspacePlainArgs.builder()
            .directoryId(directoryId?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userName(userName?.let({ args0 -> args0 }))
            .workspaceId(workspaceId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkspacePlainArgs].
 */
@PulumiTagMarker
public class GetWorkspacePlainArgsBuilder internal constructor() {
    private var directoryId: String? = null

    private var tags: Map<String, String>? = null

    private var userName: String? = null

    private var workspaceId: String? = null

    /**
     * @param value ID of the directory for the WorkSpace. You have to specify `user_name` along with `directory_id`. You cannot combine this parameter with `workspace_id`.
     */
    @JvmName("eftojjmpifcksbet")
    public suspend fun directoryId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.directoryId = mapped
    }

    /**
     * @param value Tags for the WorkSpace.
     */
    @JvmName("gbdegpmxaldisyxw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Tags for the WorkSpace.
     */
    @JvmName("hpgglpggheckhanm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value User name of the user for the WorkSpace. This user name must exist in the directory for the WorkSpace. You cannot combine this parameter with `workspace_id`.
     */
    @JvmName("ihxnffcgjkaopqaf")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.userName = mapped
    }

    /**
     * @param value ID of the WorkSpace. You cannot combine this parameter with `directory_id`.
     */
    @JvmName("ssnkjscvgydlbeak")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.workspaceId = mapped
    }

    internal fun build(): GetWorkspacePlainArgs = GetWorkspacePlainArgs(
        directoryId = directoryId,
        tags = tags,
        userName = userName,
        workspaceId = workspaceId,
    )
}
