@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property customSecurityGroupId The identifier of your custom security group. Should relate to the same VPC, where workspaces reside in.
 * @property defaultOu The default organizational unit (OU) for your WorkSpace directories. Should conform `"OU=<value>,DC=<value>,...,DC=<value>"` pattern.
 * @property enableInternetAccess Indicates whether internet access is enabled for your WorkSpaces.
 * @property enableMaintenanceMode Indicates whether maintenance mode is enabled for your WorkSpaces. For more information, see [WorkSpace Maintenance](https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html)..
 * @property userEnabledAsLocalAdministrator Indicates whether users are local administrators of their WorkSpaces.
 */
public data class DirectoryWorkspaceCreationProperties(
    public val customSecurityGroupId: String? = null,
    public val defaultOu: String? = null,
    public val enableInternetAccess: Boolean? = null,
    public val enableMaintenanceMode: Boolean? = null,
    public val userEnabledAsLocalAdministrator: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.workspaces.outputs.DirectoryWorkspaceCreationProperties): DirectoryWorkspaceCreationProperties = DirectoryWorkspaceCreationProperties(
            customSecurityGroupId = javaType.customSecurityGroupId().map({ args0 -> args0 }).orElse(null),
            defaultOu = javaType.defaultOu().map({ args0 -> args0 }).orElse(null),
            enableInternetAccess = javaType.enableInternetAccess().map({ args0 -> args0 }).orElse(null),
            enableMaintenanceMode = javaType.enableMaintenanceMode().map({ args0 -> args0 }).orElse(null),
            userEnabledAsLocalAdministrator = javaType.userEnabledAsLocalAdministrator().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
