@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getDirectory.
 * @property alias Directory alias.
 * @property customerUserName User name for the service account.
 * @property directoryId
 * @property directoryName Name of the directory.
 * @property directoryType Directory type.
 * @property dnsIpAddresses IP addresses of the DNS servers for the directory.
 * @property iamRoleId Identifier of the IAM role. This is the role that allows Amazon WorkSpaces to make calls to other services, such as Amazon EC2, on your behalf.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ipGroupIds Identifiers of the IP access control groups associated with the directory.
 * @property registrationCode Registration code for the directory. This is the code that users enter in their Amazon WorkSpaces client application to connect to the directory.
 * @property selfServicePermissions The permissions to enable or disable self-service capabilities.
 * @property subnetIds Identifiers of the subnets where the directory resides.
 * @property tags A map of tags assigned to the WorkSpaces directory.
 * @property workspaceAccessProperties (Optional) Specifies which devices and operating systems users can use to access their WorkSpaces. Defined below.
 * @property workspaceCreationProperties The default properties that are used for creating WorkSpaces. Defined below.
 * @property workspaceSecurityGroupId The identifier of the security group that is assigned to new WorkSpaces. Defined below.
 */
public data class GetDirectoryResult(
    public val alias: String,
    public val customerUserName: String,
    public val directoryId: String,
    public val directoryName: String,
    public val directoryType: String,
    public val dnsIpAddresses: List<String>,
    public val iamRoleId: String,
    public val id: String,
    public val ipGroupIds: List<String>,
    public val registrationCode: String,
    public val selfServicePermissions: List<GetDirectorySelfServicePermission>,
    public val subnetIds: List<String>,
    public val tags: Map<String, String>? = null,
    public val workspaceAccessProperties: List<GetDirectoryWorkspaceAccessProperty>,
    public val workspaceCreationProperties: List<GetDirectoryWorkspaceCreationProperty>,
    public val workspaceSecurityGroupId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.workspaces.outputs.GetDirectoryResult): GetDirectoryResult = GetDirectoryResult(
            alias = javaType.alias(),
            customerUserName = javaType.customerUserName(),
            directoryId = javaType.directoryId(),
            directoryName = javaType.directoryName(),
            directoryType = javaType.directoryType(),
            dnsIpAddresses = javaType.dnsIpAddresses().map({ args0 -> args0 }),
            iamRoleId = javaType.iamRoleId(),
            id = javaType.id(),
            ipGroupIds = javaType.ipGroupIds().map({ args0 -> args0 }),
            registrationCode = javaType.registrationCode(),
            selfServicePermissions = javaType.selfServicePermissions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.workspaces.kotlin.outputs.GetDirectorySelfServicePermission.Companion.toKotlin(args0)
                })
            }),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            workspaceAccessProperties = javaType.workspaceAccessProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.workspaces.kotlin.outputs.GetDirectoryWorkspaceAccessProperty.Companion.toKotlin(args0)
                })
            }),
            workspaceCreationProperties = javaType.workspaceCreationProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.workspaces.kotlin.outputs.GetDirectoryWorkspaceCreationProperty.Companion.toKotlin(args0)
                })
            }),
            workspaceSecurityGroupId = javaType.workspaceSecurityGroupId(),
        )
    }
}
