@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property changeComputeType Whether WorkSpaces directory users can change the compute type (bundle) for their workspace.
 * @property increaseVolumeSize Whether WorkSpaces directory users can increase the volume size of the drives on their workspace.
 * @property rebuildWorkspace Whether WorkSpaces directory users can rebuild the operating system of a workspace to its original state.
 * @property restartWorkspace Whether WorkSpaces directory users can restart their workspace.
 * @property switchRunningMode Whether WorkSpaces directory users can switch the running mode of their workspace.
 */
public data class GetDirectorySelfServicePermission(
    public val changeComputeType: Boolean,
    public val increaseVolumeSize: Boolean,
    public val rebuildWorkspace: Boolean,
    public val restartWorkspace: Boolean,
    public val switchRunningMode: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.workspaces.outputs.GetDirectorySelfServicePermission): GetDirectorySelfServicePermission = GetDirectorySelfServicePermission(
            changeComputeType = javaType.changeComputeType(),
            increaseVolumeSize = javaType.increaseVolumeSize(),
            rebuildWorkspace = javaType.rebuildWorkspace(),
            restartWorkspace = javaType.restartWorkspace(),
            switchRunningMode = javaType.switchRunningMode(),
        )
    }
}
