@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deviceTypeAndroid (Optional) Indicates whether users can use Android devices to access their WorkSpaces.
 * @property deviceTypeChromeos (Optional) Indicates whether users can use Chromebooks to access their WorkSpaces.
 * @property deviceTypeIos (Optional) Indicates whether users can use iOS devices to access their WorkSpaces.
 * @property deviceTypeLinux (Optional) Indicates whether users can use Linux clients to access their WorkSpaces.
 * @property deviceTypeOsx (Optional) Indicates whether users can use macOS clients to access their WorkSpaces.
 * @property deviceTypeWeb (Optional) Indicates whether users can access their WorkSpaces through a web browser.
 * @property deviceTypeWindows (Optional) Indicates whether users can use Windows clients to access their WorkSpaces.
 * @property deviceTypeZeroclient (Optional) Indicates whether users can use zero client devices to access their WorkSpaces.
 */
public data class GetDirectoryWorkspaceAccessProperty(
    public val deviceTypeAndroid: String,
    public val deviceTypeChromeos: String,
    public val deviceTypeIos: String,
    public val deviceTypeLinux: String,
    public val deviceTypeOsx: String,
    public val deviceTypeWeb: String,
    public val deviceTypeWindows: String,
    public val deviceTypeZeroclient: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.workspaces.outputs.GetDirectoryWorkspaceAccessProperty): GetDirectoryWorkspaceAccessProperty = GetDirectoryWorkspaceAccessProperty(
            deviceTypeAndroid = javaType.deviceTypeAndroid(),
            deviceTypeChromeos = javaType.deviceTypeChromeos(),
            deviceTypeIos = javaType.deviceTypeIos(),
            deviceTypeLinux = javaType.deviceTypeLinux(),
            deviceTypeOsx = javaType.deviceTypeOsx(),
            deviceTypeWeb = javaType.deviceTypeWeb(),
            deviceTypeWindows = javaType.deviceTypeWindows(),
            deviceTypeZeroclient = javaType.deviceTypeZeroclient(),
        )
    }
}
