@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.workspaces.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property customSecurityGroupId The identifier of your custom security group. Should relate to the same VPC, where workspaces reside in.
 * @property defaultOu The default organizational unit (OU) for your WorkSpace directories.
 * @property enableInternetAccess Indicates whether internet access is enabled for your WorkSpaces.
 * @property enableMaintenanceMode Indicates whether maintenance mode is enabled for your WorkSpaces. For more information, see [WorkSpace Maintenance](https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html).
 * @property userEnabledAsLocalAdministrator Indicates whether users are local administrators of their WorkSpaces.
 */
public data class GetDirectoryWorkspaceCreationProperty(
    public val customSecurityGroupId: String,
    public val defaultOu: String,
    public val enableInternetAccess: Boolean,
    public val enableMaintenanceMode: Boolean,
    public val userEnabledAsLocalAdministrator: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.workspaces.outputs.GetDirectoryWorkspaceCreationProperty): GetDirectoryWorkspaceCreationProperty = GetDirectoryWorkspaceCreationProperty(
            customSecurityGroupId = javaType.customSecurityGroupId(),
            defaultOu = javaType.defaultOu(),
            enableInternetAccess = javaType.enableInternetAccess(),
            enableMaintenanceMode = javaType.enableMaintenanceMode(),
            userEnabledAsLocalAdministrator = javaType.userEnabledAsLocalAdministrator(),
        )
    }
}
