@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.xray.kotlin

import com.pulumi.aws.xray.EncryptionConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Creates and manages an AWS XRay Encryption Config.
 * > **NOTE:** Removing this resource from the provider has no effect to the encryption configuration within X-Ray.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.xray.EncryptionConfig("example", {type: "NONE"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.xray.EncryptionConfig("example", type="NONE")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Xray.EncryptionConfig("example", new()
 *     {
 *         Type = "NONE",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/xray"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := xray.NewEncryptionConfig(ctx, "example", &xray.EncryptionConfigArgs{
 * 			Type: pulumi.String("NONE"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.xray.EncryptionConfig;
 * import com.pulumi.aws.xray.EncryptionConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EncryptionConfig("example", EncryptionConfigArgs.builder()
 *             .type("NONE")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:xray:EncryptionConfig
 *     properties:
 *       type: NONE
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With KMS Key
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getCallerIdentity({});
 * const example = current.then(current => aws.iam.getPolicyDocument({
 *     statements: [{
 *         sid: "Enable IAM User Permissions",
 *         effect: "Allow",
 *         principals: [{
 *             type: "AWS",
 *             identifiers: [`arn:aws:iam::${current&#46;accountId}:root`],
 *         }],
 *         actions: ["kms:*"],
 *         resources: ["*"],
 *     }],
 * }));
 * const exampleKey = new aws.kms.Key("example", {
 *     description: "Some Key",
 *     deletionWindowInDays: 7,
 *     policy: example.then(example => example.json),
 * });
 * const exampleEncryptionConfig = new aws.xray.EncryptionConfig("example", {
 *     type: "KMS",
 *     keyId: exampleKey.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * current = aws.get_caller_identity()
 * example = aws.iam.get_policy_document(statements=[{
 *     "sid": "Enable IAM User Permissions",
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "AWS",
 *         "identifiers": [f"arn:aws:iam::{current&#46;account_id}:root"],
 *     }],
 *     "actions": ["kms:*"],
 *     "resources": ["*"],
 * }])
 * example_key = aws.kms.Key("example",
 *     description="Some Key",
 *     deletion_window_in_days=7,
 *     policy=example.json)
 * example_encryption_config = aws.xray.EncryptionConfig("example",
 *     type="KMS",
 *     key_id=example_key.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetCallerIdentity.Invoke();
 *     var example = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Sid = "Enable IAM User Permissions",
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "AWS",
 *                         Identifiers = new[]
 *                         {
 *                             $"arn:aws:iam::{current.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId)}:root",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "kms:*",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "*",
 *                 },
 *             },
 *         },
 *     });
 *     var exampleKey = new Aws.Kms.Key("example", new()
 *     {
 *         Description = "Some Key",
 *         DeletionWindowInDays = 7,
 *         Policy = example.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var exampleEncryptionConfig = new Aws.Xray.EncryptionConfig("example", new()
 *     {
 *         Type = "KMS",
 *         KeyId = exampleKey.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/xray"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetCallerIdentity(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Sid:    pulumi.StringRef("Enable IAM User Permissions"),
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "AWS",
 * 							Identifiers: []string{
 * 								fmt.Sprintf("arn:aws:iam::%v:root", current.AccountId),
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"kms:*",
 * 					},
 * 					Resources: []string{
 * 						"*",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleKey, err := kms.NewKey(ctx, "example", &kms.KeyArgs{
 * 			Description:          pulumi.String("Some Key"),
 * 			DeletionWindowInDays: pulumi.Int(7),
 * 			Policy:               pulumi.String(example.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = xray.NewEncryptionConfig(ctx, "example", &xray.EncryptionConfigArgs{
 * 			Type:  pulumi.String("KMS"),
 * 			KeyId: exampleKey.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.xray.EncryptionConfig;
 * import com.pulumi.aws.xray.EncryptionConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         final var example = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("Enable IAM User Permissions")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers(String.format("arn:aws:iam::%s:root", current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                     .build())
 *                 .actions("kms:*")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .description("Some Key")
 *             .deletionWindowInDays(7)
 *             .policy(example.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleEncryptionConfig = new EncryptionConfig("exampleEncryptionConfig", EncryptionConfigArgs.builder()
 *             .type("KMS")
 *             .keyId(exampleKey.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleKey:
 *     type: aws:kms:Key
 *     name: example
 *     properties:
 *       description: Some Key
 *       deletionWindowInDays: 7
 *       policy: ${example.json}
 *   exampleEncryptionConfig:
 *     type: aws:xray:EncryptionConfig
 *     name: example
 *     properties:
 *       type: KMS
 *       keyId: ${exampleKey.arn}
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getCallerIdentity
 *       Arguments: {}
 *   example:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - sid: Enable IAM User Permissions
 *             effect: Allow
 *             principals:
 *               - type: AWS
 *                 identifiers:
 *                   - arn:aws:iam::${current.accountId}:root
 *             actions:
 *               - kms:*
 *             resources:
 *               - '*'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import XRay Encryption Config using the region name. For example:
 * ```sh
 * $ pulumi import aws:xray/encryptionConfig:EncryptionConfig example us-west-2
 * ```
 * @property keyId An AWS KMS customer master key (CMK) ARN.
 * @property type The type of encryption. Set to `KMS` to use your own key for encryption. Set to `NONE` for default encryption.
 */
public data class EncryptionConfigArgs(
    public val keyId: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.xray.EncryptionConfigArgs> {
    override fun toJava(): com.pulumi.aws.xray.EncryptionConfigArgs =
        com.pulumi.aws.xray.EncryptionConfigArgs.builder()
            .keyId(keyId?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EncryptionConfigArgs].
 */
@PulumiTagMarker
public class EncryptionConfigArgsBuilder internal constructor() {
    private var keyId: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value An AWS KMS customer master key (CMK) ARN.
     */
    @JvmName("pmtwvijkqyyukufl")
    public suspend fun keyId(`value`: Output<String>) {
        this.keyId = value
    }

    /**
     * @param value The type of encryption. Set to `KMS` to use your own key for encryption. Set to `NONE` for default encryption.
     */
    @JvmName("gxcgyncaqqwiwpue")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value An AWS KMS customer master key (CMK) ARN.
     */
    @JvmName("vpjanrbjqrqxxbvv")
    public suspend fun keyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyId = mapped
    }

    /**
     * @param value The type of encryption. Set to `KMS` to use your own key for encryption. Set to `NONE` for default encryption.
     */
    @JvmName("cgjsgujbplqgwfvv")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): EncryptionConfigArgs = EncryptionConfigArgs(
        keyId = keyId,
        type = type,
    )
}
