@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.xray.kotlin

import com.pulumi.aws.xray.GroupArgs.builder
import com.pulumi.aws.xray.kotlin.inputs.GroupInsightsConfigurationArgs
import com.pulumi.aws.xray.kotlin.inputs.GroupInsightsConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Creates and manages an AWS XRay Group.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.xray.Group("example", {
 *     groupName: "example",
 *     filterExpression: "responsetime > 5",
 *     insightsConfiguration: {
 *         insightsEnabled: true,
 *         notificationsEnabled: true,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.xray.Group("example",
 *     group_name="example",
 *     filter_expression="responsetime > 5",
 *     insights_configuration={
 *         "insights_enabled": True,
 *         "notifications_enabled": True,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Xray.Group("example", new()
 *     {
 *         GroupName = "example",
 *         FilterExpression = "responsetime > 5",
 *         InsightsConfiguration = new Aws.Xray.Inputs.GroupInsightsConfigurationArgs
 *         {
 *             InsightsEnabled = true,
 *             NotificationsEnabled = true,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/xray"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := xray.NewGroup(ctx, "example", &xray.GroupArgs{
 * 			GroupName:        pulumi.String("example"),
 * 			FilterExpression: pulumi.String("responsetime > 5"),
 * 			InsightsConfiguration: &xray.GroupInsightsConfigurationArgs{
 * 				InsightsEnabled:      pulumi.Bool(true),
 * 				NotificationsEnabled: pulumi.Bool(true),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.xray.Group;
 * import com.pulumi.aws.xray.GroupArgs;
 * import com.pulumi.aws.xray.inputs.GroupInsightsConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Group("example", GroupArgs.builder()
 *             .groupName("example")
 *             .filterExpression("responsetime > 5")
 *             .insightsConfiguration(GroupInsightsConfigurationArgs.builder()
 *                 .insightsEnabled(true)
 *                 .notificationsEnabled(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:xray:Group
 *     properties:
 *       groupName: example
 *       filterExpression: responsetime > 5
 *       insightsConfiguration:
 *         insightsEnabled: true
 *         notificationsEnabled: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import XRay Groups using the ARN. For example:
 * ```sh
 * $ pulumi import aws:xray/group:Group example arn:aws:xray:us-west-2:1234567890:group/example-group/TNGX7SW5U6QY36T4ZMOUA3HVLBYCZTWDIOOXY3CJAXTHSS3YCWUA
 * ```
 * @property filterExpression The filter expression defining criteria by which to group traces. more info can be found in official [docs](https://docs.aws.amazon.com/xray/latest/devguide/xray-console-filters.html).
 * @property groupName The name of the group.
 * @property insightsConfiguration Configuration options for enabling insights.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
 */
public data class GroupArgs(
    public val filterExpression: Output<String>? = null,
    public val groupName: Output<String>? = null,
    public val insightsConfiguration: Output<GroupInsightsConfigurationArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.xray.GroupArgs> {
    override fun toJava(): com.pulumi.aws.xray.GroupArgs = com.pulumi.aws.xray.GroupArgs.builder()
        .filterExpression(filterExpression?.applyValue({ args0 -> args0 }))
        .groupName(groupName?.applyValue({ args0 -> args0 }))
        .insightsConfiguration(
            insightsConfiguration?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [GroupArgs].
 */
@PulumiTagMarker
public class GroupArgsBuilder internal constructor() {
    private var filterExpression: Output<String>? = null

    private var groupName: Output<String>? = null

    private var insightsConfiguration: Output<GroupInsightsConfigurationArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The filter expression defining criteria by which to group traces. more info can be found in official [docs](https://docs.aws.amazon.com/xray/latest/devguide/xray-console-filters.html).
     */
    @JvmName("jqhtcopqcdqxsvla")
    public suspend fun filterExpression(`value`: Output<String>) {
        this.filterExpression = value
    }

    /**
     * @param value The name of the group.
     */
    @JvmName("jekctrmcajskwgga")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value Configuration options for enabling insights.
     */
    @JvmName("ouxuvdkwjnteilyk")
    public suspend fun insightsConfiguration(`value`: Output<GroupInsightsConfigurationArgs>) {
        this.insightsConfiguration = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("ppebgkfsmtojmcrw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The filter expression defining criteria by which to group traces. more info can be found in official [docs](https://docs.aws.amazon.com/xray/latest/devguide/xray-console-filters.html).
     */
    @JvmName("snvqcxyqvaatvkry")
    public suspend fun filterExpression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterExpression = mapped
    }

    /**
     * @param value The name of the group.
     */
    @JvmName("opjjshpigcelymnd")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    /**
     * @param value Configuration options for enabling insights.
     */
    @JvmName("vnyrcjotolybhvqg")
    public suspend fun insightsConfiguration(`value`: GroupInsightsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.insightsConfiguration = mapped
    }

    /**
     * @param argument Configuration options for enabling insights.
     */
    @JvmName("arynfdtwbvwhetsa")
    public suspend fun insightsConfiguration(argument: suspend GroupInsightsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = GroupInsightsConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.insightsConfiguration = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("osewncphadxsntgj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("solpjlegbpkfcbif")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): GroupArgs = GroupArgs(
        filterExpression = filterExpression,
        groupName = groupName,
        insightsConfiguration = insightsConfiguration,
        tags = tags,
    )
}
