@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.xray.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [SamplingRule].
 */
@PulumiTagMarker
public class SamplingRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SamplingRuleArgs = SamplingRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SamplingRuleArgsBuilder.() -> Unit) {
        val builder = SamplingRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SamplingRule {
        val builtJavaResource = com.pulumi.aws.xray.SamplingRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SamplingRule(builtJavaResource)
    }
}

/**
 * Creates and manages an AWS XRay Sampling Rule.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.xray.SamplingRule("example", {
 *     ruleName: "example",
 *     priority: 9999,
 *     version: 1,
 *     reservoirSize: 1,
 *     fixedRate: 0.05,
 *     urlPath: "*",
 *     host: "*",
 *     httpMethod: "*",
 *     serviceType: "*",
 *     serviceName: "*",
 *     resourceArn: "*",
 *     attributes: {
 *         Hello: "Tris",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.xray.SamplingRule("example",
 *     rule_name="example",
 *     priority=9999,
 *     version=1,
 *     reservoir_size=1,
 *     fixed_rate=0.05,
 *     url_path="*",
 *     host="*",
 *     http_method="*",
 *     service_type="*",
 *     service_name="*",
 *     resource_arn="*",
 *     attributes={
 *         "Hello": "Tris",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Xray.SamplingRule("example", new()
 *     {
 *         RuleName = "example",
 *         Priority = 9999,
 *         Version = 1,
 *         ReservoirSize = 1,
 *         FixedRate = 0.05,
 *         UrlPath = "*",
 *         Host = "*",
 *         HttpMethod = "*",
 *         ServiceType = "*",
 *         ServiceName = "*",
 *         ResourceArn = "*",
 *         Attributes =
 *         {
 *             { "Hello", "Tris" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/xray"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := xray.NewSamplingRule(ctx, "example", &xray.SamplingRuleArgs{
 * 			RuleName:      pulumi.String("example"),
 * 			Priority:      pulumi.Int(9999),
 * 			Version:       pulumi.Int(1),
 * 			ReservoirSize: pulumi.Int(1),
 * 			FixedRate:     pulumi.Float64(0.05),
 * 			UrlPath:       pulumi.String("*"),
 * 			Host:          pulumi.String("*"),
 * 			HttpMethod:    pulumi.String("*"),
 * 			ServiceType:   pulumi.String("*"),
 * 			ServiceName:   pulumi.String("*"),
 * 			ResourceArn:   pulumi.String("*"),
 * 			Attributes: pulumi.StringMap{
 * 				"Hello": pulumi.String("Tris"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.xray.SamplingRule;
 * import com.pulumi.aws.xray.SamplingRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SamplingRule("example", SamplingRuleArgs.builder()
 *             .ruleName("example")
 *             .priority(9999)
 *             .version(1)
 *             .reservoirSize(1)
 *             .fixedRate(0.05)
 *             .urlPath("*")
 *             .host("*")
 *             .httpMethod("*")
 *             .serviceType("*")
 *             .serviceName("*")
 *             .resourceArn("*")
 *             .attributes(Map.of("Hello", "Tris"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:xray:SamplingRule
 *     properties:
 *       ruleName: example
 *       priority: 9999
 *       version: 1
 *       reservoirSize: 1
 *       fixedRate: 0.05
 *       urlPath: '*'
 *       host: '*'
 *       httpMethod: '*'
 *       serviceType: '*'
 *       serviceName: '*'
 *       resourceArn: '*'
 *       attributes:
 *         Hello: Tris
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import XRay Sampling Rules using the name. For example:
 * ```sh
 * $ pulumi import aws:xray/samplingRule:SamplingRule example example
 * ```
 */
public class SamplingRule internal constructor(
    override val javaResource: com.pulumi.aws.xray.SamplingRule,
) : KotlinCustomResource(javaResource, SamplingRuleMapper) {
    /**
     * The ARN of the sampling rule.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Matches attributes derived from the request.
     */
    public val attributes: Output<Map<String, String>>?
        get() = javaResource.attributes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The percentage of matching requests to instrument, after the reservoir is exhausted.
     */
    public val fixedRate: Output<Double>
        get() = javaResource.fixedRate().applyValue({ args0 -> args0 })

    /**
     * Matches the hostname from a request URL.
     */
    public val host: Output<String>
        get() = javaResource.host().applyValue({ args0 -> args0 })

    /**
     * Matches the HTTP method of a request.
     */
    public val httpMethod: Output<String>
        get() = javaResource.httpMethod().applyValue({ args0 -> args0 })

    /**
     * The priority of the sampling rule.
     */
    public val priority: Output<Int>
        get() = javaResource.priority().applyValue({ args0 -> args0 })

    /**
     * A fixed number of matching requests to instrument per second, prior to applying the fixed rate. The reservoir is not used directly by services, but applies to all services using the rule collectively.
     */
    public val reservoirSize: Output<Int>
        get() = javaResource.reservoirSize().applyValue({ args0 -> args0 })

    /**
     * Matches the ARN of the AWS resource on which the service runs.
     */
    public val resourceArn: Output<String>
        get() = javaResource.resourceArn().applyValue({ args0 -> args0 })

    /**
     * The name of the sampling rule.
     */
    public val ruleName: Output<String>?
        get() = javaResource.ruleName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Matches the `name` that the service uses to identify itself in segments.
     */
    public val serviceName: Output<String>
        get() = javaResource.serviceName().applyValue({ args0 -> args0 })

    /**
     * Matches the `origin` that the service uses to identify its type in segments.
     */
    public val serviceType: Output<String>
        get() = javaResource.serviceType().applyValue({ args0 -> args0 })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Matches the path from a request URL.
     */
    public val urlPath: Output<String>
        get() = javaResource.urlPath().applyValue({ args0 -> args0 })

    /**
     * The version of the sampling rule format (`1` )
     */
    public val version: Output<Int>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object SamplingRuleMapper : ResourceMapper<SamplingRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.xray.SamplingRule::class == javaResource::class

    override fun map(javaResource: Resource): SamplingRule = SamplingRule(
        javaResource as
            com.pulumi.aws.xray.SamplingRule,
    )
}

/**
 * @see [SamplingRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SamplingRule].
 */
public suspend fun samplingRule(
    name: String,
    block: suspend SamplingRuleResourceBuilder.() -> Unit,
): SamplingRule {
    val builder = SamplingRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SamplingRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun samplingRule(name: String): SamplingRule {
    val builder = SamplingRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
