@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.xray.kotlin.inputs

import com.pulumi.aws.xray.inputs.GroupInsightsConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property insightsEnabled Specifies whether insights are enabled.
 * @property notificationsEnabled Specifies whether insight notifications are enabled.
 */
public data class GroupInsightsConfigurationArgs(
    public val insightsEnabled: Output<Boolean>,
    public val notificationsEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.xray.inputs.GroupInsightsConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.xray.inputs.GroupInsightsConfigurationArgs =
        com.pulumi.aws.xray.inputs.GroupInsightsConfigurationArgs.builder()
            .insightsEnabled(insightsEnabled.applyValue({ args0 -> args0 }))
            .notificationsEnabled(notificationsEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupInsightsConfigurationArgs].
 */
@PulumiTagMarker
public class GroupInsightsConfigurationArgsBuilder internal constructor() {
    private var insightsEnabled: Output<Boolean>? = null

    private var notificationsEnabled: Output<Boolean>? = null

    /**
     * @param value Specifies whether insights are enabled.
     */
    @JvmName("afgyqtvtkggbrewn")
    public suspend fun insightsEnabled(`value`: Output<Boolean>) {
        this.insightsEnabled = value
    }

    /**
     * @param value Specifies whether insight notifications are enabled.
     */
    @JvmName("tfywvnjpdurbybpp")
    public suspend fun notificationsEnabled(`value`: Output<Boolean>) {
        this.notificationsEnabled = value
    }

    /**
     * @param value Specifies whether insights are enabled.
     */
    @JvmName("iuoggnmqtwpjxffe")
    public suspend fun insightsEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.insightsEnabled = mapped
    }

    /**
     * @param value Specifies whether insight notifications are enabled.
     */
    @JvmName("fajppfmfasvkxxcj")
    public suspend fun notificationsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationsEnabled = mapped
    }

    internal fun build(): GroupInsightsConfigurationArgs = GroupInsightsConfigurationArgs(
        insightsEnabled = insightsEnabled ?: throw PulumiNullFieldException("insightsEnabled"),
        notificationsEnabled = notificationsEnabled,
    )
}
