@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.gitlab.kotlin.outputs.ApplicationSettingsDefaultBranchProtectionDefaults
import com.pulumi.gitlab.kotlin.outputs.ApplicationSettingsDefaultBranchProtectionDefaults.Companion.toKotlin
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ApplicationSettings].
 */
@PulumiTagMarker
public class ApplicationSettingsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationSettingsArgs = ApplicationSettingsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplicationSettingsArgsBuilder.() -> Unit) {
        val builder = ApplicationSettingsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ApplicationSettings {
        val builtJavaResource = com.pulumi.gitlab.ApplicationSettings(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ApplicationSettings(builtJavaResource)
    }
}

/**
 * ## Example Usage
 */
public class ApplicationSettings internal constructor(
    override val javaResource: com.pulumi.gitlab.ApplicationSettings,
) : KotlinCustomResource(javaResource, ApplicationSettingsMapper) {
    /**
     * If set, abuse reports are sent to this address. Abuse reports are always available in the Admin Area.
     */
    public val abuseNotificationEmail: Output<String>
        get() = javaResource.abuseNotificationEmail().applyValue({ args0 -> args0 })

    /**
     * Require administrators to enable Admin Mode by re-authenticating for administrative tasks.
     */
    public val adminMode: Output<Boolean>
        get() = javaResource.adminMode().applyValue({ args0 -> args0 })

    /**
     * Where to redirect users after logout.
     */
    public val afterSignOutPath: Output<String>
        get() = javaResource.afterSignOutPath().applyValue({ args0 -> args0 })

    /**
     * Text shown to the user after signing up.
     */
    public val afterSignUpText: Output<String>
        get() = javaResource.afterSignUpText().applyValue({ args0 -> args0 })

    /**
     * API key for Akismet spam protection.
     */
    public val akismetApiKey: Output<String>
        get() = javaResource.akismetApiKey().applyValue({ args0 -> args0 })

    /**
     * (If enabled, requires: akismet*api*key) Enable or disable Akismet spam protection.
     */
    public val akismetEnabled: Output<Boolean>
        get() = javaResource.akismetEnabled().applyValue({ args0 -> args0 })

    /**
     * Set to true to allow users to delete their accounts. Premium and Ultimate only.
     */
    public val allowAccountDeletion: Output<Boolean>
        get() = javaResource.allowAccountDeletion().applyValue({ args0 -> args0 })

    /**
     * Set to true to allow group owners to manage LDAP.
     */
    public val allowGroupOwnersToManageLdap: Output<Boolean>
        get() = javaResource.allowGroupOwnersToManageLdap().applyValue({ args0 -> args0 })

    /**
     * Allow requests to the local network from system hooks.
     */
    public val allowLocalRequestsFromSystemHooks: Output<Boolean>
        get() = javaResource.allowLocalRequestsFromSystemHooks().applyValue({ args0 -> args0 })

    /**
     * Allow requests to the local network from web hooks and services.
     */
    public val allowLocalRequestsFromWebHooksAndServices: Output<Boolean>
        get() = javaResource.allowLocalRequestsFromWebHooksAndServices().applyValue({ args0 -> args0 })

    /**
     * Indicates whether users assigned up to the Guest role can create groups and personal projects.
     */
    public val allowProjectCreationForGuestAndBelow: Output<Boolean>
        get() = javaResource.allowProjectCreationForGuestAndBelow().applyValue({ args0 -> args0 })

    /**
     * Allow using a registration token to create a runner.
     */
    public val allowRunnerRegistrationToken: Output<Boolean>
        get() = javaResource.allowRunnerRegistrationToken().applyValue({ args0 -> args0 })

    /**
     * Set the duration for which the jobs are considered as old and expired. After that time passes, the jobs are archived and no longer able to be retried. Make it empty to never expire jobs. It has to be no less than 1 day, for example: 15 days, 1 month, 2 years.
     */
    public val archiveBuildsInHumanReadable: Output<String>
        get() = javaResource.archiveBuildsInHumanReadable().applyValue({ args0 -> args0 })

    /**
     * Maximum limit of AsciiDoc include directives being processed in any one document. Maximum: 64.
     */
    public val asciidocMaxIncludes: Output<Int>
        get() = javaResource.asciidocMaxIncludes().applyValue({ args0 -> args0 })

    /**
     * Assets that match these domains are not proxied. Wildcards allowed. Your GitLab installation URL is automatically allowlisted. GitLab restart is required to apply changes.
     */
    public val assetProxyAllowlists: Output<List<String>>
        get() = javaResource.assetProxyAllowlists().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * (If enabled, requires: asset*proxy*url) Enable proxying of assets. GitLab restart is required to apply changes.
     */
    public val assetProxyEnabled: Output<Boolean>
        get() = javaResource.assetProxyEnabled().applyValue({ args0 -> args0 })

    /**
     * Shared secret with the asset proxy server. GitLab restart is required to apply changes.
     */
    public val assetProxySecretKey: Output<String>
        get() = javaResource.assetProxySecretKey().applyValue({ args0 -> args0 })

    /**
     * URL of the asset proxy server. GitLab restart is required to apply changes.
     */
    public val assetProxyUrl: Output<String>
        get() = javaResource.assetProxyUrl().applyValue({ args0 -> args0 })

    /**
     * By default, we write to the authorized_keys file to support Git over SSH without additional configuration. GitLab can be optimized to authenticate SSH keys via the database file. Only disable this if you have configured your OpenSSH server to use the AuthorizedKeysCommand.
     */
    public val authorizedKeysEnabled: Output<Boolean>
        get() = javaResource.authorizedKeysEnabled().applyValue({ args0 -> args0 })

    /**
     * When enabled, users will get automatically banned from the application when they download more than the maximum number of unique projects in the time period specified by max*number*of*repository*downloads and max*number*of*repository*downloads*within*time_period respectively. Introduced in GitLab 15.4. Self-managed, Ultimate only.
     */
    public val autoBanUserOnExcessiveProjectsDownload: Output<Boolean>
        get() = javaResource.autoBanUserOnExcessiveProjectsDownload().applyValue({ args0 -> args0 })

    /**
     * Specify a domain to use by default for every project’s Auto Review Apps and Auto Deploy stages.
     */
    public val autoDevopsDomain: Output<String>
        get() = javaResource.autoDevopsDomain().applyValue({ args0 -> args0 })

    /**
     * Enable Auto DevOps for projects by default. It automatically builds, tests, and deploys applications based on a predefined CI/CD configuration.
     */
    public val autoDevopsEnabled: Output<Boolean>
        get() = javaResource.autoDevopsEnabled().applyValue({ args0 -> args0 })

    /**
     * Enabling this permits automatic allocation of purchased storage in a namespace.
     */
    public val automaticPurchasedStorageAllocation: Output<Boolean>
        get() = javaResource.automaticPurchasedStorageAllocation().applyValue({ args0 -> args0 })

    /**
     * Maximum simultaneous Direct Transfer batches to process.
     */
    public val bulkImportConcurrentPipelineBatchLimit: Output<Int>
        get() = javaResource.bulkImportConcurrentPipelineBatchLimit().applyValue({ args0 -> args0 })

    /**
     * Enable migrating GitLab groups by direct transfer. Introduced in GitLab 15.8.
     */
    public val bulkImportEnabled: Output<Boolean>
        get() = javaResource.bulkImportEnabled().applyValue({ args0 -> args0 })

    /**
     * Maximum download file size when importing from source GitLab instances by direct transfer. Introduced in GitLab 16.3.
     */
    public val bulkImportMaxDownloadFileSize: Output<Int>
        get() = javaResource.bulkImportMaxDownloadFileSize().applyValue({ args0 -> args0 })

    /**
     * Indicates whether users can create top-level groups. Introduced in GitLab 15.5.
     */
    public val canCreateGroup: Output<Boolean>
        get() = javaResource.canCreateGroup().applyValue({ args0 -> args0 })

    /**
     * Enabling this makes only licensed EE features available to projects if the project namespace’s plan includes the feature or if the project is public.
     */
    public val checkNamespacePlan: Output<Boolean>
        get() = javaResource.checkNamespacePlan().applyValue({ args0 -> args0 })

    /**
     * The maximum number of includes per pipeline.
     */
    public val ciMaxIncludes: Output<Int>
        get() = javaResource.ciMaxIncludes().applyValue({ args0 -> args0 })

    /**
     * The maximum amount of memory, in bytes, that can be allocated for the pipeline configuration, with all included YAML configuration files.
     */
    public val ciMaxTotalYamlSizeBytes: Output<Int>
        get() = javaResource.ciMaxTotalYamlSizeBytes().applyValue({ args0 -> args0 })

    /**
     * Custom hostname (for private commit emails).
     */
    public val commitEmailHostname: Output<String>
        get() = javaResource.commitEmailHostname().applyValue({ args0 -> args0 })

    /**
     * Maximum number of simultaneous import jobs for the Bitbucket Cloud importer. Introduced in GitLab 16.11.
     */
    public val concurrentBitbucketImportJobsLimit: Output<Int>
        get() = javaResource.concurrentBitbucketImportJobsLimit().applyValue({ args0 -> args0 })

    /**
     * Maximum number of simultaneous import jobs for the Bitbucket Server importer. Introduced in GitLab 16.11.
     */
    public val concurrentBitbucketServerImportJobsLimit: Output<Int>
        get() = javaResource.concurrentBitbucketServerImportJobsLimit().applyValue({ args0 -> args0 })

    /**
     * Maximum number of simultaneous import jobs for the GitHub importer. Introduced in GitLab 16.11.
     */
    public val concurrentGithubImportJobsLimit: Output<Int>
        get() = javaResource.concurrentGithubImportJobsLimit().applyValue({ args0 -> args0 })

    /**
     * Enable cleanup policies for all projects.
     */
    public val containerExpirationPoliciesEnableHistoricEntries: Output<Boolean>
        get() = javaResource.containerExpirationPoliciesEnableHistoricEntries().applyValue({ args0 ->
            args0
        })

    /**
     * The maximum number of tags that can be deleted in a single execution of cleanup policies.
     */
    public val containerRegistryCleanupTagsServiceMaxListSize: Output<Int>
        get() = javaResource.containerRegistryCleanupTagsServiceMaxListSize().applyValue({ args0 ->
            args0
        })

    /**
     * The maximum time, in seconds, that the cleanup process can take to delete a batch of tags for cleanup policies.
     */
    public val containerRegistryDeleteTagsServiceTimeout: Output<Int>
        get() = javaResource.containerRegistryDeleteTagsServiceTimeout().applyValue({ args0 -> args0 })

    /**
     * Caching during the execution of cleanup policies.
     */
    public val containerRegistryExpirationPoliciesCaching: Output<Boolean>
        get() = javaResource.containerRegistryExpirationPoliciesCaching().applyValue({ args0 -> args0 })

    /**
     * Number of workers for cleanup policies.
     */
    public val containerRegistryExpirationPoliciesWorkerCapacity: Output<Int>
        get() = javaResource.containerRegistryExpirationPoliciesWorkerCapacity().applyValue({ args0 ->
            args0
        })

    /**
     * Container Registry token duration in minutes.
     */
    public val containerRegistryTokenExpireDelay: Output<Int>
        get() = javaResource.containerRegistryTokenExpireDelay().applyValue({ args0 -> args0 })

    /**
     * Enable automatic deactivation of dormant users.
     */
    public val deactivateDormantUsers: Output<Boolean>
        get() = javaResource.deactivateDormantUsers().applyValue({ args0 -> args0 })

    /**
     * Length of time (in days) after which a user is considered dormant. Introduced in GitLab 15.3.
     */
    public val deactivateDormantUsersPeriod: Output<Int>
        get() = javaResource.deactivateDormantUsersPeriod().applyValue({ args0 -> args0 })

    /**
     * Default timeout for decompressing archived files, in seconds. Set to 0 to disable timeouts. Introduced in GitLab 16.4.
     */
    public val decompressArchiveFileTimeout: Output<Int>
        get() = javaResource.decompressArchiveFileTimeout().applyValue({ args0 -> args0 })

    /**
     * Set the default expiration time for each job’s artifacts.
     */
    public val defaultArtifactsExpireIn: Output<String>
        get() = javaResource.defaultArtifactsExpireIn().applyValue({ args0 -> args0 })

    /**
     * Instance-level custom initial branch name (introduced in GitLab 13.2).
     */
    public val defaultBranchName: Output<String>
        get() = javaResource.defaultBranchName().applyValue({ args0 -> args0 })

    /**
     * Determine if developers can push to the default branch. Can take: 0 (not protected, both users with the Developer role or Maintainer role can push new commits and force push), 1 (partially protected, users with the Developer role or Maintainer role can push new commits, but cannot force push) or 2 (fully protected, users with the Developer or Maintainer role cannot push new commits, but users with the Developer or Maintainer role can; no one can force push) as a parameter. Default is 2.
     */
    public val defaultBranchProtection: Output<Int>
        get() = javaResource.defaultBranchProtection().applyValue({ args0 -> args0 })

    /**
     * The default*branch*protection*defaults attribute describes the default branch protection defaults. All parameters are optional.
     */
    public val defaultBranchProtectionDefaults:
        Output<ApplicationSettingsDefaultBranchProtectionDefaults>
        get() = javaResource.defaultBranchProtectionDefaults().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * Default CI/CD configuration file and path for new projects (.gitlab-ci.yml if not set).
     */
    public val defaultCiConfigPath: Output<String>
        get() = javaResource.defaultCiConfigPath().applyValue({ args0 -> args0 })

    /**
     * What visibility level new groups receive. Can take private, internal and public as a parameter.
     */
    public val defaultGroupVisibility: Output<String>
        get() = javaResource.defaultGroupVisibility().applyValue({ args0 -> args0 })

    /**
     * Default preferred language for users who are not logged in.
     */
    public val defaultPreferredLanguage: Output<String>
        get() = javaResource.defaultPreferredLanguage().applyValue({ args0 -> args0 })

    /**
     * Default project creation protection. Can take: 0 (No one), 1 (Maintainers) or 2 (Developers + Maintainers).
     */
    public val defaultProjectCreation: Output<Int>
        get() = javaResource.defaultProjectCreation().applyValue({ args0 -> args0 })

    /**
     * What visibility level new projects receive. Can take private, internal and public as a parameter.
     */
    public val defaultProjectVisibility: Output<String>
        get() = javaResource.defaultProjectVisibility().applyValue({ args0 -> args0 })

    /**
     * Project limit per user.
     */
    public val defaultProjectsLimit: Output<Int>
        get() = javaResource.defaultProjectsLimit().applyValue({ args0 -> args0 })

    /**
     * What visibility level new snippets receive. Can take private, internal and public as a parameter.
     */
    public val defaultSnippetVisibility: Output<String>
        get() = javaResource.defaultSnippetVisibility().applyValue({ args0 -> args0 })

    /**
     * Default syntax highlighting theme for users who are new or not signed in. See IDs of available themes (https://gitlab.com/gitlab-org/gitlab/blob/master/lib/gitlab/themes.rb#L16)
     */
    public val defaultSyntaxHighlightingTheme: Output<Int>
        get() = javaResource.defaultSyntaxHighlightingTheme().applyValue({ args0 -> args0 })

    /**
     * Enable inactive project deletion feature. Introduced in GitLab 14.10. Became operational in GitLab 15.0 (with feature flag inactive*projects*deletion).
     */
    public val deleteInactiveProjects: Output<Boolean>
        get() = javaResource.deleteInactiveProjects().applyValue({ args0 -> args0 })

    /**
     * Specifies whether users who have not confirmed their email should be deleted. When set to true, unconfirmed users are deleted after unconfirmed*users*delete*after*days days. Introduced in GitLab 16.1. Self-managed, Premium and Ultimate only.
     */
    public val deleteUnconfirmedUsers: Output<Boolean>
        get() = javaResource.deleteUnconfirmedUsers().applyValue({ args0 -> args0 })

    /**
     * The number of days to wait before deleting a project or group that is marked for deletion. Value must be between 1 and 90.
     */
    public val deletionAdjournedPeriod: Output<Int>
        get() = javaResource.deletionAdjournedPeriod().applyValue({ args0 -> args0 })

    /**
     * (If enabled, requires diagramsnet_url) Enable Diagrams.net integration.
     */
    public val diagramsnetEnabled: Output<Boolean>
        get() = javaResource.diagramsnetEnabled().applyValue({ args0 -> args0 })

    /**
     * The Diagrams.net instance URL for integration.
     */
    public val diagramsnetUrl: Output<String>
        get() = javaResource.diagramsnetUrl().applyValue({ args0 -> args0 })

    /**
     * Maximum files in a diff.
     */
    public val diffMaxFiles: Output<Int>
        get() = javaResource.diffMaxFiles().applyValue({ args0 -> args0 })

    /**
     * Maximum lines in a diff.
     */
    public val diffMaxLines: Output<Int>
        get() = javaResource.diffMaxLines().applyValue({ args0 -> args0 })

    /**
     * Maximum diff patch size, in bytes.
     */
    public val diffMaxPatchBytes: Output<Int>
        get() = javaResource.diffMaxPatchBytes().applyValue({ args0 -> args0 })

    /**
     * Stops administrators from connecting their GitLab accounts to non-trusted OAuth 2.0 applications that have the api, read*api, read*repository, write*repository, read*registry, write_registry, or sudo scopes. Introduced in GitLab 15.6.
     */
    public val disableAdminOauthScopes: Output<Boolean>
        get() = javaResource.disableAdminOauthScopes().applyValue({ args0 -> args0 })

    /**
     * Disable display of RSS/Atom and calendar feed tokens (introduced in GitLab 13.7).
     */
    public val disableFeedToken: Output<Boolean>
        get() = javaResource.disableFeedToken().applyValue({ args0 -> args0 })

    /**
     * Disable personal access tokens. Introduced in GitLab 15.7. Self-managed, Premium and Ultimate only. There is no method available to enable a personal access token that’s been disabled through the API. This is a known issue.
     */
    public val disablePersonalAccessTokens: Output<Boolean>
        get() = javaResource.disablePersonalAccessTokens().applyValue({ args0 -> args0 })

    /**
     * Disabled OAuth sign-in sources.
     */
    public val disabledOauthSignInSources: Output<List<String>>
        get() = javaResource.disabledOauthSignInSources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * Enforce DNS rebinding attack protection.
     */
    public val dnsRebindingProtectionEnabled: Output<Boolean>
        get() = javaResource.dnsRebindingProtectionEnabled().applyValue({ args0 -> args0 })

    /**
     * Force people to use only corporate emails for sign-up. Null means there is no restriction.
     */
    public val domainAllowlists: Output<List<String>>
        get() = javaResource.domainAllowlists().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * (If enabled, requires: domain_denylist) Allows blocking sign-ups from emails from specific domains.
     */
    public val domainDenylistEnabled: Output<Boolean>
        get() = javaResource.domainDenylistEnabled().applyValue({ args0 -> args0 })

    /**
     * Users with email addresses that match these domains cannot sign up. Wildcards allowed. Use separate lines for multiple entries. Ex: domain.com, *.domain.com.
     */
    public val domainDenylists: Output<List<String>>
        get() = javaResource.domainDenylists().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Maximum downstream pipeline trigger rate. Introduced in GitLab 16.10.
     */
    public val downstreamPipelineTriggerLimitPerProjectUserSha: Output<Int>
        get() = javaResource.downstreamPipelineTriggerLimitPerProjectUserSha().applyValue({ args0 ->
            args0
        })

    /**
     * The minimum allowed bit length of an uploaded DSA key. 0 means no restriction. -1 disables DSA keys.
     */
    public val dsaKeyRestriction: Output<Int>
        get() = javaResource.dsaKeyRestriction().applyValue({ args0 -> args0 })

    /**
     * Indicates whether GitLab Duo features are enabled for this instance. Introduced in GitLab 16.10. Self-managed, Premium and Ultimate only.
     */
    public val duoFeaturesEnabled: Output<Boolean>
        get() = javaResource.duoFeaturesEnabled().applyValue({ args0 -> args0 })

    /**
     * The minimum allowed curve size (in bits) of an uploaded ECDSA key. 0 means no restriction. -1 disables ECDSA keys.
     */
    public val ecdsaKeyRestriction: Output<Int>
        get() = javaResource.ecdsaKeyRestriction().applyValue({ args0 -> args0 })

    /**
     * The minimum allowed curve size (in bits) of an uploaded ECDSA*SK key. 0 means no restriction. -1 disables ECDSA*SK keys.
     */
    public val ecdsaSkKeyRestriction: Output<Int>
        get() = javaResource.ecdsaSkKeyRestriction().applyValue({ args0 -> args0 })

    /**
     * The minimum allowed curve size (in bits) of an uploaded ED25519 key. 0 means no restriction. -1 disables ED25519 keys.
     */
    public val ed25519KeyRestriction: Output<Int>
        get() = javaResource.ed25519KeyRestriction().applyValue({ args0 -> args0 })

    /**
     * The minimum allowed curve size (in bits) of an uploaded ED25519*SK key. 0 means no restriction. -1 disables ED25519*SK keys.
     */
    public val ed25519SkKeyRestriction: Output<Int>
        get() = javaResource.ed25519SkKeyRestriction().applyValue({ args0 -> args0 })

    /**
     * AWS IAM access key ID.
     */
    public val eksAccessKeyId: Output<String>
        get() = javaResource.eksAccessKeyId().applyValue({ args0 -> args0 })

    /**
     * Amazon account ID.
     */
    public val eksAccountId: Output<String>
        get() = javaResource.eksAccountId().applyValue({ args0 -> args0 })

    /**
     * Enable integration with Amazon EKS.
     */
    public val eksIntegrationEnabled: Output<Boolean>
        get() = javaResource.eksIntegrationEnabled().applyValue({ args0 -> args0 })

    /**
     * AWS IAM secret access key.
     */
    public val eksSecretAccessKey: Output<String>
        get() = javaResource.eksSecretAccessKey().applyValue({ args0 -> args0 })

    /**
     * Enable the use of AWS hosted Elasticsearch.
     */
    public val elasticsearchAws: Output<Boolean>
        get() = javaResource.elasticsearchAws().applyValue({ args0 -> args0 })

    /**
     * AWS IAM access key.
     */
    public val elasticsearchAwsAccessKey: Output<String>
        get() = javaResource.elasticsearchAwsAccessKey().applyValue({ args0 -> args0 })

    /**
     * The AWS region the Elasticsearch domain is configured.
     */
    public val elasticsearchAwsRegion: Output<String>
        get() = javaResource.elasticsearchAwsRegion().applyValue({ args0 -> args0 })

    /**
     * AWS IAM secret access key.
     */
    public val elasticsearchAwsSecretAccessKey: Output<String>
        get() = javaResource.elasticsearchAwsSecretAccessKey().applyValue({ args0 -> args0 })

    /**
     * Maximum size of text fields to index by Elasticsearch. 0 value means no limit. This does not apply to repository and wiki indexing.
     */
    public val elasticsearchIndexedFieldLengthLimit: Output<Int>
        get() = javaResource.elasticsearchIndexedFieldLengthLimit().applyValue({ args0 -> args0 })

    /**
     * Maximum size of repository and wiki files that are indexed by Elasticsearch.
     */
    public val elasticsearchIndexedFileSizeLimitKb: Output<Int>
        get() = javaResource.elasticsearchIndexedFileSizeLimitKb().applyValue({ args0 -> args0 })

    /**
     * Enable Elasticsearch indexing.
     */
    public val elasticsearchIndexing: Output<Boolean>
        get() = javaResource.elasticsearchIndexing().applyValue({ args0 -> args0 })

    /**
     * Limit Elasticsearch to index certain namespaces and projects.
     */
    public val elasticsearchLimitIndexing: Output<Boolean>
        get() = javaResource.elasticsearchLimitIndexing().applyValue({ args0 -> args0 })

    /**
     * Maximum concurrency of Elasticsearch bulk requests per indexing operation. This only applies to repository indexing operations.
     */
    public val elasticsearchMaxBulkConcurrency: Output<Int>
        get() = javaResource.elasticsearchMaxBulkConcurrency().applyValue({ args0 -> args0 })

    /**
     * Maximum size of Elasticsearch bulk indexing requests in MB. This only applies to repository indexing operations.
     */
    public val elasticsearchMaxBulkSizeMb: Output<Int>
        get() = javaResource.elasticsearchMaxBulkSizeMb().applyValue({ args0 -> args0 })

    /**
     * The namespaces to index via Elasticsearch if elasticsearch*limit*indexing is enabled.
     */
    public val elasticsearchNamespaceIds: Output<List<Int>>
        get() = javaResource.elasticsearchNamespaceIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * The password of your Elasticsearch instance.
     */
    public val elasticsearchPassword: Output<String>
        get() = javaResource.elasticsearchPassword().applyValue({ args0 -> args0 })

    /**
     * The projects to index via Elasticsearch if elasticsearch*limit*indexing is enabled.
     */
    public val elasticsearchProjectIds: Output<List<Int>>
        get() = javaResource.elasticsearchProjectIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * Enable Elasticsearch search.
     */
    public val elasticsearchSearch: Output<Boolean>
        get() = javaResource.elasticsearchSearch().applyValue({ args0 -> args0 })

    /**
     * The URL to use for connecting to Elasticsearch. Use a comma-separated list to support cluster (for example, http://localhost:9200, http://localhost:9201).
     */
    public val elasticsearchUrls: Output<List<String>>
        get() = javaResource.elasticsearchUrls().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The username of your Elasticsearch instance.
     */
    public val elasticsearchUsername: Output<String>
        get() = javaResource.elasticsearchUsername().applyValue({ args0 -> args0 })

    /**
     * Additional text added to the bottom of every email for legal/auditing/compliance reasons.
     */
    public val emailAdditionalText: Output<String>
        get() = javaResource.emailAdditionalText().applyValue({ args0 -> args0 })

    /**
     * Some email servers do not support overriding the email sender name. Enable this option to include the name of the author of the issue, merge request or comment in the email body instead.
     */
    public val emailAuthorInBody: Output<Boolean>
        get() = javaResource.emailAuthorInBody().applyValue({ args0 -> args0 })

    /**
     * Enabled protocols for Git access. Allowed values are: ssh, http, and nil to allow both protocols.
     */
    public val enabledGitAccessProtocol: Output<String>
        get() = javaResource.enabledGitAccessProtocol().applyValue({ args0 -> args0 })

    /**
     * Enabling this permits enforcement of namespace storage limits.
     */
    public val enforceNamespaceStorageLimit: Output<Boolean>
        get() = javaResource.enforceNamespaceStorageLimit().applyValue({ args0 -> args0 })

    /**
     * (If enabled, requires: terms) Enforce application ToS to all users.
     */
    public val enforceTerms: Output<Boolean>
        get() = javaResource.enforceTerms().applyValue({ args0 -> args0 })

    /**
     * (If enabled, requires: external*auth*client_key) The certificate to use to authenticate with the external authorization service.
     */
    public val externalAuthClientCert: Output<String>
        get() = javaResource.externalAuthClientCert().applyValue({ args0 -> args0 })

    /**
     * Private key for the certificate when authentication is required for the external authorization service, this is encrypted when stored.
     */
    public val externalAuthClientKey: Output<String>
        get() = javaResource.externalAuthClientKey().applyValue({ args0 -> args0 })

    /**
     * Passphrase to use for the private key when authenticating with the external service this is encrypted when stored.
     */
    public val externalAuthClientKeyPass: Output<String>
        get() = javaResource.externalAuthClientKeyPass().applyValue({ args0 -> args0 })

    /**
     * The default classification label to use when requesting authorization and no classification label has been specified on the project.
     */
    public val externalAuthorizationServiceDefaultLabel: Output<String>
        get() = javaResource.externalAuthorizationServiceDefaultLabel().applyValue({ args0 -> args0 })

    /**
     * (If enabled, requires: external*authorization*service*default*label, external*authorization*service*timeout and external*authorization*service*url) Enable using an external authorization service for accessing projects.
     */
    public val externalAuthorizationServiceEnabled: Output<Boolean>
        get() = javaResource.externalAuthorizationServiceEnabled().applyValue({ args0 -> args0 })

    /**
     * The timeout after which an authorization request is aborted, in seconds. When a request times out, access is denied to the user. (min: 0.001, max: 10, step: 0.001).
     */
    public val externalAuthorizationServiceTimeout: Output<Double>
        get() = javaResource.externalAuthorizationServiceTimeout().applyValue({ args0 -> args0 })

    /**
     * URL to which authorization requests are directed.
     */
    public val externalAuthorizationServiceUrl: Output<String>
        get() = javaResource.externalAuthorizationServiceUrl().applyValue({ args0 -> args0 })

    /**
     * How long to wait for a response from the pipeline validation service. Assumes OK if it times out.
     */
    public val externalPipelineValidationServiceTimeout: Output<Int>
        get() = javaResource.externalPipelineValidationServiceTimeout().applyValue({ args0 -> args0 })

    /**
     * Optional. Token to include as the X-Gitlab-Token header in requests to the URL in external*pipeline*validation*service*url.
     */
    public val externalPipelineValidationServiceToken: Output<String>
        get() = javaResource.externalPipelineValidationServiceToken().applyValue({ args0 -> args0 })

    /**
     * URL to use for pipeline validation requests.
     */
    public val externalPipelineValidationServiceUrl: Output<String>
        get() = javaResource.externalPipelineValidationServiceUrl().applyValue({ args0 -> args0 })

    /**
     * The ID of a project to load custom file templates from.
     */
    public val fileTemplateProjectId: Output<Int>
        get() = javaResource.fileTemplateProjectId().applyValue({ args0 -> args0 })

    /**
     * Start day of the week for calendar views and date pickers. Valid values are 0 for Sunday, 1 for Monday, and 6 for Saturday.
     */
    public val firstDayOfWeek: Output<Int>
        get() = javaResource.firstDayOfWeek().applyValue({ args0 -> args0 })

    /**
     * Comma-separated list of IPs and CIDRs of allowed secondary nodes. For example, 1.1.1.1, 2.2.2.0/24.
     */
    public val geoNodeAllowedIps: Output<String>
        get() = javaResource.geoNodeAllowedIps().applyValue({ args0 -> args0 })

    /**
     * The amount of seconds after which a request to get a secondary node status times out.
     */
    public val geoStatusTimeout: Output<Int>
        get() = javaResource.geoStatusTimeout().applyValue({ args0 -> args0 })

    /**
     * List of usernames excluded from Git anti-abuse rate limits. Maximum: 100 usernames. Introduced in GitLab 15.2.
     */
    public val gitRateLimitUsersAllowlists: Output<List<String>>
        get() = javaResource.gitRateLimitUsersAllowlists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * Maximum duration (in minutes) of a session for Git operations when 2FA is enabled.
     */
    public val gitTwoFactorSessionExpiry: Output<Int>
        get() = javaResource.gitTwoFactorSessionExpiry().applyValue({ args0 -> args0 })

    /**
     * Default Gitaly timeout, in seconds. This timeout is not enforced for Git fetch/push operations or Sidekiq jobs. Set to 0 to disable timeouts.
     */
    public val gitalyTimeoutDefault: Output<Int>
        get() = javaResource.gitalyTimeoutDefault().applyValue({ args0 -> args0 })

    /**
     * Gitaly fast operation timeout, in seconds. Some Gitaly operations are expected to be fast. If they exceed this threshold, there may be a problem with a storage shard and ‘failing fast’ can help maintain the stability of the GitLab instance. Set to 0 to disable timeouts.
     */
    public val gitalyTimeoutFast: Output<Int>
        get() = javaResource.gitalyTimeoutFast().applyValue({ args0 -> args0 })

    /**
     * Medium Gitaly timeout, in seconds. This should be a value between the Fast and the Default timeout. Set to 0 to disable timeouts.
     */
    public val gitalyTimeoutMedium: Output<Int>
        get() = javaResource.gitalyTimeoutMedium().applyValue({ args0 -> args0 })

    /**
     * Enable Grafana.
     */
    public val grafanaEnabled: Output<Boolean>
        get() = javaResource.grafanaEnabled().applyValue({ args0 -> args0 })

    /**
     * Grafana URL.
     */
    public val grafanaUrl: Output<String>
        get() = javaResource.grafanaUrl().applyValue({ args0 -> args0 })

    /**
     * Enable Gravatar.
     */
    public val gravatarEnabled: Output<Boolean>
        get() = javaResource.gravatarEnabled().applyValue({ args0 -> args0 })

    /**
     * Prevent overrides of default branch protection.
     */
    public val groupOwnersCanManageDefaultBranchProtection: Output<Boolean>
        get() = javaResource.groupOwnersCanManageDefaultBranchProtection().applyValue({ args0 -> args0 })

    /**
     * Create new projects using hashed storage paths: Enable immutable, hash-based paths and repository names to store repositories on disk. This prevents repositories from having to be moved or renamed when the Project URL changes and may improve disk I/O performance. (Always enabled in GitLab versions 13.0 and later, configuration is scheduled for removal in 14.0).
     */
    public val hashedStorageEnabled: Output<Boolean>
        get() = javaResource.hashedStorageEnabled().applyValue({ args0 -> args0 })

    /**
     * Hide marketing-related entries from help.
     */
    public val helpPageHideCommercialContent: Output<Boolean>
        get() = javaResource.helpPageHideCommercialContent().applyValue({ args0 -> args0 })

    /**
     * Alternate support URL for help page and help dropdown.
     */
    public val helpPageSupportUrl: Output<String>
        get() = javaResource.helpPageSupportUrl().applyValue({ args0 -> args0 })

    /**
     * Custom text displayed on the help page.
     */
    public val helpPageText: Output<String>
        get() = javaResource.helpPageText().applyValue({ args0 -> args0 })

    /**
     * GitLab server administrator information.
     */
    public val helpText: Output<String>
        get() = javaResource.helpText().applyValue({ args0 -> args0 })

    /**
     * Do not display offers from third parties in GitLab.
     */
    public val hideThirdPartyOffers: Output<Boolean>
        get() = javaResource.hideThirdPartyOffers().applyValue({ args0 -> args0 })

    /**
     * Redirect to this URL when not logged in.
     */
    public val homePageUrl: Output<String>
        get() = javaResource.homePageUrl().applyValue({ args0 -> args0 })

    /**
     * Enable or disable Git housekeeping.
     * 			If enabled, requires either housekeeping*optimize*repository*period OR housekeeping*bitmaps*enabled, housekeeping*full*repack*period, housekeeping*gc*period, and housekeeping*incremental*repack*period.
     * 			Options housekeeping*bitmaps*enabled, housekeeping*full*repack*period, housekeeping*gc*period, and housekeeping*incremental*repack*period are deprecated. Use housekeeping*optimize*repository*period instead.
     */
    public val housekeepingEnabled: Output<Boolean>
        get() = javaResource.housekeepingEnabled().applyValue({ args0 -> args0 })

    /**
     * Number of Git pushes after which an incremental git repack is run.
     */
    @Deprecated(
        message = """
  housekeeping_full_repack_period is deprecated. Use housekeeping_optimize_repository_period
      instead.
  """,
    )
    public val housekeepingFullRepackPeriod: Output<Int>
        get() = javaResource.housekeepingFullRepackPeriod().applyValue({ args0 -> args0 })

    /**
     * Number of Git pushes after which git gc is run.
     */
    @Deprecated(
        message = """
  housekeeping_gc_period is deprecated. Use housekeeping_optimize_repository_period instead.
  """,
    )
    public val housekeepingGcPeriod: Output<Int>
        get() = javaResource.housekeepingGcPeriod().applyValue({ args0 -> args0 })

    /**
     * Number of Git pushes after which an incremental git repack is run.
     */
    @Deprecated(
        message = """
  housekeeping_incremental_repack_period is deprecated. Use housekeeping_optimize_repository_period
      instead.
  """,
    )
    public val housekeepingIncrementalRepackPeriod: Output<Int>
        get() = javaResource.housekeepingIncrementalRepackPeriod().applyValue({ args0 -> args0 })

    /**
     * Number of Git pushes after which an incremental git repack is run.
     */
    public val housekeepingOptimizeRepositoryPeriod: Output<Int>
        get() = javaResource.housekeepingOptimizeRepositoryPeriod().applyValue({ args0 -> args0 })

    /**
     * Enable HTML emails.
     */
    public val htmlEmailsEnabled: Output<Boolean>
        get() = javaResource.htmlEmailsEnabled().applyValue({ args0 -> args0 })

    /**
     * Sources to allow project import from. Valid values are: `github`, `bitbucket`, `bitbucket_server`, `fogbugz`, `git`, `gitlab.Project`, `gitea`, `manifest`
     */
    public val importSources: Output<List<String>>
        get() = javaResource.importSources().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Enable in-product marketing emails.
     */
    public val inProductMarketingEmailsEnabled: Output<Boolean>
        get() = javaResource.inProductMarketingEmailsEnabled().applyValue({ args0 -> args0 })

    /**
     * If delete*inactive*projects is true, the time (in months) to wait before deleting inactive projects. Introduced in GitLab 14.10. Became operational in GitLab 15.0.
     */
    public val inactiveProjectsDeleteAfterMonths: Output<Int>
        get() = javaResource.inactiveProjectsDeleteAfterMonths().applyValue({ args0 -> args0 })

    /**
     * If delete*inactive*projects is true, the minimum repository size for projects to be checked for inactivity. Introduced in GitLab 14.10. Became operational in GitLab 15.0.
     */
    public val inactiveProjectsMinSizeMb: Output<Int>
        get() = javaResource.inactiveProjectsMinSizeMb().applyValue({ args0 -> args0 })

    /**
     * If delete*inactive*projects is true, sets the time (in months) to wait before emailing maintainers that the project is scheduled be deleted because it is inactive. Introduced in GitLab 14.10. Became operational in GitLab 15.0.
     */
    public val inactiveProjectsSendWarningEmailAfterMonths: Output<Int>
        get() = javaResource.inactiveProjectsSendWarningEmailAfterMonths().applyValue({ args0 -> args0 })

    /**
     * Enable Invisible CAPTCHA spam detection during sign-up.
     */
    public val invisibleCaptchaEnabled: Output<Boolean>
        get() = javaResource.invisibleCaptchaEnabled().applyValue({ args0 -> args0 })

    /**
     * Max number of issue creation requests per minute per user.
     */
    public val issuesCreateLimit: Output<Int>
        get() = javaResource.issuesCreateLimit().applyValue({ args0 -> args0 })

    /**
     * Prevent the deletion of the artifacts from the most recent successful jobs, regardless of the expiry time.
     */
    public val keepLatestArtifact: Output<Boolean>
        get() = javaResource.keepLatestArtifact().applyValue({ args0 -> args0 })

    /**
     * Increase this value when any cached Markdown should be invalidated.
     */
    public val localMarkdownVersion: Output<Int>
        get() = javaResource.localMarkdownVersion().applyValue({ args0 -> args0 })

    /**
     * Enable Mailgun event receiver.
     */
    public val mailgunEventsEnabled: Output<Boolean>
        get() = javaResource.mailgunEventsEnabled().applyValue({ args0 -> args0 })

    /**
     * The Mailgun HTTP webhook signing key for receiving events from webhook.
     */
    public val mailgunSigningKey: Output<String>
        get() = javaResource.mailgunSigningKey().applyValue({ args0 -> args0 })

    /**
     * When instance is in maintenance mode, non-administrative users can sign in with read-only access and make read-only API requests.
     */
    public val maintenanceMode: Output<Boolean>
        get() = javaResource.maintenanceMode().applyValue({ args0 -> args0 })

    /**
     * Message displayed when instance is in maintenance mode.
     */
    public val maintenanceModeMessage: Output<String>
        get() = javaResource.maintenanceModeMessage().applyValue({ args0 -> args0 })

    /**
     * Maximum artifacts size in MB.
     */
    public val maxArtifactsSize: Output<Int>
        get() = javaResource.maxArtifactsSize().applyValue({ args0 -> args0 })

    /**
     * Limit attachment size in MB.
     */
    public val maxAttachmentSize: Output<Int>
        get() = javaResource.maxAttachmentSize().applyValue({ args0 -> args0 })

    /**
     * Maximum export size in MB. 0 for unlimited.
     */
    public val maxExportSize: Output<Int>
        get() = javaResource.maxExportSize().applyValue({ args0 -> args0 })

    /**
     * Maximum import size in MB. 0 for unlimited.
     */
    public val maxImportSize: Output<Int>
        get() = javaResource.maxImportSize().applyValue({ args0 -> args0 })

    /**
     * Maximum number of unique repositories a user can download in the specified time period before they are banned. Maximum: 10,000 repositories. Introduced in GitLab 15.1.
     */
    public val maxNumberOfRepositoryDownloads: Output<Int>
        get() = javaResource.maxNumberOfRepositoryDownloads().applyValue({ args0 -> args0 })

    /**
     * Reporting time period (in seconds). Maximum: 864000 seconds (10 days). Introduced in GitLab 15.1.
     */
    public val maxNumberOfRepositoryDownloadsWithinTimePeriod: Output<Int>
        get() = javaResource.maxNumberOfRepositoryDownloadsWithinTimePeriod().applyValue({ args0 ->
            args0
        })

    /**
     * Maximum size of pages repositories in MB.
     */
    public val maxPagesSize: Output<Int>
        get() = javaResource.maxPagesSize().applyValue({ args0 -> args0 })

    /**
     * Maximum allowable lifetime for access tokens in days.
     */
    public val maxPersonalAccessTokenLifetime: Output<Int>
        get() = javaResource.maxPersonalAccessTokenLifetime().applyValue({ args0 -> args0 })

    /**
     * Maximum allowable lifetime for SSH keys in days. Introduced in GitLab 14.6.
     */
    public val maxSshKeyLifetime: Output<Int>
        get() = javaResource.maxSshKeyLifetime().applyValue({ args0 -> args0 })

    public val maxTerraformStateSizeBytes: Output<Int>
        get() = javaResource.maxTerraformStateSizeBytes().applyValue({ args0 -> args0 })

    /**
     * A method call is only tracked when it takes longer than the given amount of milliseconds.
     */
    public val metricsMethodCallThreshold: Output<Int>
        get() = javaResource.metricsMethodCallThreshold().applyValue({ args0 -> args0 })

    /**
     * Indicates whether passwords require a minimum length. Introduced in GitLab 15.1. Premium and Ultimate only.
     */
    public val minimumPasswordLength: Output<Int>
        get() = javaResource.minimumPasswordLength().applyValue({ args0 -> args0 })

    /**
     * Allow repository mirroring to configured by project Maintainers. If disabled, only Administrators can configure repository mirroring.
     */
    public val mirrorAvailable: Output<Boolean>
        get() = javaResource.mirrorAvailable().applyValue({ args0 -> args0 })

    /**
     * Minimum capacity to be available before scheduling more mirrors preemptively.
     */
    public val mirrorCapacityThreshold: Output<Int>
        get() = javaResource.mirrorCapacityThreshold().applyValue({ args0 -> args0 })

    /**
     * Maximum number of mirrors that can be synchronizing at the same time.
     */
    public val mirrorMaxCapacity: Output<Int>
        get() = javaResource.mirrorMaxCapacity().applyValue({ args0 -> args0 })

    /**
     * Maximum time (in minutes) between updates that a mirror can have when scheduled to synchronize.
     */
    public val mirrorMaxDelay: Output<Int>
        get() = javaResource.mirrorMaxDelay().applyValue({ args0 -> args0 })

    /**
     * Use npmjs.org as a default remote repository when the package is not found in the GitLab Package Registry for npm.
     */
    public val npmPackageRequestsForwarding: Output<Boolean>
        get() = javaResource.npmPackageRequestsForwarding().applyValue({ args0 -> args0 })

    /**
     * Define a list of trusted domains or IP addresses to which local requests are allowed when local requests for hooks and services are disabled.
     */
    public val outboundLocalRequestsWhitelists: Output<List<String>>
        get() = javaResource.outboundLocalRequestsWhitelists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * Number of workers assigned to the packages cleanup policies.
     */
    public val packageRegistryCleanupPoliciesWorkerCapacity: Output<Int>
        get() = javaResource.packageRegistryCleanupPoliciesWorkerCapacity().applyValue({ args0 -> args0 })

    /**
     * Require users to prove ownership of custom domains. Domain verification is an essential security measure for public GitLab sites. Users are required to demonstrate they control a domain before it is enabled.
     */
    public val pagesDomainVerificationEnabled: Output<Boolean>
        get() = javaResource.pagesDomainVerificationEnabled().applyValue({ args0 -> args0 })

    /**
     * Enable authentication for Git over HTTP(S) via a GitLab account password.
     */
    public val passwordAuthenticationEnabledForGit: Output<Boolean>
        get() = javaResource.passwordAuthenticationEnabledForGit().applyValue({ args0 -> args0 })

    /**
     * Enable authentication for the web interface via a GitLab account password.
     */
    public val passwordAuthenticationEnabledForWeb: Output<Boolean>
        get() = javaResource.passwordAuthenticationEnabledForWeb().applyValue({ args0 -> args0 })

    /**
     * Indicates whether passwords require at least one lowercase letter. Introduced in GitLab 15.1.
     */
    public val passwordLowercaseRequired: Output<Boolean>
        get() = javaResource.passwordLowercaseRequired().applyValue({ args0 -> args0 })

    /**
     * Indicates whether passwords require at least one number. Introduced in GitLab 15.1.
     */
    public val passwordNumberRequired: Output<Boolean>
        get() = javaResource.passwordNumberRequired().applyValue({ args0 -> args0 })

    /**
     * Indicates whether passwords require at least one symbol character. Introduced in GitLab 15.1.
     */
    public val passwordSymbolRequired: Output<Boolean>
        get() = javaResource.passwordSymbolRequired().applyValue({ args0 -> args0 })

    /**
     * Indicates whether passwords require at least one uppercase letter. Introduced in GitLab 15.1.
     */
    public val passwordUppercaseRequired: Output<Boolean>
        get() = javaResource.passwordUppercaseRequired().applyValue({ args0 -> args0 })

    /**
     * Path of the group that is allowed to toggle the performance bar.
     */
    public val performanceBarAllowedGroupPath: Output<String>
        get() = javaResource.performanceBarAllowedGroupPath().applyValue({ args0 -> args0 })

    /**
     * Prefix for all generated personal access tokens.
     */
    public val personalAccessTokenPrefix: Output<String>
        get() = javaResource.personalAccessTokenPrefix().applyValue({ args0 -> args0 })

    /**
     * Maximum number of pipeline creation requests per minute per user and commit.
     */
    public val pipelineLimitPerProjectUserSha: Output<Int>
        get() = javaResource.pipelineLimitPerProjectUserSha().applyValue({ args0 -> args0 })

    /**
     * (If enabled, requires: plantuml_url) Enable PlantUML integration.
     */
    public val plantumlEnabled: Output<Boolean>
        get() = javaResource.plantumlEnabled().applyValue({ args0 -> args0 })

    /**
     * The PlantUML instance URL for integration.
     */
    public val plantumlUrl: Output<String>
        get() = javaResource.plantumlUrl().applyValue({ args0 -> args0 })

    /**
     * Interval multiplier used by endpoints that perform polling. Set to 0 to disable polling.
     */
    public val pollingIntervalMultiplier: Output<Double>
        get() = javaResource.pollingIntervalMultiplier().applyValue({ args0 -> args0 })

    /**
     * Enable project export.
     */
    public val projectExportEnabled: Output<Boolean>
        get() = javaResource.projectExportEnabled().applyValue({ args0 -> args0 })

    /**
     * Enable Prometheus metrics.
     */
    public val prometheusMetricsEnabled: Output<Boolean>
        get() = javaResource.prometheusMetricsEnabled().applyValue({ args0 -> args0 })

    /**
     * CI/CD variables are protected by default.
     */
    public val protectedCiVariables: Output<Boolean>
        get() = javaResource.protectedCiVariables().applyValue({ args0 -> args0 })

    /**
     * Number of changes (branches or tags) in a single push to determine whether individual push events or bulk push events are created. Bulk push events are created if it surpasses that value.
     */
    public val pushEventActivitiesLimit: Output<Int>
        get() = javaResource.pushEventActivitiesLimit().applyValue({ args0 -> args0 })

    /**
     * Number of changes (branches or tags) in a single push to determine whether webhooks and services fire or not. Webhooks and services aren’t submitted if it surpasses that value.
     */
    public val pushEventHooksLimit: Output<Int>
        get() = javaResource.pushEventHooksLimit().applyValue({ args0 -> args0 })

    /**
     * Use pypi.org as a default remote repository when the package is not found in the GitLab Package Registry for PyPI.
     */
    public val pypiPackageRequestsForwarding: Output<Boolean>
        get() = javaResource.pypiPackageRequestsForwarding().applyValue({ args0 -> args0 })

    /**
     * When rate limiting is enabled via the throttle_* settings, send this plain text response when a rate limit is exceeded. ‘Retry later’ is sent if this is blank.
     */
    public val rateLimitingResponseText: Output<String>
        get() = javaResource.rateLimitingResponseText().applyValue({ args0 -> args0 })

    /**
     * Max number of requests per minute for each raw path. To disable throttling set to 0.
     */
    public val rawBlobRequestLimit: Output<Int>
        get() = javaResource.rawBlobRequestLimit().applyValue({ args0 -> args0 })

    /**
     * (If enabled, requires: recaptcha*private*key and recaptcha*site*key) Enable reCAPTCHA.
     */
    public val recaptchaEnabled: Output<Boolean>
        get() = javaResource.recaptchaEnabled().applyValue({ args0 -> args0 })

    /**
     * Private key for reCAPTCHA.
     */
    public val recaptchaPrivateKey: Output<String>
        get() = javaResource.recaptchaPrivateKey().applyValue({ args0 -> args0 })

    /**
     * Site key for reCAPTCHA.
     */
    public val recaptchaSiteKey: Output<String>
        get() = javaResource.recaptchaSiteKey().applyValue({ args0 -> args0 })

    /**
     * Maximum push size (MB).
     */
    public val receiveMaxInputSize: Output<Int>
        get() = javaResource.receiveMaxInputSize().applyValue({ args0 -> args0 })

    /**
     * GitLab periodically runs git fsck in all project and wiki repositories to look for silent disk corruption issues.
     */
    public val repositoryChecksEnabled: Output<Boolean>
        get() = javaResource.repositoryChecksEnabled().applyValue({ args0 -> args0 })

    /**
     * Size limit per repository (MB).
     */
    public val repositorySizeLimit: Output<Int>
        get() = javaResource.repositorySizeLimit().applyValue({ args0 -> args0 })

    /**
     * (GitLab 13.0 and earlier) List of names of enabled storage paths, taken from gitlab.yml. New projects are created in one of these stores, chosen at random.
     */
    public val repositoryStorages: Output<List<String>>
        get() = javaResource.repositoryStorages().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * (GitLab 13.1 and later) Hash of names of taken from gitlab.yml to weights. New projects are created in one of these stores, chosen by a weighted random selection.
     */
    public val repositoryStoragesWeighted: Output<Map<String, Int>>
        get() = javaResource.repositoryStoragesWeighted().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * When enabled, any user that signs up for an account using the registration form is placed under a Pending approval state and has to be explicitly approved by an administrator.
     */
    public val requireAdminApprovalAfterUserSignup: Output<Boolean>
        get() = javaResource.requireAdminApprovalAfterUserSignup().applyValue({ args0 -> args0 })

    /**
     * (If enabled, requires: two*factor*grace_period) Require all users to set up Two-factor authentication.
     */
    public val requireTwoFactorAuthentication: Output<Boolean>
        get() = javaResource.requireTwoFactorAuthentication().applyValue({ args0 -> args0 })

    /**
     * Selected levels cannot be used by non-Administrator users for groups, projects or snippets. Can take private, internal and public as a parameter. Null means there is no restriction.
     */
    public val restrictedVisibilityLevels: Output<List<String>>
        get() = javaResource.restrictedVisibilityLevels().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * The minimum allowed bit length of an uploaded RSA key. 0 means no restriction. -1 disables RSA keys.
     */
    public val rsaKeyRestriction: Output<Int>
        get() = javaResource.rsaKeyRestriction().applyValue({ args0 -> args0 })

    /**
     * Max number of requests per minute for performing a search while authenticated. To disable throttling set to 0.
     */
    public val searchRateLimit: Output<Int>
        get() = javaResource.searchRateLimit().applyValue({ args0 -> args0 })

    /**
     * Max number of requests per minute for performing a search while unauthenticated. To disable throttling set to 0.
     */
    public val searchRateLimitUnauthenticated: Output<Int>
        get() = javaResource.searchRateLimitUnauthenticated().applyValue({ args0 -> args0 })

    /**
     * Send confirmation email on sign-up.
     */
    public val sendUserConfirmationEmail: Output<Boolean>
        get() = javaResource.sendUserConfirmationEmail().applyValue({ args0 -> args0 })

    /**
     * Session duration in minutes. GitLab restart is required to apply changes.
     */
    public val sessionExpireDelay: Output<Int>
        get() = javaResource.sessionExpireDelay().applyValue({ args0 -> args0 })

    /**
     * (If enabled, requires: shared*runners*text and shared*runners*minutes) Enable shared runners for new projects.
     */
    public val sharedRunnersEnabled: Output<Boolean>
        get() = javaResource.sharedRunnersEnabled().applyValue({ args0 -> args0 })

    /**
     * Set the maximum number of CI/CD minutes that a group can use on shared runners per month.
     */
    public val sharedRunnersMinutes: Output<Int>
        get() = javaResource.sharedRunnersMinutes().applyValue({ args0 -> args0 })

    /**
     * Shared runners text.
     */
    public val sharedRunnersText: Output<String>
        get() = javaResource.sharedRunnersText().applyValue({ args0 -> args0 })

    /**
     * The threshold in bytes at which Sidekiq jobs are compressed before being stored in Redis.
     */
    public val sidekiqJobLimiterCompressionThresholdBytes: Output<Int>
        get() = javaResource.sidekiqJobLimiterCompressionThresholdBytes().applyValue({ args0 -> args0 })

    /**
     * The threshold in bytes at which Sidekiq jobs are rejected. 0 means do not reject any job.
     */
    public val sidekiqJobLimiterLimitBytes: Output<Int>
        get() = javaResource.sidekiqJobLimiterLimitBytes().applyValue({ args0 -> args0 })

    /**
     * track or compress. Sets the behavior for Sidekiq job size limits.
     */
    public val sidekiqJobLimiterMode: Output<String>
        get() = javaResource.sidekiqJobLimiterMode().applyValue({ args0 -> args0 })

    /**
     * Text on the login page.
     */
    public val signInText: Output<String>
        get() = javaResource.signInText().applyValue({ args0 -> args0 })

    /**
     * Enable registration.
     */
    public val signupEnabled: Output<Boolean>
        get() = javaResource.signupEnabled().applyValue({ args0 -> args0 })

    /**
     * (If enabled, requires: slack*app*id, slack*app*secret and slack*app*secret) Enable Slack app.
     */
    public val slackAppEnabled: Output<Boolean>
        get() = javaResource.slackAppEnabled().applyValue({ args0 -> args0 })

    /**
     * The app ID of the Slack-app.
     */
    public val slackAppId: Output<String>
        get() = javaResource.slackAppId().applyValue({ args0 -> args0 })

    /**
     * The app secret of the Slack-app.
     */
    public val slackAppSecret: Output<String>
        get() = javaResource.slackAppSecret().applyValue({ args0 -> args0 })

    /**
     * The signing secret of the Slack-app.
     */
    public val slackAppSigningSecret: Output<String>
        get() = javaResource.slackAppSigningSecret().applyValue({ args0 -> args0 })

    /**
     * The verification token of the Slack-app.
     */
    public val slackAppVerificationToken: Output<String>
        get() = javaResource.slackAppVerificationToken().applyValue({ args0 -> args0 })

    /**
     * Max snippet content size in bytes.
     */
    public val snippetSizeLimit: Output<Int>
        get() = javaResource.snippetSizeLimit().applyValue({ args0 -> args0 })

    /**
     * The Snowplow site name / application ID. (for example, gitlab)
     */
    public val snowplowAppId: Output<String>
        get() = javaResource.snowplowAppId().applyValue({ args0 -> args0 })

    /**
     * The Snowplow collector hostname. (for example, snowplow.trx.gitlab.net)
     */
    public val snowplowCollectorHostname: Output<String>
        get() = javaResource.snowplowCollectorHostname().applyValue({ args0 -> args0 })

    /**
     * The Snowplow cookie domain. (for example, .gitlab.com)
     */
    public val snowplowCookieDomain: Output<String>
        get() = javaResource.snowplowCookieDomain().applyValue({ args0 -> args0 })

    /**
     * Enable snowplow tracking.
     */
    public val snowplowEnabled: Output<Boolean>
        get() = javaResource.snowplowEnabled().applyValue({ args0 -> args0 })

    /**
     * Enables Sourcegraph integration. If enabled, requires sourcegraph_url.
     */
    public val sourcegraphEnabled: Output<Boolean>
        get() = javaResource.sourcegraphEnabled().applyValue({ args0 -> args0 })

    /**
     * Blocks Sourcegraph from being loaded on private and internal projects.
     */
    public val sourcegraphPublicOnly: Output<Boolean>
        get() = javaResource.sourcegraphPublicOnly().applyValue({ args0 -> args0 })

    /**
     * The Sourcegraph instance URL for integration.
     */
    public val sourcegraphUrl: Output<String>
        get() = javaResource.sourcegraphUrl().applyValue({ args0 -> args0 })

    /**
     * API key used by GitLab for accessing the Spam Check service endpoint.
     */
    public val spamCheckApiKey: Output<String>
        get() = javaResource.spamCheckApiKey().applyValue({ args0 -> args0 })

    /**
     * Enables spam checking using external Spam Check API endpoint.
     */
    public val spamCheckEndpointEnabled: Output<Boolean>
        get() = javaResource.spamCheckEndpointEnabled().applyValue({ args0 -> args0 })

    /**
     * URL of the external Spamcheck service endpoint. Valid URI schemes are grpc or tls. Specifying tls forces communication to be encrypted.
     */
    public val spamCheckEndpointUrl: Output<String>
        get() = javaResource.spamCheckEndpointUrl().applyValue({ args0 -> args0 })

    /**
     * Enable pipeline suggestion banner.
     */
    public val suggestPipelineEnabled: Output<Boolean>
        get() = javaResource.suggestPipelineEnabled().applyValue({ args0 -> args0 })

    /**
     * Maximum time for web terminal websocket connection (in seconds). Set to 0 for unlimited time.
     */
    public val terminalMaxSessionTime: Output<Int>
        get() = javaResource.terminalMaxSessionTime().applyValue({ args0 -> args0 })

    /**
     * (Required by: enforce_terms) Markdown content for the ToS.
     */
    public val terms: Output<String>
        get() = javaResource.terms().applyValue({ args0 -> args0 })

    /**
     * (If enabled, requires: throttle*authenticated*api*period*in*seconds and throttle*authenticated*api*requests*per*period) Enable authenticated API request rate limit. Helps reduce request volume (for example, from crawlers or abusive bots).
     */
    public val throttleAuthenticatedApiEnabled: Output<Boolean>
        get() = javaResource.throttleAuthenticatedApiEnabled().applyValue({ args0 -> args0 })

    /**
     * Rate limit period (in seconds).
     */
    public val throttleAuthenticatedApiPeriodInSeconds: Output<Int>
        get() = javaResource.throttleAuthenticatedApiPeriodInSeconds().applyValue({ args0 -> args0 })

    /**
     * Maximum requests per period per user.
     */
    public val throttleAuthenticatedApiRequestsPerPeriod: Output<Int>
        get() = javaResource.throttleAuthenticatedApiRequestsPerPeriod().applyValue({ args0 -> args0 })

    /**
     * (If enabled, requires: throttle*authenticated*packages*api*period*in*seconds and throttle*authenticated*packages*api*requests*per*period) Enable authenticated API request rate limit. Helps reduce request volume (for example, from crawlers or abusive bots). View Package Registry rate limits for more details.
     */
    public val throttleAuthenticatedPackagesApiEnabled: Output<Boolean>
        get() = javaResource.throttleAuthenticatedPackagesApiEnabled().applyValue({ args0 -> args0 })

    /**
     * Rate limit period (in seconds). View Package Registry rate limits for more details.
     */
    public val throttleAuthenticatedPackagesApiPeriodInSeconds: Output<Int>
        get() = javaResource.throttleAuthenticatedPackagesApiPeriodInSeconds().applyValue({ args0 ->
            args0
        })

    /**
     * Maximum requests per period per user. View Package Registry rate limits for more details.
     */
    public val throttleAuthenticatedPackagesApiRequestsPerPeriod: Output<Int>
        get() = javaResource.throttleAuthenticatedPackagesApiRequestsPerPeriod().applyValue({ args0 ->
            args0
        })

    /**
     * (If enabled, requires: throttle*authenticated*web*period*in*seconds and throttle*authenticated*web*requests*per*period) Enable authenticated web request rate limit. Helps reduce request volume (for example, from crawlers or abusive bots).
     */
    public val throttleAuthenticatedWebEnabled: Output<Boolean>
        get() = javaResource.throttleAuthenticatedWebEnabled().applyValue({ args0 -> args0 })

    /**
     * Rate limit period (in seconds).
     */
    public val throttleAuthenticatedWebPeriodInSeconds: Output<Int>
        get() = javaResource.throttleAuthenticatedWebPeriodInSeconds().applyValue({ args0 -> args0 })

    /**
     * Maximum requests per period per user.
     */
    public val throttleAuthenticatedWebRequestsPerPeriod: Output<Int>
        get() = javaResource.throttleAuthenticatedWebRequestsPerPeriod().applyValue({ args0 -> args0 })

    /**
     * (If enabled, requires: throttle*unauthenticated*api*period*in*seconds and throttle*unauthenticated*api*requests*per*period) Enable unauthenticated API request rate limit. Helps reduce request volume (for example, from crawlers or abusive bots).
     */
    public val throttleUnauthenticatedApiEnabled: Output<Boolean>
        get() = javaResource.throttleUnauthenticatedApiEnabled().applyValue({ args0 -> args0 })

    /**
     * Rate limit period in seconds.
     */
    public val throttleUnauthenticatedApiPeriodInSeconds: Output<Int>
        get() = javaResource.throttleUnauthenticatedApiPeriodInSeconds().applyValue({ args0 -> args0 })

    /**
     * Max requests per period per IP.
     */
    public val throttleUnauthenticatedApiRequestsPerPeriod: Output<Int>
        get() = javaResource.throttleUnauthenticatedApiRequestsPerPeriod().applyValue({ args0 -> args0 })

    /**
     * (If enabled, requires: throttle*unauthenticated*packages*api*period*in*seconds and throttle*unauthenticated*packages*api*requests*per*period) Enable authenticated API request rate limit. Helps reduce request volume (for example, from crawlers or abusive bots). View Package Registry rate limits for more details.
     */
    public val throttleUnauthenticatedPackagesApiEnabled: Output<Boolean>
        get() = javaResource.throttleUnauthenticatedPackagesApiEnabled().applyValue({ args0 -> args0 })

    /**
     * Rate limit period (in seconds). View Package Registry rate limits for more details.
     */
    public val throttleUnauthenticatedPackagesApiPeriodInSeconds: Output<Int>
        get() = javaResource.throttleUnauthenticatedPackagesApiPeriodInSeconds().applyValue({ args0 ->
            args0
        })

    /**
     * Maximum requests per period per user. View Package Registry rate limits for more details.
     */
    public val throttleUnauthenticatedPackagesApiRequestsPerPeriod: Output<Int>
        get() = javaResource.throttleUnauthenticatedPackagesApiRequestsPerPeriod().applyValue({ args0 ->
            args0
        })

    /**
     * (If enabled, requires: throttle*unauthenticated*web*period*in*seconds and throttle*unauthenticated*web*requests*per*period) Enable unauthenticated web request rate limit. Helps reduce request volume (for example, from crawlers or abusive bots).
     */
    public val throttleUnauthenticatedWebEnabled: Output<Boolean>
        get() = javaResource.throttleUnauthenticatedWebEnabled().applyValue({ args0 -> args0 })

    /**
     * Rate limit period in seconds.
     */
    public val throttleUnauthenticatedWebPeriodInSeconds: Output<Int>
        get() = javaResource.throttleUnauthenticatedWebPeriodInSeconds().applyValue({ args0 -> args0 })

    /**
     * Max requests per period per IP.
     */
    public val throttleUnauthenticatedWebRequestsPerPeriod: Output<Int>
        get() = javaResource.throttleUnauthenticatedWebRequestsPerPeriod().applyValue({ args0 -> args0 })

    /**
     * Limit display of time tracking units to hours.
     */
    public val timeTrackingLimitToHours: Output<Boolean>
        get() = javaResource.timeTrackingLimitToHours().applyValue({ args0 -> args0 })

    /**
     * Amount of time (in hours) that users are allowed to skip forced configuration of two-factor authentication.
     */
    public val twoFactorGracePeriod: Output<Int>
        get() = javaResource.twoFactorGracePeriod().applyValue({ args0 -> args0 })

    /**
     * (If enabled, requires: unique*ips*limit*per*user and unique*ips*limit*time*window) Limit sign in from multiple IPs.
     */
    public val uniqueIpsLimitEnabled: Output<Boolean>
        get() = javaResource.uniqueIpsLimitEnabled().applyValue({ args0 -> args0 })

    /**
     * Maximum number of IPs per user.
     */
    public val uniqueIpsLimitPerUser: Output<Int>
        get() = javaResource.uniqueIpsLimitPerUser().applyValue({ args0 -> args0 })

    /**
     * How many seconds an IP is counted towards the limit.
     */
    public val uniqueIpsLimitTimeWindow: Output<Int>
        get() = javaResource.uniqueIpsLimitTimeWindow().applyValue({ args0 -> args0 })

    /**
     * Every week GitLab reports license usage back to GitLab, Inc.
     */
    public val usagePingEnabled: Output<Boolean>
        get() = javaResource.usagePingEnabled().applyValue({ args0 -> args0 })

    /**
     * Send an email to users upon account deactivation.
     */
    public val userDeactivationEmailsEnabled: Output<Boolean>
        get() = javaResource.userDeactivationEmailsEnabled().applyValue({ args0 -> args0 })

    /**
     * Newly registered users are external by default.
     */
    public val userDefaultExternal: Output<Boolean>
        get() = javaResource.userDefaultExternal().applyValue({ args0 -> args0 })

    /**
     * Specify an email address regex pattern to identify default internal users.
     */
    public val userDefaultInternalRegex: Output<String>
        get() = javaResource.userDefaultInternalRegex().applyValue({ args0 -> args0 })

    /**
     * Allow users to register any application to use GitLab as an OAuth provider.
     */
    public val userOauthApplications: Output<Boolean>
        get() = javaResource.userOauthApplications().applyValue({ args0 -> args0 })

    /**
     * When set to false disable the You won't be able to pull or push project code via SSH warning shown to users with no uploaded SSH key.
     */
    public val userShowAddSshKeyMessage: Output<Boolean>
        get() = javaResource.userShowAddSshKeyMessage().applyValue({ args0 -> args0 })

    /**
     * Let GitLab inform you when an update is available.
     */
    public val versionCheckEnabled: Output<Boolean>
        get() = javaResource.versionCheckEnabled().applyValue({ args0 -> args0 })

    /**
     * Live Preview (allow live previews of JavaScript projects in the Web IDE using CodeSandbox Live Preview).
     */
    public val webIdeClientsidePreviewEnabled: Output<Boolean>
        get() = javaResource.webIdeClientsidePreviewEnabled().applyValue({ args0 -> args0 })

    /**
     * What’s new variant, possible values: all*tiers, current*tier, and disabled.
     */
    public val whatsNewVariant: Output<String>
        get() = javaResource.whatsNewVariant().applyValue({ args0 -> args0 })

    /**
     * Maximum wiki page content size in bytes. The minimum value is 1024 bytes.
     */
    public val wikiPageMaxContentBytes: Output<Int>
        get() = javaResource.wikiPageMaxContentBytes().applyValue({ args0 -> args0 })
}

public object ApplicationSettingsMapper : ResourceMapper<ApplicationSettings> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.ApplicationSettings::class == javaResource::class

    override fun map(javaResource: Resource): ApplicationSettings = ApplicationSettings(
        javaResource
            as com.pulumi.gitlab.ApplicationSettings,
    )
}

/**
 * @see [ApplicationSettings].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApplicationSettings].
 */
public suspend fun applicationSettings(
    name: String,
    block: suspend ApplicationSettingsResourceBuilder.() -> Unit,
): ApplicationSettings {
    val builder = ApplicationSettingsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApplicationSettings].
 * @param name The _unique_ name of the resulting resource.
 */
public fun applicationSettings(name: String): ApplicationSettings {
    val builder = ApplicationSettingsResourceBuilder()
    builder.name(name)
    return builder.build()
}
