@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.ApplicationSettingsArgs.builder
import com.pulumi.gitlab.kotlin.inputs.ApplicationSettingsDefaultBranchProtectionDefaultsArgs
import com.pulumi.gitlab.kotlin.inputs.ApplicationSettingsDefaultBranchProtectionDefaultsArgsBuilder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Double
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * @property abuseNotificationEmail If set, abuse reports are sent to this address. Abuse reports are always available in the Admin Area.
 * @property adminMode Require administrators to enable Admin Mode by re-authenticating for administrative tasks.
 * @property afterSignOutPath Where to redirect users after logout.
 * @property afterSignUpText Text shown to the user after signing up.
 * @property akismetApiKey API key for Akismet spam protection.
 * @property akismetEnabled (If enabled, requires: akismet*api*key) Enable or disable Akismet spam protection.
 * @property allowAccountDeletion Set to true to allow users to delete their accounts. Premium and Ultimate only.
 * @property allowGroupOwnersToManageLdap Set to true to allow group owners to manage LDAP.
 * @property allowLocalRequestsFromSystemHooks Allow requests to the local network from system hooks.
 * @property allowLocalRequestsFromWebHooksAndServices Allow requests to the local network from web hooks and services.
 * @property allowProjectCreationForGuestAndBelow Indicates whether users assigned up to the Guest role can create groups and personal projects.
 * @property allowRunnerRegistrationToken Allow using a registration token to create a runner.
 * @property archiveBuildsInHumanReadable Set the duration for which the jobs are considered as old and expired. After that time passes, the jobs are archived and no longer able to be retried. Make it empty to never expire jobs. It has to be no less than 1 day, for example: 15 days, 1 month, 2 years.
 * @property asciidocMaxIncludes Maximum limit of AsciiDoc include directives being processed in any one document. Maximum: 64.
 * @property assetProxyAllowlists Assets that match these domains are not proxied. Wildcards allowed. Your GitLab installation URL is automatically allowlisted. GitLab restart is required to apply changes.
 * @property assetProxyEnabled (If enabled, requires: asset*proxy*url) Enable proxying of assets. GitLab restart is required to apply changes.
 * @property assetProxySecretKey Shared secret with the asset proxy server. GitLab restart is required to apply changes.
 * @property assetProxyUrl URL of the asset proxy server. GitLab restart is required to apply changes.
 * @property authorizedKeysEnabled By default, we write to the authorized_keys file to support Git over SSH without additional configuration. GitLab can be optimized to authenticate SSH keys via the database file. Only disable this if you have configured your OpenSSH server to use the AuthorizedKeysCommand.
 * @property autoBanUserOnExcessiveProjectsDownload When enabled, users will get automatically banned from the application when they download more than the maximum number of unique projects in the time period specified by max*number*of*repository*downloads and max*number*of*repository*downloads*within*time_period respectively. Introduced in GitLab 15.4. Self-managed, Ultimate only.
 * @property autoDevopsDomain Specify a domain to use by default for every project’s Auto Review Apps and Auto Deploy stages.
 * @property autoDevopsEnabled Enable Auto DevOps for projects by default. It automatically builds, tests, and deploys applications based on a predefined CI/CD configuration.
 * @property automaticPurchasedStorageAllocation Enabling this permits automatic allocation of purchased storage in a namespace.
 * @property bulkImportConcurrentPipelineBatchLimit Maximum simultaneous Direct Transfer batches to process.
 * @property bulkImportEnabled Enable migrating GitLab groups by direct transfer. Introduced in GitLab 15.8.
 * @property bulkImportMaxDownloadFileSize Maximum download file size when importing from source GitLab instances by direct transfer. Introduced in GitLab 16.3.
 * @property canCreateGroup Indicates whether users can create top-level groups. Introduced in GitLab 15.5.
 * @property checkNamespacePlan Enabling this makes only licensed EE features available to projects if the project namespace’s plan includes the feature or if the project is public.
 * @property ciMaxIncludes The maximum number of includes per pipeline.
 * @property ciMaxTotalYamlSizeBytes The maximum amount of memory, in bytes, that can be allocated for the pipeline configuration, with all included YAML configuration files.
 * @property commitEmailHostname Custom hostname (for private commit emails).
 * @property concurrentBitbucketImportJobsLimit Maximum number of simultaneous import jobs for the Bitbucket Cloud importer. Introduced in GitLab 16.11.
 * @property concurrentBitbucketServerImportJobsLimit Maximum number of simultaneous import jobs for the Bitbucket Server importer. Introduced in GitLab 16.11.
 * @property concurrentGithubImportJobsLimit Maximum number of simultaneous import jobs for the GitHub importer. Introduced in GitLab 16.11.
 * @property containerExpirationPoliciesEnableHistoricEntries Enable cleanup policies for all projects.
 * @property containerRegistryCleanupTagsServiceMaxListSize The maximum number of tags that can be deleted in a single execution of cleanup policies.
 * @property containerRegistryDeleteTagsServiceTimeout The maximum time, in seconds, that the cleanup process can take to delete a batch of tags for cleanup policies.
 * @property containerRegistryExpirationPoliciesCaching Caching during the execution of cleanup policies.
 * @property containerRegistryExpirationPoliciesWorkerCapacity Number of workers for cleanup policies.
 * @property containerRegistryTokenExpireDelay Container Registry token duration in minutes.
 * @property deactivateDormantUsers Enable automatic deactivation of dormant users.
 * @property deactivateDormantUsersPeriod Length of time (in days) after which a user is considered dormant. Introduced in GitLab 15.3.
 * @property decompressArchiveFileTimeout Default timeout for decompressing archived files, in seconds. Set to 0 to disable timeouts. Introduced in GitLab 16.4.
 * @property defaultArtifactsExpireIn Set the default expiration time for each job’s artifacts.
 * @property defaultBranchName Instance-level custom initial branch name (introduced in GitLab 13.2).
 * @property defaultBranchProtection Determine if developers can push to the default branch. Can take: 0 (not protected, both users with the Developer role or Maintainer role can push new commits and force push), 1 (partially protected, users with the Developer role or Maintainer role can push new commits, but cannot force push) or 2 (fully protected, users with the Developer or Maintainer role cannot push new commits, but users with the Developer or Maintainer role can; no one can force push) as a parameter. Default is 2.
 * @property defaultBranchProtectionDefaults The default*branch*protection*defaults attribute describes the default branch protection defaults. All parameters are optional.
 * @property defaultCiConfigPath Default CI/CD configuration file and path for new projects (.gitlab-ci.yml if not set).
 * @property defaultGroupVisibility What visibility level new groups receive. Can take private, internal and public as a parameter.
 * @property defaultPreferredLanguage Default preferred language for users who are not logged in.
 * @property defaultProjectCreation Default project creation protection. Can take: 0 (No one), 1 (Maintainers) or 2 (Developers + Maintainers).
 * @property defaultProjectVisibility What visibility level new projects receive. Can take private, internal and public as a parameter.
 * @property defaultProjectsLimit Project limit per user.
 * @property defaultSnippetVisibility What visibility level new snippets receive. Can take private, internal and public as a parameter.
 * @property defaultSyntaxHighlightingTheme Default syntax highlighting theme for users who are new or not signed in. See IDs of available themes (https://gitlab.com/gitlab-org/gitlab/blob/master/lib/gitlab/themes.rb#L16)
 * @property deleteInactiveProjects Enable inactive project deletion feature. Introduced in GitLab 14.10. Became operational in GitLab 15.0 (with feature flag inactive*projects*deletion).
 * @property deleteUnconfirmedUsers Specifies whether users who have not confirmed their email should be deleted. When set to true, unconfirmed users are deleted after unconfirmed*users*delete*after*days days. Introduced in GitLab 16.1. Self-managed, Premium and Ultimate only.
 * @property deletionAdjournedPeriod The number of days to wait before deleting a project or group that is marked for deletion. Value must be between 1 and 90.
 * @property diagramsnetEnabled (If enabled, requires diagramsnet_url) Enable Diagrams.net integration.
 * @property diagramsnetUrl The Diagrams.net instance URL for integration.
 * @property diffMaxFiles Maximum files in a diff.
 * @property diffMaxLines Maximum lines in a diff.
 * @property diffMaxPatchBytes Maximum diff patch size, in bytes.
 * @property disableAdminOauthScopes Stops administrators from connecting their GitLab accounts to non-trusted OAuth 2.0 applications that have the api, read*api, read*repository, write*repository, read*registry, write_registry, or sudo scopes. Introduced in GitLab 15.6.
 * @property disableFeedToken Disable display of RSS/Atom and calendar feed tokens (introduced in GitLab 13.7).
 * @property disablePersonalAccessTokens Disable personal access tokens. Introduced in GitLab 15.7. Self-managed, Premium and Ultimate only. There is no method available to enable a personal access token that’s been disabled through the API. This is a known issue.
 * @property disabledOauthSignInSources Disabled OAuth sign-in sources.
 * @property dnsRebindingProtectionEnabled Enforce DNS rebinding attack protection.
 * @property domainAllowlists Force people to use only corporate emails for sign-up. Null means there is no restriction.
 * @property domainDenylistEnabled (If enabled, requires: domain_denylist) Allows blocking sign-ups from emails from specific domains.
 * @property domainDenylists Users with email addresses that match these domains cannot sign up. Wildcards allowed. Use separate lines for multiple entries. Ex: domain.com, *.domain.com.
 * @property downstreamPipelineTriggerLimitPerProjectUserSha Maximum downstream pipeline trigger rate. Introduced in GitLab 16.10.
 * @property dsaKeyRestriction The minimum allowed bit length of an uploaded DSA key. 0 means no restriction. -1 disables DSA keys.
 * @property duoFeaturesEnabled Indicates whether GitLab Duo features are enabled for this instance. Introduced in GitLab 16.10. Self-managed, Premium and Ultimate only.
 * @property ecdsaKeyRestriction The minimum allowed curve size (in bits) of an uploaded ECDSA key. 0 means no restriction. -1 disables ECDSA keys.
 * @property ecdsaSkKeyRestriction The minimum allowed curve size (in bits) of an uploaded ECDSA*SK key. 0 means no restriction. -1 disables ECDSA*SK keys.
 * @property ed25519KeyRestriction The minimum allowed curve size (in bits) of an uploaded ED25519 key. 0 means no restriction. -1 disables ED25519 keys.
 * @property ed25519SkKeyRestriction The minimum allowed curve size (in bits) of an uploaded ED25519*SK key. 0 means no restriction. -1 disables ED25519*SK keys.
 * @property eksAccessKeyId AWS IAM access key ID.
 * @property eksAccountId Amazon account ID.
 * @property eksIntegrationEnabled Enable integration with Amazon EKS.
 * @property eksSecretAccessKey AWS IAM secret access key.
 * @property elasticsearchAws Enable the use of AWS hosted Elasticsearch.
 * @property elasticsearchAwsAccessKey AWS IAM access key.
 * @property elasticsearchAwsRegion The AWS region the Elasticsearch domain is configured.
 * @property elasticsearchAwsSecretAccessKey AWS IAM secret access key.
 * @property elasticsearchIndexedFieldLengthLimit Maximum size of text fields to index by Elasticsearch. 0 value means no limit. This does not apply to repository and wiki indexing.
 * @property elasticsearchIndexedFileSizeLimitKb Maximum size of repository and wiki files that are indexed by Elasticsearch.
 * @property elasticsearchIndexing Enable Elasticsearch indexing.
 * @property elasticsearchLimitIndexing Limit Elasticsearch to index certain namespaces and projects.
 * @property elasticsearchMaxBulkConcurrency Maximum concurrency of Elasticsearch bulk requests per indexing operation. This only applies to repository indexing operations.
 * @property elasticsearchMaxBulkSizeMb Maximum size of Elasticsearch bulk indexing requests in MB. This only applies to repository indexing operations.
 * @property elasticsearchNamespaceIds The namespaces to index via Elasticsearch if elasticsearch*limit*indexing is enabled.
 * @property elasticsearchPassword The password of your Elasticsearch instance.
 * @property elasticsearchProjectIds The projects to index via Elasticsearch if elasticsearch*limit*indexing is enabled.
 * @property elasticsearchSearch Enable Elasticsearch search.
 * @property elasticsearchUrls The URL to use for connecting to Elasticsearch. Use a comma-separated list to support cluster (for example, http://localhost:9200, http://localhost:9201).
 * @property elasticsearchUsername The username of your Elasticsearch instance.
 * @property emailAdditionalText Additional text added to the bottom of every email for legal/auditing/compliance reasons.
 * @property emailAuthorInBody Some email servers do not support overriding the email sender name. Enable this option to include the name of the author of the issue, merge request or comment in the email body instead.
 * @property enabledGitAccessProtocol Enabled protocols for Git access. Allowed values are: ssh, http, and nil to allow both protocols.
 * @property enforceNamespaceStorageLimit Enabling this permits enforcement of namespace storage limits.
 * @property enforceTerms (If enabled, requires: terms) Enforce application ToS to all users.
 * @property externalAuthClientCert (If enabled, requires: external*auth*client_key) The certificate to use to authenticate with the external authorization service.
 * @property externalAuthClientKey Private key for the certificate when authentication is required for the external authorization service, this is encrypted when stored.
 * @property externalAuthClientKeyPass Passphrase to use for the private key when authenticating with the external service this is encrypted when stored.
 * @property externalAuthorizationServiceDefaultLabel The default classification label to use when requesting authorization and no classification label has been specified on the project.
 * @property externalAuthorizationServiceEnabled (If enabled, requires: external*authorization*service*default*label, external*authorization*service*timeout and external*authorization*service*url) Enable using an external authorization service for accessing projects.
 * @property externalAuthorizationServiceTimeout The timeout after which an authorization request is aborted, in seconds. When a request times out, access is denied to the user. (min: 0.001, max: 10, step: 0.001).
 * @property externalAuthorizationServiceUrl URL to which authorization requests are directed.
 * @property externalPipelineValidationServiceTimeout How long to wait for a response from the pipeline validation service. Assumes OK if it times out.
 * @property externalPipelineValidationServiceToken Optional. Token to include as the X-Gitlab-Token header in requests to the URL in external*pipeline*validation*service*url.
 * @property externalPipelineValidationServiceUrl URL to use for pipeline validation requests.
 * @property fileTemplateProjectId The ID of a project to load custom file templates from.
 * @property firstDayOfWeek Start day of the week for calendar views and date pickers. Valid values are 0 for Sunday, 1 for Monday, and 6 for Saturday.
 * @property geoNodeAllowedIps Comma-separated list of IPs and CIDRs of allowed secondary nodes. For example, 1.1.1.1, 2.2.2.0/24.
 * @property geoStatusTimeout The amount of seconds after which a request to get a secondary node status times out.
 * @property gitRateLimitUsersAllowlists List of usernames excluded from Git anti-abuse rate limits. Maximum: 100 usernames. Introduced in GitLab 15.2.
 * @property gitTwoFactorSessionExpiry Maximum duration (in minutes) of a session for Git operations when 2FA is enabled.
 * @property gitalyTimeoutDefault Default Gitaly timeout, in seconds. This timeout is not enforced for Git fetch/push operations or Sidekiq jobs. Set to 0 to disable timeouts.
 * @property gitalyTimeoutFast Gitaly fast operation timeout, in seconds. Some Gitaly operations are expected to be fast. If they exceed this threshold, there may be a problem with a storage shard and ‘failing fast’ can help maintain the stability of the GitLab instance. Set to 0 to disable timeouts.
 * @property gitalyTimeoutMedium Medium Gitaly timeout, in seconds. This should be a value between the Fast and the Default timeout. Set to 0 to disable timeouts.
 * @property grafanaEnabled Enable Grafana.
 * @property grafanaUrl Grafana URL.
 * @property gravatarEnabled Enable Gravatar.
 * @property groupOwnersCanManageDefaultBranchProtection Prevent overrides of default branch protection.
 * @property hashedStorageEnabled Create new projects using hashed storage paths: Enable immutable, hash-based paths and repository names to store repositories on disk. This prevents repositories from having to be moved or renamed when the Project URL changes and may improve disk I/O performance. (Always enabled in GitLab versions 13.0 and later, configuration is scheduled for removal in 14.0).
 * @property helpPageHideCommercialContent Hide marketing-related entries from help.
 * @property helpPageSupportUrl Alternate support URL for help page and help dropdown.
 * @property helpPageText Custom text displayed on the help page.
 * @property helpText GitLab server administrator information.
 * @property hideThirdPartyOffers Do not display offers from third parties in GitLab.
 * @property homePageUrl Redirect to this URL when not logged in.
 * @property housekeepingEnabled Enable or disable Git housekeeping.
 * 			If enabled, requires either housekeeping*optimize*repository*period OR housekeeping*bitmaps*enabled, housekeeping*full*repack*period, housekeeping*gc*period, and housekeeping*incremental*repack*period.
 * 			Options housekeeping*bitmaps*enabled, housekeeping*full*repack*period, housekeeping*gc*period, and housekeeping*incremental*repack*period are deprecated. Use housekeeping*optimize*repository*period instead.
 * @property housekeepingFullRepackPeriod Number of Git pushes after which an incremental git repack is run.
 * @property housekeepingGcPeriod Number of Git pushes after which git gc is run.
 * @property housekeepingIncrementalRepackPeriod Number of Git pushes after which an incremental git repack is run.
 * @property housekeepingOptimizeRepositoryPeriod Number of Git pushes after which an incremental git repack is run.
 * @property htmlEmailsEnabled Enable HTML emails.
 * @property importSources Sources to allow project import from. Valid values are: `github`, `bitbucket`, `bitbucket_server`, `fogbugz`, `git`, `gitlab.Project`, `gitea`, `manifest`
 * @property inProductMarketingEmailsEnabled Enable in-product marketing emails.
 * @property inactiveProjectsDeleteAfterMonths If delete*inactive*projects is true, the time (in months) to wait before deleting inactive projects. Introduced in GitLab 14.10. Became operational in GitLab 15.0.
 * @property inactiveProjectsMinSizeMb If delete*inactive*projects is true, the minimum repository size for projects to be checked for inactivity. Introduced in GitLab 14.10. Became operational in GitLab 15.0.
 * @property inactiveProjectsSendWarningEmailAfterMonths If delete*inactive*projects is true, sets the time (in months) to wait before emailing maintainers that the project is scheduled be deleted because it is inactive. Introduced in GitLab 14.10. Became operational in GitLab 15.0.
 * @property invisibleCaptchaEnabled Enable Invisible CAPTCHA spam detection during sign-up.
 * @property issuesCreateLimit Max number of issue creation requests per minute per user.
 * @property keepLatestArtifact Prevent the deletion of the artifacts from the most recent successful jobs, regardless of the expiry time.
 * @property localMarkdownVersion Increase this value when any cached Markdown should be invalidated.
 * @property mailgunEventsEnabled Enable Mailgun event receiver.
 * @property mailgunSigningKey The Mailgun HTTP webhook signing key for receiving events from webhook.
 * @property maintenanceMode When instance is in maintenance mode, non-administrative users can sign in with read-only access and make read-only API requests.
 * @property maintenanceModeMessage Message displayed when instance is in maintenance mode.
 * @property maxArtifactsSize Maximum artifacts size in MB.
 * @property maxAttachmentSize Limit attachment size in MB.
 * @property maxExportSize Maximum export size in MB. 0 for unlimited.
 * @property maxImportSize Maximum import size in MB. 0 for unlimited.
 * @property maxNumberOfRepositoryDownloads Maximum number of unique repositories a user can download in the specified time period before they are banned. Maximum: 10,000 repositories. Introduced in GitLab 15.1.
 * @property maxNumberOfRepositoryDownloadsWithinTimePeriod Reporting time period (in seconds). Maximum: 864000 seconds (10 days). Introduced in GitLab 15.1.
 * @property maxPagesSize Maximum size of pages repositories in MB.
 * @property maxPersonalAccessTokenLifetime Maximum allowable lifetime for access tokens in days.
 * @property maxSshKeyLifetime Maximum allowable lifetime for SSH keys in days. Introduced in GitLab 14.6.
 * @property maxTerraformStateSizeBytes
 * @property metricsMethodCallThreshold A method call is only tracked when it takes longer than the given amount of milliseconds.
 * @property minimumPasswordLength Indicates whether passwords require a minimum length. Introduced in GitLab 15.1. Premium and Ultimate only.
 * @property mirrorAvailable Allow repository mirroring to configured by project Maintainers. If disabled, only Administrators can configure repository mirroring.
 * @property mirrorCapacityThreshold Minimum capacity to be available before scheduling more mirrors preemptively.
 * @property mirrorMaxCapacity Maximum number of mirrors that can be synchronizing at the same time.
 * @property mirrorMaxDelay Maximum time (in minutes) between updates that a mirror can have when scheduled to synchronize.
 * @property npmPackageRequestsForwarding Use npmjs.org as a default remote repository when the package is not found in the GitLab Package Registry for npm.
 * @property outboundLocalRequestsWhitelists Define a list of trusted domains or IP addresses to which local requests are allowed when local requests for hooks and services are disabled.
 * @property packageRegistryCleanupPoliciesWorkerCapacity Number of workers assigned to the packages cleanup policies.
 * @property pagesDomainVerificationEnabled Require users to prove ownership of custom domains. Domain verification is an essential security measure for public GitLab sites. Users are required to demonstrate they control a domain before it is enabled.
 * @property passwordAuthenticationEnabledForGit Enable authentication for Git over HTTP(S) via a GitLab account password.
 * @property passwordAuthenticationEnabledForWeb Enable authentication for the web interface via a GitLab account password.
 * @property passwordLowercaseRequired Indicates whether passwords require at least one lowercase letter. Introduced in GitLab 15.1.
 * @property passwordNumberRequired Indicates whether passwords require at least one number. Introduced in GitLab 15.1.
 * @property passwordSymbolRequired Indicates whether passwords require at least one symbol character. Introduced in GitLab 15.1.
 * @property passwordUppercaseRequired Indicates whether passwords require at least one uppercase letter. Introduced in GitLab 15.1.
 * @property performanceBarAllowedGroupPath Path of the group that is allowed to toggle the performance bar.
 * @property personalAccessTokenPrefix Prefix for all generated personal access tokens.
 * @property pipelineLimitPerProjectUserSha Maximum number of pipeline creation requests per minute per user and commit.
 * @property plantumlEnabled (If enabled, requires: plantuml_url) Enable PlantUML integration.
 * @property plantumlUrl The PlantUML instance URL for integration.
 * @property pollingIntervalMultiplier Interval multiplier used by endpoints that perform polling. Set to 0 to disable polling.
 * @property projectExportEnabled Enable project export.
 * @property prometheusMetricsEnabled Enable Prometheus metrics.
 * @property protectedCiVariables CI/CD variables are protected by default.
 * @property pushEventActivitiesLimit Number of changes (branches or tags) in a single push to determine whether individual push events or bulk push events are created. Bulk push events are created if it surpasses that value.
 * @property pushEventHooksLimit Number of changes (branches or tags) in a single push to determine whether webhooks and services fire or not. Webhooks and services aren’t submitted if it surpasses that value.
 * @property pypiPackageRequestsForwarding Use pypi.org as a default remote repository when the package is not found in the GitLab Package Registry for PyPI.
 * @property rateLimitingResponseText When rate limiting is enabled via the throttle_* settings, send this plain text response when a rate limit is exceeded. ‘Retry later’ is sent if this is blank.
 * @property rawBlobRequestLimit Max number of requests per minute for each raw path. To disable throttling set to 0.
 * @property recaptchaEnabled (If enabled, requires: recaptcha*private*key and recaptcha*site*key) Enable reCAPTCHA.
 * @property recaptchaPrivateKey Private key for reCAPTCHA.
 * @property recaptchaSiteKey Site key for reCAPTCHA.
 * @property receiveMaxInputSize Maximum push size (MB).
 * @property repositoryChecksEnabled GitLab periodically runs git fsck in all project and wiki repositories to look for silent disk corruption issues.
 * @property repositorySizeLimit Size limit per repository (MB).
 * @property repositoryStorages (GitLab 13.0 and earlier) List of names of enabled storage paths, taken from gitlab.yml. New projects are created in one of these stores, chosen at random.
 * @property repositoryStoragesWeighted (GitLab 13.1 and later) Hash of names of taken from gitlab.yml to weights. New projects are created in one of these stores, chosen by a weighted random selection.
 * @property requireAdminApprovalAfterUserSignup When enabled, any user that signs up for an account using the registration form is placed under a Pending approval state and has to be explicitly approved by an administrator.
 * @property requireTwoFactorAuthentication (If enabled, requires: two*factor*grace_period) Require all users to set up Two-factor authentication.
 * @property restrictedVisibilityLevels Selected levels cannot be used by non-Administrator users for groups, projects or snippets. Can take private, internal and public as a parameter. Null means there is no restriction.
 * @property rsaKeyRestriction The minimum allowed bit length of an uploaded RSA key. 0 means no restriction. -1 disables RSA keys.
 * @property searchRateLimit Max number of requests per minute for performing a search while authenticated. To disable throttling set to 0.
 * @property searchRateLimitUnauthenticated Max number of requests per minute for performing a search while unauthenticated. To disable throttling set to 0.
 * @property sendUserConfirmationEmail Send confirmation email on sign-up.
 * @property sessionExpireDelay Session duration in minutes. GitLab restart is required to apply changes.
 * @property sharedRunnersEnabled (If enabled, requires: shared*runners*text and shared*runners*minutes) Enable shared runners for new projects.
 * @property sharedRunnersMinutes Set the maximum number of CI/CD minutes that a group can use on shared runners per month.
 * @property sharedRunnersText Shared runners text.
 * @property sidekiqJobLimiterCompressionThresholdBytes The threshold in bytes at which Sidekiq jobs are compressed before being stored in Redis.
 * @property sidekiqJobLimiterLimitBytes The threshold in bytes at which Sidekiq jobs are rejected. 0 means do not reject any job.
 * @property sidekiqJobLimiterMode track or compress. Sets the behavior for Sidekiq job size limits.
 * @property signInText Text on the login page.
 * @property signupEnabled Enable registration.
 * @property slackAppEnabled (If enabled, requires: slack*app*id, slack*app*secret and slack*app*secret) Enable Slack app.
 * @property slackAppId The app ID of the Slack-app.
 * @property slackAppSecret The app secret of the Slack-app.
 * @property slackAppSigningSecret The signing secret of the Slack-app.
 * @property slackAppVerificationToken The verification token of the Slack-app.
 * @property snippetSizeLimit Max snippet content size in bytes.
 * @property snowplowAppId The Snowplow site name / application ID. (for example, gitlab)
 * @property snowplowCollectorHostname The Snowplow collector hostname. (for example, snowplow.trx.gitlab.net)
 * @property snowplowCookieDomain The Snowplow cookie domain. (for example, .gitlab.com)
 * @property snowplowEnabled Enable snowplow tracking.
 * @property sourcegraphEnabled Enables Sourcegraph integration. If enabled, requires sourcegraph_url.
 * @property sourcegraphPublicOnly Blocks Sourcegraph from being loaded on private and internal projects.
 * @property sourcegraphUrl The Sourcegraph instance URL for integration.
 * @property spamCheckApiKey API key used by GitLab for accessing the Spam Check service endpoint.
 * @property spamCheckEndpointEnabled Enables spam checking using external Spam Check API endpoint.
 * @property spamCheckEndpointUrl URL of the external Spamcheck service endpoint. Valid URI schemes are grpc or tls. Specifying tls forces communication to be encrypted.
 * @property suggestPipelineEnabled Enable pipeline suggestion banner.
 * @property terminalMaxSessionTime Maximum time for web terminal websocket connection (in seconds). Set to 0 for unlimited time.
 * @property terms (Required by: enforce_terms) Markdown content for the ToS.
 * @property throttleAuthenticatedApiEnabled (If enabled, requires: throttle*authenticated*api*period*in*seconds and throttle*authenticated*api*requests*per*period) Enable authenticated API request rate limit. Helps reduce request volume (for example, from crawlers or abusive bots).
 * @property throttleAuthenticatedApiPeriodInSeconds Rate limit period (in seconds).
 * @property throttleAuthenticatedApiRequestsPerPeriod Maximum requests per period per user.
 * @property throttleAuthenticatedPackagesApiEnabled (If enabled, requires: throttle*authenticated*packages*api*period*in*seconds and throttle*authenticated*packages*api*requests*per*period) Enable authenticated API request rate limit. Helps reduce request volume (for example, from crawlers or abusive bots). View Package Registry rate limits for more details.
 * @property throttleAuthenticatedPackagesApiPeriodInSeconds Rate limit period (in seconds). View Package Registry rate limits for more details.
 * @property throttleAuthenticatedPackagesApiRequestsPerPeriod Maximum requests per period per user. View Package Registry rate limits for more details.
 * @property throttleAuthenticatedWebEnabled (If enabled, requires: throttle*authenticated*web*period*in*seconds and throttle*authenticated*web*requests*per*period) Enable authenticated web request rate limit. Helps reduce request volume (for example, from crawlers or abusive bots).
 * @property throttleAuthenticatedWebPeriodInSeconds Rate limit period (in seconds).
 * @property throttleAuthenticatedWebRequestsPerPeriod Maximum requests per period per user.
 * @property throttleUnauthenticatedApiEnabled (If enabled, requires: throttle*unauthenticated*api*period*in*seconds and throttle*unauthenticated*api*requests*per*period) Enable unauthenticated API request rate limit. Helps reduce request volume (for example, from crawlers or abusive bots).
 * @property throttleUnauthenticatedApiPeriodInSeconds Rate limit period in seconds.
 * @property throttleUnauthenticatedApiRequestsPerPeriod Max requests per period per IP.
 * @property throttleUnauthenticatedPackagesApiEnabled (If enabled, requires: throttle*unauthenticated*packages*api*period*in*seconds and throttle*unauthenticated*packages*api*requests*per*period) Enable authenticated API request rate limit. Helps reduce request volume (for example, from crawlers or abusive bots). View Package Registry rate limits for more details.
 * @property throttleUnauthenticatedPackagesApiPeriodInSeconds Rate limit period (in seconds). View Package Registry rate limits for more details.
 * @property throttleUnauthenticatedPackagesApiRequestsPerPeriod Maximum requests per period per user. View Package Registry rate limits for more details.
 * @property throttleUnauthenticatedWebEnabled (If enabled, requires: throttle*unauthenticated*web*period*in*seconds and throttle*unauthenticated*web*requests*per*period) Enable unauthenticated web request rate limit. Helps reduce request volume (for example, from crawlers or abusive bots).
 * @property throttleUnauthenticatedWebPeriodInSeconds Rate limit period in seconds.
 * @property throttleUnauthenticatedWebRequestsPerPeriod Max requests per period per IP.
 * @property timeTrackingLimitToHours Limit display of time tracking units to hours.
 * @property twoFactorGracePeriod Amount of time (in hours) that users are allowed to skip forced configuration of two-factor authentication.
 * @property uniqueIpsLimitEnabled (If enabled, requires: unique*ips*limit*per*user and unique*ips*limit*time*window) Limit sign in from multiple IPs.
 * @property uniqueIpsLimitPerUser Maximum number of IPs per user.
 * @property uniqueIpsLimitTimeWindow How many seconds an IP is counted towards the limit.
 * @property usagePingEnabled Every week GitLab reports license usage back to GitLab, Inc.
 * @property userDeactivationEmailsEnabled Send an email to users upon account deactivation.
 * @property userDefaultExternal Newly registered users are external by default.
 * @property userDefaultInternalRegex Specify an email address regex pattern to identify default internal users.
 * @property userOauthApplications Allow users to register any application to use GitLab as an OAuth provider.
 * @property userShowAddSshKeyMessage When set to false disable the You won't be able to pull or push project code via SSH warning shown to users with no uploaded SSH key.
 * @property versionCheckEnabled Let GitLab inform you when an update is available.
 * @property webIdeClientsidePreviewEnabled Live Preview (allow live previews of JavaScript projects in the Web IDE using CodeSandbox Live Preview).
 * @property whatsNewVariant What’s new variant, possible values: all*tiers, current*tier, and disabled.
 * @property wikiPageMaxContentBytes Maximum wiki page content size in bytes. The minimum value is 1024 bytes.
 */
public data class ApplicationSettingsArgs(
    public val abuseNotificationEmail: Output<String>? = null,
    public val adminMode: Output<Boolean>? = null,
    public val afterSignOutPath: Output<String>? = null,
    public val afterSignUpText: Output<String>? = null,
    public val akismetApiKey: Output<String>? = null,
    public val akismetEnabled: Output<Boolean>? = null,
    public val allowAccountDeletion: Output<Boolean>? = null,
    public val allowGroupOwnersToManageLdap: Output<Boolean>? = null,
    public val allowLocalRequestsFromSystemHooks: Output<Boolean>? = null,
    public val allowLocalRequestsFromWebHooksAndServices: Output<Boolean>? = null,
    public val allowProjectCreationForGuestAndBelow: Output<Boolean>? = null,
    public val allowRunnerRegistrationToken: Output<Boolean>? = null,
    public val archiveBuildsInHumanReadable: Output<String>? = null,
    public val asciidocMaxIncludes: Output<Int>? = null,
    public val assetProxyAllowlists: Output<List<String>>? = null,
    public val assetProxyEnabled: Output<Boolean>? = null,
    public val assetProxySecretKey: Output<String>? = null,
    public val assetProxyUrl: Output<String>? = null,
    public val authorizedKeysEnabled: Output<Boolean>? = null,
    public val autoBanUserOnExcessiveProjectsDownload: Output<Boolean>? = null,
    public val autoDevopsDomain: Output<String>? = null,
    public val autoDevopsEnabled: Output<Boolean>? = null,
    public val automaticPurchasedStorageAllocation: Output<Boolean>? = null,
    public val bulkImportConcurrentPipelineBatchLimit: Output<Int>? = null,
    public val bulkImportEnabled: Output<Boolean>? = null,
    public val bulkImportMaxDownloadFileSize: Output<Int>? = null,
    public val canCreateGroup: Output<Boolean>? = null,
    public val checkNamespacePlan: Output<Boolean>? = null,
    public val ciMaxIncludes: Output<Int>? = null,
    public val ciMaxTotalYamlSizeBytes: Output<Int>? = null,
    public val commitEmailHostname: Output<String>? = null,
    public val concurrentBitbucketImportJobsLimit: Output<Int>? = null,
    public val concurrentBitbucketServerImportJobsLimit: Output<Int>? = null,
    public val concurrentGithubImportJobsLimit: Output<Int>? = null,
    public val containerExpirationPoliciesEnableHistoricEntries: Output<Boolean>? = null,
    public val containerRegistryCleanupTagsServiceMaxListSize: Output<Int>? = null,
    public val containerRegistryDeleteTagsServiceTimeout: Output<Int>? = null,
    public val containerRegistryExpirationPoliciesCaching: Output<Boolean>? = null,
    public val containerRegistryExpirationPoliciesWorkerCapacity: Output<Int>? = null,
    public val containerRegistryTokenExpireDelay: Output<Int>? = null,
    public val deactivateDormantUsers: Output<Boolean>? = null,
    public val deactivateDormantUsersPeriod: Output<Int>? = null,
    public val decompressArchiveFileTimeout: Output<Int>? = null,
    public val defaultArtifactsExpireIn: Output<String>? = null,
    public val defaultBranchName: Output<String>? = null,
    public val defaultBranchProtection: Output<Int>? = null,
    public val defaultBranchProtectionDefaults: Output<ApplicationSettingsDefaultBranchProtectionDefaultsArgs>? = null,
    public val defaultCiConfigPath: Output<String>? = null,
    public val defaultGroupVisibility: Output<String>? = null,
    public val defaultPreferredLanguage: Output<String>? = null,
    public val defaultProjectCreation: Output<Int>? = null,
    public val defaultProjectVisibility: Output<String>? = null,
    public val defaultProjectsLimit: Output<Int>? = null,
    public val defaultSnippetVisibility: Output<String>? = null,
    public val defaultSyntaxHighlightingTheme: Output<Int>? = null,
    public val deleteInactiveProjects: Output<Boolean>? = null,
    public val deleteUnconfirmedUsers: Output<Boolean>? = null,
    public val deletionAdjournedPeriod: Output<Int>? = null,
    public val diagramsnetEnabled: Output<Boolean>? = null,
    public val diagramsnetUrl: Output<String>? = null,
    public val diffMaxFiles: Output<Int>? = null,
    public val diffMaxLines: Output<Int>? = null,
    public val diffMaxPatchBytes: Output<Int>? = null,
    public val disableAdminOauthScopes: Output<Boolean>? = null,
    public val disableFeedToken: Output<Boolean>? = null,
    public val disablePersonalAccessTokens: Output<Boolean>? = null,
    public val disabledOauthSignInSources: Output<List<String>>? = null,
    public val dnsRebindingProtectionEnabled: Output<Boolean>? = null,
    public val domainAllowlists: Output<List<String>>? = null,
    public val domainDenylistEnabled: Output<Boolean>? = null,
    public val domainDenylists: Output<List<String>>? = null,
    public val downstreamPipelineTriggerLimitPerProjectUserSha: Output<Int>? = null,
    public val dsaKeyRestriction: Output<Int>? = null,
    public val duoFeaturesEnabled: Output<Boolean>? = null,
    public val ecdsaKeyRestriction: Output<Int>? = null,
    public val ecdsaSkKeyRestriction: Output<Int>? = null,
    public val ed25519KeyRestriction: Output<Int>? = null,
    public val ed25519SkKeyRestriction: Output<Int>? = null,
    public val eksAccessKeyId: Output<String>? = null,
    public val eksAccountId: Output<String>? = null,
    public val eksIntegrationEnabled: Output<Boolean>? = null,
    public val eksSecretAccessKey: Output<String>? = null,
    public val elasticsearchAws: Output<Boolean>? = null,
    public val elasticsearchAwsAccessKey: Output<String>? = null,
    public val elasticsearchAwsRegion: Output<String>? = null,
    public val elasticsearchAwsSecretAccessKey: Output<String>? = null,
    public val elasticsearchIndexedFieldLengthLimit: Output<Int>? = null,
    public val elasticsearchIndexedFileSizeLimitKb: Output<Int>? = null,
    public val elasticsearchIndexing: Output<Boolean>? = null,
    public val elasticsearchLimitIndexing: Output<Boolean>? = null,
    public val elasticsearchMaxBulkConcurrency: Output<Int>? = null,
    public val elasticsearchMaxBulkSizeMb: Output<Int>? = null,
    public val elasticsearchNamespaceIds: Output<List<Int>>? = null,
    public val elasticsearchPassword: Output<String>? = null,
    public val elasticsearchProjectIds: Output<List<Int>>? = null,
    public val elasticsearchSearch: Output<Boolean>? = null,
    public val elasticsearchUrls: Output<List<String>>? = null,
    public val elasticsearchUsername: Output<String>? = null,
    public val emailAdditionalText: Output<String>? = null,
    public val emailAuthorInBody: Output<Boolean>? = null,
    public val enabledGitAccessProtocol: Output<String>? = null,
    public val enforceNamespaceStorageLimit: Output<Boolean>? = null,
    public val enforceTerms: Output<Boolean>? = null,
    public val externalAuthClientCert: Output<String>? = null,
    public val externalAuthClientKey: Output<String>? = null,
    public val externalAuthClientKeyPass: Output<String>? = null,
    public val externalAuthorizationServiceDefaultLabel: Output<String>? = null,
    public val externalAuthorizationServiceEnabled: Output<Boolean>? = null,
    public val externalAuthorizationServiceTimeout: Output<Double>? = null,
    public val externalAuthorizationServiceUrl: Output<String>? = null,
    public val externalPipelineValidationServiceTimeout: Output<Int>? = null,
    public val externalPipelineValidationServiceToken: Output<String>? = null,
    public val externalPipelineValidationServiceUrl: Output<String>? = null,
    public val fileTemplateProjectId: Output<Int>? = null,
    public val firstDayOfWeek: Output<Int>? = null,
    public val geoNodeAllowedIps: Output<String>? = null,
    public val geoStatusTimeout: Output<Int>? = null,
    public val gitRateLimitUsersAllowlists: Output<List<String>>? = null,
    public val gitTwoFactorSessionExpiry: Output<Int>? = null,
    public val gitalyTimeoutDefault: Output<Int>? = null,
    public val gitalyTimeoutFast: Output<Int>? = null,
    public val gitalyTimeoutMedium: Output<Int>? = null,
    public val grafanaEnabled: Output<Boolean>? = null,
    public val grafanaUrl: Output<String>? = null,
    public val gravatarEnabled: Output<Boolean>? = null,
    public val groupOwnersCanManageDefaultBranchProtection: Output<Boolean>? = null,
    public val hashedStorageEnabled: Output<Boolean>? = null,
    public val helpPageHideCommercialContent: Output<Boolean>? = null,
    public val helpPageSupportUrl: Output<String>? = null,
    public val helpPageText: Output<String>? = null,
    public val helpText: Output<String>? = null,
    public val hideThirdPartyOffers: Output<Boolean>? = null,
    public val homePageUrl: Output<String>? = null,
    public val housekeepingEnabled: Output<Boolean>? = null,
    @Deprecated(
        message = """
  housekeeping_full_repack_period is deprecated. Use housekeeping_optimize_repository_period
      instead.
  """,
    )
    public val housekeepingFullRepackPeriod: Output<Int>? = null,
    @Deprecated(
        message = """
  housekeeping_gc_period is deprecated. Use housekeeping_optimize_repository_period instead.
  """,
    )
    public val housekeepingGcPeriod: Output<Int>? = null,
    @Deprecated(
        message = """
  housekeeping_incremental_repack_period is deprecated. Use housekeeping_optimize_repository_period
      instead.
  """,
    )
    public val housekeepingIncrementalRepackPeriod: Output<Int>? = null,
    public val housekeepingOptimizeRepositoryPeriod: Output<Int>? = null,
    public val htmlEmailsEnabled: Output<Boolean>? = null,
    public val importSources: Output<List<String>>? = null,
    public val inProductMarketingEmailsEnabled: Output<Boolean>? = null,
    public val inactiveProjectsDeleteAfterMonths: Output<Int>? = null,
    public val inactiveProjectsMinSizeMb: Output<Int>? = null,
    public val inactiveProjectsSendWarningEmailAfterMonths: Output<Int>? = null,
    public val invisibleCaptchaEnabled: Output<Boolean>? = null,
    public val issuesCreateLimit: Output<Int>? = null,
    public val keepLatestArtifact: Output<Boolean>? = null,
    public val localMarkdownVersion: Output<Int>? = null,
    public val mailgunEventsEnabled: Output<Boolean>? = null,
    public val mailgunSigningKey: Output<String>? = null,
    public val maintenanceMode: Output<Boolean>? = null,
    public val maintenanceModeMessage: Output<String>? = null,
    public val maxArtifactsSize: Output<Int>? = null,
    public val maxAttachmentSize: Output<Int>? = null,
    public val maxExportSize: Output<Int>? = null,
    public val maxImportSize: Output<Int>? = null,
    public val maxNumberOfRepositoryDownloads: Output<Int>? = null,
    public val maxNumberOfRepositoryDownloadsWithinTimePeriod: Output<Int>? = null,
    public val maxPagesSize: Output<Int>? = null,
    public val maxPersonalAccessTokenLifetime: Output<Int>? = null,
    public val maxSshKeyLifetime: Output<Int>? = null,
    public val maxTerraformStateSizeBytes: Output<Int>? = null,
    public val metricsMethodCallThreshold: Output<Int>? = null,
    public val minimumPasswordLength: Output<Int>? = null,
    public val mirrorAvailable: Output<Boolean>? = null,
    public val mirrorCapacityThreshold: Output<Int>? = null,
    public val mirrorMaxCapacity: Output<Int>? = null,
    public val mirrorMaxDelay: Output<Int>? = null,
    public val npmPackageRequestsForwarding: Output<Boolean>? = null,
    public val outboundLocalRequestsWhitelists: Output<List<String>>? = null,
    public val packageRegistryCleanupPoliciesWorkerCapacity: Output<Int>? = null,
    public val pagesDomainVerificationEnabled: Output<Boolean>? = null,
    public val passwordAuthenticationEnabledForGit: Output<Boolean>? = null,
    public val passwordAuthenticationEnabledForWeb: Output<Boolean>? = null,
    public val passwordLowercaseRequired: Output<Boolean>? = null,
    public val passwordNumberRequired: Output<Boolean>? = null,
    public val passwordSymbolRequired: Output<Boolean>? = null,
    public val passwordUppercaseRequired: Output<Boolean>? = null,
    public val performanceBarAllowedGroupPath: Output<String>? = null,
    public val personalAccessTokenPrefix: Output<String>? = null,
    public val pipelineLimitPerProjectUserSha: Output<Int>? = null,
    public val plantumlEnabled: Output<Boolean>? = null,
    public val plantumlUrl: Output<String>? = null,
    public val pollingIntervalMultiplier: Output<Double>? = null,
    public val projectExportEnabled: Output<Boolean>? = null,
    public val prometheusMetricsEnabled: Output<Boolean>? = null,
    public val protectedCiVariables: Output<Boolean>? = null,
    public val pushEventActivitiesLimit: Output<Int>? = null,
    public val pushEventHooksLimit: Output<Int>? = null,
    public val pypiPackageRequestsForwarding: Output<Boolean>? = null,
    public val rateLimitingResponseText: Output<String>? = null,
    public val rawBlobRequestLimit: Output<Int>? = null,
    public val recaptchaEnabled: Output<Boolean>? = null,
    public val recaptchaPrivateKey: Output<String>? = null,
    public val recaptchaSiteKey: Output<String>? = null,
    public val receiveMaxInputSize: Output<Int>? = null,
    public val repositoryChecksEnabled: Output<Boolean>? = null,
    public val repositorySizeLimit: Output<Int>? = null,
    public val repositoryStorages: Output<List<String>>? = null,
    public val repositoryStoragesWeighted: Output<Map<String, Int>>? = null,
    public val requireAdminApprovalAfterUserSignup: Output<Boolean>? = null,
    public val requireTwoFactorAuthentication: Output<Boolean>? = null,
    public val restrictedVisibilityLevels: Output<List<String>>? = null,
    public val rsaKeyRestriction: Output<Int>? = null,
    public val searchRateLimit: Output<Int>? = null,
    public val searchRateLimitUnauthenticated: Output<Int>? = null,
    public val sendUserConfirmationEmail: Output<Boolean>? = null,
    public val sessionExpireDelay: Output<Int>? = null,
    public val sharedRunnersEnabled: Output<Boolean>? = null,
    public val sharedRunnersMinutes: Output<Int>? = null,
    public val sharedRunnersText: Output<String>? = null,
    public val sidekiqJobLimiterCompressionThresholdBytes: Output<Int>? = null,
    public val sidekiqJobLimiterLimitBytes: Output<Int>? = null,
    public val sidekiqJobLimiterMode: Output<String>? = null,
    public val signInText: Output<String>? = null,
    public val signupEnabled: Output<Boolean>? = null,
    public val slackAppEnabled: Output<Boolean>? = null,
    public val slackAppId: Output<String>? = null,
    public val slackAppSecret: Output<String>? = null,
    public val slackAppSigningSecret: Output<String>? = null,
    public val slackAppVerificationToken: Output<String>? = null,
    public val snippetSizeLimit: Output<Int>? = null,
    public val snowplowAppId: Output<String>? = null,
    public val snowplowCollectorHostname: Output<String>? = null,
    public val snowplowCookieDomain: Output<String>? = null,
    public val snowplowEnabled: Output<Boolean>? = null,
    public val sourcegraphEnabled: Output<Boolean>? = null,
    public val sourcegraphPublicOnly: Output<Boolean>? = null,
    public val sourcegraphUrl: Output<String>? = null,
    public val spamCheckApiKey: Output<String>? = null,
    public val spamCheckEndpointEnabled: Output<Boolean>? = null,
    public val spamCheckEndpointUrl: Output<String>? = null,
    public val suggestPipelineEnabled: Output<Boolean>? = null,
    public val terminalMaxSessionTime: Output<Int>? = null,
    public val terms: Output<String>? = null,
    public val throttleAuthenticatedApiEnabled: Output<Boolean>? = null,
    public val throttleAuthenticatedApiPeriodInSeconds: Output<Int>? = null,
    public val throttleAuthenticatedApiRequestsPerPeriod: Output<Int>? = null,
    public val throttleAuthenticatedPackagesApiEnabled: Output<Boolean>? = null,
    public val throttleAuthenticatedPackagesApiPeriodInSeconds: Output<Int>? = null,
    public val throttleAuthenticatedPackagesApiRequestsPerPeriod: Output<Int>? = null,
    public val throttleAuthenticatedWebEnabled: Output<Boolean>? = null,
    public val throttleAuthenticatedWebPeriodInSeconds: Output<Int>? = null,
    public val throttleAuthenticatedWebRequestsPerPeriod: Output<Int>? = null,
    public val throttleUnauthenticatedApiEnabled: Output<Boolean>? = null,
    public val throttleUnauthenticatedApiPeriodInSeconds: Output<Int>? = null,
    public val throttleUnauthenticatedApiRequestsPerPeriod: Output<Int>? = null,
    public val throttleUnauthenticatedPackagesApiEnabled: Output<Boolean>? = null,
    public val throttleUnauthenticatedPackagesApiPeriodInSeconds: Output<Int>? = null,
    public val throttleUnauthenticatedPackagesApiRequestsPerPeriod: Output<Int>? = null,
    public val throttleUnauthenticatedWebEnabled: Output<Boolean>? = null,
    public val throttleUnauthenticatedWebPeriodInSeconds: Output<Int>? = null,
    public val throttleUnauthenticatedWebRequestsPerPeriod: Output<Int>? = null,
    public val timeTrackingLimitToHours: Output<Boolean>? = null,
    public val twoFactorGracePeriod: Output<Int>? = null,
    public val uniqueIpsLimitEnabled: Output<Boolean>? = null,
    public val uniqueIpsLimitPerUser: Output<Int>? = null,
    public val uniqueIpsLimitTimeWindow: Output<Int>? = null,
    public val usagePingEnabled: Output<Boolean>? = null,
    public val userDeactivationEmailsEnabled: Output<Boolean>? = null,
    public val userDefaultExternal: Output<Boolean>? = null,
    public val userDefaultInternalRegex: Output<String>? = null,
    public val userOauthApplications: Output<Boolean>? = null,
    public val userShowAddSshKeyMessage: Output<Boolean>? = null,
    public val versionCheckEnabled: Output<Boolean>? = null,
    public val webIdeClientsidePreviewEnabled: Output<Boolean>? = null,
    public val whatsNewVariant: Output<String>? = null,
    public val wikiPageMaxContentBytes: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.ApplicationSettingsArgs> {
    override fun toJava(): com.pulumi.gitlab.ApplicationSettingsArgs =
        com.pulumi.gitlab.ApplicationSettingsArgs.builder()
            .abuseNotificationEmail(abuseNotificationEmail?.applyValue({ args0 -> args0 }))
            .adminMode(adminMode?.applyValue({ args0 -> args0 }))
            .afterSignOutPath(afterSignOutPath?.applyValue({ args0 -> args0 }))
            .afterSignUpText(afterSignUpText?.applyValue({ args0 -> args0 }))
            .akismetApiKey(akismetApiKey?.applyValue({ args0 -> args0 }))
            .akismetEnabled(akismetEnabled?.applyValue({ args0 -> args0 }))
            .allowAccountDeletion(allowAccountDeletion?.applyValue({ args0 -> args0 }))
            .allowGroupOwnersToManageLdap(allowGroupOwnersToManageLdap?.applyValue({ args0 -> args0 }))
            .allowLocalRequestsFromSystemHooks(
                allowLocalRequestsFromSystemHooks?.applyValue({ args0 ->
                    args0
                }),
            )
            .allowLocalRequestsFromWebHooksAndServices(
                allowLocalRequestsFromWebHooksAndServices?.applyValue({ args0 ->
                    args0
                }),
            )
            .allowProjectCreationForGuestAndBelow(
                allowProjectCreationForGuestAndBelow?.applyValue({ args0 ->
                    args0
                }),
            )
            .allowRunnerRegistrationToken(allowRunnerRegistrationToken?.applyValue({ args0 -> args0 }))
            .archiveBuildsInHumanReadable(archiveBuildsInHumanReadable?.applyValue({ args0 -> args0 }))
            .asciidocMaxIncludes(asciidocMaxIncludes?.applyValue({ args0 -> args0 }))
            .assetProxyAllowlists(assetProxyAllowlists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .assetProxyEnabled(assetProxyEnabled?.applyValue({ args0 -> args0 }))
            .assetProxySecretKey(assetProxySecretKey?.applyValue({ args0 -> args0 }))
            .assetProxyUrl(assetProxyUrl?.applyValue({ args0 -> args0 }))
            .authorizedKeysEnabled(authorizedKeysEnabled?.applyValue({ args0 -> args0 }))
            .autoBanUserOnExcessiveProjectsDownload(
                autoBanUserOnExcessiveProjectsDownload?.applyValue({ args0 ->
                    args0
                }),
            )
            .autoDevopsDomain(autoDevopsDomain?.applyValue({ args0 -> args0 }))
            .autoDevopsEnabled(autoDevopsEnabled?.applyValue({ args0 -> args0 }))
            .automaticPurchasedStorageAllocation(
                automaticPurchasedStorageAllocation?.applyValue({ args0 ->
                    args0
                }),
            )
            .bulkImportConcurrentPipelineBatchLimit(
                bulkImportConcurrentPipelineBatchLimit?.applyValue({ args0 ->
                    args0
                }),
            )
            .bulkImportEnabled(bulkImportEnabled?.applyValue({ args0 -> args0 }))
            .bulkImportMaxDownloadFileSize(bulkImportMaxDownloadFileSize?.applyValue({ args0 -> args0 }))
            .canCreateGroup(canCreateGroup?.applyValue({ args0 -> args0 }))
            .checkNamespacePlan(checkNamespacePlan?.applyValue({ args0 -> args0 }))
            .ciMaxIncludes(ciMaxIncludes?.applyValue({ args0 -> args0 }))
            .ciMaxTotalYamlSizeBytes(ciMaxTotalYamlSizeBytes?.applyValue({ args0 -> args0 }))
            .commitEmailHostname(commitEmailHostname?.applyValue({ args0 -> args0 }))
            .concurrentBitbucketImportJobsLimit(
                concurrentBitbucketImportJobsLimit?.applyValue({ args0 ->
                    args0
                }),
            )
            .concurrentBitbucketServerImportJobsLimit(
                concurrentBitbucketServerImportJobsLimit?.applyValue({ args0 ->
                    args0
                }),
            )
            .concurrentGithubImportJobsLimit(concurrentGithubImportJobsLimit?.applyValue({ args0 -> args0 }))
            .containerExpirationPoliciesEnableHistoricEntries(
                containerExpirationPoliciesEnableHistoricEntries?.applyValue({ args0 ->
                    args0
                }),
            )
            .containerRegistryCleanupTagsServiceMaxListSize(
                containerRegistryCleanupTagsServiceMaxListSize?.applyValue({ args0 ->
                    args0
                }),
            )
            .containerRegistryDeleteTagsServiceTimeout(
                containerRegistryDeleteTagsServiceTimeout?.applyValue({ args0 ->
                    args0
                }),
            )
            .containerRegistryExpirationPoliciesCaching(
                containerRegistryExpirationPoliciesCaching?.applyValue({ args0 ->
                    args0
                }),
            )
            .containerRegistryExpirationPoliciesWorkerCapacity(
                containerRegistryExpirationPoliciesWorkerCapacity?.applyValue({ args0 ->
                    args0
                }),
            )
            .containerRegistryTokenExpireDelay(
                containerRegistryTokenExpireDelay?.applyValue({ args0 ->
                    args0
                }),
            )
            .deactivateDormantUsers(deactivateDormantUsers?.applyValue({ args0 -> args0 }))
            .deactivateDormantUsersPeriod(deactivateDormantUsersPeriod?.applyValue({ args0 -> args0 }))
            .decompressArchiveFileTimeout(decompressArchiveFileTimeout?.applyValue({ args0 -> args0 }))
            .defaultArtifactsExpireIn(defaultArtifactsExpireIn?.applyValue({ args0 -> args0 }))
            .defaultBranchName(defaultBranchName?.applyValue({ args0 -> args0 }))
            .defaultBranchProtection(defaultBranchProtection?.applyValue({ args0 -> args0 }))
            .defaultBranchProtectionDefaults(
                defaultBranchProtectionDefaults?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .defaultCiConfigPath(defaultCiConfigPath?.applyValue({ args0 -> args0 }))
            .defaultGroupVisibility(defaultGroupVisibility?.applyValue({ args0 -> args0 }))
            .defaultPreferredLanguage(defaultPreferredLanguage?.applyValue({ args0 -> args0 }))
            .defaultProjectCreation(defaultProjectCreation?.applyValue({ args0 -> args0 }))
            .defaultProjectVisibility(defaultProjectVisibility?.applyValue({ args0 -> args0 }))
            .defaultProjectsLimit(defaultProjectsLimit?.applyValue({ args0 -> args0 }))
            .defaultSnippetVisibility(defaultSnippetVisibility?.applyValue({ args0 -> args0 }))
            .defaultSyntaxHighlightingTheme(defaultSyntaxHighlightingTheme?.applyValue({ args0 -> args0 }))
            .deleteInactiveProjects(deleteInactiveProjects?.applyValue({ args0 -> args0 }))
            .deleteUnconfirmedUsers(deleteUnconfirmedUsers?.applyValue({ args0 -> args0 }))
            .deletionAdjournedPeriod(deletionAdjournedPeriod?.applyValue({ args0 -> args0 }))
            .diagramsnetEnabled(diagramsnetEnabled?.applyValue({ args0 -> args0 }))
            .diagramsnetUrl(diagramsnetUrl?.applyValue({ args0 -> args0 }))
            .diffMaxFiles(diffMaxFiles?.applyValue({ args0 -> args0 }))
            .diffMaxLines(diffMaxLines?.applyValue({ args0 -> args0 }))
            .diffMaxPatchBytes(diffMaxPatchBytes?.applyValue({ args0 -> args0 }))
            .disableAdminOauthScopes(disableAdminOauthScopes?.applyValue({ args0 -> args0 }))
            .disableFeedToken(disableFeedToken?.applyValue({ args0 -> args0 }))
            .disablePersonalAccessTokens(disablePersonalAccessTokens?.applyValue({ args0 -> args0 }))
            .disabledOauthSignInSources(
                disabledOauthSignInSources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .dnsRebindingProtectionEnabled(dnsRebindingProtectionEnabled?.applyValue({ args0 -> args0 }))
            .domainAllowlists(domainAllowlists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .domainDenylistEnabled(domainDenylistEnabled?.applyValue({ args0 -> args0 }))
            .domainDenylists(domainDenylists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .downstreamPipelineTriggerLimitPerProjectUserSha(
                downstreamPipelineTriggerLimitPerProjectUserSha?.applyValue({ args0 ->
                    args0
                }),
            )
            .dsaKeyRestriction(dsaKeyRestriction?.applyValue({ args0 -> args0 }))
            .duoFeaturesEnabled(duoFeaturesEnabled?.applyValue({ args0 -> args0 }))
            .ecdsaKeyRestriction(ecdsaKeyRestriction?.applyValue({ args0 -> args0 }))
            .ecdsaSkKeyRestriction(ecdsaSkKeyRestriction?.applyValue({ args0 -> args0 }))
            .ed25519KeyRestriction(ed25519KeyRestriction?.applyValue({ args0 -> args0 }))
            .ed25519SkKeyRestriction(ed25519SkKeyRestriction?.applyValue({ args0 -> args0 }))
            .eksAccessKeyId(eksAccessKeyId?.applyValue({ args0 -> args0 }))
            .eksAccountId(eksAccountId?.applyValue({ args0 -> args0 }))
            .eksIntegrationEnabled(eksIntegrationEnabled?.applyValue({ args0 -> args0 }))
            .eksSecretAccessKey(eksSecretAccessKey?.applyValue({ args0 -> args0 }))
            .elasticsearchAws(elasticsearchAws?.applyValue({ args0 -> args0 }))
            .elasticsearchAwsAccessKey(elasticsearchAwsAccessKey?.applyValue({ args0 -> args0 }))
            .elasticsearchAwsRegion(elasticsearchAwsRegion?.applyValue({ args0 -> args0 }))
            .elasticsearchAwsSecretAccessKey(elasticsearchAwsSecretAccessKey?.applyValue({ args0 -> args0 }))
            .elasticsearchIndexedFieldLengthLimit(
                elasticsearchIndexedFieldLengthLimit?.applyValue({ args0 ->
                    args0
                }),
            )
            .elasticsearchIndexedFileSizeLimitKb(
                elasticsearchIndexedFileSizeLimitKb?.applyValue({ args0 ->
                    args0
                }),
            )
            .elasticsearchIndexing(elasticsearchIndexing?.applyValue({ args0 -> args0 }))
            .elasticsearchLimitIndexing(elasticsearchLimitIndexing?.applyValue({ args0 -> args0 }))
            .elasticsearchMaxBulkConcurrency(elasticsearchMaxBulkConcurrency?.applyValue({ args0 -> args0 }))
            .elasticsearchMaxBulkSizeMb(elasticsearchMaxBulkSizeMb?.applyValue({ args0 -> args0 }))
            .elasticsearchNamespaceIds(
                elasticsearchNamespaceIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .elasticsearchPassword(elasticsearchPassword?.applyValue({ args0 -> args0 }))
            .elasticsearchProjectIds(
                elasticsearchProjectIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .elasticsearchSearch(elasticsearchSearch?.applyValue({ args0 -> args0 }))
            .elasticsearchUrls(elasticsearchUrls?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .elasticsearchUsername(elasticsearchUsername?.applyValue({ args0 -> args0 }))
            .emailAdditionalText(emailAdditionalText?.applyValue({ args0 -> args0 }))
            .emailAuthorInBody(emailAuthorInBody?.applyValue({ args0 -> args0 }))
            .enabledGitAccessProtocol(enabledGitAccessProtocol?.applyValue({ args0 -> args0 }))
            .enforceNamespaceStorageLimit(enforceNamespaceStorageLimit?.applyValue({ args0 -> args0 }))
            .enforceTerms(enforceTerms?.applyValue({ args0 -> args0 }))
            .externalAuthClientCert(externalAuthClientCert?.applyValue({ args0 -> args0 }))
            .externalAuthClientKey(externalAuthClientKey?.applyValue({ args0 -> args0 }))
            .externalAuthClientKeyPass(externalAuthClientKeyPass?.applyValue({ args0 -> args0 }))
            .externalAuthorizationServiceDefaultLabel(
                externalAuthorizationServiceDefaultLabel?.applyValue({ args0 ->
                    args0
                }),
            )
            .externalAuthorizationServiceEnabled(
                externalAuthorizationServiceEnabled?.applyValue({ args0 ->
                    args0
                }),
            )
            .externalAuthorizationServiceTimeout(
                externalAuthorizationServiceTimeout?.applyValue({ args0 ->
                    args0
                }),
            )
            .externalAuthorizationServiceUrl(externalAuthorizationServiceUrl?.applyValue({ args0 -> args0 }))
            .externalPipelineValidationServiceTimeout(
                externalPipelineValidationServiceTimeout?.applyValue({ args0 ->
                    args0
                }),
            )
            .externalPipelineValidationServiceToken(
                externalPipelineValidationServiceToken?.applyValue({ args0 ->
                    args0
                }),
            )
            .externalPipelineValidationServiceUrl(
                externalPipelineValidationServiceUrl?.applyValue({ args0 ->
                    args0
                }),
            )
            .fileTemplateProjectId(fileTemplateProjectId?.applyValue({ args0 -> args0 }))
            .firstDayOfWeek(firstDayOfWeek?.applyValue({ args0 -> args0 }))
            .geoNodeAllowedIps(geoNodeAllowedIps?.applyValue({ args0 -> args0 }))
            .geoStatusTimeout(geoStatusTimeout?.applyValue({ args0 -> args0 }))
            .gitRateLimitUsersAllowlists(
                gitRateLimitUsersAllowlists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .gitTwoFactorSessionExpiry(gitTwoFactorSessionExpiry?.applyValue({ args0 -> args0 }))
            .gitalyTimeoutDefault(gitalyTimeoutDefault?.applyValue({ args0 -> args0 }))
            .gitalyTimeoutFast(gitalyTimeoutFast?.applyValue({ args0 -> args0 }))
            .gitalyTimeoutMedium(gitalyTimeoutMedium?.applyValue({ args0 -> args0 }))
            .grafanaEnabled(grafanaEnabled?.applyValue({ args0 -> args0 }))
            .grafanaUrl(grafanaUrl?.applyValue({ args0 -> args0 }))
            .gravatarEnabled(gravatarEnabled?.applyValue({ args0 -> args0 }))
            .groupOwnersCanManageDefaultBranchProtection(
                groupOwnersCanManageDefaultBranchProtection?.applyValue({ args0 ->
                    args0
                }),
            )
            .hashedStorageEnabled(hashedStorageEnabled?.applyValue({ args0 -> args0 }))
            .helpPageHideCommercialContent(helpPageHideCommercialContent?.applyValue({ args0 -> args0 }))
            .helpPageSupportUrl(helpPageSupportUrl?.applyValue({ args0 -> args0 }))
            .helpPageText(helpPageText?.applyValue({ args0 -> args0 }))
            .helpText(helpText?.applyValue({ args0 -> args0 }))
            .hideThirdPartyOffers(hideThirdPartyOffers?.applyValue({ args0 -> args0 }))
            .homePageUrl(homePageUrl?.applyValue({ args0 -> args0 }))
            .housekeepingEnabled(housekeepingEnabled?.applyValue({ args0 -> args0 }))
            .housekeepingFullRepackPeriod(housekeepingFullRepackPeriod?.applyValue({ args0 -> args0 }))
            .housekeepingGcPeriod(housekeepingGcPeriod?.applyValue({ args0 -> args0 }))
            .housekeepingIncrementalRepackPeriod(
                housekeepingIncrementalRepackPeriod?.applyValue({ args0 ->
                    args0
                }),
            )
            .housekeepingOptimizeRepositoryPeriod(
                housekeepingOptimizeRepositoryPeriod?.applyValue({ args0 ->
                    args0
                }),
            )
            .htmlEmailsEnabled(htmlEmailsEnabled?.applyValue({ args0 -> args0 }))
            .importSources(importSources?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .inProductMarketingEmailsEnabled(inProductMarketingEmailsEnabled?.applyValue({ args0 -> args0 }))
            .inactiveProjectsDeleteAfterMonths(
                inactiveProjectsDeleteAfterMonths?.applyValue({ args0 ->
                    args0
                }),
            )
            .inactiveProjectsMinSizeMb(inactiveProjectsMinSizeMb?.applyValue({ args0 -> args0 }))
            .inactiveProjectsSendWarningEmailAfterMonths(
                inactiveProjectsSendWarningEmailAfterMonths?.applyValue({ args0 ->
                    args0
                }),
            )
            .invisibleCaptchaEnabled(invisibleCaptchaEnabled?.applyValue({ args0 -> args0 }))
            .issuesCreateLimit(issuesCreateLimit?.applyValue({ args0 -> args0 }))
            .keepLatestArtifact(keepLatestArtifact?.applyValue({ args0 -> args0 }))
            .localMarkdownVersion(localMarkdownVersion?.applyValue({ args0 -> args0 }))
            .mailgunEventsEnabled(mailgunEventsEnabled?.applyValue({ args0 -> args0 }))
            .mailgunSigningKey(mailgunSigningKey?.applyValue({ args0 -> args0 }))
            .maintenanceMode(maintenanceMode?.applyValue({ args0 -> args0 }))
            .maintenanceModeMessage(maintenanceModeMessage?.applyValue({ args0 -> args0 }))
            .maxArtifactsSize(maxArtifactsSize?.applyValue({ args0 -> args0 }))
            .maxAttachmentSize(maxAttachmentSize?.applyValue({ args0 -> args0 }))
            .maxExportSize(maxExportSize?.applyValue({ args0 -> args0 }))
            .maxImportSize(maxImportSize?.applyValue({ args0 -> args0 }))
            .maxNumberOfRepositoryDownloads(maxNumberOfRepositoryDownloads?.applyValue({ args0 -> args0 }))
            .maxNumberOfRepositoryDownloadsWithinTimePeriod(
                maxNumberOfRepositoryDownloadsWithinTimePeriod?.applyValue({ args0 ->
                    args0
                }),
            )
            .maxPagesSize(maxPagesSize?.applyValue({ args0 -> args0 }))
            .maxPersonalAccessTokenLifetime(maxPersonalAccessTokenLifetime?.applyValue({ args0 -> args0 }))
            .maxSshKeyLifetime(maxSshKeyLifetime?.applyValue({ args0 -> args0 }))
            .maxTerraformStateSizeBytes(maxTerraformStateSizeBytes?.applyValue({ args0 -> args0 }))
            .metricsMethodCallThreshold(metricsMethodCallThreshold?.applyValue({ args0 -> args0 }))
            .minimumPasswordLength(minimumPasswordLength?.applyValue({ args0 -> args0 }))
            .mirrorAvailable(mirrorAvailable?.applyValue({ args0 -> args0 }))
            .mirrorCapacityThreshold(mirrorCapacityThreshold?.applyValue({ args0 -> args0 }))
            .mirrorMaxCapacity(mirrorMaxCapacity?.applyValue({ args0 -> args0 }))
            .mirrorMaxDelay(mirrorMaxDelay?.applyValue({ args0 -> args0 }))
            .npmPackageRequestsForwarding(npmPackageRequestsForwarding?.applyValue({ args0 -> args0 }))
            .outboundLocalRequestsWhitelists(
                outboundLocalRequestsWhitelists?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .packageRegistryCleanupPoliciesWorkerCapacity(
                packageRegistryCleanupPoliciesWorkerCapacity?.applyValue({ args0 ->
                    args0
                }),
            )
            .pagesDomainVerificationEnabled(pagesDomainVerificationEnabled?.applyValue({ args0 -> args0 }))
            .passwordAuthenticationEnabledForGit(
                passwordAuthenticationEnabledForGit?.applyValue({ args0 ->
                    args0
                }),
            )
            .passwordAuthenticationEnabledForWeb(
                passwordAuthenticationEnabledForWeb?.applyValue({ args0 ->
                    args0
                }),
            )
            .passwordLowercaseRequired(passwordLowercaseRequired?.applyValue({ args0 -> args0 }))
            .passwordNumberRequired(passwordNumberRequired?.applyValue({ args0 -> args0 }))
            .passwordSymbolRequired(passwordSymbolRequired?.applyValue({ args0 -> args0 }))
            .passwordUppercaseRequired(passwordUppercaseRequired?.applyValue({ args0 -> args0 }))
            .performanceBarAllowedGroupPath(performanceBarAllowedGroupPath?.applyValue({ args0 -> args0 }))
            .personalAccessTokenPrefix(personalAccessTokenPrefix?.applyValue({ args0 -> args0 }))
            .pipelineLimitPerProjectUserSha(pipelineLimitPerProjectUserSha?.applyValue({ args0 -> args0 }))
            .plantumlEnabled(plantumlEnabled?.applyValue({ args0 -> args0 }))
            .plantumlUrl(plantumlUrl?.applyValue({ args0 -> args0 }))
            .pollingIntervalMultiplier(pollingIntervalMultiplier?.applyValue({ args0 -> args0 }))
            .projectExportEnabled(projectExportEnabled?.applyValue({ args0 -> args0 }))
            .prometheusMetricsEnabled(prometheusMetricsEnabled?.applyValue({ args0 -> args0 }))
            .protectedCiVariables(protectedCiVariables?.applyValue({ args0 -> args0 }))
            .pushEventActivitiesLimit(pushEventActivitiesLimit?.applyValue({ args0 -> args0 }))
            .pushEventHooksLimit(pushEventHooksLimit?.applyValue({ args0 -> args0 }))
            .pypiPackageRequestsForwarding(pypiPackageRequestsForwarding?.applyValue({ args0 -> args0 }))
            .rateLimitingResponseText(rateLimitingResponseText?.applyValue({ args0 -> args0 }))
            .rawBlobRequestLimit(rawBlobRequestLimit?.applyValue({ args0 -> args0 }))
            .recaptchaEnabled(recaptchaEnabled?.applyValue({ args0 -> args0 }))
            .recaptchaPrivateKey(recaptchaPrivateKey?.applyValue({ args0 -> args0 }))
            .recaptchaSiteKey(recaptchaSiteKey?.applyValue({ args0 -> args0 }))
            .receiveMaxInputSize(receiveMaxInputSize?.applyValue({ args0 -> args0 }))
            .repositoryChecksEnabled(repositoryChecksEnabled?.applyValue({ args0 -> args0 }))
            .repositorySizeLimit(repositorySizeLimit?.applyValue({ args0 -> args0 }))
            .repositoryStorages(repositoryStorages?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .repositoryStoragesWeighted(
                repositoryStoragesWeighted?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .requireAdminApprovalAfterUserSignup(
                requireAdminApprovalAfterUserSignup?.applyValue({ args0 ->
                    args0
                }),
            )
            .requireTwoFactorAuthentication(requireTwoFactorAuthentication?.applyValue({ args0 -> args0 }))
            .restrictedVisibilityLevels(
                restrictedVisibilityLevels?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .rsaKeyRestriction(rsaKeyRestriction?.applyValue({ args0 -> args0 }))
            .searchRateLimit(searchRateLimit?.applyValue({ args0 -> args0 }))
            .searchRateLimitUnauthenticated(searchRateLimitUnauthenticated?.applyValue({ args0 -> args0 }))
            .sendUserConfirmationEmail(sendUserConfirmationEmail?.applyValue({ args0 -> args0 }))
            .sessionExpireDelay(sessionExpireDelay?.applyValue({ args0 -> args0 }))
            .sharedRunnersEnabled(sharedRunnersEnabled?.applyValue({ args0 -> args0 }))
            .sharedRunnersMinutes(sharedRunnersMinutes?.applyValue({ args0 -> args0 }))
            .sharedRunnersText(sharedRunnersText?.applyValue({ args0 -> args0 }))
            .sidekiqJobLimiterCompressionThresholdBytes(
                sidekiqJobLimiterCompressionThresholdBytes?.applyValue({ args0 ->
                    args0
                }),
            )
            .sidekiqJobLimiterLimitBytes(sidekiqJobLimiterLimitBytes?.applyValue({ args0 -> args0 }))
            .sidekiqJobLimiterMode(sidekiqJobLimiterMode?.applyValue({ args0 -> args0 }))
            .signInText(signInText?.applyValue({ args0 -> args0 }))
            .signupEnabled(signupEnabled?.applyValue({ args0 -> args0 }))
            .slackAppEnabled(slackAppEnabled?.applyValue({ args0 -> args0 }))
            .slackAppId(slackAppId?.applyValue({ args0 -> args0 }))
            .slackAppSecret(slackAppSecret?.applyValue({ args0 -> args0 }))
            .slackAppSigningSecret(slackAppSigningSecret?.applyValue({ args0 -> args0 }))
            .slackAppVerificationToken(slackAppVerificationToken?.applyValue({ args0 -> args0 }))
            .snippetSizeLimit(snippetSizeLimit?.applyValue({ args0 -> args0 }))
            .snowplowAppId(snowplowAppId?.applyValue({ args0 -> args0 }))
            .snowplowCollectorHostname(snowplowCollectorHostname?.applyValue({ args0 -> args0 }))
            .snowplowCookieDomain(snowplowCookieDomain?.applyValue({ args0 -> args0 }))
            .snowplowEnabled(snowplowEnabled?.applyValue({ args0 -> args0 }))
            .sourcegraphEnabled(sourcegraphEnabled?.applyValue({ args0 -> args0 }))
            .sourcegraphPublicOnly(sourcegraphPublicOnly?.applyValue({ args0 -> args0 }))
            .sourcegraphUrl(sourcegraphUrl?.applyValue({ args0 -> args0 }))
            .spamCheckApiKey(spamCheckApiKey?.applyValue({ args0 -> args0 }))
            .spamCheckEndpointEnabled(spamCheckEndpointEnabled?.applyValue({ args0 -> args0 }))
            .spamCheckEndpointUrl(spamCheckEndpointUrl?.applyValue({ args0 -> args0 }))
            .suggestPipelineEnabled(suggestPipelineEnabled?.applyValue({ args0 -> args0 }))
            .terminalMaxSessionTime(terminalMaxSessionTime?.applyValue({ args0 -> args0 }))
            .terms(terms?.applyValue({ args0 -> args0 }))
            .throttleAuthenticatedApiEnabled(throttleAuthenticatedApiEnabled?.applyValue({ args0 -> args0 }))
            .throttleAuthenticatedApiPeriodInSeconds(
                throttleAuthenticatedApiPeriodInSeconds?.applyValue({ args0 ->
                    args0
                }),
            )
            .throttleAuthenticatedApiRequestsPerPeriod(
                throttleAuthenticatedApiRequestsPerPeriod?.applyValue({ args0 ->
                    args0
                }),
            )
            .throttleAuthenticatedPackagesApiEnabled(
                throttleAuthenticatedPackagesApiEnabled?.applyValue({ args0 ->
                    args0
                }),
            )
            .throttleAuthenticatedPackagesApiPeriodInSeconds(
                throttleAuthenticatedPackagesApiPeriodInSeconds?.applyValue({ args0 ->
                    args0
                }),
            )
            .throttleAuthenticatedPackagesApiRequestsPerPeriod(
                throttleAuthenticatedPackagesApiRequestsPerPeriod?.applyValue({ args0 ->
                    args0
                }),
            )
            .throttleAuthenticatedWebEnabled(throttleAuthenticatedWebEnabled?.applyValue({ args0 -> args0 }))
            .throttleAuthenticatedWebPeriodInSeconds(
                throttleAuthenticatedWebPeriodInSeconds?.applyValue({ args0 ->
                    args0
                }),
            )
            .throttleAuthenticatedWebRequestsPerPeriod(
                throttleAuthenticatedWebRequestsPerPeriod?.applyValue({ args0 ->
                    args0
                }),
            )
            .throttleUnauthenticatedApiEnabled(
                throttleUnauthenticatedApiEnabled?.applyValue({ args0 ->
                    args0
                }),
            )
            .throttleUnauthenticatedApiPeriodInSeconds(
                throttleUnauthenticatedApiPeriodInSeconds?.applyValue({ args0 ->
                    args0
                }),
            )
            .throttleUnauthenticatedApiRequestsPerPeriod(
                throttleUnauthenticatedApiRequestsPerPeriod?.applyValue({ args0 ->
                    args0
                }),
            )
            .throttleUnauthenticatedPackagesApiEnabled(
                throttleUnauthenticatedPackagesApiEnabled?.applyValue({ args0 ->
                    args0
                }),
            )
            .throttleUnauthenticatedPackagesApiPeriodInSeconds(
                throttleUnauthenticatedPackagesApiPeriodInSeconds?.applyValue({ args0 ->
                    args0
                }),
            )
            .throttleUnauthenticatedPackagesApiRequestsPerPeriod(
                throttleUnauthenticatedPackagesApiRequestsPerPeriod?.applyValue({ args0 ->
                    args0
                }),
            )
            .throttleUnauthenticatedWebEnabled(
                throttleUnauthenticatedWebEnabled?.applyValue({ args0 ->
                    args0
                }),
            )
            .throttleUnauthenticatedWebPeriodInSeconds(
                throttleUnauthenticatedWebPeriodInSeconds?.applyValue({ args0 ->
                    args0
                }),
            )
            .throttleUnauthenticatedWebRequestsPerPeriod(
                throttleUnauthenticatedWebRequestsPerPeriod?.applyValue({ args0 ->
                    args0
                }),
            )
            .timeTrackingLimitToHours(timeTrackingLimitToHours?.applyValue({ args0 -> args0 }))
            .twoFactorGracePeriod(twoFactorGracePeriod?.applyValue({ args0 -> args0 }))
            .uniqueIpsLimitEnabled(uniqueIpsLimitEnabled?.applyValue({ args0 -> args0 }))
            .uniqueIpsLimitPerUser(uniqueIpsLimitPerUser?.applyValue({ args0 -> args0 }))
            .uniqueIpsLimitTimeWindow(uniqueIpsLimitTimeWindow?.applyValue({ args0 -> args0 }))
            .usagePingEnabled(usagePingEnabled?.applyValue({ args0 -> args0 }))
            .userDeactivationEmailsEnabled(userDeactivationEmailsEnabled?.applyValue({ args0 -> args0 }))
            .userDefaultExternal(userDefaultExternal?.applyValue({ args0 -> args0 }))
            .userDefaultInternalRegex(userDefaultInternalRegex?.applyValue({ args0 -> args0 }))
            .userOauthApplications(userOauthApplications?.applyValue({ args0 -> args0 }))
            .userShowAddSshKeyMessage(userShowAddSshKeyMessage?.applyValue({ args0 -> args0 }))
            .versionCheckEnabled(versionCheckEnabled?.applyValue({ args0 -> args0 }))
            .webIdeClientsidePreviewEnabled(webIdeClientsidePreviewEnabled?.applyValue({ args0 -> args0 }))
            .whatsNewVariant(whatsNewVariant?.applyValue({ args0 -> args0 }))
            .wikiPageMaxContentBytes(wikiPageMaxContentBytes?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationSettingsArgs].
 */
@PulumiTagMarker
public class ApplicationSettingsArgsBuilder internal constructor() {
    private var abuseNotificationEmail: Output<String>? = null

    private var adminMode: Output<Boolean>? = null

    private var afterSignOutPath: Output<String>? = null

    private var afterSignUpText: Output<String>? = null

    private var akismetApiKey: Output<String>? = null

    private var akismetEnabled: Output<Boolean>? = null

    private var allowAccountDeletion: Output<Boolean>? = null

    private var allowGroupOwnersToManageLdap: Output<Boolean>? = null

    private var allowLocalRequestsFromSystemHooks: Output<Boolean>? = null

    private var allowLocalRequestsFromWebHooksAndServices: Output<Boolean>? = null

    private var allowProjectCreationForGuestAndBelow: Output<Boolean>? = null

    private var allowRunnerRegistrationToken: Output<Boolean>? = null

    private var archiveBuildsInHumanReadable: Output<String>? = null

    private var asciidocMaxIncludes: Output<Int>? = null

    private var assetProxyAllowlists: Output<List<String>>? = null

    private var assetProxyEnabled: Output<Boolean>? = null

    private var assetProxySecretKey: Output<String>? = null

    private var assetProxyUrl: Output<String>? = null

    private var authorizedKeysEnabled: Output<Boolean>? = null

    private var autoBanUserOnExcessiveProjectsDownload: Output<Boolean>? = null

    private var autoDevopsDomain: Output<String>? = null

    private var autoDevopsEnabled: Output<Boolean>? = null

    private var automaticPurchasedStorageAllocation: Output<Boolean>? = null

    private var bulkImportConcurrentPipelineBatchLimit: Output<Int>? = null

    private var bulkImportEnabled: Output<Boolean>? = null

    private var bulkImportMaxDownloadFileSize: Output<Int>? = null

    private var canCreateGroup: Output<Boolean>? = null

    private var checkNamespacePlan: Output<Boolean>? = null

    private var ciMaxIncludes: Output<Int>? = null

    private var ciMaxTotalYamlSizeBytes: Output<Int>? = null

    private var commitEmailHostname: Output<String>? = null

    private var concurrentBitbucketImportJobsLimit: Output<Int>? = null

    private var concurrentBitbucketServerImportJobsLimit: Output<Int>? = null

    private var concurrentGithubImportJobsLimit: Output<Int>? = null

    private var containerExpirationPoliciesEnableHistoricEntries: Output<Boolean>? = null

    private var containerRegistryCleanupTagsServiceMaxListSize: Output<Int>? = null

    private var containerRegistryDeleteTagsServiceTimeout: Output<Int>? = null

    private var containerRegistryExpirationPoliciesCaching: Output<Boolean>? = null

    private var containerRegistryExpirationPoliciesWorkerCapacity: Output<Int>? = null

    private var containerRegistryTokenExpireDelay: Output<Int>? = null

    private var deactivateDormantUsers: Output<Boolean>? = null

    private var deactivateDormantUsersPeriod: Output<Int>? = null

    private var decompressArchiveFileTimeout: Output<Int>? = null

    private var defaultArtifactsExpireIn: Output<String>? = null

    private var defaultBranchName: Output<String>? = null

    private var defaultBranchProtection: Output<Int>? = null

    private var defaultBranchProtectionDefaults:
        Output<ApplicationSettingsDefaultBranchProtectionDefaultsArgs>? = null

    private var defaultCiConfigPath: Output<String>? = null

    private var defaultGroupVisibility: Output<String>? = null

    private var defaultPreferredLanguage: Output<String>? = null

    private var defaultProjectCreation: Output<Int>? = null

    private var defaultProjectVisibility: Output<String>? = null

    private var defaultProjectsLimit: Output<Int>? = null

    private var defaultSnippetVisibility: Output<String>? = null

    private var defaultSyntaxHighlightingTheme: Output<Int>? = null

    private var deleteInactiveProjects: Output<Boolean>? = null

    private var deleteUnconfirmedUsers: Output<Boolean>? = null

    private var deletionAdjournedPeriod: Output<Int>? = null

    private var diagramsnetEnabled: Output<Boolean>? = null

    private var diagramsnetUrl: Output<String>? = null

    private var diffMaxFiles: Output<Int>? = null

    private var diffMaxLines: Output<Int>? = null

    private var diffMaxPatchBytes: Output<Int>? = null

    private var disableAdminOauthScopes: Output<Boolean>? = null

    private var disableFeedToken: Output<Boolean>? = null

    private var disablePersonalAccessTokens: Output<Boolean>? = null

    private var disabledOauthSignInSources: Output<List<String>>? = null

    private var dnsRebindingProtectionEnabled: Output<Boolean>? = null

    private var domainAllowlists: Output<List<String>>? = null

    private var domainDenylistEnabled: Output<Boolean>? = null

    private var domainDenylists: Output<List<String>>? = null

    private var downstreamPipelineTriggerLimitPerProjectUserSha: Output<Int>? = null

    private var dsaKeyRestriction: Output<Int>? = null

    private var duoFeaturesEnabled: Output<Boolean>? = null

    private var ecdsaKeyRestriction: Output<Int>? = null

    private var ecdsaSkKeyRestriction: Output<Int>? = null

    private var ed25519KeyRestriction: Output<Int>? = null

    private var ed25519SkKeyRestriction: Output<Int>? = null

    private var eksAccessKeyId: Output<String>? = null

    private var eksAccountId: Output<String>? = null

    private var eksIntegrationEnabled: Output<Boolean>? = null

    private var eksSecretAccessKey: Output<String>? = null

    private var elasticsearchAws: Output<Boolean>? = null

    private var elasticsearchAwsAccessKey: Output<String>? = null

    private var elasticsearchAwsRegion: Output<String>? = null

    private var elasticsearchAwsSecretAccessKey: Output<String>? = null

    private var elasticsearchIndexedFieldLengthLimit: Output<Int>? = null

    private var elasticsearchIndexedFileSizeLimitKb: Output<Int>? = null

    private var elasticsearchIndexing: Output<Boolean>? = null

    private var elasticsearchLimitIndexing: Output<Boolean>? = null

    private var elasticsearchMaxBulkConcurrency: Output<Int>? = null

    private var elasticsearchMaxBulkSizeMb: Output<Int>? = null

    private var elasticsearchNamespaceIds: Output<List<Int>>? = null

    private var elasticsearchPassword: Output<String>? = null

    private var elasticsearchProjectIds: Output<List<Int>>? = null

    private var elasticsearchSearch: Output<Boolean>? = null

    private var elasticsearchUrls: Output<List<String>>? = null

    private var elasticsearchUsername: Output<String>? = null

    private var emailAdditionalText: Output<String>? = null

    private var emailAuthorInBody: Output<Boolean>? = null

    private var enabledGitAccessProtocol: Output<String>? = null

    private var enforceNamespaceStorageLimit: Output<Boolean>? = null

    private var enforceTerms: Output<Boolean>? = null

    private var externalAuthClientCert: Output<String>? = null

    private var externalAuthClientKey: Output<String>? = null

    private var externalAuthClientKeyPass: Output<String>? = null

    private var externalAuthorizationServiceDefaultLabel: Output<String>? = null

    private var externalAuthorizationServiceEnabled: Output<Boolean>? = null

    private var externalAuthorizationServiceTimeout: Output<Double>? = null

    private var externalAuthorizationServiceUrl: Output<String>? = null

    private var externalPipelineValidationServiceTimeout: Output<Int>? = null

    private var externalPipelineValidationServiceToken: Output<String>? = null

    private var externalPipelineValidationServiceUrl: Output<String>? = null

    private var fileTemplateProjectId: Output<Int>? = null

    private var firstDayOfWeek: Output<Int>? = null

    private var geoNodeAllowedIps: Output<String>? = null

    private var geoStatusTimeout: Output<Int>? = null

    private var gitRateLimitUsersAllowlists: Output<List<String>>? = null

    private var gitTwoFactorSessionExpiry: Output<Int>? = null

    private var gitalyTimeoutDefault: Output<Int>? = null

    private var gitalyTimeoutFast: Output<Int>? = null

    private var gitalyTimeoutMedium: Output<Int>? = null

    private var grafanaEnabled: Output<Boolean>? = null

    private var grafanaUrl: Output<String>? = null

    private var gravatarEnabled: Output<Boolean>? = null

    private var groupOwnersCanManageDefaultBranchProtection: Output<Boolean>? = null

    private var hashedStorageEnabled: Output<Boolean>? = null

    private var helpPageHideCommercialContent: Output<Boolean>? = null

    private var helpPageSupportUrl: Output<String>? = null

    private var helpPageText: Output<String>? = null

    private var helpText: Output<String>? = null

    private var hideThirdPartyOffers: Output<Boolean>? = null

    private var homePageUrl: Output<String>? = null

    private var housekeepingEnabled: Output<Boolean>? = null

    private var housekeepingFullRepackPeriod: Output<Int>? = null

    private var housekeepingGcPeriod: Output<Int>? = null

    private var housekeepingIncrementalRepackPeriod: Output<Int>? = null

    private var housekeepingOptimizeRepositoryPeriod: Output<Int>? = null

    private var htmlEmailsEnabled: Output<Boolean>? = null

    private var importSources: Output<List<String>>? = null

    private var inProductMarketingEmailsEnabled: Output<Boolean>? = null

    private var inactiveProjectsDeleteAfterMonths: Output<Int>? = null

    private var inactiveProjectsMinSizeMb: Output<Int>? = null

    private var inactiveProjectsSendWarningEmailAfterMonths: Output<Int>? = null

    private var invisibleCaptchaEnabled: Output<Boolean>? = null

    private var issuesCreateLimit: Output<Int>? = null

    private var keepLatestArtifact: Output<Boolean>? = null

    private var localMarkdownVersion: Output<Int>? = null

    private var mailgunEventsEnabled: Output<Boolean>? = null

    private var mailgunSigningKey: Output<String>? = null

    private var maintenanceMode: Output<Boolean>? = null

    private var maintenanceModeMessage: Output<String>? = null

    private var maxArtifactsSize: Output<Int>? = null

    private var maxAttachmentSize: Output<Int>? = null

    private var maxExportSize: Output<Int>? = null

    private var maxImportSize: Output<Int>? = null

    private var maxNumberOfRepositoryDownloads: Output<Int>? = null

    private var maxNumberOfRepositoryDownloadsWithinTimePeriod: Output<Int>? = null

    private var maxPagesSize: Output<Int>? = null

    private var maxPersonalAccessTokenLifetime: Output<Int>? = null

    private var maxSshKeyLifetime: Output<Int>? = null

    private var maxTerraformStateSizeBytes: Output<Int>? = null

    private var metricsMethodCallThreshold: Output<Int>? = null

    private var minimumPasswordLength: Output<Int>? = null

    private var mirrorAvailable: Output<Boolean>? = null

    private var mirrorCapacityThreshold: Output<Int>? = null

    private var mirrorMaxCapacity: Output<Int>? = null

    private var mirrorMaxDelay: Output<Int>? = null

    private var npmPackageRequestsForwarding: Output<Boolean>? = null

    private var outboundLocalRequestsWhitelists: Output<List<String>>? = null

    private var packageRegistryCleanupPoliciesWorkerCapacity: Output<Int>? = null

    private var pagesDomainVerificationEnabled: Output<Boolean>? = null

    private var passwordAuthenticationEnabledForGit: Output<Boolean>? = null

    private var passwordAuthenticationEnabledForWeb: Output<Boolean>? = null

    private var passwordLowercaseRequired: Output<Boolean>? = null

    private var passwordNumberRequired: Output<Boolean>? = null

    private var passwordSymbolRequired: Output<Boolean>? = null

    private var passwordUppercaseRequired: Output<Boolean>? = null

    private var performanceBarAllowedGroupPath: Output<String>? = null

    private var personalAccessTokenPrefix: Output<String>? = null

    private var pipelineLimitPerProjectUserSha: Output<Int>? = null

    private var plantumlEnabled: Output<Boolean>? = null

    private var plantumlUrl: Output<String>? = null

    private var pollingIntervalMultiplier: Output<Double>? = null

    private var projectExportEnabled: Output<Boolean>? = null

    private var prometheusMetricsEnabled: Output<Boolean>? = null

    private var protectedCiVariables: Output<Boolean>? = null

    private var pushEventActivitiesLimit: Output<Int>? = null

    private var pushEventHooksLimit: Output<Int>? = null

    private var pypiPackageRequestsForwarding: Output<Boolean>? = null

    private var rateLimitingResponseText: Output<String>? = null

    private var rawBlobRequestLimit: Output<Int>? = null

    private var recaptchaEnabled: Output<Boolean>? = null

    private var recaptchaPrivateKey: Output<String>? = null

    private var recaptchaSiteKey: Output<String>? = null

    private var receiveMaxInputSize: Output<Int>? = null

    private var repositoryChecksEnabled: Output<Boolean>? = null

    private var repositorySizeLimit: Output<Int>? = null

    private var repositoryStorages: Output<List<String>>? = null

    private var repositoryStoragesWeighted: Output<Map<String, Int>>? = null

    private var requireAdminApprovalAfterUserSignup: Output<Boolean>? = null

    private var requireTwoFactorAuthentication: Output<Boolean>? = null

    private var restrictedVisibilityLevels: Output<List<String>>? = null

    private var rsaKeyRestriction: Output<Int>? = null

    private var searchRateLimit: Output<Int>? = null

    private var searchRateLimitUnauthenticated: Output<Int>? = null

    private var sendUserConfirmationEmail: Output<Boolean>? = null

    private var sessionExpireDelay: Output<Int>? = null

    private var sharedRunnersEnabled: Output<Boolean>? = null

    private var sharedRunnersMinutes: Output<Int>? = null

    private var sharedRunnersText: Output<String>? = null

    private var sidekiqJobLimiterCompressionThresholdBytes: Output<Int>? = null

    private var sidekiqJobLimiterLimitBytes: Output<Int>? = null

    private var sidekiqJobLimiterMode: Output<String>? = null

    private var signInText: Output<String>? = null

    private var signupEnabled: Output<Boolean>? = null

    private var slackAppEnabled: Output<Boolean>? = null

    private var slackAppId: Output<String>? = null

    private var slackAppSecret: Output<String>? = null

    private var slackAppSigningSecret: Output<String>? = null

    private var slackAppVerificationToken: Output<String>? = null

    private var snippetSizeLimit: Output<Int>? = null

    private var snowplowAppId: Output<String>? = null

    private var snowplowCollectorHostname: Output<String>? = null

    private var snowplowCookieDomain: Output<String>? = null

    private var snowplowEnabled: Output<Boolean>? = null

    private var sourcegraphEnabled: Output<Boolean>? = null

    private var sourcegraphPublicOnly: Output<Boolean>? = null

    private var sourcegraphUrl: Output<String>? = null

    private var spamCheckApiKey: Output<String>? = null

    private var spamCheckEndpointEnabled: Output<Boolean>? = null

    private var spamCheckEndpointUrl: Output<String>? = null

    private var suggestPipelineEnabled: Output<Boolean>? = null

    private var terminalMaxSessionTime: Output<Int>? = null

    private var terms: Output<String>? = null

    private var throttleAuthenticatedApiEnabled: Output<Boolean>? = null

    private var throttleAuthenticatedApiPeriodInSeconds: Output<Int>? = null

    private var throttleAuthenticatedApiRequestsPerPeriod: Output<Int>? = null

    private var throttleAuthenticatedPackagesApiEnabled: Output<Boolean>? = null

    private var throttleAuthenticatedPackagesApiPeriodInSeconds: Output<Int>? = null

    private var throttleAuthenticatedPackagesApiRequestsPerPeriod: Output<Int>? = null

    private var throttleAuthenticatedWebEnabled: Output<Boolean>? = null

    private var throttleAuthenticatedWebPeriodInSeconds: Output<Int>? = null

    private var throttleAuthenticatedWebRequestsPerPeriod: Output<Int>? = null

    private var throttleUnauthenticatedApiEnabled: Output<Boolean>? = null

    private var throttleUnauthenticatedApiPeriodInSeconds: Output<Int>? = null

    private var throttleUnauthenticatedApiRequestsPerPeriod: Output<Int>? = null

    private var throttleUnauthenticatedPackagesApiEnabled: Output<Boolean>? = null

    private var throttleUnauthenticatedPackagesApiPeriodInSeconds: Output<Int>? = null

    private var throttleUnauthenticatedPackagesApiRequestsPerPeriod: Output<Int>? = null

    private var throttleUnauthenticatedWebEnabled: Output<Boolean>? = null

    private var throttleUnauthenticatedWebPeriodInSeconds: Output<Int>? = null

    private var throttleUnauthenticatedWebRequestsPerPeriod: Output<Int>? = null

    private var timeTrackingLimitToHours: Output<Boolean>? = null

    private var twoFactorGracePeriod: Output<Int>? = null

    private var uniqueIpsLimitEnabled: Output<Boolean>? = null

    private var uniqueIpsLimitPerUser: Output<Int>? = null

    private var uniqueIpsLimitTimeWindow: Output<Int>? = null

    private var usagePingEnabled: Output<Boolean>? = null

    private var userDeactivationEmailsEnabled: Output<Boolean>? = null

    private var userDefaultExternal: Output<Boolean>? = null

    private var userDefaultInternalRegex: Output<String>? = null

    private var userOauthApplications: Output<Boolean>? = null

    private var userShowAddSshKeyMessage: Output<Boolean>? = null

    private var versionCheckEnabled: Output<Boolean>? = null

    private var webIdeClientsidePreviewEnabled: Output<Boolean>? = null

    private var whatsNewVariant: Output<String>? = null

    private var wikiPageMaxContentBytes: Output<Int>? = null

    /**
     * @param value If set, abuse reports are sent to this address. Abuse reports are always available in the Admin Area.
     */
    @JvmName("wkbhnierfsrnnmpv")
    public suspend fun abuseNotificationEmail(`value`: Output<String>) {
        this.abuseNotificationEmail = value
    }

    /**
     * @param value Require administrators to enable Admin Mode by re-authenticating for administrative tasks.
     */
    @JvmName("kdvxinabygjypbfn")
    public suspend fun adminMode(`value`: Output<Boolean>) {
        this.adminMode = value
    }

    /**
     * @param value Where to redirect users after logout.
     */
    @JvmName("luxkanuwkdktvxuj")
    public suspend fun afterSignOutPath(`value`: Output<String>) {
        this.afterSignOutPath = value
    }

    /**
     * @param value Text shown to the user after signing up.
     */
    @JvmName("wdorrinepbwtfqjn")
    public suspend fun afterSignUpText(`value`: Output<String>) {
        this.afterSignUpText = value
    }

    /**
     * @param value API key for Akismet spam protection.
     */
    @JvmName("hndctvsshssxjiku")
    public suspend fun akismetApiKey(`value`: Output<String>) {
        this.akismetApiKey = value
    }

    /**
     * @param value (If enabled, requires: akismet*api*key) Enable or disable Akismet spam protection.
     */
    @JvmName("sgirthmlfpbnbpri")
    public suspend fun akismetEnabled(`value`: Output<Boolean>) {
        this.akismetEnabled = value
    }

    /**
     * @param value Set to true to allow users to delete their accounts. Premium and Ultimate only.
     */
    @JvmName("xqywkrdegrargyvo")
    public suspend fun allowAccountDeletion(`value`: Output<Boolean>) {
        this.allowAccountDeletion = value
    }

    /**
     * @param value Set to true to allow group owners to manage LDAP.
     */
    @JvmName("nfbptbkbmxukuxbs")
    public suspend fun allowGroupOwnersToManageLdap(`value`: Output<Boolean>) {
        this.allowGroupOwnersToManageLdap = value
    }

    /**
     * @param value Allow requests to the local network from system hooks.
     */
    @JvmName("aiwrxojuqyepmjkw")
    public suspend fun allowLocalRequestsFromSystemHooks(`value`: Output<Boolean>) {
        this.allowLocalRequestsFromSystemHooks = value
    }

    /**
     * @param value Allow requests to the local network from web hooks and services.
     */
    @JvmName("ujliqqgoovwtpelf")
    public suspend fun allowLocalRequestsFromWebHooksAndServices(`value`: Output<Boolean>) {
        this.allowLocalRequestsFromWebHooksAndServices = value
    }

    /**
     * @param value Indicates whether users assigned up to the Guest role can create groups and personal projects.
     */
    @JvmName("vgqgnnpysdedivtd")
    public suspend fun allowProjectCreationForGuestAndBelow(`value`: Output<Boolean>) {
        this.allowProjectCreationForGuestAndBelow = value
    }

    /**
     * @param value Allow using a registration token to create a runner.
     */
    @JvmName("wfgyfqkbxsvqcmbx")
    public suspend fun allowRunnerRegistrationToken(`value`: Output<Boolean>) {
        this.allowRunnerRegistrationToken = value
    }

    /**
     * @param value Set the duration for which the jobs are considered as old and expired. After that time passes, the jobs are archived and no longer able to be retried. Make it empty to never expire jobs. It has to be no less than 1 day, for example: 15 days, 1 month, 2 years.
     */
    @JvmName("cqjixnrqmguehrgd")
    public suspend fun archiveBuildsInHumanReadable(`value`: Output<String>) {
        this.archiveBuildsInHumanReadable = value
    }

    /**
     * @param value Maximum limit of AsciiDoc include directives being processed in any one document. Maximum: 64.
     */
    @JvmName("ysfryrieiemovfte")
    public suspend fun asciidocMaxIncludes(`value`: Output<Int>) {
        this.asciidocMaxIncludes = value
    }

    /**
     * @param value Assets that match these domains are not proxied. Wildcards allowed. Your GitLab installation URL is automatically allowlisted. GitLab restart is required to apply changes.
     */
    @JvmName("vmtenkqfupeabpwl")
    public suspend fun assetProxyAllowlists(`value`: Output<List<String>>) {
        this.assetProxyAllowlists = value
    }

    @JvmName("sngqskuhsxjignrn")
    public suspend fun assetProxyAllowlists(vararg values: Output<String>) {
        this.assetProxyAllowlists = Output.all(values.asList())
    }

    /**
     * @param values Assets that match these domains are not proxied. Wildcards allowed. Your GitLab installation URL is automatically allowlisted. GitLab restart is required to apply changes.
     */
    @JvmName("epmnpkmdsukdcheu")
    public suspend fun assetProxyAllowlists(values: List<Output<String>>) {
        this.assetProxyAllowlists = Output.all(values)
    }

    /**
     * @param value (If enabled, requires: asset*proxy*url) Enable proxying of assets. GitLab restart is required to apply changes.
     */
    @JvmName("vuefduvjewokqbde")
    public suspend fun assetProxyEnabled(`value`: Output<Boolean>) {
        this.assetProxyEnabled = value
    }

    /**
     * @param value Shared secret with the asset proxy server. GitLab restart is required to apply changes.
     */
    @JvmName("eyedgqyebppkhwen")
    public suspend fun assetProxySecretKey(`value`: Output<String>) {
        this.assetProxySecretKey = value
    }

    /**
     * @param value URL of the asset proxy server. GitLab restart is required to apply changes.
     */
    @JvmName("lqwxdcxsrsjfyayv")
    public suspend fun assetProxyUrl(`value`: Output<String>) {
        this.assetProxyUrl = value
    }

    /**
     * @param value By default, we write to the authorized_keys file to support Git over SSH without additional configuration. GitLab can be optimized to authenticate SSH keys via the database file. Only disable this if you have configured your OpenSSH server to use the AuthorizedKeysCommand.
     */
    @JvmName("tlibhxgwekxufpjh")
    public suspend fun authorizedKeysEnabled(`value`: Output<Boolean>) {
        this.authorizedKeysEnabled = value
    }

    /**
     * @param value When enabled, users will get automatically banned from the application when they download more than the maximum number of unique projects in the time period specified by max*number*of*repository*downloads and max*number*of*repository*downloads*within*time_period respectively. Introduced in GitLab 15.4. Self-managed, Ultimate only.
     */
    @JvmName("sxoeoffplifpysqx")
    public suspend fun autoBanUserOnExcessiveProjectsDownload(`value`: Output<Boolean>) {
        this.autoBanUserOnExcessiveProjectsDownload = value
    }

    /**
     * @param value Specify a domain to use by default for every project’s Auto Review Apps and Auto Deploy stages.
     */
    @JvmName("pjjsxaykkigbjhwd")
    public suspend fun autoDevopsDomain(`value`: Output<String>) {
        this.autoDevopsDomain = value
    }

    /**
     * @param value Enable Auto DevOps for projects by default. It automatically builds, tests, and deploys applications based on a predefined CI/CD configuration.
     */
    @JvmName("tnemrwhmfawtukwr")
    public suspend fun autoDevopsEnabled(`value`: Output<Boolean>) {
        this.autoDevopsEnabled = value
    }

    /**
     * @param value Enabling this permits automatic allocation of purchased storage in a namespace.
     */
    @JvmName("jmwcsbhodufxsiwc")
    public suspend fun automaticPurchasedStorageAllocation(`value`: Output<Boolean>) {
        this.automaticPurchasedStorageAllocation = value
    }

    /**
     * @param value Maximum simultaneous Direct Transfer batches to process.
     */
    @JvmName("japreikbnkqjqobr")
    public suspend fun bulkImportConcurrentPipelineBatchLimit(`value`: Output<Int>) {
        this.bulkImportConcurrentPipelineBatchLimit = value
    }

    /**
     * @param value Enable migrating GitLab groups by direct transfer. Introduced in GitLab 15.8.
     */
    @JvmName("gltchkpwyqojsjns")
    public suspend fun bulkImportEnabled(`value`: Output<Boolean>) {
        this.bulkImportEnabled = value
    }

    /**
     * @param value Maximum download file size when importing from source GitLab instances by direct transfer. Introduced in GitLab 16.3.
     */
    @JvmName("rxpmwnpfahirhiwg")
    public suspend fun bulkImportMaxDownloadFileSize(`value`: Output<Int>) {
        this.bulkImportMaxDownloadFileSize = value
    }

    /**
     * @param value Indicates whether users can create top-level groups. Introduced in GitLab 15.5.
     */
    @JvmName("cojbmaeboargmvky")
    public suspend fun canCreateGroup(`value`: Output<Boolean>) {
        this.canCreateGroup = value
    }

    /**
     * @param value Enabling this makes only licensed EE features available to projects if the project namespace’s plan includes the feature or if the project is public.
     */
    @JvmName("tchqlmrghmqfcabw")
    public suspend fun checkNamespacePlan(`value`: Output<Boolean>) {
        this.checkNamespacePlan = value
    }

    /**
     * @param value The maximum number of includes per pipeline.
     */
    @JvmName("ruqwjhtwfsieheyv")
    public suspend fun ciMaxIncludes(`value`: Output<Int>) {
        this.ciMaxIncludes = value
    }

    /**
     * @param value The maximum amount of memory, in bytes, that can be allocated for the pipeline configuration, with all included YAML configuration files.
     */
    @JvmName("esfnuykqkcwaemxa")
    public suspend fun ciMaxTotalYamlSizeBytes(`value`: Output<Int>) {
        this.ciMaxTotalYamlSizeBytes = value
    }

    /**
     * @param value Custom hostname (for private commit emails).
     */
    @JvmName("ikfifpkykytkdroi")
    public suspend fun commitEmailHostname(`value`: Output<String>) {
        this.commitEmailHostname = value
    }

    /**
     * @param value Maximum number of simultaneous import jobs for the Bitbucket Cloud importer. Introduced in GitLab 16.11.
     */
    @JvmName("sxphfrbbigdansyx")
    public suspend fun concurrentBitbucketImportJobsLimit(`value`: Output<Int>) {
        this.concurrentBitbucketImportJobsLimit = value
    }

    /**
     * @param value Maximum number of simultaneous import jobs for the Bitbucket Server importer. Introduced in GitLab 16.11.
     */
    @JvmName("pgaksquatsqsqase")
    public suspend fun concurrentBitbucketServerImportJobsLimit(`value`: Output<Int>) {
        this.concurrentBitbucketServerImportJobsLimit = value
    }

    /**
     * @param value Maximum number of simultaneous import jobs for the GitHub importer. Introduced in GitLab 16.11.
     */
    @JvmName("jhlmyelqrssveqqx")
    public suspend fun concurrentGithubImportJobsLimit(`value`: Output<Int>) {
        this.concurrentGithubImportJobsLimit = value
    }

    /**
     * @param value Enable cleanup policies for all projects.
     */
    @JvmName("sgegdmxxixnkyolg")
    public suspend fun containerExpirationPoliciesEnableHistoricEntries(`value`: Output<Boolean>) {
        this.containerExpirationPoliciesEnableHistoricEntries = value
    }

    /**
     * @param value The maximum number of tags that can be deleted in a single execution of cleanup policies.
     */
    @JvmName("buofpugrermymxrn")
    public suspend fun containerRegistryCleanupTagsServiceMaxListSize(`value`: Output<Int>) {
        this.containerRegistryCleanupTagsServiceMaxListSize = value
    }

    /**
     * @param value The maximum time, in seconds, that the cleanup process can take to delete a batch of tags for cleanup policies.
     */
    @JvmName("bqwdqlixpodskrtb")
    public suspend fun containerRegistryDeleteTagsServiceTimeout(`value`: Output<Int>) {
        this.containerRegistryDeleteTagsServiceTimeout = value
    }

    /**
     * @param value Caching during the execution of cleanup policies.
     */
    @JvmName("nankglicvcejbskg")
    public suspend fun containerRegistryExpirationPoliciesCaching(`value`: Output<Boolean>) {
        this.containerRegistryExpirationPoliciesCaching = value
    }

    /**
     * @param value Number of workers for cleanup policies.
     */
    @JvmName("qiowbjfeohdataqt")
    public suspend fun containerRegistryExpirationPoliciesWorkerCapacity(`value`: Output<Int>) {
        this.containerRegistryExpirationPoliciesWorkerCapacity = value
    }

    /**
     * @param value Container Registry token duration in minutes.
     */
    @JvmName("pakaejeibvekdstb")
    public suspend fun containerRegistryTokenExpireDelay(`value`: Output<Int>) {
        this.containerRegistryTokenExpireDelay = value
    }

    /**
     * @param value Enable automatic deactivation of dormant users.
     */
    @JvmName("mrasuoimoqhluger")
    public suspend fun deactivateDormantUsers(`value`: Output<Boolean>) {
        this.deactivateDormantUsers = value
    }

    /**
     * @param value Length of time (in days) after which a user is considered dormant. Introduced in GitLab 15.3.
     */
    @JvmName("qcrekprhatxcsckh")
    public suspend fun deactivateDormantUsersPeriod(`value`: Output<Int>) {
        this.deactivateDormantUsersPeriod = value
    }

    /**
     * @param value Default timeout for decompressing archived files, in seconds. Set to 0 to disable timeouts. Introduced in GitLab 16.4.
     */
    @JvmName("ooxkyrafqfbvjplc")
    public suspend fun decompressArchiveFileTimeout(`value`: Output<Int>) {
        this.decompressArchiveFileTimeout = value
    }

    /**
     * @param value Set the default expiration time for each job’s artifacts.
     */
    @JvmName("wyaspyavogqqblcd")
    public suspend fun defaultArtifactsExpireIn(`value`: Output<String>) {
        this.defaultArtifactsExpireIn = value
    }

    /**
     * @param value Instance-level custom initial branch name (introduced in GitLab 13.2).
     */
    @JvmName("nrsglaihpsgukvkp")
    public suspend fun defaultBranchName(`value`: Output<String>) {
        this.defaultBranchName = value
    }

    /**
     * @param value Determine if developers can push to the default branch. Can take: 0 (not protected, both users with the Developer role or Maintainer role can push new commits and force push), 1 (partially protected, users with the Developer role or Maintainer role can push new commits, but cannot force push) or 2 (fully protected, users with the Developer or Maintainer role cannot push new commits, but users with the Developer or Maintainer role can; no one can force push) as a parameter. Default is 2.
     */
    @JvmName("rdnoqpkhhobnlkpo")
    public suspend fun defaultBranchProtection(`value`: Output<Int>) {
        this.defaultBranchProtection = value
    }

    /**
     * @param value The default*branch*protection*defaults attribute describes the default branch protection defaults. All parameters are optional.
     */
    @JvmName("vcmoofritiuheibb")
    public suspend fun defaultBranchProtectionDefaults(`value`: Output<ApplicationSettingsDefaultBranchProtectionDefaultsArgs>) {
        this.defaultBranchProtectionDefaults = value
    }

    /**
     * @param value Default CI/CD configuration file and path for new projects (.gitlab-ci.yml if not set).
     */
    @JvmName("soxggphtxoqskrxi")
    public suspend fun defaultCiConfigPath(`value`: Output<String>) {
        this.defaultCiConfigPath = value
    }

    /**
     * @param value What visibility level new groups receive. Can take private, internal and public as a parameter.
     */
    @JvmName("ppqkqaolwymemyvv")
    public suspend fun defaultGroupVisibility(`value`: Output<String>) {
        this.defaultGroupVisibility = value
    }

    /**
     * @param value Default preferred language for users who are not logged in.
     */
    @JvmName("sfafnipipgprgjih")
    public suspend fun defaultPreferredLanguage(`value`: Output<String>) {
        this.defaultPreferredLanguage = value
    }

    /**
     * @param value Default project creation protection. Can take: 0 (No one), 1 (Maintainers) or 2 (Developers + Maintainers).
     */
    @JvmName("kyovdufwfihctemk")
    public suspend fun defaultProjectCreation(`value`: Output<Int>) {
        this.defaultProjectCreation = value
    }

    /**
     * @param value What visibility level new projects receive. Can take private, internal and public as a parameter.
     */
    @JvmName("evelpqbsygurvoix")
    public suspend fun defaultProjectVisibility(`value`: Output<String>) {
        this.defaultProjectVisibility = value
    }

    /**
     * @param value Project limit per user.
     */
    @JvmName("gbgshljbhthwrmkq")
    public suspend fun defaultProjectsLimit(`value`: Output<Int>) {
        this.defaultProjectsLimit = value
    }

    /**
     * @param value What visibility level new snippets receive. Can take private, internal and public as a parameter.
     */
    @JvmName("rnxtcyeuthlfvpic")
    public suspend fun defaultSnippetVisibility(`value`: Output<String>) {
        this.defaultSnippetVisibility = value
    }

    /**
     * @param value Default syntax highlighting theme for users who are new or not signed in. See IDs of available themes (https://gitlab.com/gitlab-org/gitlab/blob/master/lib/gitlab/themes.rb#L16)
     */
    @JvmName("mlonbpewtfclngxl")
    public suspend fun defaultSyntaxHighlightingTheme(`value`: Output<Int>) {
        this.defaultSyntaxHighlightingTheme = value
    }

    /**
     * @param value Enable inactive project deletion feature. Introduced in GitLab 14.10. Became operational in GitLab 15.0 (with feature flag inactive*projects*deletion).
     */
    @JvmName("cukqtdhglhdcdvti")
    public suspend fun deleteInactiveProjects(`value`: Output<Boolean>) {
        this.deleteInactiveProjects = value
    }

    /**
     * @param value Specifies whether users who have not confirmed their email should be deleted. When set to true, unconfirmed users are deleted after unconfirmed*users*delete*after*days days. Introduced in GitLab 16.1. Self-managed, Premium and Ultimate only.
     */
    @JvmName("hlwbxpblfrohhhsl")
    public suspend fun deleteUnconfirmedUsers(`value`: Output<Boolean>) {
        this.deleteUnconfirmedUsers = value
    }

    /**
     * @param value The number of days to wait before deleting a project or group that is marked for deletion. Value must be between 1 and 90.
     */
    @JvmName("xjsvudmwplsgeenq")
    public suspend fun deletionAdjournedPeriod(`value`: Output<Int>) {
        this.deletionAdjournedPeriod = value
    }

    /**
     * @param value (If enabled, requires diagramsnet_url) Enable Diagrams.net integration.
     */
    @JvmName("vcyxffsbnvwyckqf")
    public suspend fun diagramsnetEnabled(`value`: Output<Boolean>) {
        this.diagramsnetEnabled = value
    }

    /**
     * @param value The Diagrams.net instance URL for integration.
     */
    @JvmName("hndcpetuhdhgniyr")
    public suspend fun diagramsnetUrl(`value`: Output<String>) {
        this.diagramsnetUrl = value
    }

    /**
     * @param value Maximum files in a diff.
     */
    @JvmName("argojeicccvdrabd")
    public suspend fun diffMaxFiles(`value`: Output<Int>) {
        this.diffMaxFiles = value
    }

    /**
     * @param value Maximum lines in a diff.
     */
    @JvmName("jmoopmqvfhygdvmb")
    public suspend fun diffMaxLines(`value`: Output<Int>) {
        this.diffMaxLines = value
    }

    /**
     * @param value Maximum diff patch size, in bytes.
     */
    @JvmName("nsfhmdfyaspprbjs")
    public suspend fun diffMaxPatchBytes(`value`: Output<Int>) {
        this.diffMaxPatchBytes = value
    }

    /**
     * @param value Stops administrators from connecting their GitLab accounts to non-trusted OAuth 2.0 applications that have the api, read*api, read*repository, write*repository, read*registry, write_registry, or sudo scopes. Introduced in GitLab 15.6.
     */
    @JvmName("ptdxcsvsjegsftta")
    public suspend fun disableAdminOauthScopes(`value`: Output<Boolean>) {
        this.disableAdminOauthScopes = value
    }

    /**
     * @param value Disable display of RSS/Atom and calendar feed tokens (introduced in GitLab 13.7).
     */
    @JvmName("lhnhwiesnhienetp")
    public suspend fun disableFeedToken(`value`: Output<Boolean>) {
        this.disableFeedToken = value
    }

    /**
     * @param value Disable personal access tokens. Introduced in GitLab 15.7. Self-managed, Premium and Ultimate only. There is no method available to enable a personal access token that’s been disabled through the API. This is a known issue.
     */
    @JvmName("bddrskpqmpmvmcfl")
    public suspend fun disablePersonalAccessTokens(`value`: Output<Boolean>) {
        this.disablePersonalAccessTokens = value
    }

    /**
     * @param value Disabled OAuth sign-in sources.
     */
    @JvmName("crtqheypjqbxnxms")
    public suspend fun disabledOauthSignInSources(`value`: Output<List<String>>) {
        this.disabledOauthSignInSources = value
    }

    @JvmName("lusghercjnyjvbys")
    public suspend fun disabledOauthSignInSources(vararg values: Output<String>) {
        this.disabledOauthSignInSources = Output.all(values.asList())
    }

    /**
     * @param values Disabled OAuth sign-in sources.
     */
    @JvmName("tsdlqjpknsnnlrpk")
    public suspend fun disabledOauthSignInSources(values: List<Output<String>>) {
        this.disabledOauthSignInSources = Output.all(values)
    }

    /**
     * @param value Enforce DNS rebinding attack protection.
     */
    @JvmName("mllobmangqdeftrj")
    public suspend fun dnsRebindingProtectionEnabled(`value`: Output<Boolean>) {
        this.dnsRebindingProtectionEnabled = value
    }

    /**
     * @param value Force people to use only corporate emails for sign-up. Null means there is no restriction.
     */
    @JvmName("vssfvaxftnapsnda")
    public suspend fun domainAllowlists(`value`: Output<List<String>>) {
        this.domainAllowlists = value
    }

    @JvmName("onwitjbhmerdyekl")
    public suspend fun domainAllowlists(vararg values: Output<String>) {
        this.domainAllowlists = Output.all(values.asList())
    }

    /**
     * @param values Force people to use only corporate emails for sign-up. Null means there is no restriction.
     */
    @JvmName("rfsjnnnorptpmufu")
    public suspend fun domainAllowlists(values: List<Output<String>>) {
        this.domainAllowlists = Output.all(values)
    }

    /**
     * @param value (If enabled, requires: domain_denylist) Allows blocking sign-ups from emails from specific domains.
     */
    @JvmName("otregiivabiypcar")
    public suspend fun domainDenylistEnabled(`value`: Output<Boolean>) {
        this.domainDenylistEnabled = value
    }

    /**
     * @param value Users with email addresses that match these domains cannot sign up. Wildcards allowed. Use separate lines for multiple entries. Ex: domain.com, *.domain.com.
     */
    @JvmName("bmbrfbftqcorjjsj")
    public suspend fun domainDenylists(`value`: Output<List<String>>) {
        this.domainDenylists = value
    }

    @JvmName("tekridskiqjcgajm")
    public suspend fun domainDenylists(vararg values: Output<String>) {
        this.domainDenylists = Output.all(values.asList())
    }

    /**
     * @param values Users with email addresses that match these domains cannot sign up. Wildcards allowed. Use separate lines for multiple entries. Ex: domain.com, *.domain.com.
     */
    @JvmName("oecsufjfqybchkdy")
    public suspend fun domainDenylists(values: List<Output<String>>) {
        this.domainDenylists = Output.all(values)
    }

    /**
     * @param value Maximum downstream pipeline trigger rate. Introduced in GitLab 16.10.
     */
    @JvmName("jedxwdoufnbsocgg")
    public suspend fun downstreamPipelineTriggerLimitPerProjectUserSha(`value`: Output<Int>) {
        this.downstreamPipelineTriggerLimitPerProjectUserSha = value
    }

    /**
     * @param value The minimum allowed bit length of an uploaded DSA key. 0 means no restriction. -1 disables DSA keys.
     */
    @JvmName("vnlqcpykgntyfahl")
    public suspend fun dsaKeyRestriction(`value`: Output<Int>) {
        this.dsaKeyRestriction = value
    }

    /**
     * @param value Indicates whether GitLab Duo features are enabled for this instance. Introduced in GitLab 16.10. Self-managed, Premium and Ultimate only.
     */
    @JvmName("nbnryilmwyfhvrph")
    public suspend fun duoFeaturesEnabled(`value`: Output<Boolean>) {
        this.duoFeaturesEnabled = value
    }

    /**
     * @param value The minimum allowed curve size (in bits) of an uploaded ECDSA key. 0 means no restriction. -1 disables ECDSA keys.
     */
    @JvmName("vgynywndtjnpbfxw")
    public suspend fun ecdsaKeyRestriction(`value`: Output<Int>) {
        this.ecdsaKeyRestriction = value
    }

    /**
     * @param value The minimum allowed curve size (in bits) of an uploaded ECDSA*SK key. 0 means no restriction. -1 disables ECDSA*SK keys.
     */
    @JvmName("oaxwthyegsnbulfx")
    public suspend fun ecdsaSkKeyRestriction(`value`: Output<Int>) {
        this.ecdsaSkKeyRestriction = value
    }

    /**
     * @param value The minimum allowed curve size (in bits) of an uploaded ED25519 key. 0 means no restriction. -1 disables ED25519 keys.
     */
    @JvmName("mwxgjnnysyuepfpj")
    public suspend fun ed25519KeyRestriction(`value`: Output<Int>) {
        this.ed25519KeyRestriction = value
    }

    /**
     * @param value The minimum allowed curve size (in bits) of an uploaded ED25519*SK key. 0 means no restriction. -1 disables ED25519*SK keys.
     */
    @JvmName("vkdjwbdubsrkvxnr")
    public suspend fun ed25519SkKeyRestriction(`value`: Output<Int>) {
        this.ed25519SkKeyRestriction = value
    }

    /**
     * @param value AWS IAM access key ID.
     */
    @JvmName("yrlqboerqaudvmsf")
    public suspend fun eksAccessKeyId(`value`: Output<String>) {
        this.eksAccessKeyId = value
    }

    /**
     * @param value Amazon account ID.
     */
    @JvmName("jjwkgmfohqhtydwa")
    public suspend fun eksAccountId(`value`: Output<String>) {
        this.eksAccountId = value
    }

    /**
     * @param value Enable integration with Amazon EKS.
     */
    @JvmName("vfmdtuclgtmpoiev")
    public suspend fun eksIntegrationEnabled(`value`: Output<Boolean>) {
        this.eksIntegrationEnabled = value
    }

    /**
     * @param value AWS IAM secret access key.
     */
    @JvmName("fwyakrbmnumjfouj")
    public suspend fun eksSecretAccessKey(`value`: Output<String>) {
        this.eksSecretAccessKey = value
    }

    /**
     * @param value Enable the use of AWS hosted Elasticsearch.
     */
    @JvmName("wkngmwylfqksswbj")
    public suspend fun elasticsearchAws(`value`: Output<Boolean>) {
        this.elasticsearchAws = value
    }

    /**
     * @param value AWS IAM access key.
     */
    @JvmName("vppskqmixoknwbxf")
    public suspend fun elasticsearchAwsAccessKey(`value`: Output<String>) {
        this.elasticsearchAwsAccessKey = value
    }

    /**
     * @param value The AWS region the Elasticsearch domain is configured.
     */
    @JvmName("ibmqacmwsyxvelef")
    public suspend fun elasticsearchAwsRegion(`value`: Output<String>) {
        this.elasticsearchAwsRegion = value
    }

    /**
     * @param value AWS IAM secret access key.
     */
    @JvmName("iuwmucpxcfyfsgou")
    public suspend fun elasticsearchAwsSecretAccessKey(`value`: Output<String>) {
        this.elasticsearchAwsSecretAccessKey = value
    }

    /**
     * @param value Maximum size of text fields to index by Elasticsearch. 0 value means no limit. This does not apply to repository and wiki indexing.
     */
    @JvmName("qswvaxdfdyecpsjm")
    public suspend fun elasticsearchIndexedFieldLengthLimit(`value`: Output<Int>) {
        this.elasticsearchIndexedFieldLengthLimit = value
    }

    /**
     * @param value Maximum size of repository and wiki files that are indexed by Elasticsearch.
     */
    @JvmName("kxlgppvkoybmogox")
    public suspend fun elasticsearchIndexedFileSizeLimitKb(`value`: Output<Int>) {
        this.elasticsearchIndexedFileSizeLimitKb = value
    }

    /**
     * @param value Enable Elasticsearch indexing.
     */
    @JvmName("ofhnwgxgrffopngu")
    public suspend fun elasticsearchIndexing(`value`: Output<Boolean>) {
        this.elasticsearchIndexing = value
    }

    /**
     * @param value Limit Elasticsearch to index certain namespaces and projects.
     */
    @JvmName("sevlqmwsurdfwtqu")
    public suspend fun elasticsearchLimitIndexing(`value`: Output<Boolean>) {
        this.elasticsearchLimitIndexing = value
    }

    /**
     * @param value Maximum concurrency of Elasticsearch bulk requests per indexing operation. This only applies to repository indexing operations.
     */
    @JvmName("gyqqkhaictogvmaj")
    public suspend fun elasticsearchMaxBulkConcurrency(`value`: Output<Int>) {
        this.elasticsearchMaxBulkConcurrency = value
    }

    /**
     * @param value Maximum size of Elasticsearch bulk indexing requests in MB. This only applies to repository indexing operations.
     */
    @JvmName("yjsvjencuugjvgbr")
    public suspend fun elasticsearchMaxBulkSizeMb(`value`: Output<Int>) {
        this.elasticsearchMaxBulkSizeMb = value
    }

    /**
     * @param value The namespaces to index via Elasticsearch if elasticsearch*limit*indexing is enabled.
     */
    @JvmName("iltderflmoitmpch")
    public suspend fun elasticsearchNamespaceIds(`value`: Output<List<Int>>) {
        this.elasticsearchNamespaceIds = value
    }

    @JvmName("wvwycoyuvxwudypo")
    public suspend fun elasticsearchNamespaceIds(vararg values: Output<Int>) {
        this.elasticsearchNamespaceIds = Output.all(values.asList())
    }

    /**
     * @param values The namespaces to index via Elasticsearch if elasticsearch*limit*indexing is enabled.
     */
    @JvmName("qtaohvtpyxvhtsrh")
    public suspend fun elasticsearchNamespaceIds(values: List<Output<Int>>) {
        this.elasticsearchNamespaceIds = Output.all(values)
    }

    /**
     * @param value The password of your Elasticsearch instance.
     */
    @JvmName("ekdxanfpjmhijnrk")
    public suspend fun elasticsearchPassword(`value`: Output<String>) {
        this.elasticsearchPassword = value
    }

    /**
     * @param value The projects to index via Elasticsearch if elasticsearch*limit*indexing is enabled.
     */
    @JvmName("jotfhcjnsaafwtdt")
    public suspend fun elasticsearchProjectIds(`value`: Output<List<Int>>) {
        this.elasticsearchProjectIds = value
    }

    @JvmName("qabpgbaactrpsxaa")
    public suspend fun elasticsearchProjectIds(vararg values: Output<Int>) {
        this.elasticsearchProjectIds = Output.all(values.asList())
    }

    /**
     * @param values The projects to index via Elasticsearch if elasticsearch*limit*indexing is enabled.
     */
    @JvmName("bmqhahicmlvqbwsm")
    public suspend fun elasticsearchProjectIds(values: List<Output<Int>>) {
        this.elasticsearchProjectIds = Output.all(values)
    }

    /**
     * @param value Enable Elasticsearch search.
     */
    @JvmName("mgjmoehyiyklkrov")
    public suspend fun elasticsearchSearch(`value`: Output<Boolean>) {
        this.elasticsearchSearch = value
    }

    /**
     * @param value The URL to use for connecting to Elasticsearch. Use a comma-separated list to support cluster (for example, http://localhost:9200, http://localhost:9201).
     */
    @JvmName("culfiqpmvduyensr")
    public suspend fun elasticsearchUrls(`value`: Output<List<String>>) {
        this.elasticsearchUrls = value
    }

    @JvmName("pxqqchmqllepppaq")
    public suspend fun elasticsearchUrls(vararg values: Output<String>) {
        this.elasticsearchUrls = Output.all(values.asList())
    }

    /**
     * @param values The URL to use for connecting to Elasticsearch. Use a comma-separated list to support cluster (for example, http://localhost:9200, http://localhost:9201).
     */
    @JvmName("mjadhhprfrunpwrd")
    public suspend fun elasticsearchUrls(values: List<Output<String>>) {
        this.elasticsearchUrls = Output.all(values)
    }

    /**
     * @param value The username of your Elasticsearch instance.
     */
    @JvmName("kigbyoildgfvrmja")
    public suspend fun elasticsearchUsername(`value`: Output<String>) {
        this.elasticsearchUsername = value
    }

    /**
     * @param value Additional text added to the bottom of every email for legal/auditing/compliance reasons.
     */
    @JvmName("leetvddkaxmbyxjc")
    public suspend fun emailAdditionalText(`value`: Output<String>) {
        this.emailAdditionalText = value
    }

    /**
     * @param value Some email servers do not support overriding the email sender name. Enable this option to include the name of the author of the issue, merge request or comment in the email body instead.
     */
    @JvmName("eiawuovgitirtrdw")
    public suspend fun emailAuthorInBody(`value`: Output<Boolean>) {
        this.emailAuthorInBody = value
    }

    /**
     * @param value Enabled protocols for Git access. Allowed values are: ssh, http, and nil to allow both protocols.
     */
    @JvmName("rkrhmddsirepvvrh")
    public suspend fun enabledGitAccessProtocol(`value`: Output<String>) {
        this.enabledGitAccessProtocol = value
    }

    /**
     * @param value Enabling this permits enforcement of namespace storage limits.
     */
    @JvmName("jialsvoyedinocdh")
    public suspend fun enforceNamespaceStorageLimit(`value`: Output<Boolean>) {
        this.enforceNamespaceStorageLimit = value
    }

    /**
     * @param value (If enabled, requires: terms) Enforce application ToS to all users.
     */
    @JvmName("kasntronyrundccq")
    public suspend fun enforceTerms(`value`: Output<Boolean>) {
        this.enforceTerms = value
    }

    /**
     * @param value (If enabled, requires: external*auth*client_key) The certificate to use to authenticate with the external authorization service.
     */
    @JvmName("ijnpqwuvrvsqamnq")
    public suspend fun externalAuthClientCert(`value`: Output<String>) {
        this.externalAuthClientCert = value
    }

    /**
     * @param value Private key for the certificate when authentication is required for the external authorization service, this is encrypted when stored.
     */
    @JvmName("uxintvveawllckmx")
    public suspend fun externalAuthClientKey(`value`: Output<String>) {
        this.externalAuthClientKey = value
    }

    /**
     * @param value Passphrase to use for the private key when authenticating with the external service this is encrypted when stored.
     */
    @JvmName("ygvhsxaubkgpphke")
    public suspend fun externalAuthClientKeyPass(`value`: Output<String>) {
        this.externalAuthClientKeyPass = value
    }

    /**
     * @param value The default classification label to use when requesting authorization and no classification label has been specified on the project.
     */
    @JvmName("abbxyhxvgxbhgpde")
    public suspend fun externalAuthorizationServiceDefaultLabel(`value`: Output<String>) {
        this.externalAuthorizationServiceDefaultLabel = value
    }

    /**
     * @param value (If enabled, requires: external*authorization*service*default*label, external*authorization*service*timeout and external*authorization*service*url) Enable using an external authorization service for accessing projects.
     */
    @JvmName("hicspoakkhrjxiwk")
    public suspend fun externalAuthorizationServiceEnabled(`value`: Output<Boolean>) {
        this.externalAuthorizationServiceEnabled = value
    }

    /**
     * @param value The timeout after which an authorization request is aborted, in seconds. When a request times out, access is denied to the user. (min: 0.001, max: 10, step: 0.001).
     */
    @JvmName("ivdwqxewebhdqnye")
    public suspend fun externalAuthorizationServiceTimeout(`value`: Output<Double>) {
        this.externalAuthorizationServiceTimeout = value
    }

    /**
     * @param value URL to which authorization requests are directed.
     */
    @JvmName("kokcwopekffhyfkw")
    public suspend fun externalAuthorizationServiceUrl(`value`: Output<String>) {
        this.externalAuthorizationServiceUrl = value
    }

    /**
     * @param value How long to wait for a response from the pipeline validation service. Assumes OK if it times out.
     */
    @JvmName("igxvrpmaxawqbuhb")
    public suspend fun externalPipelineValidationServiceTimeout(`value`: Output<Int>) {
        this.externalPipelineValidationServiceTimeout = value
    }

    /**
     * @param value Optional. Token to include as the X-Gitlab-Token header in requests to the URL in external*pipeline*validation*service*url.
     */
    @JvmName("aahksejpystcjevy")
    public suspend fun externalPipelineValidationServiceToken(`value`: Output<String>) {
        this.externalPipelineValidationServiceToken = value
    }

    /**
     * @param value URL to use for pipeline validation requests.
     */
    @JvmName("aaopqjpscuvmejol")
    public suspend fun externalPipelineValidationServiceUrl(`value`: Output<String>) {
        this.externalPipelineValidationServiceUrl = value
    }

    /**
     * @param value The ID of a project to load custom file templates from.
     */
    @JvmName("dsmgvucyuakvrwtk")
    public suspend fun fileTemplateProjectId(`value`: Output<Int>) {
        this.fileTemplateProjectId = value
    }

    /**
     * @param value Start day of the week for calendar views and date pickers. Valid values are 0 for Sunday, 1 for Monday, and 6 for Saturday.
     */
    @JvmName("dqjjpgdminsvdhgt")
    public suspend fun firstDayOfWeek(`value`: Output<Int>) {
        this.firstDayOfWeek = value
    }

    /**
     * @param value Comma-separated list of IPs and CIDRs of allowed secondary nodes. For example, 1.1.1.1, 2.2.2.0/24.
     */
    @JvmName("tcuxrxpxvppudxky")
    public suspend fun geoNodeAllowedIps(`value`: Output<String>) {
        this.geoNodeAllowedIps = value
    }

    /**
     * @param value The amount of seconds after which a request to get a secondary node status times out.
     */
    @JvmName("uljbeegvmauahooi")
    public suspend fun geoStatusTimeout(`value`: Output<Int>) {
        this.geoStatusTimeout = value
    }

    /**
     * @param value List of usernames excluded from Git anti-abuse rate limits. Maximum: 100 usernames. Introduced in GitLab 15.2.
     */
    @JvmName("klijtrknhhtpfvnj")
    public suspend fun gitRateLimitUsersAllowlists(`value`: Output<List<String>>) {
        this.gitRateLimitUsersAllowlists = value
    }

    @JvmName("cleqperiuwvpqklk")
    public suspend fun gitRateLimitUsersAllowlists(vararg values: Output<String>) {
        this.gitRateLimitUsersAllowlists = Output.all(values.asList())
    }

    /**
     * @param values List of usernames excluded from Git anti-abuse rate limits. Maximum: 100 usernames. Introduced in GitLab 15.2.
     */
    @JvmName("hiyjniibicffmubg")
    public suspend fun gitRateLimitUsersAllowlists(values: List<Output<String>>) {
        this.gitRateLimitUsersAllowlists = Output.all(values)
    }

    /**
     * @param value Maximum duration (in minutes) of a session for Git operations when 2FA is enabled.
     */
    @JvmName("jcesopoknygpjnlt")
    public suspend fun gitTwoFactorSessionExpiry(`value`: Output<Int>) {
        this.gitTwoFactorSessionExpiry = value
    }

    /**
     * @param value Default Gitaly timeout, in seconds. This timeout is not enforced for Git fetch/push operations or Sidekiq jobs. Set to 0 to disable timeouts.
     */
    @JvmName("wjgtoupkipvrtbft")
    public suspend fun gitalyTimeoutDefault(`value`: Output<Int>) {
        this.gitalyTimeoutDefault = value
    }

    /**
     * @param value Gitaly fast operation timeout, in seconds. Some Gitaly operations are expected to be fast. If they exceed this threshold, there may be a problem with a storage shard and ‘failing fast’ can help maintain the stability of the GitLab instance. Set to 0 to disable timeouts.
     */
    @JvmName("mxnhaatlunevvtlw")
    public suspend fun gitalyTimeoutFast(`value`: Output<Int>) {
        this.gitalyTimeoutFast = value
    }

    /**
     * @param value Medium Gitaly timeout, in seconds. This should be a value between the Fast and the Default timeout. Set to 0 to disable timeouts.
     */
    @JvmName("utxnxpasdatslqul")
    public suspend fun gitalyTimeoutMedium(`value`: Output<Int>) {
        this.gitalyTimeoutMedium = value
    }

    /**
     * @param value Enable Grafana.
     */
    @JvmName("oflliaqtarjgbsba")
    public suspend fun grafanaEnabled(`value`: Output<Boolean>) {
        this.grafanaEnabled = value
    }

    /**
     * @param value Grafana URL.
     */
    @JvmName("cmdmbrxnlkqvnwrs")
    public suspend fun grafanaUrl(`value`: Output<String>) {
        this.grafanaUrl = value
    }

    /**
     * @param value Enable Gravatar.
     */
    @JvmName("proumsposekbvbvp")
    public suspend fun gravatarEnabled(`value`: Output<Boolean>) {
        this.gravatarEnabled = value
    }

    /**
     * @param value Prevent overrides of default branch protection.
     */
    @JvmName("rosjsactmeijvntm")
    public suspend fun groupOwnersCanManageDefaultBranchProtection(`value`: Output<Boolean>) {
        this.groupOwnersCanManageDefaultBranchProtection = value
    }

    /**
     * @param value Create new projects using hashed storage paths: Enable immutable, hash-based paths and repository names to store repositories on disk. This prevents repositories from having to be moved or renamed when the Project URL changes and may improve disk I/O performance. (Always enabled in GitLab versions 13.0 and later, configuration is scheduled for removal in 14.0).
     */
    @JvmName("jnlpynwtmyhopqge")
    public suspend fun hashedStorageEnabled(`value`: Output<Boolean>) {
        this.hashedStorageEnabled = value
    }

    /**
     * @param value Hide marketing-related entries from help.
     */
    @JvmName("pschabikdhvbunta")
    public suspend fun helpPageHideCommercialContent(`value`: Output<Boolean>) {
        this.helpPageHideCommercialContent = value
    }

    /**
     * @param value Alternate support URL for help page and help dropdown.
     */
    @JvmName("fkxvwglmiosivjuj")
    public suspend fun helpPageSupportUrl(`value`: Output<String>) {
        this.helpPageSupportUrl = value
    }

    /**
     * @param value Custom text displayed on the help page.
     */
    @JvmName("mywrqxpingvuvhja")
    public suspend fun helpPageText(`value`: Output<String>) {
        this.helpPageText = value
    }

    /**
     * @param value GitLab server administrator information.
     */
    @JvmName("trqvaxfksfgfjdye")
    public suspend fun helpText(`value`: Output<String>) {
        this.helpText = value
    }

    /**
     * @param value Do not display offers from third parties in GitLab.
     */
    @JvmName("uefbvpoeadnslrff")
    public suspend fun hideThirdPartyOffers(`value`: Output<Boolean>) {
        this.hideThirdPartyOffers = value
    }

    /**
     * @param value Redirect to this URL when not logged in.
     */
    @JvmName("yqrgyonxmtblijuq")
    public suspend fun homePageUrl(`value`: Output<String>) {
        this.homePageUrl = value
    }

    /**
     * @param value Enable or disable Git housekeeping.
     * 			If enabled, requires either housekeeping*optimize*repository*period OR housekeeping*bitmaps*enabled, housekeeping*full*repack*period, housekeeping*gc*period, and housekeeping*incremental*repack*period.
     * 			Options housekeeping*bitmaps*enabled, housekeeping*full*repack*period, housekeeping*gc*period, and housekeeping*incremental*repack*period are deprecated. Use housekeeping*optimize*repository*period instead.
     */
    @JvmName("ixntlhtracajhicv")
    public suspend fun housekeepingEnabled(`value`: Output<Boolean>) {
        this.housekeepingEnabled = value
    }

    /**
     * @param value Number of Git pushes after which an incremental git repack is run.
     */
    @Deprecated(
        message = """
  housekeeping_full_repack_period is deprecated. Use housekeeping_optimize_repository_period
      instead.
  """,
    )
    @JvmName("memsvbtbpfvxcocq")
    public suspend fun housekeepingFullRepackPeriod(`value`: Output<Int>) {
        this.housekeepingFullRepackPeriod = value
    }

    /**
     * @param value Number of Git pushes after which git gc is run.
     */
    @Deprecated(
        message = """
  housekeeping_gc_period is deprecated. Use housekeeping_optimize_repository_period instead.
  """,
    )
    @JvmName("gskmnhhvyxenflpw")
    public suspend fun housekeepingGcPeriod(`value`: Output<Int>) {
        this.housekeepingGcPeriod = value
    }

    /**
     * @param value Number of Git pushes after which an incremental git repack is run.
     */
    @Deprecated(
        message = """
  housekeeping_incremental_repack_period is deprecated. Use housekeeping_optimize_repository_period
      instead.
  """,
    )
    @JvmName("jkkamoxttigxibrr")
    public suspend fun housekeepingIncrementalRepackPeriod(`value`: Output<Int>) {
        this.housekeepingIncrementalRepackPeriod = value
    }

    /**
     * @param value Number of Git pushes after which an incremental git repack is run.
     */
    @JvmName("cyyjarjulrwdyoos")
    public suspend fun housekeepingOptimizeRepositoryPeriod(`value`: Output<Int>) {
        this.housekeepingOptimizeRepositoryPeriod = value
    }

    /**
     * @param value Enable HTML emails.
     */
    @JvmName("aogwrgwwyhrvobva")
    public suspend fun htmlEmailsEnabled(`value`: Output<Boolean>) {
        this.htmlEmailsEnabled = value
    }

    /**
     * @param value Sources to allow project import from. Valid values are: `github`, `bitbucket`, `bitbucket_server`, `fogbugz`, `git`, `gitlab.Project`, `gitea`, `manifest`
     */
    @JvmName("vshqfochfuswgtqn")
    public suspend fun importSources(`value`: Output<List<String>>) {
        this.importSources = value
    }

    @JvmName("ycnehqgakxkiywwf")
    public suspend fun importSources(vararg values: Output<String>) {
        this.importSources = Output.all(values.asList())
    }

    /**
     * @param values Sources to allow project import from. Valid values are: `github`, `bitbucket`, `bitbucket_server`, `fogbugz`, `git`, `gitlab.Project`, `gitea`, `manifest`
     */
    @JvmName("hmkjdkbrpwiifkxn")
    public suspend fun importSources(values: List<Output<String>>) {
        this.importSources = Output.all(values)
    }

    /**
     * @param value Enable in-product marketing emails.
     */
    @JvmName("nbbfmbcuuafaddvu")
    public suspend fun inProductMarketingEmailsEnabled(`value`: Output<Boolean>) {
        this.inProductMarketingEmailsEnabled = value
    }

    /**
     * @param value If delete*inactive*projects is true, the time (in months) to wait before deleting inactive projects. Introduced in GitLab 14.10. Became operational in GitLab 15.0.
     */
    @JvmName("neriayylydwgskqg")
    public suspend fun inactiveProjectsDeleteAfterMonths(`value`: Output<Int>) {
        this.inactiveProjectsDeleteAfterMonths = value
    }

    /**
     * @param value If delete*inactive*projects is true, the minimum repository size for projects to be checked for inactivity. Introduced in GitLab 14.10. Became operational in GitLab 15.0.
     */
    @JvmName("vvdqnuhinricqpqk")
    public suspend fun inactiveProjectsMinSizeMb(`value`: Output<Int>) {
        this.inactiveProjectsMinSizeMb = value
    }

    /**
     * @param value If delete*inactive*projects is true, sets the time (in months) to wait before emailing maintainers that the project is scheduled be deleted because it is inactive. Introduced in GitLab 14.10. Became operational in GitLab 15.0.
     */
    @JvmName("sewupovcagagajnn")
    public suspend fun inactiveProjectsSendWarningEmailAfterMonths(`value`: Output<Int>) {
        this.inactiveProjectsSendWarningEmailAfterMonths = value
    }

    /**
     * @param value Enable Invisible CAPTCHA spam detection during sign-up.
     */
    @JvmName("ioahirjdxoiugpbr")
    public suspend fun invisibleCaptchaEnabled(`value`: Output<Boolean>) {
        this.invisibleCaptchaEnabled = value
    }

    /**
     * @param value Max number of issue creation requests per minute per user.
     */
    @JvmName("nhhlanbeqilvpjqi")
    public suspend fun issuesCreateLimit(`value`: Output<Int>) {
        this.issuesCreateLimit = value
    }

    /**
     * @param value Prevent the deletion of the artifacts from the most recent successful jobs, regardless of the expiry time.
     */
    @JvmName("sdqucltokiblvnwq")
    public suspend fun keepLatestArtifact(`value`: Output<Boolean>) {
        this.keepLatestArtifact = value
    }

    /**
     * @param value Increase this value when any cached Markdown should be invalidated.
     */
    @JvmName("viaecouiweaamymt")
    public suspend fun localMarkdownVersion(`value`: Output<Int>) {
        this.localMarkdownVersion = value
    }

    /**
     * @param value Enable Mailgun event receiver.
     */
    @JvmName("qohagscxwyxxcqbw")
    public suspend fun mailgunEventsEnabled(`value`: Output<Boolean>) {
        this.mailgunEventsEnabled = value
    }

    /**
     * @param value The Mailgun HTTP webhook signing key for receiving events from webhook.
     */
    @JvmName("roammhityjpyerve")
    public suspend fun mailgunSigningKey(`value`: Output<String>) {
        this.mailgunSigningKey = value
    }

    /**
     * @param value When instance is in maintenance mode, non-administrative users can sign in with read-only access and make read-only API requests.
     */
    @JvmName("lxqdrqnododakvhp")
    public suspend fun maintenanceMode(`value`: Output<Boolean>) {
        this.maintenanceMode = value
    }

    /**
     * @param value Message displayed when instance is in maintenance mode.
     */
    @JvmName("bllbgoreecqgmgqd")
    public suspend fun maintenanceModeMessage(`value`: Output<String>) {
        this.maintenanceModeMessage = value
    }

    /**
     * @param value Maximum artifacts size in MB.
     */
    @JvmName("odbbjmwqpygopqxx")
    public suspend fun maxArtifactsSize(`value`: Output<Int>) {
        this.maxArtifactsSize = value
    }

    /**
     * @param value Limit attachment size in MB.
     */
    @JvmName("bddhftwqpuiasxdu")
    public suspend fun maxAttachmentSize(`value`: Output<Int>) {
        this.maxAttachmentSize = value
    }

    /**
     * @param value Maximum export size in MB. 0 for unlimited.
     */
    @JvmName("wrxevuyirmvkbpsp")
    public suspend fun maxExportSize(`value`: Output<Int>) {
        this.maxExportSize = value
    }

    /**
     * @param value Maximum import size in MB. 0 for unlimited.
     */
    @JvmName("gaefmqljkmfpquju")
    public suspend fun maxImportSize(`value`: Output<Int>) {
        this.maxImportSize = value
    }

    /**
     * @param value Maximum number of unique repositories a user can download in the specified time period before they are banned. Maximum: 10,000 repositories. Introduced in GitLab 15.1.
     */
    @JvmName("xysxnmmdvxmbmxkd")
    public suspend fun maxNumberOfRepositoryDownloads(`value`: Output<Int>) {
        this.maxNumberOfRepositoryDownloads = value
    }

    /**
     * @param value Reporting time period (in seconds). Maximum: 864000 seconds (10 days). Introduced in GitLab 15.1.
     */
    @JvmName("rhsrjtfrkrpgcmlv")
    public suspend fun maxNumberOfRepositoryDownloadsWithinTimePeriod(`value`: Output<Int>) {
        this.maxNumberOfRepositoryDownloadsWithinTimePeriod = value
    }

    /**
     * @param value Maximum size of pages repositories in MB.
     */
    @JvmName("eastsnhcyhgstawo")
    public suspend fun maxPagesSize(`value`: Output<Int>) {
        this.maxPagesSize = value
    }

    /**
     * @param value Maximum allowable lifetime for access tokens in days.
     */
    @JvmName("gvwvrkuxittpdhyr")
    public suspend fun maxPersonalAccessTokenLifetime(`value`: Output<Int>) {
        this.maxPersonalAccessTokenLifetime = value
    }

    /**
     * @param value Maximum allowable lifetime for SSH keys in days. Introduced in GitLab 14.6.
     */
    @JvmName("eeoiinhuxvmejdnw")
    public suspend fun maxSshKeyLifetime(`value`: Output<Int>) {
        this.maxSshKeyLifetime = value
    }

    /**
     * @param value
     */
    @JvmName("egkxhpmndtefrpgq")
    public suspend fun maxTerraformStateSizeBytes(`value`: Output<Int>) {
        this.maxTerraformStateSizeBytes = value
    }

    /**
     * @param value A method call is only tracked when it takes longer than the given amount of milliseconds.
     */
    @JvmName("xlrpbwjgtmtijhgr")
    public suspend fun metricsMethodCallThreshold(`value`: Output<Int>) {
        this.metricsMethodCallThreshold = value
    }

    /**
     * @param value Indicates whether passwords require a minimum length. Introduced in GitLab 15.1. Premium and Ultimate only.
     */
    @JvmName("vhgugltslhllnvcs")
    public suspend fun minimumPasswordLength(`value`: Output<Int>) {
        this.minimumPasswordLength = value
    }

    /**
     * @param value Allow repository mirroring to configured by project Maintainers. If disabled, only Administrators can configure repository mirroring.
     */
    @JvmName("agbsodywahawqmne")
    public suspend fun mirrorAvailable(`value`: Output<Boolean>) {
        this.mirrorAvailable = value
    }

    /**
     * @param value Minimum capacity to be available before scheduling more mirrors preemptively.
     */
    @JvmName("esouflsumwwtobtn")
    public suspend fun mirrorCapacityThreshold(`value`: Output<Int>) {
        this.mirrorCapacityThreshold = value
    }

    /**
     * @param value Maximum number of mirrors that can be synchronizing at the same time.
     */
    @JvmName("tsctunrqkrbfblic")
    public suspend fun mirrorMaxCapacity(`value`: Output<Int>) {
        this.mirrorMaxCapacity = value
    }

    /**
     * @param value Maximum time (in minutes) between updates that a mirror can have when scheduled to synchronize.
     */
    @JvmName("mtrdhstwvofrrgic")
    public suspend fun mirrorMaxDelay(`value`: Output<Int>) {
        this.mirrorMaxDelay = value
    }

    /**
     * @param value Use npmjs.org as a default remote repository when the package is not found in the GitLab Package Registry for npm.
     */
    @JvmName("pgsvbgefvopcrgmx")
    public suspend fun npmPackageRequestsForwarding(`value`: Output<Boolean>) {
        this.npmPackageRequestsForwarding = value
    }

    /**
     * @param value Define a list of trusted domains or IP addresses to which local requests are allowed when local requests for hooks and services are disabled.
     */
    @JvmName("tctebrcfgqdqxmus")
    public suspend fun outboundLocalRequestsWhitelists(`value`: Output<List<String>>) {
        this.outboundLocalRequestsWhitelists = value
    }

    @JvmName("ygxadkvidrwglbrw")
    public suspend fun outboundLocalRequestsWhitelists(vararg values: Output<String>) {
        this.outboundLocalRequestsWhitelists = Output.all(values.asList())
    }

    /**
     * @param values Define a list of trusted domains or IP addresses to which local requests are allowed when local requests for hooks and services are disabled.
     */
    @JvmName("ajmjgafjbeyaytwh")
    public suspend fun outboundLocalRequestsWhitelists(values: List<Output<String>>) {
        this.outboundLocalRequestsWhitelists = Output.all(values)
    }

    /**
     * @param value Number of workers assigned to the packages cleanup policies.
     */
    @JvmName("npbbcjpbpfdrumdx")
    public suspend fun packageRegistryCleanupPoliciesWorkerCapacity(`value`: Output<Int>) {
        this.packageRegistryCleanupPoliciesWorkerCapacity = value
    }

    /**
     * @param value Require users to prove ownership of custom domains. Domain verification is an essential security measure for public GitLab sites. Users are required to demonstrate they control a domain before it is enabled.
     */
    @JvmName("deyeogfulrkglesx")
    public suspend fun pagesDomainVerificationEnabled(`value`: Output<Boolean>) {
        this.pagesDomainVerificationEnabled = value
    }

    /**
     * @param value Enable authentication for Git over HTTP(S) via a GitLab account password.
     */
    @JvmName("qpagmbtdmxcykldq")
    public suspend fun passwordAuthenticationEnabledForGit(`value`: Output<Boolean>) {
        this.passwordAuthenticationEnabledForGit = value
    }

    /**
     * @param value Enable authentication for the web interface via a GitLab account password.
     */
    @JvmName("rnioumbrwxpsgeie")
    public suspend fun passwordAuthenticationEnabledForWeb(`value`: Output<Boolean>) {
        this.passwordAuthenticationEnabledForWeb = value
    }

    /**
     * @param value Indicates whether passwords require at least one lowercase letter. Introduced in GitLab 15.1.
     */
    @JvmName("qkgowlujnwcdgsoa")
    public suspend fun passwordLowercaseRequired(`value`: Output<Boolean>) {
        this.passwordLowercaseRequired = value
    }

    /**
     * @param value Indicates whether passwords require at least one number. Introduced in GitLab 15.1.
     */
    @JvmName("ruebcwfxicihmhbo")
    public suspend fun passwordNumberRequired(`value`: Output<Boolean>) {
        this.passwordNumberRequired = value
    }

    /**
     * @param value Indicates whether passwords require at least one symbol character. Introduced in GitLab 15.1.
     */
    @JvmName("qwsjmywxtngmuokx")
    public suspend fun passwordSymbolRequired(`value`: Output<Boolean>) {
        this.passwordSymbolRequired = value
    }

    /**
     * @param value Indicates whether passwords require at least one uppercase letter. Introduced in GitLab 15.1.
     */
    @JvmName("dfkubkoxdjehstmb")
    public suspend fun passwordUppercaseRequired(`value`: Output<Boolean>) {
        this.passwordUppercaseRequired = value
    }

    /**
     * @param value Path of the group that is allowed to toggle the performance bar.
     */
    @JvmName("qftjtmfjpakwvpvu")
    public suspend fun performanceBarAllowedGroupPath(`value`: Output<String>) {
        this.performanceBarAllowedGroupPath = value
    }

    /**
     * @param value Prefix for all generated personal access tokens.
     */
    @JvmName("naujowyfgbdugwdj")
    public suspend fun personalAccessTokenPrefix(`value`: Output<String>) {
        this.personalAccessTokenPrefix = value
    }

    /**
     * @param value Maximum number of pipeline creation requests per minute per user and commit.
     */
    @JvmName("bpkbpynovwenflfh")
    public suspend fun pipelineLimitPerProjectUserSha(`value`: Output<Int>) {
        this.pipelineLimitPerProjectUserSha = value
    }

    /**
     * @param value (If enabled, requires: plantuml_url) Enable PlantUML integration.
     */
    @JvmName("ifnimncpafgwybpm")
    public suspend fun plantumlEnabled(`value`: Output<Boolean>) {
        this.plantumlEnabled = value
    }

    /**
     * @param value The PlantUML instance URL for integration.
     */
    @JvmName("vouyepncrjfvnhuj")
    public suspend fun plantumlUrl(`value`: Output<String>) {
        this.plantumlUrl = value
    }

    /**
     * @param value Interval multiplier used by endpoints that perform polling. Set to 0 to disable polling.
     */
    @JvmName("vlunwkfyamqqmntn")
    public suspend fun pollingIntervalMultiplier(`value`: Output<Double>) {
        this.pollingIntervalMultiplier = value
    }

    /**
     * @param value Enable project export.
     */
    @JvmName("oaykphrkynefxjdx")
    public suspend fun projectExportEnabled(`value`: Output<Boolean>) {
        this.projectExportEnabled = value
    }

    /**
     * @param value Enable Prometheus metrics.
     */
    @JvmName("wryhrogxddquinlh")
    public suspend fun prometheusMetricsEnabled(`value`: Output<Boolean>) {
        this.prometheusMetricsEnabled = value
    }

    /**
     * @param value CI/CD variables are protected by default.
     */
    @JvmName("ulofrnnscihetyta")
    public suspend fun protectedCiVariables(`value`: Output<Boolean>) {
        this.protectedCiVariables = value
    }

    /**
     * @param value Number of changes (branches or tags) in a single push to determine whether individual push events or bulk push events are created. Bulk push events are created if it surpasses that value.
     */
    @JvmName("eidcxlssddlkkolv")
    public suspend fun pushEventActivitiesLimit(`value`: Output<Int>) {
        this.pushEventActivitiesLimit = value
    }

    /**
     * @param value Number of changes (branches or tags) in a single push to determine whether webhooks and services fire or not. Webhooks and services aren’t submitted if it surpasses that value.
     */
    @JvmName("soyivoparyyjupgb")
    public suspend fun pushEventHooksLimit(`value`: Output<Int>) {
        this.pushEventHooksLimit = value
    }

    /**
     * @param value Use pypi.org as a default remote repository when the package is not found in the GitLab Package Registry for PyPI.
     */
    @JvmName("jxigsdesirggivax")
    public suspend fun pypiPackageRequestsForwarding(`value`: Output<Boolean>) {
        this.pypiPackageRequestsForwarding = value
    }

    /**
     * @param value When rate limiting is enabled via the throttle_* settings, send this plain text response when a rate limit is exceeded. ‘Retry later’ is sent if this is blank.
     */
    @JvmName("xemoolrywrsjjsqu")
    public suspend fun rateLimitingResponseText(`value`: Output<String>) {
        this.rateLimitingResponseText = value
    }

    /**
     * @param value Max number of requests per minute for each raw path. To disable throttling set to 0.
     */
    @JvmName("xexycbgiobofgoyj")
    public suspend fun rawBlobRequestLimit(`value`: Output<Int>) {
        this.rawBlobRequestLimit = value
    }

    /**
     * @param value (If enabled, requires: recaptcha*private*key and recaptcha*site*key) Enable reCAPTCHA.
     */
    @JvmName("ldvqcpperpgpbqmw")
    public suspend fun recaptchaEnabled(`value`: Output<Boolean>) {
        this.recaptchaEnabled = value
    }

    /**
     * @param value Private key for reCAPTCHA.
     */
    @JvmName("gwhwkhdabmshmkgp")
    public suspend fun recaptchaPrivateKey(`value`: Output<String>) {
        this.recaptchaPrivateKey = value
    }

    /**
     * @param value Site key for reCAPTCHA.
     */
    @JvmName("uyecfgdqlsxuctdo")
    public suspend fun recaptchaSiteKey(`value`: Output<String>) {
        this.recaptchaSiteKey = value
    }

    /**
     * @param value Maximum push size (MB).
     */
    @JvmName("vfjcjbgveouvmdys")
    public suspend fun receiveMaxInputSize(`value`: Output<Int>) {
        this.receiveMaxInputSize = value
    }

    /**
     * @param value GitLab periodically runs git fsck in all project and wiki repositories to look for silent disk corruption issues.
     */
    @JvmName("khhceoovhsoutmhq")
    public suspend fun repositoryChecksEnabled(`value`: Output<Boolean>) {
        this.repositoryChecksEnabled = value
    }

    /**
     * @param value Size limit per repository (MB).
     */
    @JvmName("hlrivmwwvhmooghv")
    public suspend fun repositorySizeLimit(`value`: Output<Int>) {
        this.repositorySizeLimit = value
    }

    /**
     * @param value (GitLab 13.0 and earlier) List of names of enabled storage paths, taken from gitlab.yml. New projects are created in one of these stores, chosen at random.
     */
    @JvmName("gvtkfbctuqivydbr")
    public suspend fun repositoryStorages(`value`: Output<List<String>>) {
        this.repositoryStorages = value
    }

    @JvmName("twbjdvwycjocsgsr")
    public suspend fun repositoryStorages(vararg values: Output<String>) {
        this.repositoryStorages = Output.all(values.asList())
    }

    /**
     * @param values (GitLab 13.0 and earlier) List of names of enabled storage paths, taken from gitlab.yml. New projects are created in one of these stores, chosen at random.
     */
    @JvmName("tqykaniipbkpxdnw")
    public suspend fun repositoryStorages(values: List<Output<String>>) {
        this.repositoryStorages = Output.all(values)
    }

    /**
     * @param value (GitLab 13.1 and later) Hash of names of taken from gitlab.yml to weights. New projects are created in one of these stores, chosen by a weighted random selection.
     */
    @JvmName("pjancbxmcmeoyind")
    public suspend fun repositoryStoragesWeighted(`value`: Output<Map<String, Int>>) {
        this.repositoryStoragesWeighted = value
    }

    /**
     * @param value When enabled, any user that signs up for an account using the registration form is placed under a Pending approval state and has to be explicitly approved by an administrator.
     */
    @JvmName("rbkyqifpsunfopww")
    public suspend fun requireAdminApprovalAfterUserSignup(`value`: Output<Boolean>) {
        this.requireAdminApprovalAfterUserSignup = value
    }

    /**
     * @param value (If enabled, requires: two*factor*grace_period) Require all users to set up Two-factor authentication.
     */
    @JvmName("ycdmnfclhbkesldm")
    public suspend fun requireTwoFactorAuthentication(`value`: Output<Boolean>) {
        this.requireTwoFactorAuthentication = value
    }

    /**
     * @param value Selected levels cannot be used by non-Administrator users for groups, projects or snippets. Can take private, internal and public as a parameter. Null means there is no restriction.
     */
    @JvmName("gdarcpqsueejllpx")
    public suspend fun restrictedVisibilityLevels(`value`: Output<List<String>>) {
        this.restrictedVisibilityLevels = value
    }

    @JvmName("sqrtvxierijxsmlp")
    public suspend fun restrictedVisibilityLevels(vararg values: Output<String>) {
        this.restrictedVisibilityLevels = Output.all(values.asList())
    }

    /**
     * @param values Selected levels cannot be used by non-Administrator users for groups, projects or snippets. Can take private, internal and public as a parameter. Null means there is no restriction.
     */
    @JvmName("cuxqovavjavqxixj")
    public suspend fun restrictedVisibilityLevels(values: List<Output<String>>) {
        this.restrictedVisibilityLevels = Output.all(values)
    }

    /**
     * @param value The minimum allowed bit length of an uploaded RSA key. 0 means no restriction. -1 disables RSA keys.
     */
    @JvmName("xncddeixjeryfonm")
    public suspend fun rsaKeyRestriction(`value`: Output<Int>) {
        this.rsaKeyRestriction = value
    }

    /**
     * @param value Max number of requests per minute for performing a search while authenticated. To disable throttling set to 0.
     */
    @JvmName("rjttbwijajfipjef")
    public suspend fun searchRateLimit(`value`: Output<Int>) {
        this.searchRateLimit = value
    }

    /**
     * @param value Max number of requests per minute for performing a search while unauthenticated. To disable throttling set to 0.
     */
    @JvmName("bwqlwyseqdxpecvi")
    public suspend fun searchRateLimitUnauthenticated(`value`: Output<Int>) {
        this.searchRateLimitUnauthenticated = value
    }

    /**
     * @param value Send confirmation email on sign-up.
     */
    @JvmName("mwtraeybdhifhwxe")
    public suspend fun sendUserConfirmationEmail(`value`: Output<Boolean>) {
        this.sendUserConfirmationEmail = value
    }

    /**
     * @param value Session duration in minutes. GitLab restart is required to apply changes.
     */
    @JvmName("ypmgqsllnxgbwldr")
    public suspend fun sessionExpireDelay(`value`: Output<Int>) {
        this.sessionExpireDelay = value
    }

    /**
     * @param value (If enabled, requires: shared*runners*text and shared*runners*minutes) Enable shared runners for new projects.
     */
    @JvmName("ksfauqxtqaehdvrr")
    public suspend fun sharedRunnersEnabled(`value`: Output<Boolean>) {
        this.sharedRunnersEnabled = value
    }

    /**
     * @param value Set the maximum number of CI/CD minutes that a group can use on shared runners per month.
     */
    @JvmName("xfdsrqfauvlafrhe")
    public suspend fun sharedRunnersMinutes(`value`: Output<Int>) {
        this.sharedRunnersMinutes = value
    }

    /**
     * @param value Shared runners text.
     */
    @JvmName("umbbfayjfdlperpk")
    public suspend fun sharedRunnersText(`value`: Output<String>) {
        this.sharedRunnersText = value
    }

    /**
     * @param value The threshold in bytes at which Sidekiq jobs are compressed before being stored in Redis.
     */
    @JvmName("vulnoafottnqlmhf")
    public suspend fun sidekiqJobLimiterCompressionThresholdBytes(`value`: Output<Int>) {
        this.sidekiqJobLimiterCompressionThresholdBytes = value
    }

    /**
     * @param value The threshold in bytes at which Sidekiq jobs are rejected. 0 means do not reject any job.
     */
    @JvmName("wvuyuhjmwjhmbdls")
    public suspend fun sidekiqJobLimiterLimitBytes(`value`: Output<Int>) {
        this.sidekiqJobLimiterLimitBytes = value
    }

    /**
     * @param value track or compress. Sets the behavior for Sidekiq job size limits.
     */
    @JvmName("mcvmwpwedqmrmtca")
    public suspend fun sidekiqJobLimiterMode(`value`: Output<String>) {
        this.sidekiqJobLimiterMode = value
    }

    /**
     * @param value Text on the login page.
     */
    @JvmName("ddiikktwwoafdqle")
    public suspend fun signInText(`value`: Output<String>) {
        this.signInText = value
    }

    /**
     * @param value Enable registration.
     */
    @JvmName("ucpfdjloxojabbmd")
    public suspend fun signupEnabled(`value`: Output<Boolean>) {
        this.signupEnabled = value
    }

    /**
     * @param value (If enabled, requires: slack*app*id, slack*app*secret and slack*app*secret) Enable Slack app.
     */
    @JvmName("tsnkovqqrgfsdgew")
    public suspend fun slackAppEnabled(`value`: Output<Boolean>) {
        this.slackAppEnabled = value
    }

    /**
     * @param value The app ID of the Slack-app.
     */
    @JvmName("bxfqowmibyomjyei")
    public suspend fun slackAppId(`value`: Output<String>) {
        this.slackAppId = value
    }

    /**
     * @param value The app secret of the Slack-app.
     */
    @JvmName("xdnuaxwvdggwxqbr")
    public suspend fun slackAppSecret(`value`: Output<String>) {
        this.slackAppSecret = value
    }

    /**
     * @param value The signing secret of the Slack-app.
     */
    @JvmName("emopbailiqrrrhnh")
    public suspend fun slackAppSigningSecret(`value`: Output<String>) {
        this.slackAppSigningSecret = value
    }

    /**
     * @param value The verification token of the Slack-app.
     */
    @JvmName("pmfucamgjtrntsil")
    public suspend fun slackAppVerificationToken(`value`: Output<String>) {
        this.slackAppVerificationToken = value
    }

    /**
     * @param value Max snippet content size in bytes.
     */
    @JvmName("yxhjqhqnwisutejj")
    public suspend fun snippetSizeLimit(`value`: Output<Int>) {
        this.snippetSizeLimit = value
    }

    /**
     * @param value The Snowplow site name / application ID. (for example, gitlab)
     */
    @JvmName("jmdwvqfcblwbabvy")
    public suspend fun snowplowAppId(`value`: Output<String>) {
        this.snowplowAppId = value
    }

    /**
     * @param value The Snowplow collector hostname. (for example, snowplow.trx.gitlab.net)
     */
    @JvmName("efellinpoffsdfep")
    public suspend fun snowplowCollectorHostname(`value`: Output<String>) {
        this.snowplowCollectorHostname = value
    }

    /**
     * @param value The Snowplow cookie domain. (for example, .gitlab.com)
     */
    @JvmName("opdeeupflgpispmw")
    public suspend fun snowplowCookieDomain(`value`: Output<String>) {
        this.snowplowCookieDomain = value
    }

    /**
     * @param value Enable snowplow tracking.
     */
    @JvmName("uhbgpwikwjbitbgr")
    public suspend fun snowplowEnabled(`value`: Output<Boolean>) {
        this.snowplowEnabled = value
    }

    /**
     * @param value Enables Sourcegraph integration. If enabled, requires sourcegraph_url.
     */
    @JvmName("prpmmafbyusjgeuv")
    public suspend fun sourcegraphEnabled(`value`: Output<Boolean>) {
        this.sourcegraphEnabled = value
    }

    /**
     * @param value Blocks Sourcegraph from being loaded on private and internal projects.
     */
    @JvmName("hffmeeqmmjshuybb")
    public suspend fun sourcegraphPublicOnly(`value`: Output<Boolean>) {
        this.sourcegraphPublicOnly = value
    }

    /**
     * @param value The Sourcegraph instance URL for integration.
     */
    @JvmName("msrdtjknvctnucvb")
    public suspend fun sourcegraphUrl(`value`: Output<String>) {
        this.sourcegraphUrl = value
    }

    /**
     * @param value API key used by GitLab for accessing the Spam Check service endpoint.
     */
    @JvmName("apnvnfrnidlwvgas")
    public suspend fun spamCheckApiKey(`value`: Output<String>) {
        this.spamCheckApiKey = value
    }

    /**
     * @param value Enables spam checking using external Spam Check API endpoint.
     */
    @JvmName("twpllaovvucoupcv")
    public suspend fun spamCheckEndpointEnabled(`value`: Output<Boolean>) {
        this.spamCheckEndpointEnabled = value
    }

    /**
     * @param value URL of the external Spamcheck service endpoint. Valid URI schemes are grpc or tls. Specifying tls forces communication to be encrypted.
     */
    @JvmName("boxmmeqwmmbyljpt")
    public suspend fun spamCheckEndpointUrl(`value`: Output<String>) {
        this.spamCheckEndpointUrl = value
    }

    /**
     * @param value Enable pipeline suggestion banner.
     */
    @JvmName("ptxqxtmdwmdyshvu")
    public suspend fun suggestPipelineEnabled(`value`: Output<Boolean>) {
        this.suggestPipelineEnabled = value
    }

    /**
     * @param value Maximum time for web terminal websocket connection (in seconds). Set to 0 for unlimited time.
     */
    @JvmName("qnusnogbjisfkdul")
    public suspend fun terminalMaxSessionTime(`value`: Output<Int>) {
        this.terminalMaxSessionTime = value
    }

    /**
     * @param value (Required by: enforce_terms) Markdown content for the ToS.
     */
    @JvmName("tujxlyymkvfkdktc")
    public suspend fun terms(`value`: Output<String>) {
        this.terms = value
    }

    /**
     * @param value (If enabled, requires: throttle*authenticated*api*period*in*seconds and throttle*authenticated*api*requests*per*period) Enable authenticated API request rate limit. Helps reduce request volume (for example, from crawlers or abusive bots).
     */
    @JvmName("apffnaeboxixvcgf")
    public suspend fun throttleAuthenticatedApiEnabled(`value`: Output<Boolean>) {
        this.throttleAuthenticatedApiEnabled = value
    }

    /**
     * @param value Rate limit period (in seconds).
     */
    @JvmName("nmhbhvhxidncutdb")
    public suspend fun throttleAuthenticatedApiPeriodInSeconds(`value`: Output<Int>) {
        this.throttleAuthenticatedApiPeriodInSeconds = value
    }

    /**
     * @param value Maximum requests per period per user.
     */
    @JvmName("nfwvgiswousgcydu")
    public suspend fun throttleAuthenticatedApiRequestsPerPeriod(`value`: Output<Int>) {
        this.throttleAuthenticatedApiRequestsPerPeriod = value
    }

    /**
     * @param value (If enabled, requires: throttle*authenticated*packages*api*period*in*seconds and throttle*authenticated*packages*api*requests*per*period) Enable authenticated API request rate limit. Helps reduce request volume (for example, from crawlers or abusive bots). View Package Registry rate limits for more details.
     */
    @JvmName("dwnhlniwmwjmufqq")
    public suspend fun throttleAuthenticatedPackagesApiEnabled(`value`: Output<Boolean>) {
        this.throttleAuthenticatedPackagesApiEnabled = value
    }

    /**
     * @param value Rate limit period (in seconds). View Package Registry rate limits for more details.
     */
    @JvmName("lmoqiaqspqocturj")
    public suspend fun throttleAuthenticatedPackagesApiPeriodInSeconds(`value`: Output<Int>) {
        this.throttleAuthenticatedPackagesApiPeriodInSeconds = value
    }

    /**
     * @param value Maximum requests per period per user. View Package Registry rate limits for more details.
     */
    @JvmName("xcnuwgfmlmdsvywp")
    public suspend fun throttleAuthenticatedPackagesApiRequestsPerPeriod(`value`: Output<Int>) {
        this.throttleAuthenticatedPackagesApiRequestsPerPeriod = value
    }

    /**
     * @param value (If enabled, requires: throttle*authenticated*web*period*in*seconds and throttle*authenticated*web*requests*per*period) Enable authenticated web request rate limit. Helps reduce request volume (for example, from crawlers or abusive bots).
     */
    @JvmName("tbabiuwlvrcvakjm")
    public suspend fun throttleAuthenticatedWebEnabled(`value`: Output<Boolean>) {
        this.throttleAuthenticatedWebEnabled = value
    }

    /**
     * @param value Rate limit period (in seconds).
     */
    @JvmName("jwrfydxrkdaxnmyv")
    public suspend fun throttleAuthenticatedWebPeriodInSeconds(`value`: Output<Int>) {
        this.throttleAuthenticatedWebPeriodInSeconds = value
    }

    /**
     * @param value Maximum requests per period per user.
     */
    @JvmName("futfxwcweifnmsjt")
    public suspend fun throttleAuthenticatedWebRequestsPerPeriod(`value`: Output<Int>) {
        this.throttleAuthenticatedWebRequestsPerPeriod = value
    }

    /**
     * @param value (If enabled, requires: throttle*unauthenticated*api*period*in*seconds and throttle*unauthenticated*api*requests*per*period) Enable unauthenticated API request rate limit. Helps reduce request volume (for example, from crawlers or abusive bots).
     */
    @JvmName("gmaoomvfkjxsyhsf")
    public suspend fun throttleUnauthenticatedApiEnabled(`value`: Output<Boolean>) {
        this.throttleUnauthenticatedApiEnabled = value
    }

    /**
     * @param value Rate limit period in seconds.
     */
    @JvmName("gotquwldwjhkqsmk")
    public suspend fun throttleUnauthenticatedApiPeriodInSeconds(`value`: Output<Int>) {
        this.throttleUnauthenticatedApiPeriodInSeconds = value
    }

    /**
     * @param value Max requests per period per IP.
     */
    @JvmName("kclhchgbrorqvvrq")
    public suspend fun throttleUnauthenticatedApiRequestsPerPeriod(`value`: Output<Int>) {
        this.throttleUnauthenticatedApiRequestsPerPeriod = value
    }

    /**
     * @param value (If enabled, requires: throttle*unauthenticated*packages*api*period*in*seconds and throttle*unauthenticated*packages*api*requests*per*period) Enable authenticated API request rate limit. Helps reduce request volume (for example, from crawlers or abusive bots). View Package Registry rate limits for more details.
     */
    @JvmName("kssdpmkimgmlbxgc")
    public suspend fun throttleUnauthenticatedPackagesApiEnabled(`value`: Output<Boolean>) {
        this.throttleUnauthenticatedPackagesApiEnabled = value
    }

    /**
     * @param value Rate limit period (in seconds). View Package Registry rate limits for more details.
     */
    @JvmName("ivsuddvatbuvofsq")
    public suspend fun throttleUnauthenticatedPackagesApiPeriodInSeconds(`value`: Output<Int>) {
        this.throttleUnauthenticatedPackagesApiPeriodInSeconds = value
    }

    /**
     * @param value Maximum requests per period per user. View Package Registry rate limits for more details.
     */
    @JvmName("vkwqbjawvyixmvix")
    public suspend fun throttleUnauthenticatedPackagesApiRequestsPerPeriod(`value`: Output<Int>) {
        this.throttleUnauthenticatedPackagesApiRequestsPerPeriod = value
    }

    /**
     * @param value (If enabled, requires: throttle*unauthenticated*web*period*in*seconds and throttle*unauthenticated*web*requests*per*period) Enable unauthenticated web request rate limit. Helps reduce request volume (for example, from crawlers or abusive bots).
     */
    @JvmName("fawvquvmftscfnuy")
    public suspend fun throttleUnauthenticatedWebEnabled(`value`: Output<Boolean>) {
        this.throttleUnauthenticatedWebEnabled = value
    }

    /**
     * @param value Rate limit period in seconds.
     */
    @JvmName("vhgmjqstgmqfbchc")
    public suspend fun throttleUnauthenticatedWebPeriodInSeconds(`value`: Output<Int>) {
        this.throttleUnauthenticatedWebPeriodInSeconds = value
    }

    /**
     * @param value Max requests per period per IP.
     */
    @JvmName("bswsikbbueavocof")
    public suspend fun throttleUnauthenticatedWebRequestsPerPeriod(`value`: Output<Int>) {
        this.throttleUnauthenticatedWebRequestsPerPeriod = value
    }

    /**
     * @param value Limit display of time tracking units to hours.
     */
    @JvmName("apbywvnbqdxbutqi")
    public suspend fun timeTrackingLimitToHours(`value`: Output<Boolean>) {
        this.timeTrackingLimitToHours = value
    }

    /**
     * @param value Amount of time (in hours) that users are allowed to skip forced configuration of two-factor authentication.
     */
    @JvmName("rdqhhdngnqlrgead")
    public suspend fun twoFactorGracePeriod(`value`: Output<Int>) {
        this.twoFactorGracePeriod = value
    }

    /**
     * @param value (If enabled, requires: unique*ips*limit*per*user and unique*ips*limit*time*window) Limit sign in from multiple IPs.
     */
    @JvmName("nqayivsvefmhkxuh")
    public suspend fun uniqueIpsLimitEnabled(`value`: Output<Boolean>) {
        this.uniqueIpsLimitEnabled = value
    }

    /**
     * @param value Maximum number of IPs per user.
     */
    @JvmName("npbxrakilkaulwyq")
    public suspend fun uniqueIpsLimitPerUser(`value`: Output<Int>) {
        this.uniqueIpsLimitPerUser = value
    }

    /**
     * @param value How many seconds an IP is counted towards the limit.
     */
    @JvmName("qwsvuwikksjphyom")
    public suspend fun uniqueIpsLimitTimeWindow(`value`: Output<Int>) {
        this.uniqueIpsLimitTimeWindow = value
    }

    /**
     * @param value Every week GitLab reports license usage back to GitLab, Inc.
     */
    @JvmName("niudpejqqqniogmt")
    public suspend fun usagePingEnabled(`value`: Output<Boolean>) {
        this.usagePingEnabled = value
    }

    /**
     * @param value Send an email to users upon account deactivation.
     */
    @JvmName("urndlgdofswxecng")
    public suspend fun userDeactivationEmailsEnabled(`value`: Output<Boolean>) {
        this.userDeactivationEmailsEnabled = value
    }

    /**
     * @param value Newly registered users are external by default.
     */
    @JvmName("olkgdbfjtuiwnqjo")
    public suspend fun userDefaultExternal(`value`: Output<Boolean>) {
        this.userDefaultExternal = value
    }

    /**
     * @param value Specify an email address regex pattern to identify default internal users.
     */
    @JvmName("boutswfeijarwpqu")
    public suspend fun userDefaultInternalRegex(`value`: Output<String>) {
        this.userDefaultInternalRegex = value
    }

    /**
     * @param value Allow users to register any application to use GitLab as an OAuth provider.
     */
    @JvmName("kevgqnyuinikcjly")
    public suspend fun userOauthApplications(`value`: Output<Boolean>) {
        this.userOauthApplications = value
    }

    /**
     * @param value When set to false disable the You won't be able to pull or push project code via SSH warning shown to users with no uploaded SSH key.
     */
    @JvmName("nlccqplceereyujx")
    public suspend fun userShowAddSshKeyMessage(`value`: Output<Boolean>) {
        this.userShowAddSshKeyMessage = value
    }

    /**
     * @param value Let GitLab inform you when an update is available.
     */
    @JvmName("wgvubskryowijult")
    public suspend fun versionCheckEnabled(`value`: Output<Boolean>) {
        this.versionCheckEnabled = value
    }

    /**
     * @param value Live Preview (allow live previews of JavaScript projects in the Web IDE using CodeSandbox Live Preview).
     */
    @JvmName("qrllxxehaonqpunm")
    public suspend fun webIdeClientsidePreviewEnabled(`value`: Output<Boolean>) {
        this.webIdeClientsidePreviewEnabled = value
    }

    /**
     * @param value What’s new variant, possible values: all*tiers, current*tier, and disabled.
     */
    @JvmName("kyqhoqtecudnnlfe")
    public suspend fun whatsNewVariant(`value`: Output<String>) {
        this.whatsNewVariant = value
    }

    /**
     * @param value Maximum wiki page content size in bytes. The minimum value is 1024 bytes.
     */
    @JvmName("vljqhpviuwdtdohn")
    public suspend fun wikiPageMaxContentBytes(`value`: Output<Int>) {
        this.wikiPageMaxContentBytes = value
    }

    /**
     * @param value If set, abuse reports are sent to this address. Abuse reports are always available in the Admin Area.
     */
    @JvmName("tsypedwftvtyaqmr")
    public suspend fun abuseNotificationEmail(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.abuseNotificationEmail = mapped
    }

    /**
     * @param value Require administrators to enable Admin Mode by re-authenticating for administrative tasks.
     */
    @JvmName("qnyubfbjijgbnetv")
    public suspend fun adminMode(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminMode = mapped
    }

    /**
     * @param value Where to redirect users after logout.
     */
    @JvmName("xvpsyrnvowtfxcph")
    public suspend fun afterSignOutPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.afterSignOutPath = mapped
    }

    /**
     * @param value Text shown to the user after signing up.
     */
    @JvmName("kqpfgypkbfalnabh")
    public suspend fun afterSignUpText(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.afterSignUpText = mapped
    }

    /**
     * @param value API key for Akismet spam protection.
     */
    @JvmName("noooduflymbauosu")
    public suspend fun akismetApiKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.akismetApiKey = mapped
    }

    /**
     * @param value (If enabled, requires: akismet*api*key) Enable or disable Akismet spam protection.
     */
    @JvmName("jxxfakwphlhbakvd")
    public suspend fun akismetEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.akismetEnabled = mapped
    }

    /**
     * @param value Set to true to allow users to delete their accounts. Premium and Ultimate only.
     */
    @JvmName("dpgwcrsryjnbcyds")
    public suspend fun allowAccountDeletion(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowAccountDeletion = mapped
    }

    /**
     * @param value Set to true to allow group owners to manage LDAP.
     */
    @JvmName("cmgejdwhcvbuysjn")
    public suspend fun allowGroupOwnersToManageLdap(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowGroupOwnersToManageLdap = mapped
    }

    /**
     * @param value Allow requests to the local network from system hooks.
     */
    @JvmName("ssqluxgogydntwdw")
    public suspend fun allowLocalRequestsFromSystemHooks(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowLocalRequestsFromSystemHooks = mapped
    }

    /**
     * @param value Allow requests to the local network from web hooks and services.
     */
    @JvmName("rsvypwkwwuowyxgl")
    public suspend fun allowLocalRequestsFromWebHooksAndServices(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowLocalRequestsFromWebHooksAndServices = mapped
    }

    /**
     * @param value Indicates whether users assigned up to the Guest role can create groups and personal projects.
     */
    @JvmName("xfbsopnqtdndehck")
    public suspend fun allowProjectCreationForGuestAndBelow(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowProjectCreationForGuestAndBelow = mapped
    }

    /**
     * @param value Allow using a registration token to create a runner.
     */
    @JvmName("hhxqghigpsxuugap")
    public suspend fun allowRunnerRegistrationToken(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowRunnerRegistrationToken = mapped
    }

    /**
     * @param value Set the duration for which the jobs are considered as old and expired. After that time passes, the jobs are archived and no longer able to be retried. Make it empty to never expire jobs. It has to be no less than 1 day, for example: 15 days, 1 month, 2 years.
     */
    @JvmName("sbmmrgmejymmhske")
    public suspend fun archiveBuildsInHumanReadable(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.archiveBuildsInHumanReadable = mapped
    }

    /**
     * @param value Maximum limit of AsciiDoc include directives being processed in any one document. Maximum: 64.
     */
    @JvmName("afmrkpiwsxppqqil")
    public suspend fun asciidocMaxIncludes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.asciidocMaxIncludes = mapped
    }

    /**
     * @param value Assets that match these domains are not proxied. Wildcards allowed. Your GitLab installation URL is automatically allowlisted. GitLab restart is required to apply changes.
     */
    @JvmName("oyvqtohliqlyrsmk")
    public suspend fun assetProxyAllowlists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assetProxyAllowlists = mapped
    }

    /**
     * @param values Assets that match these domains are not proxied. Wildcards allowed. Your GitLab installation URL is automatically allowlisted. GitLab restart is required to apply changes.
     */
    @JvmName("gthytiemaxvlighp")
    public suspend fun assetProxyAllowlists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.assetProxyAllowlists = mapped
    }

    /**
     * @param value (If enabled, requires: asset*proxy*url) Enable proxying of assets. GitLab restart is required to apply changes.
     */
    @JvmName("rdhcalxepwftvowr")
    public suspend fun assetProxyEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assetProxyEnabled = mapped
    }

    /**
     * @param value Shared secret with the asset proxy server. GitLab restart is required to apply changes.
     */
    @JvmName("bxpbcstjxuduibwp")
    public suspend fun assetProxySecretKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assetProxySecretKey = mapped
    }

    /**
     * @param value URL of the asset proxy server. GitLab restart is required to apply changes.
     */
    @JvmName("eervnfwhrvywrjgo")
    public suspend fun assetProxyUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assetProxyUrl = mapped
    }

    /**
     * @param value By default, we write to the authorized_keys file to support Git over SSH without additional configuration. GitLab can be optimized to authenticate SSH keys via the database file. Only disable this if you have configured your OpenSSH server to use the AuthorizedKeysCommand.
     */
    @JvmName("ectklfmwevmslspj")
    public suspend fun authorizedKeysEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizedKeysEnabled = mapped
    }

    /**
     * @param value When enabled, users will get automatically banned from the application when they download more than the maximum number of unique projects in the time period specified by max*number*of*repository*downloads and max*number*of*repository*downloads*within*time_period respectively. Introduced in GitLab 15.4. Self-managed, Ultimate only.
     */
    @JvmName("xrekhjgagxlkmqpx")
    public suspend fun autoBanUserOnExcessiveProjectsDownload(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoBanUserOnExcessiveProjectsDownload = mapped
    }

    /**
     * @param value Specify a domain to use by default for every project’s Auto Review Apps and Auto Deploy stages.
     */
    @JvmName("mcielgwxlxkgbhby")
    public suspend fun autoDevopsDomain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoDevopsDomain = mapped
    }

    /**
     * @param value Enable Auto DevOps for projects by default. It automatically builds, tests, and deploys applications based on a predefined CI/CD configuration.
     */
    @JvmName("hopstauqyikqypuk")
    public suspend fun autoDevopsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoDevopsEnabled = mapped
    }

    /**
     * @param value Enabling this permits automatic allocation of purchased storage in a namespace.
     */
    @JvmName("ibwciwfnxfoluoan")
    public suspend fun automaticPurchasedStorageAllocation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automaticPurchasedStorageAllocation = mapped
    }

    /**
     * @param value Maximum simultaneous Direct Transfer batches to process.
     */
    @JvmName("xcctdhmpgqpoqeft")
    public suspend fun bulkImportConcurrentPipelineBatchLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bulkImportConcurrentPipelineBatchLimit = mapped
    }

    /**
     * @param value Enable migrating GitLab groups by direct transfer. Introduced in GitLab 15.8.
     */
    @JvmName("slwyllptxfpmrqln")
    public suspend fun bulkImportEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bulkImportEnabled = mapped
    }

    /**
     * @param value Maximum download file size when importing from source GitLab instances by direct transfer. Introduced in GitLab 16.3.
     */
    @JvmName("shqyrtolimstjxbc")
    public suspend fun bulkImportMaxDownloadFileSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bulkImportMaxDownloadFileSize = mapped
    }

    /**
     * @param value Indicates whether users can create top-level groups. Introduced in GitLab 15.5.
     */
    @JvmName("jroniqjccsujtbyp")
    public suspend fun canCreateGroup(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.canCreateGroup = mapped
    }

    /**
     * @param value Enabling this makes only licensed EE features available to projects if the project namespace’s plan includes the feature or if the project is public.
     */
    @JvmName("wgsktopyyvlvjeoq")
    public suspend fun checkNamespacePlan(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.checkNamespacePlan = mapped
    }

    /**
     * @param value The maximum number of includes per pipeline.
     */
    @JvmName("sragnllfhuiqpsmh")
    public suspend fun ciMaxIncludes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ciMaxIncludes = mapped
    }

    /**
     * @param value The maximum amount of memory, in bytes, that can be allocated for the pipeline configuration, with all included YAML configuration files.
     */
    @JvmName("nigibdogemsqhbsd")
    public suspend fun ciMaxTotalYamlSizeBytes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ciMaxTotalYamlSizeBytes = mapped
    }

    /**
     * @param value Custom hostname (for private commit emails).
     */
    @JvmName("bexvyvgtxkwtroeb")
    public suspend fun commitEmailHostname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commitEmailHostname = mapped
    }

    /**
     * @param value Maximum number of simultaneous import jobs for the Bitbucket Cloud importer. Introduced in GitLab 16.11.
     */
    @JvmName("wksdceemceqfawcw")
    public suspend fun concurrentBitbucketImportJobsLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.concurrentBitbucketImportJobsLimit = mapped
    }

    /**
     * @param value Maximum number of simultaneous import jobs for the Bitbucket Server importer. Introduced in GitLab 16.11.
     */
    @JvmName("rxgbigmuymnpuann")
    public suspend fun concurrentBitbucketServerImportJobsLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.concurrentBitbucketServerImportJobsLimit = mapped
    }

    /**
     * @param value Maximum number of simultaneous import jobs for the GitHub importer. Introduced in GitLab 16.11.
     */
    @JvmName("usuuwtgveruqmpsw")
    public suspend fun concurrentGithubImportJobsLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.concurrentGithubImportJobsLimit = mapped
    }

    /**
     * @param value Enable cleanup policies for all projects.
     */
    @JvmName("lnylakhlwvpmatml")
    public suspend fun containerExpirationPoliciesEnableHistoricEntries(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerExpirationPoliciesEnableHistoricEntries = mapped
    }

    /**
     * @param value The maximum number of tags that can be deleted in a single execution of cleanup policies.
     */
    @JvmName("jtbedteprqhnkraw")
    public suspend fun containerRegistryCleanupTagsServiceMaxListSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerRegistryCleanupTagsServiceMaxListSize = mapped
    }

    /**
     * @param value The maximum time, in seconds, that the cleanup process can take to delete a batch of tags for cleanup policies.
     */
    @JvmName("wttwwihpngujdkgn")
    public suspend fun containerRegistryDeleteTagsServiceTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerRegistryDeleteTagsServiceTimeout = mapped
    }

    /**
     * @param value Caching during the execution of cleanup policies.
     */
    @JvmName("xvxndrjhinswsfhx")
    public suspend fun containerRegistryExpirationPoliciesCaching(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerRegistryExpirationPoliciesCaching = mapped
    }

    /**
     * @param value Number of workers for cleanup policies.
     */
    @JvmName("uhaicerlwnyqkosv")
    public suspend fun containerRegistryExpirationPoliciesWorkerCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerRegistryExpirationPoliciesWorkerCapacity = mapped
    }

    /**
     * @param value Container Registry token duration in minutes.
     */
    @JvmName("atkcppuwfrpnywmd")
    public suspend fun containerRegistryTokenExpireDelay(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerRegistryTokenExpireDelay = mapped
    }

    /**
     * @param value Enable automatic deactivation of dormant users.
     */
    @JvmName("vwntksxoadqjbdsj")
    public suspend fun deactivateDormantUsers(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deactivateDormantUsers = mapped
    }

    /**
     * @param value Length of time (in days) after which a user is considered dormant. Introduced in GitLab 15.3.
     */
    @JvmName("ssyiuognxvwdkapr")
    public suspend fun deactivateDormantUsersPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deactivateDormantUsersPeriod = mapped
    }

    /**
     * @param value Default timeout for decompressing archived files, in seconds. Set to 0 to disable timeouts. Introduced in GitLab 16.4.
     */
    @JvmName("axrvbesnpntgecop")
    public suspend fun decompressArchiveFileTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.decompressArchiveFileTimeout = mapped
    }

    /**
     * @param value Set the default expiration time for each job’s artifacts.
     */
    @JvmName("mnbrijqanpngdyiq")
    public suspend fun defaultArtifactsExpireIn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultArtifactsExpireIn = mapped
    }

    /**
     * @param value Instance-level custom initial branch name (introduced in GitLab 13.2).
     */
    @JvmName("uednwwgvyklhvyux")
    public suspend fun defaultBranchName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultBranchName = mapped
    }

    /**
     * @param value Determine if developers can push to the default branch. Can take: 0 (not protected, both users with the Developer role or Maintainer role can push new commits and force push), 1 (partially protected, users with the Developer role or Maintainer role can push new commits, but cannot force push) or 2 (fully protected, users with the Developer or Maintainer role cannot push new commits, but users with the Developer or Maintainer role can; no one can force push) as a parameter. Default is 2.
     */
    @JvmName("rafmrufmdqfbaorb")
    public suspend fun defaultBranchProtection(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultBranchProtection = mapped
    }

    /**
     * @param value The default*branch*protection*defaults attribute describes the default branch protection defaults. All parameters are optional.
     */
    @JvmName("fmbrqdsouroplrua")
    public suspend fun defaultBranchProtectionDefaults(`value`: ApplicationSettingsDefaultBranchProtectionDefaultsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultBranchProtectionDefaults = mapped
    }

    /**
     * @param argument The default*branch*protection*defaults attribute describes the default branch protection defaults. All parameters are optional.
     */
    @JvmName("heaubsibopsaumhk")
    public suspend fun defaultBranchProtectionDefaults(argument: suspend ApplicationSettingsDefaultBranchProtectionDefaultsArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationSettingsDefaultBranchProtectionDefaultsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.defaultBranchProtectionDefaults = mapped
    }

    /**
     * @param value Default CI/CD configuration file and path for new projects (.gitlab-ci.yml if not set).
     */
    @JvmName("mrenxbidprbabnmx")
    public suspend fun defaultCiConfigPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultCiConfigPath = mapped
    }

    /**
     * @param value What visibility level new groups receive. Can take private, internal and public as a parameter.
     */
    @JvmName("igetglxpplwrmmwj")
    public suspend fun defaultGroupVisibility(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultGroupVisibility = mapped
    }

    /**
     * @param value Default preferred language for users who are not logged in.
     */
    @JvmName("annrhthqcwmottmj")
    public suspend fun defaultPreferredLanguage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultPreferredLanguage = mapped
    }

    /**
     * @param value Default project creation protection. Can take: 0 (No one), 1 (Maintainers) or 2 (Developers + Maintainers).
     */
    @JvmName("srudkatnnxmknpyd")
    public suspend fun defaultProjectCreation(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultProjectCreation = mapped
    }

    /**
     * @param value What visibility level new projects receive. Can take private, internal and public as a parameter.
     */
    @JvmName("tpdsrnbpyanykilh")
    public suspend fun defaultProjectVisibility(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultProjectVisibility = mapped
    }

    /**
     * @param value Project limit per user.
     */
    @JvmName("qmxalbsupptweubu")
    public suspend fun defaultProjectsLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultProjectsLimit = mapped
    }

    /**
     * @param value What visibility level new snippets receive. Can take private, internal and public as a parameter.
     */
    @JvmName("vgbrdodnmupbomiy")
    public suspend fun defaultSnippetVisibility(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultSnippetVisibility = mapped
    }

    /**
     * @param value Default syntax highlighting theme for users who are new or not signed in. See IDs of available themes (https://gitlab.com/gitlab-org/gitlab/blob/master/lib/gitlab/themes.rb#L16)
     */
    @JvmName("lqwjpqlfgebixafn")
    public suspend fun defaultSyntaxHighlightingTheme(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultSyntaxHighlightingTheme = mapped
    }

    /**
     * @param value Enable inactive project deletion feature. Introduced in GitLab 14.10. Became operational in GitLab 15.0 (with feature flag inactive*projects*deletion).
     */
    @JvmName("vreyvinyycpqdfqt")
    public suspend fun deleteInactiveProjects(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteInactiveProjects = mapped
    }

    /**
     * @param value Specifies whether users who have not confirmed their email should be deleted. When set to true, unconfirmed users are deleted after unconfirmed*users*delete*after*days days. Introduced in GitLab 16.1. Self-managed, Premium and Ultimate only.
     */
    @JvmName("prurnfivqjsuboxx")
    public suspend fun deleteUnconfirmedUsers(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteUnconfirmedUsers = mapped
    }

    /**
     * @param value The number of days to wait before deleting a project or group that is marked for deletion. Value must be between 1 and 90.
     */
    @JvmName("eutnngnbpqwutvus")
    public suspend fun deletionAdjournedPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deletionAdjournedPeriod = mapped
    }

    /**
     * @param value (If enabled, requires diagramsnet_url) Enable Diagrams.net integration.
     */
    @JvmName("yqtykwmhmycthvxj")
    public suspend fun diagramsnetEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diagramsnetEnabled = mapped
    }

    /**
     * @param value The Diagrams.net instance URL for integration.
     */
    @JvmName("bvrrwoueincqutlj")
    public suspend fun diagramsnetUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diagramsnetUrl = mapped
    }

    /**
     * @param value Maximum files in a diff.
     */
    @JvmName("umpdwcsqnftjbcgx")
    public suspend fun diffMaxFiles(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diffMaxFiles = mapped
    }

    /**
     * @param value Maximum lines in a diff.
     */
    @JvmName("fygugtgkrrqlednv")
    public suspend fun diffMaxLines(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diffMaxLines = mapped
    }

    /**
     * @param value Maximum diff patch size, in bytes.
     */
    @JvmName("agnxgaekpeulnmil")
    public suspend fun diffMaxPatchBytes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diffMaxPatchBytes = mapped
    }

    /**
     * @param value Stops administrators from connecting their GitLab accounts to non-trusted OAuth 2.0 applications that have the api, read*api, read*repository, write*repository, read*registry, write_registry, or sudo scopes. Introduced in GitLab 15.6.
     */
    @JvmName("whemhkawveqsbseo")
    public suspend fun disableAdminOauthScopes(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableAdminOauthScopes = mapped
    }

    /**
     * @param value Disable display of RSS/Atom and calendar feed tokens (introduced in GitLab 13.7).
     */
    @JvmName("lypjlncjwnbkyidx")
    public suspend fun disableFeedToken(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableFeedToken = mapped
    }

    /**
     * @param value Disable personal access tokens. Introduced in GitLab 15.7. Self-managed, Premium and Ultimate only. There is no method available to enable a personal access token that’s been disabled through the API. This is a known issue.
     */
    @JvmName("acuwcqstgutoypdg")
    public suspend fun disablePersonalAccessTokens(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disablePersonalAccessTokens = mapped
    }

    /**
     * @param value Disabled OAuth sign-in sources.
     */
    @JvmName("olktwjkaiknkerwr")
    public suspend fun disabledOauthSignInSources(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disabledOauthSignInSources = mapped
    }

    /**
     * @param values Disabled OAuth sign-in sources.
     */
    @JvmName("lygaxidwenypmkut")
    public suspend fun disabledOauthSignInSources(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.disabledOauthSignInSources = mapped
    }

    /**
     * @param value Enforce DNS rebinding attack protection.
     */
    @JvmName("pgpljervhulrilum")
    public suspend fun dnsRebindingProtectionEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsRebindingProtectionEnabled = mapped
    }

    /**
     * @param value Force people to use only corporate emails for sign-up. Null means there is no restriction.
     */
    @JvmName("aondakawiloolcbh")
    public suspend fun domainAllowlists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainAllowlists = mapped
    }

    /**
     * @param values Force people to use only corporate emails for sign-up. Null means there is no restriction.
     */
    @JvmName("ptgnvbwkdpeukkpr")
    public suspend fun domainAllowlists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainAllowlists = mapped
    }

    /**
     * @param value (If enabled, requires: domain_denylist) Allows blocking sign-ups from emails from specific domains.
     */
    @JvmName("cmqxuwnhuknnvaje")
    public suspend fun domainDenylistEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainDenylistEnabled = mapped
    }

    /**
     * @param value Users with email addresses that match these domains cannot sign up. Wildcards allowed. Use separate lines for multiple entries. Ex: domain.com, *.domain.com.
     */
    @JvmName("kpdqslodlejkawmf")
    public suspend fun domainDenylists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainDenylists = mapped
    }

    /**
     * @param values Users with email addresses that match these domains cannot sign up. Wildcards allowed. Use separate lines for multiple entries. Ex: domain.com, *.domain.com.
     */
    @JvmName("mnfujksxxlkrkdqj")
    public suspend fun domainDenylists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainDenylists = mapped
    }

    /**
     * @param value Maximum downstream pipeline trigger rate. Introduced in GitLab 16.10.
     */
    @JvmName("kvmkehncvinonosu")
    public suspend fun downstreamPipelineTriggerLimitPerProjectUserSha(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.downstreamPipelineTriggerLimitPerProjectUserSha = mapped
    }

    /**
     * @param value The minimum allowed bit length of an uploaded DSA key. 0 means no restriction. -1 disables DSA keys.
     */
    @JvmName("roeyehepwprkyqqb")
    public suspend fun dsaKeyRestriction(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dsaKeyRestriction = mapped
    }

    /**
     * @param value Indicates whether GitLab Duo features are enabled for this instance. Introduced in GitLab 16.10. Self-managed, Premium and Ultimate only.
     */
    @JvmName("rwwmvytrbcvittdd")
    public suspend fun duoFeaturesEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.duoFeaturesEnabled = mapped
    }

    /**
     * @param value The minimum allowed curve size (in bits) of an uploaded ECDSA key. 0 means no restriction. -1 disables ECDSA keys.
     */
    @JvmName("sbidpxbyuggyqfwg")
    public suspend fun ecdsaKeyRestriction(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecdsaKeyRestriction = mapped
    }

    /**
     * @param value The minimum allowed curve size (in bits) of an uploaded ECDSA*SK key. 0 means no restriction. -1 disables ECDSA*SK keys.
     */
    @JvmName("mardrcmvnbrbtbef")
    public suspend fun ecdsaSkKeyRestriction(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecdsaSkKeyRestriction = mapped
    }

    /**
     * @param value The minimum allowed curve size (in bits) of an uploaded ED25519 key. 0 means no restriction. -1 disables ED25519 keys.
     */
    @JvmName("gswsvjvhjakmatvk")
    public suspend fun ed25519KeyRestriction(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ed25519KeyRestriction = mapped
    }

    /**
     * @param value The minimum allowed curve size (in bits) of an uploaded ED25519*SK key. 0 means no restriction. -1 disables ED25519*SK keys.
     */
    @JvmName("gsqhlrlaqnvexaca")
    public suspend fun ed25519SkKeyRestriction(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ed25519SkKeyRestriction = mapped
    }

    /**
     * @param value AWS IAM access key ID.
     */
    @JvmName("vbpqgycsklhsqcrm")
    public suspend fun eksAccessKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eksAccessKeyId = mapped
    }

    /**
     * @param value Amazon account ID.
     */
    @JvmName("fypdroxmspgklxln")
    public suspend fun eksAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eksAccountId = mapped
    }

    /**
     * @param value Enable integration with Amazon EKS.
     */
    @JvmName("nkxlfneffsgobrrv")
    public suspend fun eksIntegrationEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eksIntegrationEnabled = mapped
    }

    /**
     * @param value AWS IAM secret access key.
     */
    @JvmName("hqcsjrrvtnhcludt")
    public suspend fun eksSecretAccessKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eksSecretAccessKey = mapped
    }

    /**
     * @param value Enable the use of AWS hosted Elasticsearch.
     */
    @JvmName("tqtbkrvcjkyjtavd")
    public suspend fun elasticsearchAws(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticsearchAws = mapped
    }

    /**
     * @param value AWS IAM access key.
     */
    @JvmName("vnueydumlslmlxfe")
    public suspend fun elasticsearchAwsAccessKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticsearchAwsAccessKey = mapped
    }

    /**
     * @param value The AWS region the Elasticsearch domain is configured.
     */
    @JvmName("mlwgpyjxqfpruyis")
    public suspend fun elasticsearchAwsRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticsearchAwsRegion = mapped
    }

    /**
     * @param value AWS IAM secret access key.
     */
    @JvmName("uswctbkrrsbdfvsn")
    public suspend fun elasticsearchAwsSecretAccessKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticsearchAwsSecretAccessKey = mapped
    }

    /**
     * @param value Maximum size of text fields to index by Elasticsearch. 0 value means no limit. This does not apply to repository and wiki indexing.
     */
    @JvmName("raquuvrtoonxwceb")
    public suspend fun elasticsearchIndexedFieldLengthLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticsearchIndexedFieldLengthLimit = mapped
    }

    /**
     * @param value Maximum size of repository and wiki files that are indexed by Elasticsearch.
     */
    @JvmName("ggbotgyqodghawvo")
    public suspend fun elasticsearchIndexedFileSizeLimitKb(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticsearchIndexedFileSizeLimitKb = mapped
    }

    /**
     * @param value Enable Elasticsearch indexing.
     */
    @JvmName("yuvbpyduxsftsiml")
    public suspend fun elasticsearchIndexing(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticsearchIndexing = mapped
    }

    /**
     * @param value Limit Elasticsearch to index certain namespaces and projects.
     */
    @JvmName("tyuevhbttojvnwgu")
    public suspend fun elasticsearchLimitIndexing(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticsearchLimitIndexing = mapped
    }

    /**
     * @param value Maximum concurrency of Elasticsearch bulk requests per indexing operation. This only applies to repository indexing operations.
     */
    @JvmName("kvswbuctuolauhea")
    public suspend fun elasticsearchMaxBulkConcurrency(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticsearchMaxBulkConcurrency = mapped
    }

    /**
     * @param value Maximum size of Elasticsearch bulk indexing requests in MB. This only applies to repository indexing operations.
     */
    @JvmName("hyhipgqlhnfnbpjn")
    public suspend fun elasticsearchMaxBulkSizeMb(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticsearchMaxBulkSizeMb = mapped
    }

    /**
     * @param value The namespaces to index via Elasticsearch if elasticsearch*limit*indexing is enabled.
     */
    @JvmName("rrqtfmwiuvkwpgfq")
    public suspend fun elasticsearchNamespaceIds(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticsearchNamespaceIds = mapped
    }

    /**
     * @param values The namespaces to index via Elasticsearch if elasticsearch*limit*indexing is enabled.
     */
    @JvmName("sfyhhyrhdmcpblnv")
    public suspend fun elasticsearchNamespaceIds(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.elasticsearchNamespaceIds = mapped
    }

    /**
     * @param value The password of your Elasticsearch instance.
     */
    @JvmName("kiiwhjgdclbhdhjf")
    public suspend fun elasticsearchPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticsearchPassword = mapped
    }

    /**
     * @param value The projects to index via Elasticsearch if elasticsearch*limit*indexing is enabled.
     */
    @JvmName("oelehqgsqwpbwlke")
    public suspend fun elasticsearchProjectIds(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticsearchProjectIds = mapped
    }

    /**
     * @param values The projects to index via Elasticsearch if elasticsearch*limit*indexing is enabled.
     */
    @JvmName("slcggaabvoofndah")
    public suspend fun elasticsearchProjectIds(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.elasticsearchProjectIds = mapped
    }

    /**
     * @param value Enable Elasticsearch search.
     */
    @JvmName("nbxtrwdrggndnvwu")
    public suspend fun elasticsearchSearch(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticsearchSearch = mapped
    }

    /**
     * @param value The URL to use for connecting to Elasticsearch. Use a comma-separated list to support cluster (for example, http://localhost:9200, http://localhost:9201).
     */
    @JvmName("vuwsahsqcuqrgwjx")
    public suspend fun elasticsearchUrls(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticsearchUrls = mapped
    }

    /**
     * @param values The URL to use for connecting to Elasticsearch. Use a comma-separated list to support cluster (for example, http://localhost:9200, http://localhost:9201).
     */
    @JvmName("ygcxojaugwgatayl")
    public suspend fun elasticsearchUrls(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.elasticsearchUrls = mapped
    }

    /**
     * @param value The username of your Elasticsearch instance.
     */
    @JvmName("ichwvuowtkchdhdw")
    public suspend fun elasticsearchUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticsearchUsername = mapped
    }

    /**
     * @param value Additional text added to the bottom of every email for legal/auditing/compliance reasons.
     */
    @JvmName("theupjbycmturllq")
    public suspend fun emailAdditionalText(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailAdditionalText = mapped
    }

    /**
     * @param value Some email servers do not support overriding the email sender name. Enable this option to include the name of the author of the issue, merge request or comment in the email body instead.
     */
    @JvmName("bqpuelvwdkvfrjow")
    public suspend fun emailAuthorInBody(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailAuthorInBody = mapped
    }

    /**
     * @param value Enabled protocols for Git access. Allowed values are: ssh, http, and nil to allow both protocols.
     */
    @JvmName("kygafweshnxkpksf")
    public suspend fun enabledGitAccessProtocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledGitAccessProtocol = mapped
    }

    /**
     * @param value Enabling this permits enforcement of namespace storage limits.
     */
    @JvmName("lmqnwudlswouwnsa")
    public suspend fun enforceNamespaceStorageLimit(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enforceNamespaceStorageLimit = mapped
    }

    /**
     * @param value (If enabled, requires: terms) Enforce application ToS to all users.
     */
    @JvmName("egqebeotfjddrulr")
    public suspend fun enforceTerms(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enforceTerms = mapped
    }

    /**
     * @param value (If enabled, requires: external*auth*client_key) The certificate to use to authenticate with the external authorization service.
     */
    @JvmName("vhmghliaurrqvdcw")
    public suspend fun externalAuthClientCert(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalAuthClientCert = mapped
    }

    /**
     * @param value Private key for the certificate when authentication is required for the external authorization service, this is encrypted when stored.
     */
    @JvmName("yqsfnfyaevsjjwpe")
    public suspend fun externalAuthClientKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalAuthClientKey = mapped
    }

    /**
     * @param value Passphrase to use for the private key when authenticating with the external service this is encrypted when stored.
     */
    @JvmName("hougtdlhrypskapc")
    public suspend fun externalAuthClientKeyPass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalAuthClientKeyPass = mapped
    }

    /**
     * @param value The default classification label to use when requesting authorization and no classification label has been specified on the project.
     */
    @JvmName("lvfncboyrqiayvba")
    public suspend fun externalAuthorizationServiceDefaultLabel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalAuthorizationServiceDefaultLabel = mapped
    }

    /**
     * @param value (If enabled, requires: external*authorization*service*default*label, external*authorization*service*timeout and external*authorization*service*url) Enable using an external authorization service for accessing projects.
     */
    @JvmName("oqcnwigxfakheeas")
    public suspend fun externalAuthorizationServiceEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalAuthorizationServiceEnabled = mapped
    }

    /**
     * @param value The timeout after which an authorization request is aborted, in seconds. When a request times out, access is denied to the user. (min: 0.001, max: 10, step: 0.001).
     */
    @JvmName("rrmfvfrjycbjhkan")
    public suspend fun externalAuthorizationServiceTimeout(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalAuthorizationServiceTimeout = mapped
    }

    /**
     * @param value URL to which authorization requests are directed.
     */
    @JvmName("eyhhegkwasyflxbp")
    public suspend fun externalAuthorizationServiceUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalAuthorizationServiceUrl = mapped
    }

    /**
     * @param value How long to wait for a response from the pipeline validation service. Assumes OK if it times out.
     */
    @JvmName("wgmrjmmqubkwdydf")
    public suspend fun externalPipelineValidationServiceTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalPipelineValidationServiceTimeout = mapped
    }

    /**
     * @param value Optional. Token to include as the X-Gitlab-Token header in requests to the URL in external*pipeline*validation*service*url.
     */
    @JvmName("rrtydkkmmnxetytf")
    public suspend fun externalPipelineValidationServiceToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalPipelineValidationServiceToken = mapped
    }

    /**
     * @param value URL to use for pipeline validation requests.
     */
    @JvmName("rtwqtndaqhfuppob")
    public suspend fun externalPipelineValidationServiceUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalPipelineValidationServiceUrl = mapped
    }

    /**
     * @param value The ID of a project to load custom file templates from.
     */
    @JvmName("oywkhlivotwprulu")
    public suspend fun fileTemplateProjectId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileTemplateProjectId = mapped
    }

    /**
     * @param value Start day of the week for calendar views and date pickers. Valid values are 0 for Sunday, 1 for Monday, and 6 for Saturday.
     */
    @JvmName("tvbqxacccwqyqxiu")
    public suspend fun firstDayOfWeek(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firstDayOfWeek = mapped
    }

    /**
     * @param value Comma-separated list of IPs and CIDRs of allowed secondary nodes. For example, 1.1.1.1, 2.2.2.0/24.
     */
    @JvmName("mgishihbbdqsauxr")
    public suspend fun geoNodeAllowedIps(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.geoNodeAllowedIps = mapped
    }

    /**
     * @param value The amount of seconds after which a request to get a secondary node status times out.
     */
    @JvmName("dokbxuubptbsnoof")
    public suspend fun geoStatusTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.geoStatusTimeout = mapped
    }

    /**
     * @param value List of usernames excluded from Git anti-abuse rate limits. Maximum: 100 usernames. Introduced in GitLab 15.2.
     */
    @JvmName("jsngribfhcnrgsbi")
    public suspend fun gitRateLimitUsersAllowlists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gitRateLimitUsersAllowlists = mapped
    }

    /**
     * @param values List of usernames excluded from Git anti-abuse rate limits. Maximum: 100 usernames. Introduced in GitLab 15.2.
     */
    @JvmName("tqfsfemtatrfjyvl")
    public suspend fun gitRateLimitUsersAllowlists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.gitRateLimitUsersAllowlists = mapped
    }

    /**
     * @param value Maximum duration (in minutes) of a session for Git operations when 2FA is enabled.
     */
    @JvmName("oehrbyjbvmvcdnsv")
    public suspend fun gitTwoFactorSessionExpiry(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gitTwoFactorSessionExpiry = mapped
    }

    /**
     * @param value Default Gitaly timeout, in seconds. This timeout is not enforced for Git fetch/push operations or Sidekiq jobs. Set to 0 to disable timeouts.
     */
    @JvmName("yspbwjnajnghaahd")
    public suspend fun gitalyTimeoutDefault(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gitalyTimeoutDefault = mapped
    }

    /**
     * @param value Gitaly fast operation timeout, in seconds. Some Gitaly operations are expected to be fast. If they exceed this threshold, there may be a problem with a storage shard and ‘failing fast’ can help maintain the stability of the GitLab instance. Set to 0 to disable timeouts.
     */
    @JvmName("bwxmwdwnjqcldrpj")
    public suspend fun gitalyTimeoutFast(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gitalyTimeoutFast = mapped
    }

    /**
     * @param value Medium Gitaly timeout, in seconds. This should be a value between the Fast and the Default timeout. Set to 0 to disable timeouts.
     */
    @JvmName("txgbreovrykdmqjc")
    public suspend fun gitalyTimeoutMedium(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gitalyTimeoutMedium = mapped
    }

    /**
     * @param value Enable Grafana.
     */
    @JvmName("lbhuiufuplfadkre")
    public suspend fun grafanaEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.grafanaEnabled = mapped
    }

    /**
     * @param value Grafana URL.
     */
    @JvmName("qbimblujaamqbxwe")
    public suspend fun grafanaUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.grafanaUrl = mapped
    }

    /**
     * @param value Enable Gravatar.
     */
    @JvmName("yknihdrqysmmqpbm")
    public suspend fun gravatarEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gravatarEnabled = mapped
    }

    /**
     * @param value Prevent overrides of default branch protection.
     */
    @JvmName("ytsnqsvexwbaeupu")
    public suspend fun groupOwnersCanManageDefaultBranchProtection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupOwnersCanManageDefaultBranchProtection = mapped
    }

    /**
     * @param value Create new projects using hashed storage paths: Enable immutable, hash-based paths and repository names to store repositories on disk. This prevents repositories from having to be moved or renamed when the Project URL changes and may improve disk I/O performance. (Always enabled in GitLab versions 13.0 and later, configuration is scheduled for removal in 14.0).
     */
    @JvmName("ceyrnmeaakdnrxbs")
    public suspend fun hashedStorageEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hashedStorageEnabled = mapped
    }

    /**
     * @param value Hide marketing-related entries from help.
     */
    @JvmName("ssadwnpvsvwvnkek")
    public suspend fun helpPageHideCommercialContent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.helpPageHideCommercialContent = mapped
    }

    /**
     * @param value Alternate support URL for help page and help dropdown.
     */
    @JvmName("rbbuugwexyqjygdu")
    public suspend fun helpPageSupportUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.helpPageSupportUrl = mapped
    }

    /**
     * @param value Custom text displayed on the help page.
     */
    @JvmName("vewoealawxrdiors")
    public suspend fun helpPageText(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.helpPageText = mapped
    }

    /**
     * @param value GitLab server administrator information.
     */
    @JvmName("yvyjwnlrnrhefbfl")
    public suspend fun helpText(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.helpText = mapped
    }

    /**
     * @param value Do not display offers from third parties in GitLab.
     */
    @JvmName("bigganikgdlkkmck")
    public suspend fun hideThirdPartyOffers(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hideThirdPartyOffers = mapped
    }

    /**
     * @param value Redirect to this URL when not logged in.
     */
    @JvmName("frqsgkhsnsweqpru")
    public suspend fun homePageUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.homePageUrl = mapped
    }

    /**
     * @param value Enable or disable Git housekeeping.
     * 			If enabled, requires either housekeeping*optimize*repository*period OR housekeeping*bitmaps*enabled, housekeeping*full*repack*period, housekeeping*gc*period, and housekeeping*incremental*repack*period.
     * 			Options housekeeping*bitmaps*enabled, housekeeping*full*repack*period, housekeeping*gc*period, and housekeeping*incremental*repack*period are deprecated. Use housekeeping*optimize*repository*period instead.
     */
    @JvmName("xmetsspcyajxglxn")
    public suspend fun housekeepingEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.housekeepingEnabled = mapped
    }

    /**
     * @param value Number of Git pushes after which an incremental git repack is run.
     */
    @Deprecated(
        message = """
  housekeeping_full_repack_period is deprecated. Use housekeeping_optimize_repository_period
      instead.
  """,
    )
    @JvmName("ltttcnlaikauyjqx")
    public suspend fun housekeepingFullRepackPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.housekeepingFullRepackPeriod = mapped
    }

    /**
     * @param value Number of Git pushes after which git gc is run.
     */
    @Deprecated(
        message = """
  housekeeping_gc_period is deprecated. Use housekeeping_optimize_repository_period instead.
  """,
    )
    @JvmName("jeajjmrfcixwavpu")
    public suspend fun housekeepingGcPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.housekeepingGcPeriod = mapped
    }

    /**
     * @param value Number of Git pushes after which an incremental git repack is run.
     */
    @Deprecated(
        message = """
  housekeeping_incremental_repack_period is deprecated. Use housekeeping_optimize_repository_period
      instead.
  """,
    )
    @JvmName("tfsvlpcoqpguopvj")
    public suspend fun housekeepingIncrementalRepackPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.housekeepingIncrementalRepackPeriod = mapped
    }

    /**
     * @param value Number of Git pushes after which an incremental git repack is run.
     */
    @JvmName("kxsswjcijqhckpnl")
    public suspend fun housekeepingOptimizeRepositoryPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.housekeepingOptimizeRepositoryPeriod = mapped
    }

    /**
     * @param value Enable HTML emails.
     */
    @JvmName("tqodahtgqtkrkmpd")
    public suspend fun htmlEmailsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.htmlEmailsEnabled = mapped
    }

    /**
     * @param value Sources to allow project import from. Valid values are: `github`, `bitbucket`, `bitbucket_server`, `fogbugz`, `git`, `gitlab.Project`, `gitea`, `manifest`
     */
    @JvmName("gelwjiypmvbbrprr")
    public suspend fun importSources(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.importSources = mapped
    }

    /**
     * @param values Sources to allow project import from. Valid values are: `github`, `bitbucket`, `bitbucket_server`, `fogbugz`, `git`, `gitlab.Project`, `gitea`, `manifest`
     */
    @JvmName("yjcxkgwfyobelmfm")
    public suspend fun importSources(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.importSources = mapped
    }

    /**
     * @param value Enable in-product marketing emails.
     */
    @JvmName("gubephixiwefkchf")
    public suspend fun inProductMarketingEmailsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inProductMarketingEmailsEnabled = mapped
    }

    /**
     * @param value If delete*inactive*projects is true, the time (in months) to wait before deleting inactive projects. Introduced in GitLab 14.10. Became operational in GitLab 15.0.
     */
    @JvmName("jxpngmaolmfdmaiy")
    public suspend fun inactiveProjectsDeleteAfterMonths(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inactiveProjectsDeleteAfterMonths = mapped
    }

    /**
     * @param value If delete*inactive*projects is true, the minimum repository size for projects to be checked for inactivity. Introduced in GitLab 14.10. Became operational in GitLab 15.0.
     */
    @JvmName("pioemdhfjwwvoxin")
    public suspend fun inactiveProjectsMinSizeMb(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inactiveProjectsMinSizeMb = mapped
    }

    /**
     * @param value If delete*inactive*projects is true, sets the time (in months) to wait before emailing maintainers that the project is scheduled be deleted because it is inactive. Introduced in GitLab 14.10. Became operational in GitLab 15.0.
     */
    @JvmName("qchduodqxnyyohek")
    public suspend fun inactiveProjectsSendWarningEmailAfterMonths(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inactiveProjectsSendWarningEmailAfterMonths = mapped
    }

    /**
     * @param value Enable Invisible CAPTCHA spam detection during sign-up.
     */
    @JvmName("omiltnvsnrlwabjn")
    public suspend fun invisibleCaptchaEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.invisibleCaptchaEnabled = mapped
    }

    /**
     * @param value Max number of issue creation requests per minute per user.
     */
    @JvmName("nvosxqhbbnwexbjr")
    public suspend fun issuesCreateLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issuesCreateLimit = mapped
    }

    /**
     * @param value Prevent the deletion of the artifacts from the most recent successful jobs, regardless of the expiry time.
     */
    @JvmName("smhimoelabxrlhya")
    public suspend fun keepLatestArtifact(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keepLatestArtifact = mapped
    }

    /**
     * @param value Increase this value when any cached Markdown should be invalidated.
     */
    @JvmName("fqtlkvmoqmrydivb")
    public suspend fun localMarkdownVersion(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localMarkdownVersion = mapped
    }

    /**
     * @param value Enable Mailgun event receiver.
     */
    @JvmName("nhmdfenmicislwgl")
    public suspend fun mailgunEventsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mailgunEventsEnabled = mapped
    }

    /**
     * @param value The Mailgun HTTP webhook signing key for receiving events from webhook.
     */
    @JvmName("gcnthxsklygkbapo")
    public suspend fun mailgunSigningKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mailgunSigningKey = mapped
    }

    /**
     * @param value When instance is in maintenance mode, non-administrative users can sign in with read-only access and make read-only API requests.
     */
    @JvmName("hjolpwcawvyfxexo")
    public suspend fun maintenanceMode(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintenanceMode = mapped
    }

    /**
     * @param value Message displayed when instance is in maintenance mode.
     */
    @JvmName("stafimqaavhkcsus")
    public suspend fun maintenanceModeMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintenanceModeMessage = mapped
    }

    /**
     * @param value Maximum artifacts size in MB.
     */
    @JvmName("sdehwvbumhrjetee")
    public suspend fun maxArtifactsSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxArtifactsSize = mapped
    }

    /**
     * @param value Limit attachment size in MB.
     */
    @JvmName("aylboofpcsxbywtp")
    public suspend fun maxAttachmentSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxAttachmentSize = mapped
    }

    /**
     * @param value Maximum export size in MB. 0 for unlimited.
     */
    @JvmName("yrgjxpgxfycndtqf")
    public suspend fun maxExportSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxExportSize = mapped
    }

    /**
     * @param value Maximum import size in MB. 0 for unlimited.
     */
    @JvmName("rfejvtkskrnwnfgq")
    public suspend fun maxImportSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxImportSize = mapped
    }

    /**
     * @param value Maximum number of unique repositories a user can download in the specified time period before they are banned. Maximum: 10,000 repositories. Introduced in GitLab 15.1.
     */
    @JvmName("rinvewqkgepbqyso")
    public suspend fun maxNumberOfRepositoryDownloads(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxNumberOfRepositoryDownloads = mapped
    }

    /**
     * @param value Reporting time period (in seconds). Maximum: 864000 seconds (10 days). Introduced in GitLab 15.1.
     */
    @JvmName("jmrpprasnifqpjco")
    public suspend fun maxNumberOfRepositoryDownloadsWithinTimePeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxNumberOfRepositoryDownloadsWithinTimePeriod = mapped
    }

    /**
     * @param value Maximum size of pages repositories in MB.
     */
    @JvmName("xrduarwvxeogwwjb")
    public suspend fun maxPagesSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxPagesSize = mapped
    }

    /**
     * @param value Maximum allowable lifetime for access tokens in days.
     */
    @JvmName("fdirpfuoekjgtfro")
    public suspend fun maxPersonalAccessTokenLifetime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxPersonalAccessTokenLifetime = mapped
    }

    /**
     * @param value Maximum allowable lifetime for SSH keys in days. Introduced in GitLab 14.6.
     */
    @JvmName("qnjwbourxoxinsln")
    public suspend fun maxSshKeyLifetime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxSshKeyLifetime = mapped
    }

    /**
     * @param value
     */
    @JvmName("lhtxjspbqgbuhchi")
    public suspend fun maxTerraformStateSizeBytes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxTerraformStateSizeBytes = mapped
    }

    /**
     * @param value A method call is only tracked when it takes longer than the given amount of milliseconds.
     */
    @JvmName("kjvrkhkuvtonxyxk")
    public suspend fun metricsMethodCallThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricsMethodCallThreshold = mapped
    }

    /**
     * @param value Indicates whether passwords require a minimum length. Introduced in GitLab 15.1. Premium and Ultimate only.
     */
    @JvmName("dxagbcwoxsfgkjnc")
    public suspend fun minimumPasswordLength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimumPasswordLength = mapped
    }

    /**
     * @param value Allow repository mirroring to configured by project Maintainers. If disabled, only Administrators can configure repository mirroring.
     */
    @JvmName("aaonsjtlhsuwxsrr")
    public suspend fun mirrorAvailable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mirrorAvailable = mapped
    }

    /**
     * @param value Minimum capacity to be available before scheduling more mirrors preemptively.
     */
    @JvmName("mvwpebqhfcuthmfv")
    public suspend fun mirrorCapacityThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mirrorCapacityThreshold = mapped
    }

    /**
     * @param value Maximum number of mirrors that can be synchronizing at the same time.
     */
    @JvmName("ivlpdkbxmokfxvoq")
    public suspend fun mirrorMaxCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mirrorMaxCapacity = mapped
    }

    /**
     * @param value Maximum time (in minutes) between updates that a mirror can have when scheduled to synchronize.
     */
    @JvmName("fewyyibqjnyanydw")
    public suspend fun mirrorMaxDelay(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mirrorMaxDelay = mapped
    }

    /**
     * @param value Use npmjs.org as a default remote repository when the package is not found in the GitLab Package Registry for npm.
     */
    @JvmName("ovuvpqdaydqkrvub")
    public suspend fun npmPackageRequestsForwarding(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.npmPackageRequestsForwarding = mapped
    }

    /**
     * @param value Define a list of trusted domains or IP addresses to which local requests are allowed when local requests for hooks and services are disabled.
     */
    @JvmName("cjvcxcgbaccfgihv")
    public suspend fun outboundLocalRequestsWhitelists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outboundLocalRequestsWhitelists = mapped
    }

    /**
     * @param values Define a list of trusted domains or IP addresses to which local requests are allowed when local requests for hooks and services are disabled.
     */
    @JvmName("npumwltgrmsdcowb")
    public suspend fun outboundLocalRequestsWhitelists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outboundLocalRequestsWhitelists = mapped
    }

    /**
     * @param value Number of workers assigned to the packages cleanup policies.
     */
    @JvmName("dxxuscnnhrrsbhsv")
    public suspend fun packageRegistryCleanupPoliciesWorkerCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageRegistryCleanupPoliciesWorkerCapacity = mapped
    }

    /**
     * @param value Require users to prove ownership of custom domains. Domain verification is an essential security measure for public GitLab sites. Users are required to demonstrate they control a domain before it is enabled.
     */
    @JvmName("ebckmhcldslkcssi")
    public suspend fun pagesDomainVerificationEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pagesDomainVerificationEnabled = mapped
    }

    /**
     * @param value Enable authentication for Git over HTTP(S) via a GitLab account password.
     */
    @JvmName("vydktmisdvhweciv")
    public suspend fun passwordAuthenticationEnabledForGit(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordAuthenticationEnabledForGit = mapped
    }

    /**
     * @param value Enable authentication for the web interface via a GitLab account password.
     */
    @JvmName("ndirbhxpmfkgtpik")
    public suspend fun passwordAuthenticationEnabledForWeb(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordAuthenticationEnabledForWeb = mapped
    }

    /**
     * @param value Indicates whether passwords require at least one lowercase letter. Introduced in GitLab 15.1.
     */
    @JvmName("npoxjjcytjpxkpps")
    public suspend fun passwordLowercaseRequired(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordLowercaseRequired = mapped
    }

    /**
     * @param value Indicates whether passwords require at least one number. Introduced in GitLab 15.1.
     */
    @JvmName("xgcrhsmogxkcnfgb")
    public suspend fun passwordNumberRequired(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordNumberRequired = mapped
    }

    /**
     * @param value Indicates whether passwords require at least one symbol character. Introduced in GitLab 15.1.
     */
    @JvmName("ivxfotdsqxfmdbgy")
    public suspend fun passwordSymbolRequired(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordSymbolRequired = mapped
    }

    /**
     * @param value Indicates whether passwords require at least one uppercase letter. Introduced in GitLab 15.1.
     */
    @JvmName("bgaovpdhcpugwcij")
    public suspend fun passwordUppercaseRequired(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordUppercaseRequired = mapped
    }

    /**
     * @param value Path of the group that is allowed to toggle the performance bar.
     */
    @JvmName("uulodjmhkbstpfnc")
    public suspend fun performanceBarAllowedGroupPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.performanceBarAllowedGroupPath = mapped
    }

    /**
     * @param value Prefix for all generated personal access tokens.
     */
    @JvmName("maaqxkvhbgnjhfxy")
    public suspend fun personalAccessTokenPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.personalAccessTokenPrefix = mapped
    }

    /**
     * @param value Maximum number of pipeline creation requests per minute per user and commit.
     */
    @JvmName("lgldobisnjmfblul")
    public suspend fun pipelineLimitPerProjectUserSha(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineLimitPerProjectUserSha = mapped
    }

    /**
     * @param value (If enabled, requires: plantuml_url) Enable PlantUML integration.
     */
    @JvmName("avntsbjghmotwykl")
    public suspend fun plantumlEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plantumlEnabled = mapped
    }

    /**
     * @param value The PlantUML instance URL for integration.
     */
    @JvmName("totudivrugshkuwm")
    public suspend fun plantumlUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plantumlUrl = mapped
    }

    /**
     * @param value Interval multiplier used by endpoints that perform polling. Set to 0 to disable polling.
     */
    @JvmName("hjbfdoubggarvjsy")
    public suspend fun pollingIntervalMultiplier(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pollingIntervalMultiplier = mapped
    }

    /**
     * @param value Enable project export.
     */
    @JvmName("eosfdcalwsvhdnbl")
    public suspend fun projectExportEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectExportEnabled = mapped
    }

    /**
     * @param value Enable Prometheus metrics.
     */
    @JvmName("liglmmfgxrhaigna")
    public suspend fun prometheusMetricsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prometheusMetricsEnabled = mapped
    }

    /**
     * @param value CI/CD variables are protected by default.
     */
    @JvmName("nllxgtqqppcfsihc")
    public suspend fun protectedCiVariables(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedCiVariables = mapped
    }

    /**
     * @param value Number of changes (branches or tags) in a single push to determine whether individual push events or bulk push events are created. Bulk push events are created if it surpasses that value.
     */
    @JvmName("evukvmhmtsdqyqwe")
    public suspend fun pushEventActivitiesLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pushEventActivitiesLimit = mapped
    }

    /**
     * @param value Number of changes (branches or tags) in a single push to determine whether webhooks and services fire or not. Webhooks and services aren’t submitted if it surpasses that value.
     */
    @JvmName("lqdphulkgcqiqgph")
    public suspend fun pushEventHooksLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pushEventHooksLimit = mapped
    }

    /**
     * @param value Use pypi.org as a default remote repository when the package is not found in the GitLab Package Registry for PyPI.
     */
    @JvmName("ojxqcdqjgctffjqq")
    public suspend fun pypiPackageRequestsForwarding(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pypiPackageRequestsForwarding = mapped
    }

    /**
     * @param value When rate limiting is enabled via the throttle_* settings, send this plain text response when a rate limit is exceeded. ‘Retry later’ is sent if this is blank.
     */
    @JvmName("vudtyefhunkpybfy")
    public suspend fun rateLimitingResponseText(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rateLimitingResponseText = mapped
    }

    /**
     * @param value Max number of requests per minute for each raw path. To disable throttling set to 0.
     */
    @JvmName("gwivxxdektbogwrc")
    public suspend fun rawBlobRequestLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rawBlobRequestLimit = mapped
    }

    /**
     * @param value (If enabled, requires: recaptcha*private*key and recaptcha*site*key) Enable reCAPTCHA.
     */
    @JvmName("shiounormdtqosbw")
    public suspend fun recaptchaEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recaptchaEnabled = mapped
    }

    /**
     * @param value Private key for reCAPTCHA.
     */
    @JvmName("coxcxmdjtnlgqrcs")
    public suspend fun recaptchaPrivateKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recaptchaPrivateKey = mapped
    }

    /**
     * @param value Site key for reCAPTCHA.
     */
    @JvmName("lyknjkwbramywjyi")
    public suspend fun recaptchaSiteKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recaptchaSiteKey = mapped
    }

    /**
     * @param value Maximum push size (MB).
     */
    @JvmName("gohtopektcyixlyv")
    public suspend fun receiveMaxInputSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.receiveMaxInputSize = mapped
    }

    /**
     * @param value GitLab periodically runs git fsck in all project and wiki repositories to look for silent disk corruption issues.
     */
    @JvmName("ihixewsqdbbcplgv")
    public suspend fun repositoryChecksEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositoryChecksEnabled = mapped
    }

    /**
     * @param value Size limit per repository (MB).
     */
    @JvmName("vsrtoefpcwreqmst")
    public suspend fun repositorySizeLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositorySizeLimit = mapped
    }

    /**
     * @param value (GitLab 13.0 and earlier) List of names of enabled storage paths, taken from gitlab.yml. New projects are created in one of these stores, chosen at random.
     */
    @JvmName("dwiqsuyobeceuqay")
    public suspend fun repositoryStorages(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositoryStorages = mapped
    }

    /**
     * @param values (GitLab 13.0 and earlier) List of names of enabled storage paths, taken from gitlab.yml. New projects are created in one of these stores, chosen at random.
     */
    @JvmName("bvivirgxgmbfkcej")
    public suspend fun repositoryStorages(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repositoryStorages = mapped
    }

    /**
     * @param value (GitLab 13.1 and later) Hash of names of taken from gitlab.yml to weights. New projects are created in one of these stores, chosen by a weighted random selection.
     */
    @JvmName("khtasncccdcbvenx")
    public suspend fun repositoryStoragesWeighted(`value`: Map<String, Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositoryStoragesWeighted = mapped
    }

    /**
     * @param values (GitLab 13.1 and later) Hash of names of taken from gitlab.yml to weights. New projects are created in one of these stores, chosen by a weighted random selection.
     */
    @JvmName("eihttdnapnkjvfjc")
    public fun repositoryStoragesWeighted(vararg values: Pair<String, Int>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repositoryStoragesWeighted = mapped
    }

    /**
     * @param value When enabled, any user that signs up for an account using the registration form is placed under a Pending approval state and has to be explicitly approved by an administrator.
     */
    @JvmName("qteckshtganfoasf")
    public suspend fun requireAdminApprovalAfterUserSignup(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireAdminApprovalAfterUserSignup = mapped
    }

    /**
     * @param value (If enabled, requires: two*factor*grace_period) Require all users to set up Two-factor authentication.
     */
    @JvmName("whepifnepmrvsrat")
    public suspend fun requireTwoFactorAuthentication(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireTwoFactorAuthentication = mapped
    }

    /**
     * @param value Selected levels cannot be used by non-Administrator users for groups, projects or snippets. Can take private, internal and public as a parameter. Null means there is no restriction.
     */
    @JvmName("gdajtnenxvxttxvv")
    public suspend fun restrictedVisibilityLevels(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restrictedVisibilityLevels = mapped
    }

    /**
     * @param values Selected levels cannot be used by non-Administrator users for groups, projects or snippets. Can take private, internal and public as a parameter. Null means there is no restriction.
     */
    @JvmName("vaulepaevfshvsnr")
    public suspend fun restrictedVisibilityLevels(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.restrictedVisibilityLevels = mapped
    }

    /**
     * @param value The minimum allowed bit length of an uploaded RSA key. 0 means no restriction. -1 disables RSA keys.
     */
    @JvmName("mgdlcebsrnneerpw")
    public suspend fun rsaKeyRestriction(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rsaKeyRestriction = mapped
    }

    /**
     * @param value Max number of requests per minute for performing a search while authenticated. To disable throttling set to 0.
     */
    @JvmName("myonocnrwftjxvfe")
    public suspend fun searchRateLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.searchRateLimit = mapped
    }

    /**
     * @param value Max number of requests per minute for performing a search while unauthenticated. To disable throttling set to 0.
     */
    @JvmName("dmxwlrnelpfolvmx")
    public suspend fun searchRateLimitUnauthenticated(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.searchRateLimitUnauthenticated = mapped
    }

    /**
     * @param value Send confirmation email on sign-up.
     */
    @JvmName("jhvnfkbegsluqgdj")
    public suspend fun sendUserConfirmationEmail(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sendUserConfirmationEmail = mapped
    }

    /**
     * @param value Session duration in minutes. GitLab restart is required to apply changes.
     */
    @JvmName("retafkuwlmvkvwlh")
    public suspend fun sessionExpireDelay(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionExpireDelay = mapped
    }

    /**
     * @param value (If enabled, requires: shared*runners*text and shared*runners*minutes) Enable shared runners for new projects.
     */
    @JvmName("caifdbfxikiayniv")
    public suspend fun sharedRunnersEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedRunnersEnabled = mapped
    }

    /**
     * @param value Set the maximum number of CI/CD minutes that a group can use on shared runners per month.
     */
    @JvmName("pixnhihgjtfvqfgh")
    public suspend fun sharedRunnersMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedRunnersMinutes = mapped
    }

    /**
     * @param value Shared runners text.
     */
    @JvmName("bbusjaxogjcyuuti")
    public suspend fun sharedRunnersText(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedRunnersText = mapped
    }

    /**
     * @param value The threshold in bytes at which Sidekiq jobs are compressed before being stored in Redis.
     */
    @JvmName("clgscgfgoygmlcvf")
    public suspend fun sidekiqJobLimiterCompressionThresholdBytes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sidekiqJobLimiterCompressionThresholdBytes = mapped
    }

    /**
     * @param value The threshold in bytes at which Sidekiq jobs are rejected. 0 means do not reject any job.
     */
    @JvmName("rjgaoolaukftoecf")
    public suspend fun sidekiqJobLimiterLimitBytes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sidekiqJobLimiterLimitBytes = mapped
    }

    /**
     * @param value track or compress. Sets the behavior for Sidekiq job size limits.
     */
    @JvmName("deacygfgepplmnsu")
    public suspend fun sidekiqJobLimiterMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sidekiqJobLimiterMode = mapped
    }

    /**
     * @param value Text on the login page.
     */
    @JvmName("tevuhljkcrwxqejb")
    public suspend fun signInText(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.signInText = mapped
    }

    /**
     * @param value Enable registration.
     */
    @JvmName("dawjfevdwhlhqyuo")
    public suspend fun signupEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.signupEnabled = mapped
    }

    /**
     * @param value (If enabled, requires: slack*app*id, slack*app*secret and slack*app*secret) Enable Slack app.
     */
    @JvmName("vxbkuhjcbxckfetr")
    public suspend fun slackAppEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slackAppEnabled = mapped
    }

    /**
     * @param value The app ID of the Slack-app.
     */
    @JvmName("ucusejhlgalcnmxq")
    public suspend fun slackAppId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slackAppId = mapped
    }

    /**
     * @param value The app secret of the Slack-app.
     */
    @JvmName("cigpvpglkfofwfxq")
    public suspend fun slackAppSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slackAppSecret = mapped
    }

    /**
     * @param value The signing secret of the Slack-app.
     */
    @JvmName("ffreckdmjkugsquw")
    public suspend fun slackAppSigningSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slackAppSigningSecret = mapped
    }

    /**
     * @param value The verification token of the Slack-app.
     */
    @JvmName("nserxaxcwdqsisee")
    public suspend fun slackAppVerificationToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slackAppVerificationToken = mapped
    }

    /**
     * @param value Max snippet content size in bytes.
     */
    @JvmName("gtnkyowspqttkxxi")
    public suspend fun snippetSizeLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snippetSizeLimit = mapped
    }

    /**
     * @param value The Snowplow site name / application ID. (for example, gitlab)
     */
    @JvmName("cyaqeilsgouqkfdq")
    public suspend fun snowplowAppId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snowplowAppId = mapped
    }

    /**
     * @param value The Snowplow collector hostname. (for example, snowplow.trx.gitlab.net)
     */
    @JvmName("nwtwcqagljnovrln")
    public suspend fun snowplowCollectorHostname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snowplowCollectorHostname = mapped
    }

    /**
     * @param value The Snowplow cookie domain. (for example, .gitlab.com)
     */
    @JvmName("jcrwhmcgnhyjbket")
    public suspend fun snowplowCookieDomain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snowplowCookieDomain = mapped
    }

    /**
     * @param value Enable snowplow tracking.
     */
    @JvmName("dypfytwkebcqcvmr")
    public suspend fun snowplowEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snowplowEnabled = mapped
    }

    /**
     * @param value Enables Sourcegraph integration. If enabled, requires sourcegraph_url.
     */
    @JvmName("etcultjjmrtbmxsu")
    public suspend fun sourcegraphEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourcegraphEnabled = mapped
    }

    /**
     * @param value Blocks Sourcegraph from being loaded on private and internal projects.
     */
    @JvmName("odalxcwkptctgont")
    public suspend fun sourcegraphPublicOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourcegraphPublicOnly = mapped
    }

    /**
     * @param value The Sourcegraph instance URL for integration.
     */
    @JvmName("xhsoqqqslaprsaan")
    public suspend fun sourcegraphUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourcegraphUrl = mapped
    }

    /**
     * @param value API key used by GitLab for accessing the Spam Check service endpoint.
     */
    @JvmName("nebejttyhcyqgraa")
    public suspend fun spamCheckApiKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spamCheckApiKey = mapped
    }

    /**
     * @param value Enables spam checking using external Spam Check API endpoint.
     */
    @JvmName("quvurwywtabmnsns")
    public suspend fun spamCheckEndpointEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spamCheckEndpointEnabled = mapped
    }

    /**
     * @param value URL of the external Spamcheck service endpoint. Valid URI schemes are grpc or tls. Specifying tls forces communication to be encrypted.
     */
    @JvmName("ydhfdpklvsxyejib")
    public suspend fun spamCheckEndpointUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spamCheckEndpointUrl = mapped
    }

    /**
     * @param value Enable pipeline suggestion banner.
     */
    @JvmName("djrqfsjcmnbimeaw")
    public suspend fun suggestPipelineEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.suggestPipelineEnabled = mapped
    }

    /**
     * @param value Maximum time for web terminal websocket connection (in seconds). Set to 0 for unlimited time.
     */
    @JvmName("bbvkmxdxxwkqbchs")
    public suspend fun terminalMaxSessionTime(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.terminalMaxSessionTime = mapped
    }

    /**
     * @param value (Required by: enforce_terms) Markdown content for the ToS.
     */
    @JvmName("bvcedvntasucwnck")
    public suspend fun terms(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.terms = mapped
    }

    /**
     * @param value (If enabled, requires: throttle*authenticated*api*period*in*seconds and throttle*authenticated*api*requests*per*period) Enable authenticated API request rate limit. Helps reduce request volume (for example, from crawlers or abusive bots).
     */
    @JvmName("bfjverdtufqwppgq")
    public suspend fun throttleAuthenticatedApiEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throttleAuthenticatedApiEnabled = mapped
    }

    /**
     * @param value Rate limit period (in seconds).
     */
    @JvmName("oogpbnvgfcmxqawh")
    public suspend fun throttleAuthenticatedApiPeriodInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throttleAuthenticatedApiPeriodInSeconds = mapped
    }

    /**
     * @param value Maximum requests per period per user.
     */
    @JvmName("ajxrrcgewkexhlbu")
    public suspend fun throttleAuthenticatedApiRequestsPerPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throttleAuthenticatedApiRequestsPerPeriod = mapped
    }

    /**
     * @param value (If enabled, requires: throttle*authenticated*packages*api*period*in*seconds and throttle*authenticated*packages*api*requests*per*period) Enable authenticated API request rate limit. Helps reduce request volume (for example, from crawlers or abusive bots). View Package Registry rate limits for more details.
     */
    @JvmName("soypnximdkrodkys")
    public suspend fun throttleAuthenticatedPackagesApiEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throttleAuthenticatedPackagesApiEnabled = mapped
    }

    /**
     * @param value Rate limit period (in seconds). View Package Registry rate limits for more details.
     */
    @JvmName("kkkvprdwgtcfhfph")
    public suspend fun throttleAuthenticatedPackagesApiPeriodInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throttleAuthenticatedPackagesApiPeriodInSeconds = mapped
    }

    /**
     * @param value Maximum requests per period per user. View Package Registry rate limits for more details.
     */
    @JvmName("xemygvssgpgmvrwu")
    public suspend fun throttleAuthenticatedPackagesApiRequestsPerPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throttleAuthenticatedPackagesApiRequestsPerPeriod = mapped
    }

    /**
     * @param value (If enabled, requires: throttle*authenticated*web*period*in*seconds and throttle*authenticated*web*requests*per*period) Enable authenticated web request rate limit. Helps reduce request volume (for example, from crawlers or abusive bots).
     */
    @JvmName("jupewgolfiorywlr")
    public suspend fun throttleAuthenticatedWebEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throttleAuthenticatedWebEnabled = mapped
    }

    /**
     * @param value Rate limit period (in seconds).
     */
    @JvmName("cojthhihspndmjbe")
    public suspend fun throttleAuthenticatedWebPeriodInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throttleAuthenticatedWebPeriodInSeconds = mapped
    }

    /**
     * @param value Maximum requests per period per user.
     */
    @JvmName("orpyeuyaqvmkxgix")
    public suspend fun throttleAuthenticatedWebRequestsPerPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throttleAuthenticatedWebRequestsPerPeriod = mapped
    }

    /**
     * @param value (If enabled, requires: throttle*unauthenticated*api*period*in*seconds and throttle*unauthenticated*api*requests*per*period) Enable unauthenticated API request rate limit. Helps reduce request volume (for example, from crawlers or abusive bots).
     */
    @JvmName("tixkhdhvpxxvslqt")
    public suspend fun throttleUnauthenticatedApiEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throttleUnauthenticatedApiEnabled = mapped
    }

    /**
     * @param value Rate limit period in seconds.
     */
    @JvmName("qkstispqjdxapayk")
    public suspend fun throttleUnauthenticatedApiPeriodInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throttleUnauthenticatedApiPeriodInSeconds = mapped
    }

    /**
     * @param value Max requests per period per IP.
     */
    @JvmName("eoahqwnvkqxxlybb")
    public suspend fun throttleUnauthenticatedApiRequestsPerPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throttleUnauthenticatedApiRequestsPerPeriod = mapped
    }

    /**
     * @param value (If enabled, requires: throttle*unauthenticated*packages*api*period*in*seconds and throttle*unauthenticated*packages*api*requests*per*period) Enable authenticated API request rate limit. Helps reduce request volume (for example, from crawlers or abusive bots). View Package Registry rate limits for more details.
     */
    @JvmName("abiexugkghffvuix")
    public suspend fun throttleUnauthenticatedPackagesApiEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throttleUnauthenticatedPackagesApiEnabled = mapped
    }

    /**
     * @param value Rate limit period (in seconds). View Package Registry rate limits for more details.
     */
    @JvmName("ibcwmflixfjrlftc")
    public suspend fun throttleUnauthenticatedPackagesApiPeriodInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throttleUnauthenticatedPackagesApiPeriodInSeconds = mapped
    }

    /**
     * @param value Maximum requests per period per user. View Package Registry rate limits for more details.
     */
    @JvmName("hvyfxuodeaervbka")
    public suspend fun throttleUnauthenticatedPackagesApiRequestsPerPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throttleUnauthenticatedPackagesApiRequestsPerPeriod = mapped
    }

    /**
     * @param value (If enabled, requires: throttle*unauthenticated*web*period*in*seconds and throttle*unauthenticated*web*requests*per*period) Enable unauthenticated web request rate limit. Helps reduce request volume (for example, from crawlers or abusive bots).
     */
    @JvmName("cnyiuulusueskkbw")
    public suspend fun throttleUnauthenticatedWebEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throttleUnauthenticatedWebEnabled = mapped
    }

    /**
     * @param value Rate limit period in seconds.
     */
    @JvmName("ehcxvcfavcqstlns")
    public suspend fun throttleUnauthenticatedWebPeriodInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throttleUnauthenticatedWebPeriodInSeconds = mapped
    }

    /**
     * @param value Max requests per period per IP.
     */
    @JvmName("oteacqfwxlkeuvne")
    public suspend fun throttleUnauthenticatedWebRequestsPerPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throttleUnauthenticatedWebRequestsPerPeriod = mapped
    }

    /**
     * @param value Limit display of time tracking units to hours.
     */
    @JvmName("bfurwlnxaokmkrje")
    public suspend fun timeTrackingLimitToHours(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeTrackingLimitToHours = mapped
    }

    /**
     * @param value Amount of time (in hours) that users are allowed to skip forced configuration of two-factor authentication.
     */
    @JvmName("kawuwtmnylujtccj")
    public suspend fun twoFactorGracePeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.twoFactorGracePeriod = mapped
    }

    /**
     * @param value (If enabled, requires: unique*ips*limit*per*user and unique*ips*limit*time*window) Limit sign in from multiple IPs.
     */
    @JvmName("aaqoplwlwxriwtwt")
    public suspend fun uniqueIpsLimitEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uniqueIpsLimitEnabled = mapped
    }

    /**
     * @param value Maximum number of IPs per user.
     */
    @JvmName("txrfswisxlgnmvhg")
    public suspend fun uniqueIpsLimitPerUser(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uniqueIpsLimitPerUser = mapped
    }

    /**
     * @param value How many seconds an IP is counted towards the limit.
     */
    @JvmName("kibnoxypttufaace")
    public suspend fun uniqueIpsLimitTimeWindow(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uniqueIpsLimitTimeWindow = mapped
    }

    /**
     * @param value Every week GitLab reports license usage back to GitLab, Inc.
     */
    @JvmName("laqqdimugpkumeav")
    public suspend fun usagePingEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usagePingEnabled = mapped
    }

    /**
     * @param value Send an email to users upon account deactivation.
     */
    @JvmName("tmhwnaawntgrvrqf")
    public suspend fun userDeactivationEmailsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userDeactivationEmailsEnabled = mapped
    }

    /**
     * @param value Newly registered users are external by default.
     */
    @JvmName("syiglwgakogrcsog")
    public suspend fun userDefaultExternal(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userDefaultExternal = mapped
    }

    /**
     * @param value Specify an email address regex pattern to identify default internal users.
     */
    @JvmName("xmcbilwkqohvnqnb")
    public suspend fun userDefaultInternalRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userDefaultInternalRegex = mapped
    }

    /**
     * @param value Allow users to register any application to use GitLab as an OAuth provider.
     */
    @JvmName("amactuepsrimlagy")
    public suspend fun userOauthApplications(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userOauthApplications = mapped
    }

    /**
     * @param value When set to false disable the You won't be able to pull or push project code via SSH warning shown to users with no uploaded SSH key.
     */
    @JvmName("ajuxdunshlbrqyow")
    public suspend fun userShowAddSshKeyMessage(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userShowAddSshKeyMessage = mapped
    }

    /**
     * @param value Let GitLab inform you when an update is available.
     */
    @JvmName("fjhwdesdchcxrwav")
    public suspend fun versionCheckEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionCheckEnabled = mapped
    }

    /**
     * @param value Live Preview (allow live previews of JavaScript projects in the Web IDE using CodeSandbox Live Preview).
     */
    @JvmName("bvtwrctcsvwiygbn")
    public suspend fun webIdeClientsidePreviewEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webIdeClientsidePreviewEnabled = mapped
    }

    /**
     * @param value What’s new variant, possible values: all*tiers, current*tier, and disabled.
     */
    @JvmName("obcbvgolfvbtqvpn")
    public suspend fun whatsNewVariant(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.whatsNewVariant = mapped
    }

    /**
     * @param value Maximum wiki page content size in bytes. The minimum value is 1024 bytes.
     */
    @JvmName("vctkmudvpkvhlusj")
    public suspend fun wikiPageMaxContentBytes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wikiPageMaxContentBytes = mapped
    }

    internal fun build(): ApplicationSettingsArgs = ApplicationSettingsArgs(
        abuseNotificationEmail = abuseNotificationEmail,
        adminMode = adminMode,
        afterSignOutPath = afterSignOutPath,
        afterSignUpText = afterSignUpText,
        akismetApiKey = akismetApiKey,
        akismetEnabled = akismetEnabled,
        allowAccountDeletion = allowAccountDeletion,
        allowGroupOwnersToManageLdap = allowGroupOwnersToManageLdap,
        allowLocalRequestsFromSystemHooks = allowLocalRequestsFromSystemHooks,
        allowLocalRequestsFromWebHooksAndServices = allowLocalRequestsFromWebHooksAndServices,
        allowProjectCreationForGuestAndBelow = allowProjectCreationForGuestAndBelow,
        allowRunnerRegistrationToken = allowRunnerRegistrationToken,
        archiveBuildsInHumanReadable = archiveBuildsInHumanReadable,
        asciidocMaxIncludes = asciidocMaxIncludes,
        assetProxyAllowlists = assetProxyAllowlists,
        assetProxyEnabled = assetProxyEnabled,
        assetProxySecretKey = assetProxySecretKey,
        assetProxyUrl = assetProxyUrl,
        authorizedKeysEnabled = authorizedKeysEnabled,
        autoBanUserOnExcessiveProjectsDownload = autoBanUserOnExcessiveProjectsDownload,
        autoDevopsDomain = autoDevopsDomain,
        autoDevopsEnabled = autoDevopsEnabled,
        automaticPurchasedStorageAllocation = automaticPurchasedStorageAllocation,
        bulkImportConcurrentPipelineBatchLimit = bulkImportConcurrentPipelineBatchLimit,
        bulkImportEnabled = bulkImportEnabled,
        bulkImportMaxDownloadFileSize = bulkImportMaxDownloadFileSize,
        canCreateGroup = canCreateGroup,
        checkNamespacePlan = checkNamespacePlan,
        ciMaxIncludes = ciMaxIncludes,
        ciMaxTotalYamlSizeBytes = ciMaxTotalYamlSizeBytes,
        commitEmailHostname = commitEmailHostname,
        concurrentBitbucketImportJobsLimit = concurrentBitbucketImportJobsLimit,
        concurrentBitbucketServerImportJobsLimit = concurrentBitbucketServerImportJobsLimit,
        concurrentGithubImportJobsLimit = concurrentGithubImportJobsLimit,
        containerExpirationPoliciesEnableHistoricEntries = containerExpirationPoliciesEnableHistoricEntries,
        containerRegistryCleanupTagsServiceMaxListSize = containerRegistryCleanupTagsServiceMaxListSize,
        containerRegistryDeleteTagsServiceTimeout = containerRegistryDeleteTagsServiceTimeout,
        containerRegistryExpirationPoliciesCaching = containerRegistryExpirationPoliciesCaching,
        containerRegistryExpirationPoliciesWorkerCapacity = containerRegistryExpirationPoliciesWorkerCapacity,
        containerRegistryTokenExpireDelay = containerRegistryTokenExpireDelay,
        deactivateDormantUsers = deactivateDormantUsers,
        deactivateDormantUsersPeriod = deactivateDormantUsersPeriod,
        decompressArchiveFileTimeout = decompressArchiveFileTimeout,
        defaultArtifactsExpireIn = defaultArtifactsExpireIn,
        defaultBranchName = defaultBranchName,
        defaultBranchProtection = defaultBranchProtection,
        defaultBranchProtectionDefaults = defaultBranchProtectionDefaults,
        defaultCiConfigPath = defaultCiConfigPath,
        defaultGroupVisibility = defaultGroupVisibility,
        defaultPreferredLanguage = defaultPreferredLanguage,
        defaultProjectCreation = defaultProjectCreation,
        defaultProjectVisibility = defaultProjectVisibility,
        defaultProjectsLimit = defaultProjectsLimit,
        defaultSnippetVisibility = defaultSnippetVisibility,
        defaultSyntaxHighlightingTheme = defaultSyntaxHighlightingTheme,
        deleteInactiveProjects = deleteInactiveProjects,
        deleteUnconfirmedUsers = deleteUnconfirmedUsers,
        deletionAdjournedPeriod = deletionAdjournedPeriod,
        diagramsnetEnabled = diagramsnetEnabled,
        diagramsnetUrl = diagramsnetUrl,
        diffMaxFiles = diffMaxFiles,
        diffMaxLines = diffMaxLines,
        diffMaxPatchBytes = diffMaxPatchBytes,
        disableAdminOauthScopes = disableAdminOauthScopes,
        disableFeedToken = disableFeedToken,
        disablePersonalAccessTokens = disablePersonalAccessTokens,
        disabledOauthSignInSources = disabledOauthSignInSources,
        dnsRebindingProtectionEnabled = dnsRebindingProtectionEnabled,
        domainAllowlists = domainAllowlists,
        domainDenylistEnabled = domainDenylistEnabled,
        domainDenylists = domainDenylists,
        downstreamPipelineTriggerLimitPerProjectUserSha = downstreamPipelineTriggerLimitPerProjectUserSha,
        dsaKeyRestriction = dsaKeyRestriction,
        duoFeaturesEnabled = duoFeaturesEnabled,
        ecdsaKeyRestriction = ecdsaKeyRestriction,
        ecdsaSkKeyRestriction = ecdsaSkKeyRestriction,
        ed25519KeyRestriction = ed25519KeyRestriction,
        ed25519SkKeyRestriction = ed25519SkKeyRestriction,
        eksAccessKeyId = eksAccessKeyId,
        eksAccountId = eksAccountId,
        eksIntegrationEnabled = eksIntegrationEnabled,
        eksSecretAccessKey = eksSecretAccessKey,
        elasticsearchAws = elasticsearchAws,
        elasticsearchAwsAccessKey = elasticsearchAwsAccessKey,
        elasticsearchAwsRegion = elasticsearchAwsRegion,
        elasticsearchAwsSecretAccessKey = elasticsearchAwsSecretAccessKey,
        elasticsearchIndexedFieldLengthLimit = elasticsearchIndexedFieldLengthLimit,
        elasticsearchIndexedFileSizeLimitKb = elasticsearchIndexedFileSizeLimitKb,
        elasticsearchIndexing = elasticsearchIndexing,
        elasticsearchLimitIndexing = elasticsearchLimitIndexing,
        elasticsearchMaxBulkConcurrency = elasticsearchMaxBulkConcurrency,
        elasticsearchMaxBulkSizeMb = elasticsearchMaxBulkSizeMb,
        elasticsearchNamespaceIds = elasticsearchNamespaceIds,
        elasticsearchPassword = elasticsearchPassword,
        elasticsearchProjectIds = elasticsearchProjectIds,
        elasticsearchSearch = elasticsearchSearch,
        elasticsearchUrls = elasticsearchUrls,
        elasticsearchUsername = elasticsearchUsername,
        emailAdditionalText = emailAdditionalText,
        emailAuthorInBody = emailAuthorInBody,
        enabledGitAccessProtocol = enabledGitAccessProtocol,
        enforceNamespaceStorageLimit = enforceNamespaceStorageLimit,
        enforceTerms = enforceTerms,
        externalAuthClientCert = externalAuthClientCert,
        externalAuthClientKey = externalAuthClientKey,
        externalAuthClientKeyPass = externalAuthClientKeyPass,
        externalAuthorizationServiceDefaultLabel = externalAuthorizationServiceDefaultLabel,
        externalAuthorizationServiceEnabled = externalAuthorizationServiceEnabled,
        externalAuthorizationServiceTimeout = externalAuthorizationServiceTimeout,
        externalAuthorizationServiceUrl = externalAuthorizationServiceUrl,
        externalPipelineValidationServiceTimeout = externalPipelineValidationServiceTimeout,
        externalPipelineValidationServiceToken = externalPipelineValidationServiceToken,
        externalPipelineValidationServiceUrl = externalPipelineValidationServiceUrl,
        fileTemplateProjectId = fileTemplateProjectId,
        firstDayOfWeek = firstDayOfWeek,
        geoNodeAllowedIps = geoNodeAllowedIps,
        geoStatusTimeout = geoStatusTimeout,
        gitRateLimitUsersAllowlists = gitRateLimitUsersAllowlists,
        gitTwoFactorSessionExpiry = gitTwoFactorSessionExpiry,
        gitalyTimeoutDefault = gitalyTimeoutDefault,
        gitalyTimeoutFast = gitalyTimeoutFast,
        gitalyTimeoutMedium = gitalyTimeoutMedium,
        grafanaEnabled = grafanaEnabled,
        grafanaUrl = grafanaUrl,
        gravatarEnabled = gravatarEnabled,
        groupOwnersCanManageDefaultBranchProtection = groupOwnersCanManageDefaultBranchProtection,
        hashedStorageEnabled = hashedStorageEnabled,
        helpPageHideCommercialContent = helpPageHideCommercialContent,
        helpPageSupportUrl = helpPageSupportUrl,
        helpPageText = helpPageText,
        helpText = helpText,
        hideThirdPartyOffers = hideThirdPartyOffers,
        homePageUrl = homePageUrl,
        housekeepingEnabled = housekeepingEnabled,
        housekeepingFullRepackPeriod = housekeepingFullRepackPeriod,
        housekeepingGcPeriod = housekeepingGcPeriod,
        housekeepingIncrementalRepackPeriod = housekeepingIncrementalRepackPeriod,
        housekeepingOptimizeRepositoryPeriod = housekeepingOptimizeRepositoryPeriod,
        htmlEmailsEnabled = htmlEmailsEnabled,
        importSources = importSources,
        inProductMarketingEmailsEnabled = inProductMarketingEmailsEnabled,
        inactiveProjectsDeleteAfterMonths = inactiveProjectsDeleteAfterMonths,
        inactiveProjectsMinSizeMb = inactiveProjectsMinSizeMb,
        inactiveProjectsSendWarningEmailAfterMonths = inactiveProjectsSendWarningEmailAfterMonths,
        invisibleCaptchaEnabled = invisibleCaptchaEnabled,
        issuesCreateLimit = issuesCreateLimit,
        keepLatestArtifact = keepLatestArtifact,
        localMarkdownVersion = localMarkdownVersion,
        mailgunEventsEnabled = mailgunEventsEnabled,
        mailgunSigningKey = mailgunSigningKey,
        maintenanceMode = maintenanceMode,
        maintenanceModeMessage = maintenanceModeMessage,
        maxArtifactsSize = maxArtifactsSize,
        maxAttachmentSize = maxAttachmentSize,
        maxExportSize = maxExportSize,
        maxImportSize = maxImportSize,
        maxNumberOfRepositoryDownloads = maxNumberOfRepositoryDownloads,
        maxNumberOfRepositoryDownloadsWithinTimePeriod = maxNumberOfRepositoryDownloadsWithinTimePeriod,
        maxPagesSize = maxPagesSize,
        maxPersonalAccessTokenLifetime = maxPersonalAccessTokenLifetime,
        maxSshKeyLifetime = maxSshKeyLifetime,
        maxTerraformStateSizeBytes = maxTerraformStateSizeBytes,
        metricsMethodCallThreshold = metricsMethodCallThreshold,
        minimumPasswordLength = minimumPasswordLength,
        mirrorAvailable = mirrorAvailable,
        mirrorCapacityThreshold = mirrorCapacityThreshold,
        mirrorMaxCapacity = mirrorMaxCapacity,
        mirrorMaxDelay = mirrorMaxDelay,
        npmPackageRequestsForwarding = npmPackageRequestsForwarding,
        outboundLocalRequestsWhitelists = outboundLocalRequestsWhitelists,
        packageRegistryCleanupPoliciesWorkerCapacity = packageRegistryCleanupPoliciesWorkerCapacity,
        pagesDomainVerificationEnabled = pagesDomainVerificationEnabled,
        passwordAuthenticationEnabledForGit = passwordAuthenticationEnabledForGit,
        passwordAuthenticationEnabledForWeb = passwordAuthenticationEnabledForWeb,
        passwordLowercaseRequired = passwordLowercaseRequired,
        passwordNumberRequired = passwordNumberRequired,
        passwordSymbolRequired = passwordSymbolRequired,
        passwordUppercaseRequired = passwordUppercaseRequired,
        performanceBarAllowedGroupPath = performanceBarAllowedGroupPath,
        personalAccessTokenPrefix = personalAccessTokenPrefix,
        pipelineLimitPerProjectUserSha = pipelineLimitPerProjectUserSha,
        plantumlEnabled = plantumlEnabled,
        plantumlUrl = plantumlUrl,
        pollingIntervalMultiplier = pollingIntervalMultiplier,
        projectExportEnabled = projectExportEnabled,
        prometheusMetricsEnabled = prometheusMetricsEnabled,
        protectedCiVariables = protectedCiVariables,
        pushEventActivitiesLimit = pushEventActivitiesLimit,
        pushEventHooksLimit = pushEventHooksLimit,
        pypiPackageRequestsForwarding = pypiPackageRequestsForwarding,
        rateLimitingResponseText = rateLimitingResponseText,
        rawBlobRequestLimit = rawBlobRequestLimit,
        recaptchaEnabled = recaptchaEnabled,
        recaptchaPrivateKey = recaptchaPrivateKey,
        recaptchaSiteKey = recaptchaSiteKey,
        receiveMaxInputSize = receiveMaxInputSize,
        repositoryChecksEnabled = repositoryChecksEnabled,
        repositorySizeLimit = repositorySizeLimit,
        repositoryStorages = repositoryStorages,
        repositoryStoragesWeighted = repositoryStoragesWeighted,
        requireAdminApprovalAfterUserSignup = requireAdminApprovalAfterUserSignup,
        requireTwoFactorAuthentication = requireTwoFactorAuthentication,
        restrictedVisibilityLevels = restrictedVisibilityLevels,
        rsaKeyRestriction = rsaKeyRestriction,
        searchRateLimit = searchRateLimit,
        searchRateLimitUnauthenticated = searchRateLimitUnauthenticated,
        sendUserConfirmationEmail = sendUserConfirmationEmail,
        sessionExpireDelay = sessionExpireDelay,
        sharedRunnersEnabled = sharedRunnersEnabled,
        sharedRunnersMinutes = sharedRunnersMinutes,
        sharedRunnersText = sharedRunnersText,
        sidekiqJobLimiterCompressionThresholdBytes = sidekiqJobLimiterCompressionThresholdBytes,
        sidekiqJobLimiterLimitBytes = sidekiqJobLimiterLimitBytes,
        sidekiqJobLimiterMode = sidekiqJobLimiterMode,
        signInText = signInText,
        signupEnabled = signupEnabled,
        slackAppEnabled = slackAppEnabled,
        slackAppId = slackAppId,
        slackAppSecret = slackAppSecret,
        slackAppSigningSecret = slackAppSigningSecret,
        slackAppVerificationToken = slackAppVerificationToken,
        snippetSizeLimit = snippetSizeLimit,
        snowplowAppId = snowplowAppId,
        snowplowCollectorHostname = snowplowCollectorHostname,
        snowplowCookieDomain = snowplowCookieDomain,
        snowplowEnabled = snowplowEnabled,
        sourcegraphEnabled = sourcegraphEnabled,
        sourcegraphPublicOnly = sourcegraphPublicOnly,
        sourcegraphUrl = sourcegraphUrl,
        spamCheckApiKey = spamCheckApiKey,
        spamCheckEndpointEnabled = spamCheckEndpointEnabled,
        spamCheckEndpointUrl = spamCheckEndpointUrl,
        suggestPipelineEnabled = suggestPipelineEnabled,
        terminalMaxSessionTime = terminalMaxSessionTime,
        terms = terms,
        throttleAuthenticatedApiEnabled = throttleAuthenticatedApiEnabled,
        throttleAuthenticatedApiPeriodInSeconds = throttleAuthenticatedApiPeriodInSeconds,
        throttleAuthenticatedApiRequestsPerPeriod = throttleAuthenticatedApiRequestsPerPeriod,
        throttleAuthenticatedPackagesApiEnabled = throttleAuthenticatedPackagesApiEnabled,
        throttleAuthenticatedPackagesApiPeriodInSeconds = throttleAuthenticatedPackagesApiPeriodInSeconds,
        throttleAuthenticatedPackagesApiRequestsPerPeriod = throttleAuthenticatedPackagesApiRequestsPerPeriod,
        throttleAuthenticatedWebEnabled = throttleAuthenticatedWebEnabled,
        throttleAuthenticatedWebPeriodInSeconds = throttleAuthenticatedWebPeriodInSeconds,
        throttleAuthenticatedWebRequestsPerPeriod = throttleAuthenticatedWebRequestsPerPeriod,
        throttleUnauthenticatedApiEnabled = throttleUnauthenticatedApiEnabled,
        throttleUnauthenticatedApiPeriodInSeconds = throttleUnauthenticatedApiPeriodInSeconds,
        throttleUnauthenticatedApiRequestsPerPeriod = throttleUnauthenticatedApiRequestsPerPeriod,
        throttleUnauthenticatedPackagesApiEnabled = throttleUnauthenticatedPackagesApiEnabled,
        throttleUnauthenticatedPackagesApiPeriodInSeconds = throttleUnauthenticatedPackagesApiPeriodInSeconds,
        throttleUnauthenticatedPackagesApiRequestsPerPeriod = throttleUnauthenticatedPackagesApiRequestsPerPeriod,
        throttleUnauthenticatedWebEnabled = throttleUnauthenticatedWebEnabled,
        throttleUnauthenticatedWebPeriodInSeconds = throttleUnauthenticatedWebPeriodInSeconds,
        throttleUnauthenticatedWebRequestsPerPeriod = throttleUnauthenticatedWebRequestsPerPeriod,
        timeTrackingLimitToHours = timeTrackingLimitToHours,
        twoFactorGracePeriod = twoFactorGracePeriod,
        uniqueIpsLimitEnabled = uniqueIpsLimitEnabled,
        uniqueIpsLimitPerUser = uniqueIpsLimitPerUser,
        uniqueIpsLimitTimeWindow = uniqueIpsLimitTimeWindow,
        usagePingEnabled = usagePingEnabled,
        userDeactivationEmailsEnabled = userDeactivationEmailsEnabled,
        userDefaultExternal = userDefaultExternal,
        userDefaultInternalRegex = userDefaultInternalRegex,
        userOauthApplications = userOauthApplications,
        userShowAddSshKeyMessage = userShowAddSshKeyMessage,
        versionCheckEnabled = versionCheckEnabled,
        webIdeClientsidePreviewEnabled = webIdeClientsidePreviewEnabled,
        whatsNewVariant = whatsNewVariant,
        wikiPageMaxContentBytes = wikiPageMaxContentBytes,
    )
}
