@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.gitlab.kotlin.outputs.BranchCommit
import com.pulumi.gitlab.kotlin.outputs.BranchCommit.Companion.toKotlin
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [Branch].
 */
@PulumiTagMarker
public class BranchResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BranchArgs = BranchArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BranchArgsBuilder.() -> Unit) {
        val builder = BranchArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Branch {
        val builtJavaResource = com.pulumi.gitlab.Branch(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Branch(builtJavaResource)
    }
}

/**
 * The `gitlab.Branch` resource allows to manage the lifecycle of a repository branch.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/branches.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * // Create a project for the branch to use
 * const example = new gitlab.Project("example", {
 *     name: "example",
 *     description: "An example project",
 *     namespaceId: exampleGitlabGroup.id,
 * });
 * const exampleBranch = new gitlab.Branch("example", {
 *     name: "example",
 *     ref: "main",
 *     project: example.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * # Create a project for the branch to use
 * example = gitlab.Project("example",
 *     name="example",
 *     description="An example project",
 *     namespace_id=example_gitlab_group["id"])
 * example_branch = gitlab.Branch("example",
 *     name="example",
 *     ref="main",
 *     project=example.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a project for the branch to use
 *     var example = new GitLab.Project("example", new()
 *     {
 *         Name = "example",
 *         Description = "An example project",
 *         NamespaceId = exampleGitlabGroup.Id,
 *     });
 *     var exampleBranch = new GitLab.Branch("example", new()
 *     {
 *         Name = "example",
 *         Ref = "main",
 *         Project = example.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a project for the branch to use
 * 		example, err := gitlab.NewProject(ctx, "example", &gitlab.ProjectArgs{
 * 			Name:        pulumi.String("example"),
 * 			Description: pulumi.String("An example project"),
 * 			NamespaceId: pulumi.Any(exampleGitlabGroup.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewBranch(ctx, "example", &gitlab.BranchArgs{
 * 			Name:    pulumi.String("example"),
 * 			Ref:     pulumi.String("main"),
 * 			Project: example.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.Branch;
 * import com.pulumi.gitlab.BranchArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a project for the branch to use
 *         var example = new Project("example", ProjectArgs.builder()
 *             .name("example")
 *             .description("An example project")
 *             .namespaceId(exampleGitlabGroup.id())
 *             .build());
 *         var exampleBranch = new Branch("exampleBranch", BranchArgs.builder()
 *             .name("example")
 *             .ref("main")
 *             .project(example.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a project for the branch to use
 *   example:
 *     type: gitlab:Project
 *     properties:
 *       name: example
 *       description: An example project
 *       namespaceId: ${exampleGitlabGroup.id}
 *   exampleBranch:
 *     type: gitlab:Branch
 *     name: example
 *     properties:
 *       name: example
 *       ref: main
 *       project: ${example.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Gitlab branches can be imported with a key composed of `<project_id>:<branch_name>`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/branch:Branch example "12345:develop"
 * ```
 */
public class Branch internal constructor(
    override val javaResource: com.pulumi.gitlab.Branch,
) : KotlinCustomResource(javaResource, BranchMapper) {
    /**
     * Bool, true if you can push to the branch.
     */
    public val canPush: Output<Boolean>
        get() = javaResource.canPush().applyValue({ args0 -> args0 })

    /**
     * The commit associated with the branch ref.
     */
    public val commits: Output<List<BranchCommit>>
        get() = javaResource.commits().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * Bool, true if branch is the default branch for the project.
     */
    public val default: Output<Boolean>
        get() = javaResource.default_().applyValue({ args0 -> args0 })

    /**
     * Bool, true if developer level access allows to merge branch.
     */
    public val developerCanMerge: Output<Boolean>
        get() = javaResource.developerCanMerge().applyValue({ args0 -> args0 })

    /**
     * Bool, true if developer level access allows git push.
     */
    public val developerCanPush: Output<Boolean>
        get() = javaResource.developerCanPush().applyValue({ args0 -> args0 })

    /**
     * Bool, true if the branch has been merged into it's parent.
     */
    public val merged: Output<Boolean>
        get() = javaResource.merged().applyValue({ args0 -> args0 })

    /**
     * The name for this branch.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The ID or full path of the project which the branch is created against.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * Bool, true if branch has branch protection.
     */
    public val `protected`: Output<Boolean>
        get() = javaResource.protected_().applyValue({ args0 -> args0 })

    /**
     * The ref which the branch is created from.
     */
    public val ref: Output<String>
        get() = javaResource.ref().applyValue({ args0 -> args0 })

    /**
     * The url of the created branch (https).
     */
    public val webUrl: Output<String>
        get() = javaResource.webUrl().applyValue({ args0 -> args0 })
}

public object BranchMapper : ResourceMapper<Branch> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.Branch::class == javaResource::class

    override fun map(javaResource: Resource): Branch = Branch(
        javaResource as
            com.pulumi.gitlab.Branch,
    )
}

/**
 * @see [Branch].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Branch].
 */
public suspend fun branch(name: String, block: suspend BranchResourceBuilder.() -> Unit): Branch {
    val builder = BranchResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Branch].
 * @param name The _unique_ name of the resulting resource.
 */
public fun branch(name: String): Branch {
    val builder = BranchResourceBuilder()
    builder.name(name)
    return builder.build()
}
