@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.BranchProtectionArgs.builder
import com.pulumi.gitlab.kotlin.inputs.BranchProtectionAllowedToMergeArgs
import com.pulumi.gitlab.kotlin.inputs.BranchProtectionAllowedToMergeArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.BranchProtectionAllowedToPushArgs
import com.pulumi.gitlab.kotlin.inputs.BranchProtectionAllowedToPushArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.BranchProtectionAllowedToUnprotectArgs
import com.pulumi.gitlab.kotlin.inputs.BranchProtectionAllowedToUnprotectArgsBuilder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const branchProtect = new gitlab.BranchProtection("BranchProtect", {
 *     project: "12345",
 *     branch: "BranchProtected",
 *     pushAccessLevel: "developer",
 *     mergeAccessLevel: "developer",
 *     unprotectAccessLevel: "developer",
 *     allowForcePush: true,
 *     codeOwnerApprovalRequired: true,
 *     allowedToPushes: [
 *         {
 *             userId: 5,
 *         },
 *         {
 *             userId: 521,
 *         },
 *     ],
 *     allowedToMerges: [
 *         {
 *             userId: 15,
 *         },
 *         {
 *             userId: 37,
 *         },
 *     ],
 *     allowedToUnprotects: [
 *         {
 *             userId: 15,
 *         },
 *         {
 *             groupId: 42,
 *         },
 *     ],
 * });
 * // Example using dynamic block
 * const main = new gitlab.BranchProtection("main", {
 *     allowedToPushes: [
 *         50,
 *         55,
 *         60,
 *     ].map((v, k) => ({key: k, value: v})).map(entry => ({
 *         userId: entry.value,
 *     })),
 *     project: "12345",
 *     branch: "main",
 *     pushAccessLevel: "maintainer",
 *     mergeAccessLevel: "maintainer",
 *     unprotectAccessLevel: "maintainer",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * branch_protect = gitlab.BranchProtection("BranchProtect",
 *     project="12345",
 *     branch="BranchProtected",
 *     push_access_level="developer",
 *     merge_access_level="developer",
 *     unprotect_access_level="developer",
 *     allow_force_push=True,
 *     code_owner_approval_required=True,
 *     allowed_to_pushes=[
 *         {
 *             "user_id": 5,
 *         },
 *         {
 *             "user_id": 521,
 *         },
 *     ],
 *     allowed_to_merges=[
 *         {
 *             "user_id": 15,
 *         },
 *         {
 *             "user_id": 37,
 *         },
 *     ],
 *     allowed_to_unprotects=[
 *         {
 *             "user_id": 15,
 *         },
 *         {
 *             "group_id": 42,
 *         },
 *     ])
 * # Example using dynamic block
 * main = gitlab.BranchProtection("main",
 *     allowed_to_pushes=[{
 *         "user_id": entry["value"],
 *     } for entry in [{"key": k, "value": v} for k, v in [
 *         50,
 *         55,
 *         60,
 *     ]]],
 *     project="12345",
 *     branch="main",
 *     push_access_level="maintainer",
 *     merge_access_level="maintainer",
 *     unprotect_access_level="maintainer")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var branchProtect = new GitLab.BranchProtection("BranchProtect", new()
 *     {
 *         Project = "12345",
 *         Branch = "BranchProtected",
 *         PushAccessLevel = "developer",
 *         MergeAccessLevel = "developer",
 *         UnprotectAccessLevel = "developer",
 *         AllowForcePush = true,
 *         CodeOwnerApprovalRequired = true,
 *         AllowedToPushes = new[]
 *         {
 *             new GitLab.Inputs.BranchProtectionAllowedToPushArgs
 *             {
 *                 UserId = 5,
 *             },
 *             new GitLab.Inputs.BranchProtectionAllowedToPushArgs
 *             {
 *                 UserId = 521,
 *             },
 *         },
 *         AllowedToMerges = new[]
 *         {
 *             new GitLab.Inputs.BranchProtectionAllowedToMergeArgs
 *             {
 *                 UserId = 15,
 *             },
 *             new GitLab.Inputs.BranchProtectionAllowedToMergeArgs
 *             {
 *                 UserId = 37,
 *             },
 *         },
 *         AllowedToUnprotects = new[]
 *         {
 *             new GitLab.Inputs.BranchProtectionAllowedToUnprotectArgs
 *             {
 *                 UserId = 15,
 *             },
 *             new GitLab.Inputs.BranchProtectionAllowedToUnprotectArgs
 *             {
 *                 GroupId = 42,
 *             },
 *         },
 *     });
 *     // Example using dynamic block
 *     var main = new GitLab.BranchProtection("main", new()
 *     {
 *         AllowedToPushes = new[]
 *         {
 *             50,
 *             55,
 *             60,
 *         }.Select((v, k) => new { Key = k, Value = v }).Select(entry =>
 *         {
 *             return new GitLab.Inputs.BranchProtectionAllowedToPushArgs
 *             {
 *                 UserId = entry.Value,
 *             };
 *         }).ToList(),
 *         Project = "12345",
 *         Branch = "main",
 *         PushAccessLevel = "maintainer",
 *         MergeAccessLevel = "maintainer",
 *         UnprotectAccessLevel = "maintainer",
 *     });
 * });
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Gitlab protected branches can be imported with a key composed of `<project_id>:<branch>`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/branchProtection:BranchProtection BranchProtect "12345:main"
 * ```
 * @property allowForcePush Can be set to true to allow users with push access to force push.
 * @property allowedToMerges Array of access levels and user(s)/group(s) allowed to merge to protected branch.
 * @property allowedToPushes Array of access levels and user(s)/group(s) allowed to push to protected branch.
 * @property allowedToUnprotects Array of access levels and user(s)/group(s) allowed to unprotect push to protected branch.
 * @property branch Name of the branch.
 * @property codeOwnerApprovalRequired Can be set to true to require code owner approval before merging. Only available for Premium and Ultimate instances.
 * @property mergeAccessLevel Access levels allowed to merge. Valid values are: `no one`, `developer`, `maintainer`.
 * @property project The id of the project.
 * @property pushAccessLevel Access levels allowed to push. Valid values are: `no one`, `developer`, `maintainer`.
 * @property unprotectAccessLevel Access levels allowed to unprotect. Valid values are: `developer`, `maintainer`, `admin`.
 */
public data class BranchProtectionArgs(
    public val allowForcePush: Output<Boolean>? = null,
    public val allowedToMerges: Output<List<BranchProtectionAllowedToMergeArgs>>? = null,
    public val allowedToPushes: Output<List<BranchProtectionAllowedToPushArgs>>? = null,
    public val allowedToUnprotects: Output<List<BranchProtectionAllowedToUnprotectArgs>>? = null,
    public val branch: Output<String>? = null,
    public val codeOwnerApprovalRequired: Output<Boolean>? = null,
    public val mergeAccessLevel: Output<String>? = null,
    public val project: Output<String>? = null,
    public val pushAccessLevel: Output<String>? = null,
    public val unprotectAccessLevel: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.BranchProtectionArgs> {
    override fun toJava(): com.pulumi.gitlab.BranchProtectionArgs =
        com.pulumi.gitlab.BranchProtectionArgs.builder()
            .allowForcePush(allowForcePush?.applyValue({ args0 -> args0 }))
            .allowedToMerges(
                allowedToMerges?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .allowedToPushes(
                allowedToPushes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .allowedToUnprotects(
                allowedToUnprotects?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .branch(branch?.applyValue({ args0 -> args0 }))
            .codeOwnerApprovalRequired(codeOwnerApprovalRequired?.applyValue({ args0 -> args0 }))
            .mergeAccessLevel(mergeAccessLevel?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .pushAccessLevel(pushAccessLevel?.applyValue({ args0 -> args0 }))
            .unprotectAccessLevel(unprotectAccessLevel?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BranchProtectionArgs].
 */
@PulumiTagMarker
public class BranchProtectionArgsBuilder internal constructor() {
    private var allowForcePush: Output<Boolean>? = null

    private var allowedToMerges: Output<List<BranchProtectionAllowedToMergeArgs>>? = null

    private var allowedToPushes: Output<List<BranchProtectionAllowedToPushArgs>>? = null

    private var allowedToUnprotects: Output<List<BranchProtectionAllowedToUnprotectArgs>>? = null

    private var branch: Output<String>? = null

    private var codeOwnerApprovalRequired: Output<Boolean>? = null

    private var mergeAccessLevel: Output<String>? = null

    private var project: Output<String>? = null

    private var pushAccessLevel: Output<String>? = null

    private var unprotectAccessLevel: Output<String>? = null

    /**
     * @param value Can be set to true to allow users with push access to force push.
     */
    @JvmName("bhbyqidnlgsavxsx")
    public suspend fun allowForcePush(`value`: Output<Boolean>) {
        this.allowForcePush = value
    }

    /**
     * @param value Array of access levels and user(s)/group(s) allowed to merge to protected branch.
     */
    @JvmName("jfbntfcvpdwxtvrl")
    public suspend fun allowedToMerges(`value`: Output<List<BranchProtectionAllowedToMergeArgs>>) {
        this.allowedToMerges = value
    }

    @JvmName("inkdvwxjfgmenbbx")
    public suspend fun allowedToMerges(vararg values: Output<BranchProtectionAllowedToMergeArgs>) {
        this.allowedToMerges = Output.all(values.asList())
    }

    /**
     * @param values Array of access levels and user(s)/group(s) allowed to merge to protected branch.
     */
    @JvmName("lsnedsqeqkeovajk")
    public suspend fun allowedToMerges(values: List<Output<BranchProtectionAllowedToMergeArgs>>) {
        this.allowedToMerges = Output.all(values)
    }

    /**
     * @param value Array of access levels and user(s)/group(s) allowed to push to protected branch.
     */
    @JvmName("ytqlcbilrieffhyh")
    public suspend fun allowedToPushes(`value`: Output<List<BranchProtectionAllowedToPushArgs>>) {
        this.allowedToPushes = value
    }

    @JvmName("ipwmgqrddwmkmmun")
    public suspend fun allowedToPushes(vararg values: Output<BranchProtectionAllowedToPushArgs>) {
        this.allowedToPushes = Output.all(values.asList())
    }

    /**
     * @param values Array of access levels and user(s)/group(s) allowed to push to protected branch.
     */
    @JvmName("jhgimdjoswymsgxo")
    public suspend fun allowedToPushes(values: List<Output<BranchProtectionAllowedToPushArgs>>) {
        this.allowedToPushes = Output.all(values)
    }

    /**
     * @param value Array of access levels and user(s)/group(s) allowed to unprotect push to protected branch.
     */
    @JvmName("fyngyormaywqskix")
    public suspend fun allowedToUnprotects(`value`: Output<List<BranchProtectionAllowedToUnprotectArgs>>) {
        this.allowedToUnprotects = value
    }

    @JvmName("oerrmpgyfpxmcexc")
    public suspend fun allowedToUnprotects(vararg values: Output<BranchProtectionAllowedToUnprotectArgs>) {
        this.allowedToUnprotects = Output.all(values.asList())
    }

    /**
     * @param values Array of access levels and user(s)/group(s) allowed to unprotect push to protected branch.
     */
    @JvmName("gpfnsbauqlstpkxu")
    public suspend fun allowedToUnprotects(values: List<Output<BranchProtectionAllowedToUnprotectArgs>>) {
        this.allowedToUnprotects = Output.all(values)
    }

    /**
     * @param value Name of the branch.
     */
    @JvmName("ultevovikwxtbjpx")
    public suspend fun branch(`value`: Output<String>) {
        this.branch = value
    }

    /**
     * @param value Can be set to true to require code owner approval before merging. Only available for Premium and Ultimate instances.
     */
    @JvmName("jabimgvfvevexyay")
    public suspend fun codeOwnerApprovalRequired(`value`: Output<Boolean>) {
        this.codeOwnerApprovalRequired = value
    }

    /**
     * @param value Access levels allowed to merge. Valid values are: `no one`, `developer`, `maintainer`.
     */
    @JvmName("adgishimwjptrtyd")
    public suspend fun mergeAccessLevel(`value`: Output<String>) {
        this.mergeAccessLevel = value
    }

    /**
     * @param value The id of the project.
     */
    @JvmName("vekoojrhdqfjbaqc")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value Access levels allowed to push. Valid values are: `no one`, `developer`, `maintainer`.
     */
    @JvmName("prmwudffxnehkiwh")
    public suspend fun pushAccessLevel(`value`: Output<String>) {
        this.pushAccessLevel = value
    }

    /**
     * @param value Access levels allowed to unprotect. Valid values are: `developer`, `maintainer`, `admin`.
     */
    @JvmName("vdghdkyxismeoxqx")
    public suspend fun unprotectAccessLevel(`value`: Output<String>) {
        this.unprotectAccessLevel = value
    }

    /**
     * @param value Can be set to true to allow users with push access to force push.
     */
    @JvmName("xkgrejloxluucqux")
    public suspend fun allowForcePush(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowForcePush = mapped
    }

    /**
     * @param value Array of access levels and user(s)/group(s) allowed to merge to protected branch.
     */
    @JvmName("mgfdqadegypahlfk")
    public suspend fun allowedToMerges(`value`: List<BranchProtectionAllowedToMergeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedToMerges = mapped
    }

    /**
     * @param argument Array of access levels and user(s)/group(s) allowed to merge to protected branch.
     */
    @JvmName("xdgwrvpsrrbmwwoj")
    public suspend fun allowedToMerges(argument: List<suspend BranchProtectionAllowedToMergeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BranchProtectionAllowedToMergeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.allowedToMerges = mapped
    }

    /**
     * @param argument Array of access levels and user(s)/group(s) allowed to merge to protected branch.
     */
    @JvmName("hackcxykpvmdgbxh")
    public suspend fun allowedToMerges(vararg argument: suspend BranchProtectionAllowedToMergeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BranchProtectionAllowedToMergeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.allowedToMerges = mapped
    }

    /**
     * @param argument Array of access levels and user(s)/group(s) allowed to merge to protected branch.
     */
    @JvmName("bcssfciwgykatnhh")
    public suspend fun allowedToMerges(argument: suspend BranchProtectionAllowedToMergeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BranchProtectionAllowedToMergeArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.allowedToMerges = mapped
    }

    /**
     * @param values Array of access levels and user(s)/group(s) allowed to merge to protected branch.
     */
    @JvmName("vmrvdhdhngbngfvv")
    public suspend fun allowedToMerges(vararg values: BranchProtectionAllowedToMergeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedToMerges = mapped
    }

    /**
     * @param value Array of access levels and user(s)/group(s) allowed to push to protected branch.
     */
    @JvmName("ykpueohgwmledabs")
    public suspend fun allowedToPushes(`value`: List<BranchProtectionAllowedToPushArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedToPushes = mapped
    }

    /**
     * @param argument Array of access levels and user(s)/group(s) allowed to push to protected branch.
     */
    @JvmName("jiwycmxohhetvply")
    public suspend fun allowedToPushes(argument: List<suspend BranchProtectionAllowedToPushArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BranchProtectionAllowedToPushArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.allowedToPushes = mapped
    }

    /**
     * @param argument Array of access levels and user(s)/group(s) allowed to push to protected branch.
     */
    @JvmName("upsxybxgvawpnorp")
    public suspend fun allowedToPushes(vararg argument: suspend BranchProtectionAllowedToPushArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BranchProtectionAllowedToPushArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.allowedToPushes = mapped
    }

    /**
     * @param argument Array of access levels and user(s)/group(s) allowed to push to protected branch.
     */
    @JvmName("vodantsavajkwpfu")
    public suspend fun allowedToPushes(argument: suspend BranchProtectionAllowedToPushArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BranchProtectionAllowedToPushArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.allowedToPushes = mapped
    }

    /**
     * @param values Array of access levels and user(s)/group(s) allowed to push to protected branch.
     */
    @JvmName("bfjeufjcvhydupyw")
    public suspend fun allowedToPushes(vararg values: BranchProtectionAllowedToPushArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedToPushes = mapped
    }

    /**
     * @param value Array of access levels and user(s)/group(s) allowed to unprotect push to protected branch.
     */
    @JvmName("clicvtiojukutlfq")
    public suspend fun allowedToUnprotects(`value`: List<BranchProtectionAllowedToUnprotectArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedToUnprotects = mapped
    }

    /**
     * @param argument Array of access levels and user(s)/group(s) allowed to unprotect push to protected branch.
     */
    @JvmName("oftugnurhkphoolx")
    public suspend fun allowedToUnprotects(argument: List<suspend BranchProtectionAllowedToUnprotectArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BranchProtectionAllowedToUnprotectArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.allowedToUnprotects = mapped
    }

    /**
     * @param argument Array of access levels and user(s)/group(s) allowed to unprotect push to protected branch.
     */
    @JvmName("ecpfuylojhicjxwk")
    public suspend fun allowedToUnprotects(vararg argument: suspend BranchProtectionAllowedToUnprotectArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BranchProtectionAllowedToUnprotectArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.allowedToUnprotects = mapped
    }

    /**
     * @param argument Array of access levels and user(s)/group(s) allowed to unprotect push to protected branch.
     */
    @JvmName("ljauiijtpkbncumy")
    public suspend fun allowedToUnprotects(argument: suspend BranchProtectionAllowedToUnprotectArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BranchProtectionAllowedToUnprotectArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.allowedToUnprotects = mapped
    }

    /**
     * @param values Array of access levels and user(s)/group(s) allowed to unprotect push to protected branch.
     */
    @JvmName("jwfxwtobpttpvlct")
    public suspend fun allowedToUnprotects(vararg values: BranchProtectionAllowedToUnprotectArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedToUnprotects = mapped
    }

    /**
     * @param value Name of the branch.
     */
    @JvmName("bqnjdwkggmwahclu")
    public suspend fun branch(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.branch = mapped
    }

    /**
     * @param value Can be set to true to require code owner approval before merging. Only available for Premium and Ultimate instances.
     */
    @JvmName("fpwhwyfyfrxxixbd")
    public suspend fun codeOwnerApprovalRequired(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeOwnerApprovalRequired = mapped
    }

    /**
     * @param value Access levels allowed to merge. Valid values are: `no one`, `developer`, `maintainer`.
     */
    @JvmName("fwutjsoivweoyoeh")
    public suspend fun mergeAccessLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mergeAccessLevel = mapped
    }

    /**
     * @param value The id of the project.
     */
    @JvmName("glxkiekgxjpuhwdm")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value Access levels allowed to push. Valid values are: `no one`, `developer`, `maintainer`.
     */
    @JvmName("bxrtmywgshdacwxm")
    public suspend fun pushAccessLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pushAccessLevel = mapped
    }

    /**
     * @param value Access levels allowed to unprotect. Valid values are: `developer`, `maintainer`, `admin`.
     */
    @JvmName("xqeyvspuoavxkoij")
    public suspend fun unprotectAccessLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unprotectAccessLevel = mapped
    }

    internal fun build(): BranchProtectionArgs = BranchProtectionArgs(
        allowForcePush = allowForcePush,
        allowedToMerges = allowedToMerges,
        allowedToPushes = allowedToPushes,
        allowedToUnprotects = allowedToUnprotects,
        branch = branch,
        codeOwnerApprovalRequired = codeOwnerApprovalRequired,
        mergeAccessLevel = mergeAccessLevel,
        project = project,
        pushAccessLevel = pushAccessLevel,
        unprotectAccessLevel = unprotectAccessLevel,
    )
}
