@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ClusterAgent].
 */
@PulumiTagMarker
public class ClusterAgentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterAgentArgs = ClusterAgentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterAgentArgsBuilder.() -> Unit) {
        val builder = ClusterAgentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ClusterAgent {
        val builtJavaResource = com.pulumi.gitlab.ClusterAgent(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ClusterAgent(builtJavaResource)
    }
}

/**
 * The `gitlab.ClusterAgent` resource allows to manage the lifecycle of a GitLab Agent for Kubernetes.
 * > Note that this resource only registers the agent, but doesn't configure it.
 *    The configuration needs to be manually added as described in
 *    [the docs](https://docs.gitlab.com/ee/user/clusters/agent/install/index.html#create-an-agent-configuration-file).
 *    However, a `gitlab.RepositoryFile` resource may be used to achieve that.
 * > Requires at least maintainer permissions on the project.
 * > Requires at least GitLab 14.10
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/cluster_agents.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * import * as std from "@pulumi/std";
 * const example = new gitlab.ClusterAgent("example", {
 *     project: "12345",
 *     name: "agent-1",
 * });
 * // Optionally, configure the agent as described in
 * // https://docs.gitlab.com/ee/user/clusters/agent/install/index.html#create-an-agent-configuration-file
 * const exampleAgentConfig = new gitlab.RepositoryFile("example_agent_config", {
 *     project: example.project,
 *     branch: "main",
 *     filePath: pulumi.interpolate`.gitlab/agents/${example.name}/config.yaml`,
 *     content: std.base64encode({
 *         input: "# the GitLab Agent for Kubernetes configuration goes here ...\n",
 *     }).then(invoke => invoke.result),
 *     authorEmail: "terraform@example.com",
 *     authorName: "Terraform",
 *     commitMessage: pulumi.interpolate`feature: add agent config for ${example.name} [skip ci]`,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * import pulumi_std as std
 * example = gitlab.ClusterAgent("example",
 *     project="12345",
 *     name="agent-1")
 * # Optionally, configure the agent as described in
 * # https://docs.gitlab.com/ee/user/clusters/agent/install/index.html#create-an-agent-configuration-file
 * example_agent_config = gitlab.RepositoryFile("example_agent_config",
 *     project=example.project,
 *     branch="main",
 *     file_path=example.name.apply(lambda name: f".gitlab/agents/{name}/config.yaml"),
 *     content=std.base64encode(input="# the GitLab Agent for Kubernetes configuration goes here ...\n").result,
 *     author_email="terraform@example.com",
 *     author_name="Terraform",
 *     commit_message=example.name.apply(lambda name: f"feature: add agent config for {name} [skip ci]"))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new GitLab.ClusterAgent("example", new()
 *     {
 *         Project = "12345",
 *         Name = "agent-1",
 *     });
 *     // Optionally, configure the agent as described in
 *     // https://docs.gitlab.com/ee/user/clusters/agent/install/index.html#create-an-agent-configuration-file
 *     var exampleAgentConfig = new GitLab.RepositoryFile("example_agent_config", new()
 *     {
 *         Project = example.Project,
 *         Branch = "main",
 *         FilePath = example.Name.Apply(name => $".gitlab/agents/{name}/config.yaml"),
 *         Content = Std.Base64encode.Invoke(new()
 *         {
 *             Input = @"# the GitLab Agent for Kubernetes configuration goes here ...
 * ",
 *         }).Apply(invoke => invoke.Result),
 *         AuthorEmail = "terraform@example.com",
 *         AuthorName = "Terraform",
 *         CommitMessage = example.Name.Apply(name => $"feature: add agent config for {name} [skip ci]"),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := gitlab.NewClusterAgent(ctx, "example", &gitlab.ClusterAgentArgs{
 * 			Project: pulumi.String("12345"),
 * 			Name:    pulumi.String("agent-1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		invokeBase64encode, err := std.Base64encode(ctx, &std.Base64encodeArgs{
 * 			Input: "# the GitLab Agent for Kubernetes configuration goes here ...\n",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Optionally, configure the agent as described in
 * 		// https://docs.gitlab.com/ee/user/clusters/agent/install/index.html#create-an-agent-configuration-file
 * 		_, err = gitlab.NewRepositoryFile(ctx, "example_agent_config", &gitlab.RepositoryFileArgs{
 * 			Project: example.Project,
 * 			Branch:  pulumi.String("main"),
 * 			FilePath: example.Name.ApplyT(func(name string) (string, error) {
 * 				return fmt.Sprintf(".gitlab/agents/%v/config.yaml", name), nil
 * 			}).(pulumi.StringOutput),
 * 			Content:     pulumi.String(invokeBase64encode.Result),
 * 			AuthorEmail: pulumi.String("terraform@example.com"),
 * 			AuthorName:  pulumi.String("Terraform"),
 * 			CommitMessage: example.Name.ApplyT(func(name string) (string, error) {
 * 				return fmt.Sprintf("feature: add agent config for %v [skip ci]", name), nil
 * 			}).(pulumi.StringOutput),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.ClusterAgent;
 * import com.pulumi.gitlab.ClusterAgentArgs;
 * import com.pulumi.gitlab.RepositoryFile;
 * import com.pulumi.gitlab.RepositoryFileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ClusterAgent("example", ClusterAgentArgs.builder()
 *             .project("12345")
 *             .name("agent-1")
 *             .build());
 *         // Optionally, configure the agent as described in
 *         // https://docs.gitlab.com/ee/user/clusters/agent/install/index.html#create-an-agent-configuration-file
 *         var exampleAgentConfig = new RepositoryFile("exampleAgentConfig", RepositoryFileArgs.builder()
 *             .project(example.project())
 *             .branch("main")
 *             .filePath(example.name().applyValue(name -> String.format(".gitlab/agents/%s/config.yaml", name)))
 *             .content(StdFunctions.base64encode(Base64encodeArgs.builder()
 *                 .input("""
 * # the GitLab Agent for Kubernetes configuration goes here ...
 *                 """)
 *                 .build()).result())
 *             .authorEmail("terraform@example.com")
 *             .authorName("Terraform")
 *             .commitMessage(example.name().applyValue(name -> String.format("feature: add agent config for %s [skip ci]", name)))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: gitlab:ClusterAgent
 *     properties:
 *       project: '12345'
 *       name: agent-1
 *   # Optionally, configure the agent as described in
 *   # // https://docs.gitlab.com/ee/user/clusters/agent/install/index.html#create-an-agent-configuration-file
 *   exampleAgentConfig:
 *     type: gitlab:RepositoryFile
 *     name: example_agent_config
 *     properties:
 *       project: ${example.project}
 *       branch: main
 *       filePath: .gitlab/agents/${example.name}/config.yaml
 *       content:
 *         fn::invoke:
 *           Function: std:base64encode
 *           Arguments:
 *             input: |
 *               # the GitLab Agent for Kubernetes configuration goes here ...
 *           Return: result
 *       authorEmail: terraform@example.com
 *       authorName: Terraform
 *       commitMessage: 'feature: add agent config for ${example.name} [skip ci]'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab Agent for Kubernetes can be imported with the following command and the id pattern `<project>:<agent-id>`
 * ```sh
 * $ pulumi import gitlab:index/clusterAgent:ClusterAgent example '12345:42'
 * ```
 */
public class ClusterAgent internal constructor(
    override val javaResource: com.pulumi.gitlab.ClusterAgent,
) : KotlinCustomResource(javaResource, ClusterAgentMapper) {
    /**
     * The ID of the agent.
     */
    public val agentId: Output<Int>
        get() = javaResource.agentId().applyValue({ args0 -> args0 })

    /**
     * The ISO8601 datetime when the agent was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * The ID of the user who created the agent.
     */
    public val createdByUserId: Output<Int>
        get() = javaResource.createdByUserId().applyValue({ args0 -> args0 })

    /**
     * The Name of the agent.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * ID or full path of the project maintained by the authenticated user.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })
}

public object ClusterAgentMapper : ResourceMapper<ClusterAgent> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.ClusterAgent::class == javaResource::class

    override fun map(javaResource: Resource): ClusterAgent = ClusterAgent(
        javaResource as
            com.pulumi.gitlab.ClusterAgent,
    )
}

/**
 * @see [ClusterAgent].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ClusterAgent].
 */
public suspend fun clusterAgent(
    name: String,
    block: suspend ClusterAgentResourceBuilder.() -> Unit,
): ClusterAgent {
    val builder = ClusterAgentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ClusterAgent].
 * @param name The _unique_ name of the resulting resource.
 */
public fun clusterAgent(name: String): ClusterAgent {
    val builder = ClusterAgentResourceBuilder()
    builder.name(name)
    return builder.build()
}
