@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ClusterAgentToken].
 */
@PulumiTagMarker
public class ClusterAgentTokenResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterAgentTokenArgs = ClusterAgentTokenArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterAgentTokenArgsBuilder.() -> Unit) {
        val builder = ClusterAgentTokenArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ClusterAgentToken {
        val builtJavaResource = com.pulumi.gitlab.ClusterAgentToken(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ClusterAgentToken(builtJavaResource)
    }
}

/**
 * The `gitlab.ClusterAgentToken` resource allows to manage the lifecycle of a token for a GitLab Agent for Kubernetes.
 * > Requires at least maintainer permissions on the project.
 * > Requires at least GitLab 15.0
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/cluster_agents.html#create-an-agent-token)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * import * as helm from "@pulumi/helm";
 * // Create token for an agent
 * const example = new gitlab.ClusterAgentToken("example", {
 *     project: "12345",
 *     agentId: 42,
 *     name: "some-token",
 *     description: "some token",
 * });
 * // The following example creates a GitLab Agent for Kubernetes in a given project,
 * // creates a token and install the `gitlab-agent` Helm Chart.
 * // (see https://gitlab.com/gitlab-org/charts/gitlab-agent)
 * const this = gitlab.getProject({
 *     pathWithNamespace: "my-org/example",
 * });
 * const thisClusterAgent = new gitlab.ClusterAgent("this", {
 *     project: _this.then(_this => _this.id),
 *     name: "my-agent",
 * });
 * const thisClusterAgentToken = new gitlab.ClusterAgentToken("this", {
 *     project: _this.then(_this => _this.id),
 *     agentId: thisClusterAgent.agentId,
 *     name: "my-agent-token",
 *     description: "Token for the my-agent used with `gitlab-agent` Helm Chart",
 * });
 * const gitlabAgent = new helm.index.Release("gitlab_agent", {
 *     name: "gitlab-agent",
 *     namespace: "gitlab-agent",
 *     createNamespace: true,
 *     repository: "https://charts.gitlab.io",
 *     chart: "gitlab-agent",
 *     version: "1.2.0",
 *     set: [{
 *         name: "config.token",
 *         value: thisClusterAgentToken.token,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * import pulumi_helm as helm
 * # Create token for an agent
 * example = gitlab.ClusterAgentToken("example",
 *     project="12345",
 *     agent_id=42,
 *     name="some-token",
 *     description="some token")
 * # The following example creates a GitLab Agent for Kubernetes in a given project,
 * # creates a token and install the `gitlab-agent` Helm Chart.
 * # (see https://gitlab.com/gitlab-org/charts/gitlab-agent)
 * this = gitlab.get_project(path_with_namespace="my-org/example")
 * this_cluster_agent = gitlab.ClusterAgent("this",
 *     project=this.id,
 *     name="my-agent")
 * this_cluster_agent_token = gitlab.ClusterAgentToken("this",
 *     project=this.id,
 *     agent_id=this_cluster_agent.agent_id,
 *     name="my-agent-token",
 *     description="Token for the my-agent used with `gitlab-agent` Helm Chart")
 * gitlab_agent = helm.index.Release("gitlab_agent",
 *     name=gitlab-agent,
 *     namespace=gitlab-agent,
 *     create_namespace=True,
 *     repository=https://charts.gitlab.io,
 *     chart=gitlab-agent,
 *     version=1.2.0,
 *     set=[{
 *         name: config.token,
 *         value: this_cluster_agent_token.token,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * using Helm = Pulumi.Helm;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create token for an agent
 *     var example = new GitLab.ClusterAgentToken("example", new()
 *     {
 *         Project = "12345",
 *         AgentId = 42,
 *         Name = "some-token",
 *         Description = "some token",
 *     });
 *     // The following example creates a GitLab Agent for Kubernetes in a given project,
 *     // creates a token and install the `gitlab-agent` Helm Chart.
 *     // (see https://gitlab.com/gitlab-org/charts/gitlab-agent)
 *     var @this = GitLab.GetProject.Invoke(new()
 *     {
 *         PathWithNamespace = "my-org/example",
 *     });
 *     var thisClusterAgent = new GitLab.ClusterAgent("this", new()
 *     {
 *         Project = @this.Apply(@this => @this.Apply(getProjectResult => getProjectResult.Id)),
 *         Name = "my-agent",
 *     });
 *     var thisClusterAgentToken = new GitLab.ClusterAgentToken("this", new()
 *     {
 *         Project = @this.Apply(@this => @this.Apply(getProjectResult => getProjectResult.Id)),
 *         AgentId = thisClusterAgent.AgentId,
 *         Name = "my-agent-token",
 *         Description = "Token for the my-agent used with `gitlab-agent` Helm Chart",
 *     });
 *     var gitlabAgent = new Helm.Index.Release("gitlab_agent", new()
 *     {
 *         Name = "gitlab-agent",
 *         Namespace = "gitlab-agent",
 *         CreateNamespace = true,
 *         Repository = "https://charts.gitlab.io",
 *         Chart = "gitlab-agent",
 *         Version = "1.2.0",
 *         Set = new[]
 *         {
 *             {
 *                 { "name", "config.token" },
 *                 { "value", thisClusterAgentToken.Token },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi-helm/sdk/go/helm"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create token for an agent
 * 		_, err := gitlab.NewClusterAgentToken(ctx, "example", &gitlab.ClusterAgentTokenArgs{
 * 			Project:     pulumi.String("12345"),
 * 			AgentId:     pulumi.Int(42),
 * 			Name:        pulumi.String("some-token"),
 * 			Description: pulumi.String("some token"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// The following example creates a GitLab Agent for Kubernetes in a given project,
 * 		// creates a token and install the `gitlab-agent` Helm Chart.
 * 		// (see https://gitlab.com/gitlab-org/charts/gitlab-agent)
 * 		this, err := gitlab.LookupProject(ctx, &gitlab.LookupProjectArgs{
 * 			PathWithNamespace: pulumi.StringRef("my-org/example"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		thisClusterAgent, err := gitlab.NewClusterAgent(ctx, "this", &gitlab.ClusterAgentArgs{
 * 			Project: pulumi.String(this.Id),
 * 			Name:    pulumi.String("my-agent"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		thisClusterAgentToken, err := gitlab.NewClusterAgentToken(ctx, "this", &gitlab.ClusterAgentTokenArgs{
 * 			Project:     pulumi.String(this.Id),
 * 			AgentId:     thisClusterAgent.AgentId,
 * 			Name:        pulumi.String("my-agent-token"),
 * 			Description: pulumi.String("Token for the my-agent used with `gitlab-agent` Helm Chart"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = helm.NewRelease(ctx, "gitlab_agent", &helm.ReleaseArgs{
 * 			Name:            "gitlab-agent",
 * 			Namespace:       "gitlab-agent",
 * 			CreateNamespace: true,
 * 			Repository:      "https://charts.gitlab.io",
 * 			Chart:           "gitlab-agent",
 * 			Version:         "1.2.0",
 * 			Set: []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"name":  "config.token",
 * 					"value": thisClusterAgentToken.Token,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.ClusterAgentToken;
 * import com.pulumi.gitlab.ClusterAgentTokenArgs;
 * import com.pulumi.gitlab.GitlabFunctions;
 * import com.pulumi.gitlab.inputs.GetProjectArgs;
 * import com.pulumi.gitlab.ClusterAgent;
 * import com.pulumi.gitlab.ClusterAgentArgs;
 * import com.pulumi.helm.release;
 * import com.pulumi.helm.ReleaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create token for an agent
 *         var example = new ClusterAgentToken("example", ClusterAgentTokenArgs.builder()
 *             .project("12345")
 *             .agentId(42)
 *             .name("some-token")
 *             .description("some token")
 *             .build());
 *         // The following example creates a GitLab Agent for Kubernetes in a given project,
 *         // creates a token and install the `gitlab-agent` Helm Chart.
 *         // (see https://gitlab.com/gitlab-org/charts/gitlab-agent)
 *         final var this = GitlabFunctions.getProject(GetProjectArgs.builder()
 *             .pathWithNamespace("my-org/example")
 *             .build());
 *         var thisClusterAgent = new ClusterAgent("thisClusterAgent", ClusterAgentArgs.builder()
 *             .project(this_.id())
 *             .name("my-agent")
 *             .build());
 *         var thisClusterAgentToken = new ClusterAgentToken("thisClusterAgentToken", ClusterAgentTokenArgs.builder()
 *             .project(this_.id())
 *             .agentId(thisClusterAgent.agentId())
 *             .name("my-agent-token")
 *             .description("Token for the my-agent used with `gitlab-agent` Helm Chart")
 *             .build());
 *         var gitlabAgent = new Release("gitlabAgent", ReleaseArgs.builder()
 *             .name("gitlab-agent")
 *             .namespace("gitlab-agent")
 *             .createNamespace(true)
 *             .repository("https://charts.gitlab.io")
 *             .chart("gitlab-agent")
 *             .version("1.2.0")
 *             .set(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create token for an agent
 *   example:
 *     type: gitlab:ClusterAgentToken
 *     properties:
 *       project: '12345'
 *       agentId: 42
 *       name: some-token
 *       description: some token
 *   thisClusterAgent:
 *     type: gitlab:ClusterAgent
 *     name: this
 *     properties:
 *       project: ${this.id}
 *       name: my-agent
 *   thisClusterAgentToken:
 *     type: gitlab:ClusterAgentToken
 *     name: this
 *     properties:
 *       project: ${this.id}
 *       agentId: ${thisClusterAgent.agentId}
 *       name: my-agent-token
 *       description: Token for the my-agent used with `gitlab-agent` Helm Chart
 *   gitlabAgent:
 *     type: helm:release
 *     name: gitlab_agent
 *     properties:
 *       name: gitlab-agent
 *       namespace: gitlab-agent
 *       createNamespace: true
 *       repository: https://charts.gitlab.io
 *       chart: gitlab-agent
 *       version: 1.2.0
 *       set:
 *         - name: config.token
 *           value: ${thisClusterAgentToken.token}
 * variables:
 *   # The following example creates a GitLab Agent for Kubernetes in a given project,
 *   # // creates a token and install the `gitlab-agent` Helm Chart.
 *   # // (see https://gitlab.com/gitlab-org/charts/gitlab-agent)
 *   this:
 *     fn::invoke:
 *       Function: gitlab:getProject
 *       Arguments:
 *         pathWithNamespace: my-org/example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * A token for a GitLab Agent for Kubernetes can be imported with the following command and the id pattern `<project>:<agent-id>:<token-id>`:
 * ```sh
 * $ pulumi import gitlab:index/clusterAgentToken:ClusterAgentToken example '12345:42:1'
 * ```
 * ATTENTION: the `token` resource attribute is not available for imported resources as this information cannot be read from the GitLab API.
 */
public class ClusterAgentToken internal constructor(
    override val javaResource: com.pulumi.gitlab.ClusterAgentToken,
) : KotlinCustomResource(javaResource, ClusterAgentTokenMapper) {
    /**
     * The ID of the agent.
     */
    public val agentId: Output<Int>
        get() = javaResource.agentId().applyValue({ args0 -> args0 })

    /**
     * The ISO8601 datetime when the agent was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * The ID of the user who created the agent.
     */
    public val createdByUserId: Output<Int>
        get() = javaResource.createdByUserId().applyValue({ args0 -> args0 })

    /**
     * The Description for the agent.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ISO8601 datetime when the token was last used.
     */
    public val lastUsedAt: Output<String>
        get() = javaResource.lastUsedAt().applyValue({ args0 -> args0 })

    /**
     * The Name of the agent.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * ID or full path of the project maintained by the authenticated user.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * The status of the token. Valid values are `active`, `revoked`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The secret token for the agent. The `token` is not available in imported resources.
     */
    public val token: Output<String>
        get() = javaResource.token().applyValue({ args0 -> args0 })

    /**
     * The ID of the token.
     */
    public val tokenId: Output<Int>
        get() = javaResource.tokenId().applyValue({ args0 -> args0 })
}

public object ClusterAgentTokenMapper : ResourceMapper<ClusterAgentToken> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.ClusterAgentToken::class == javaResource::class

    override fun map(javaResource: Resource): ClusterAgentToken = ClusterAgentToken(
        javaResource as
            com.pulumi.gitlab.ClusterAgentToken,
    )
}

/**
 * @see [ClusterAgentToken].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ClusterAgentToken].
 */
public suspend fun clusterAgentToken(
    name: String,
    block: suspend ClusterAgentTokenResourceBuilder.() -> Unit,
): ClusterAgentToken {
    val builder = ClusterAgentTokenResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ClusterAgentToken].
 * @param name The _unique_ name of the resulting resource.
 */
public fun clusterAgentToken(name: String): ClusterAgentToken {
    val builder = ClusterAgentTokenResourceBuilder()
    builder.name(name)
    return builder.build()
}
