@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DeployKey].
 */
@PulumiTagMarker
public class DeployKeyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DeployKeyArgs = DeployKeyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DeployKeyArgsBuilder.() -> Unit) {
        val builder = DeployKeyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DeployKey {
        val builtJavaResource = com.pulumi.gitlab.DeployKey(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DeployKey(builtJavaResource)
    }
}

/**
 * The `gitlab.DeployKey` resource allows to manage the lifecycle of a deploy key.
 * > To enable an already existing deploy key for another project use the `gitlab.DeployKeyEnable` resource.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/deploy_keys.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const example = new gitlab.DeployKey("example", {
 *     project: "example/deploying",
 *     title: "Example deploy key",
 *     key: "ssh-ed25519 AAAA...",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * example = gitlab.DeployKey("example",
 *     project="example/deploying",
 *     title="Example deploy key",
 *     key="ssh-ed25519 AAAA...")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new GitLab.DeployKey("example", new()
 *     {
 *         Project = "example/deploying",
 *         Title = "Example deploy key",
 *         Key = "ssh-ed25519 AAAA...",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewDeployKey(ctx, "example", &gitlab.DeployKeyArgs{
 * 			Project: pulumi.String("example/deploying"),
 * 			Title:   pulumi.String("Example deploy key"),
 * 			Key:     pulumi.String("ssh-ed25519 AAAA..."),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.DeployKey;
 * import com.pulumi.gitlab.DeployKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DeployKey("example", DeployKeyArgs.builder()
 *             .project("example/deploying")
 *             .title("Example deploy key")
 *             .key("ssh-ed25519 AAAA...")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: gitlab:DeployKey
 *     properties:
 *       project: example/deploying
 *       title: Example deploy key
 *       key: ssh-ed25519 AAAA...
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab deploy keys can be imported using an id made up of `{project_id}:{deploy_key_id}`, e.g.
 * `project_id` can be whatever the [get single project api][get_single_project] takes for
 * its `:id` value, so for example:
 * ```sh
 * $ pulumi import gitlab:index/deployKey:DeployKey test 1:3
 * ```
 * ```sh
 * $ pulumi import gitlab:index/deployKey:DeployKey test richardc/example:3
 * ```
 */
public class DeployKey internal constructor(
    override val javaResource: com.pulumi.gitlab.DeployKey,
) : KotlinCustomResource(javaResource, DeployKeyMapper) {
    /**
     * Allow this deploy key to be used to push changes to the project. Defaults to `false`.
     */
    public val canPush: Output<Boolean>?
        get() = javaResource.canPush().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The id of the project deploy key.
     */
    public val deployKeyId: Output<Int>
        get() = javaResource.deployKeyId().applyValue({ args0 -> args0 })

    /**
     * The public ssh key body.
     */
    public val key: Output<String>
        get() = javaResource.key().applyValue({ args0 -> args0 })

    /**
     * The name or id of the project to add the deploy key to.
     */
    public val project: Output<String>
        get() = javaResource.project().applyValue({ args0 -> args0 })

    /**
     * A title to describe the deploy key with.
     */
    public val title: Output<String>
        get() = javaResource.title().applyValue({ args0 -> args0 })
}

public object DeployKeyMapper : ResourceMapper<DeployKey> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.DeployKey::class == javaResource::class

    override fun map(javaResource: Resource): DeployKey = DeployKey(
        javaResource as
            com.pulumi.gitlab.DeployKey,
    )
}

/**
 * @see [DeployKey].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DeployKey].
 */
public suspend fun deployKey(name: String, block: suspend DeployKeyResourceBuilder.() -> Unit): DeployKey {
    val builder = DeployKeyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DeployKey].
 * @param name The _unique_ name of the resulting resource.
 */
public fun deployKey(name: String): DeployKey {
    val builder = DeployKeyResourceBuilder()
    builder.name(name)
    return builder.build()
}
