@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [DeployToken].
 */
@PulumiTagMarker
public class DeployTokenResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DeployTokenArgs = DeployTokenArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DeployTokenArgsBuilder.() -> Unit) {
        val builder = DeployTokenArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DeployToken {
        val builtJavaResource = com.pulumi.gitlab.DeployToken(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DeployToken(builtJavaResource)
    }
}

/**
 * The `gitlab.DeployToken` resource allows to manage the lifecycle of group and project deploy tokens.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/deploy_tokens.html)
 * ## Import
 * GitLab deploy tokens can be imported using an id made up of `{type}:{type_id}:{deploy_token_id}`, where type is one of: project, group.
 * ```sh
 * $ pulumi import gitlab:index/deployToken:DeployToken group_token group:1:3
 * ```
 * ```sh
 * $ pulumi import gitlab:index/deployToken:DeployToken project_token project:1:4
 * ```
 * Note: the `token` resource attribute is not available for imported resources as this information cannot be read from the GitLab API.
 */
public class DeployToken internal constructor(
    override val javaResource: com.pulumi.gitlab.DeployToken,
) : KotlinCustomResource(javaResource, DeployTokenMapper) {
    /**
     * The id of the deploy token.
     */
    public val deployTokenId: Output<Int>
        get() = javaResource.deployTokenId().applyValue({ args0 -> args0 })

    /**
     * Time the token will expire it, RFC3339 format. Will not expire per default.
     */
    public val expiresAt: Output<String>?
        get() = javaResource.expiresAt().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name or id of the group to add the deploy token to.
     */
    public val group: Output<String>?
        get() = javaResource.group().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A name to describe the deploy token with.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The name or id of the project to add the deploy token to.
     */
    public val project: Output<String>?
        get() = javaResource.project().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Valid values: `read_repository`, `read_registry`, `read_package_registry`, `write_registry`, `write_package_registry`.
     */
    public val scopes: Output<List<String>>
        get() = javaResource.scopes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The secret token. This is only populated when creating a new deploy token. **Note**: The token is not available for imported resources.
     */
    public val token: Output<String>
        get() = javaResource.token().applyValue({ args0 -> args0 })

    /**
     * A username for the deploy token. Default is `gitlab+deploy-token-{n}`.
     */
    public val username: Output<String>
        get() = javaResource.username().applyValue({ args0 -> args0 })
}

public object DeployTokenMapper : ResourceMapper<DeployToken> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.DeployToken::class == javaResource::class

    override fun map(javaResource: Resource): DeployToken = DeployToken(
        javaResource as
            com.pulumi.gitlab.DeployToken,
    )
}

/**
 * @see [DeployToken].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DeployToken].
 */
public suspend fun deployToken(name: String, block: suspend DeployTokenResourceBuilder.() -> Unit): DeployToken {
    val builder = DeployTokenResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DeployToken].
 * @param name The _unique_ name of the resulting resource.
 */
public fun deployToken(name: String): DeployToken {
    val builder = DeployTokenResourceBuilder()
    builder.name(name)
    return builder.build()
}
