@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.DeployTokenArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The `gitlab.DeployToken` resource allows to manage the lifecycle of group and project deploy tokens.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/deploy_tokens.html)
 * ## Import
 * GitLab deploy tokens can be imported using an id made up of `{type}:{type_id}:{deploy_token_id}`, where type is one of: project, group.
 * ```sh
 * $ pulumi import gitlab:index/deployToken:DeployToken group_token group:1:3
 * ```
 * ```sh
 * $ pulumi import gitlab:index/deployToken:DeployToken project_token project:1:4
 * ```
 * Note: the `token` resource attribute is not available for imported resources as this information cannot be read from the GitLab API.
 * @property expiresAt Time the token will expire it, RFC3339 format. Will not expire per default.
 * @property group The name or id of the group to add the deploy token to.
 * @property name A name to describe the deploy token with.
 * @property project The name or id of the project to add the deploy token to.
 * @property scopes Valid values: `read_repository`, `read_registry`, `read_package_registry`, `write_registry`, `write_package_registry`.
 * @property username A username for the deploy token. Default is `gitlab+deploy-token-{n}`.
 */
public data class DeployTokenArgs(
    public val expiresAt: Output<String>? = null,
    public val group: Output<String>? = null,
    public val name: Output<String>? = null,
    public val project: Output<String>? = null,
    public val scopes: Output<List<String>>? = null,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.DeployTokenArgs> {
    override fun toJava(): com.pulumi.gitlab.DeployTokenArgs =
        com.pulumi.gitlab.DeployTokenArgs.builder()
            .expiresAt(expiresAt?.applyValue({ args0 -> args0 }))
            .group(group?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 }))
            .scopes(scopes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeployTokenArgs].
 */
@PulumiTagMarker
public class DeployTokenArgsBuilder internal constructor() {
    private var expiresAt: Output<String>? = null

    private var group: Output<String>? = null

    private var name: Output<String>? = null

    private var project: Output<String>? = null

    private var scopes: Output<List<String>>? = null

    private var username: Output<String>? = null

    /**
     * @param value Time the token will expire it, RFC3339 format. Will not expire per default.
     */
    @JvmName("cssgfsrjdhgcslhk")
    public suspend fun expiresAt(`value`: Output<String>) {
        this.expiresAt = value
    }

    /**
     * @param value The name or id of the group to add the deploy token to.
     */
    @JvmName("ltgufxtfpaqdsvnr")
    public suspend fun group(`value`: Output<String>) {
        this.group = value
    }

    /**
     * @param value A name to describe the deploy token with.
     */
    @JvmName("bqdonnkfahosawwj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name or id of the project to add the deploy token to.
     */
    @JvmName("cusethjnjxacatfr")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value Valid values: `read_repository`, `read_registry`, `read_package_registry`, `write_registry`, `write_package_registry`.
     */
    @JvmName("bpjgwaqjsoqagtif")
    public suspend fun scopes(`value`: Output<List<String>>) {
        this.scopes = value
    }

    @JvmName("ucyhepefhbrkyrud")
    public suspend fun scopes(vararg values: Output<String>) {
        this.scopes = Output.all(values.asList())
    }

    /**
     * @param values Valid values: `read_repository`, `read_registry`, `read_package_registry`, `write_registry`, `write_package_registry`.
     */
    @JvmName("yemcvtbpajoillfj")
    public suspend fun scopes(values: List<Output<String>>) {
        this.scopes = Output.all(values)
    }

    /**
     * @param value A username for the deploy token. Default is `gitlab+deploy-token-{n}`.
     */
    @JvmName("ucplcymounrgkegi")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value Time the token will expire it, RFC3339 format. Will not expire per default.
     */
    @JvmName("rsmmsyjieadkwmwq")
    public suspend fun expiresAt(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiresAt = mapped
    }

    /**
     * @param value The name or id of the group to add the deploy token to.
     */
    @JvmName("prwbuaadsjxiojaa")
    public suspend fun group(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.group = mapped
    }

    /**
     * @param value A name to describe the deploy token with.
     */
    @JvmName("gpfxvebkrxcydkro")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name or id of the project to add the deploy token to.
     */
    @JvmName("fsghgollyxfxwrjf")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    /**
     * @param value Valid values: `read_repository`, `read_registry`, `read_package_registry`, `write_registry`, `write_package_registry`.
     */
    @JvmName("juqiexrjoiayxigr")
    public suspend fun scopes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param values Valid values: `read_repository`, `read_registry`, `read_package_registry`, `write_registry`, `write_package_registry`.
     */
    @JvmName("yhqwnhyadgxlccpw")
    public suspend fun scopes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param value A username for the deploy token. Default is `gitlab+deploy-token-{n}`.
     */
    @JvmName("pnhlyqiahogrqbhu")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): DeployTokenArgs = DeployTokenArgs(
        expiresAt = expiresAt,
        group = group,
        name = name,
        project = project,
        scopes = scopes,
        username = username,
    )
}
