@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.gitlab.GitlabFunctions.getApplicationPlain
import com.pulumi.gitlab.GitlabFunctions.getBranchPlain
import com.pulumi.gitlab.GitlabFunctions.getClusterAgentPlain
import com.pulumi.gitlab.GitlabFunctions.getClusterAgentsPlain
import com.pulumi.gitlab.GitlabFunctions.getComplianceFrameworkPlain
import com.pulumi.gitlab.GitlabFunctions.getCurrentUserPlain
import com.pulumi.gitlab.GitlabFunctions.getGroupHookPlain
import com.pulumi.gitlab.GitlabFunctions.getGroupHooksPlain
import com.pulumi.gitlab.GitlabFunctions.getGroupIdsPlain
import com.pulumi.gitlab.GitlabFunctions.getGroupMembershipPlain
import com.pulumi.gitlab.GitlabFunctions.getGroupPlain
import com.pulumi.gitlab.GitlabFunctions.getGroupSubgroupsPlain
import com.pulumi.gitlab.GitlabFunctions.getGroupVariablePlain
import com.pulumi.gitlab.GitlabFunctions.getGroupVariablesPlain
import com.pulumi.gitlab.GitlabFunctions.getGroupsPlain
import com.pulumi.gitlab.GitlabFunctions.getInstanceDeployKeysPlain
import com.pulumi.gitlab.GitlabFunctions.getInstanceVariablePlain
import com.pulumi.gitlab.GitlabFunctions.getInstanceVariablesPlain
import com.pulumi.gitlab.GitlabFunctions.getMetadataPlain
import com.pulumi.gitlab.GitlabFunctions.getPipelineSchedulePlain
import com.pulumi.gitlab.GitlabFunctions.getPipelineSchedulesPlain
import com.pulumi.gitlab.GitlabFunctions.getProjectBranchesPlain
import com.pulumi.gitlab.GitlabFunctions.getProjectHookPlain
import com.pulumi.gitlab.GitlabFunctions.getProjectHooksPlain
import com.pulumi.gitlab.GitlabFunctions.getProjectIdsPlain
import com.pulumi.gitlab.GitlabFunctions.getProjectIssuePlain
import com.pulumi.gitlab.GitlabFunctions.getProjectIssuesPlain
import com.pulumi.gitlab.GitlabFunctions.getProjectMembershipPlain
import com.pulumi.gitlab.GitlabFunctions.getProjectMilestonePlain
import com.pulumi.gitlab.GitlabFunctions.getProjectMilestonesPlain
import com.pulumi.gitlab.GitlabFunctions.getProjectPlain
import com.pulumi.gitlab.GitlabFunctions.getProjectProtectedBranchPlain
import com.pulumi.gitlab.GitlabFunctions.getProjectProtectedBranchesPlain
import com.pulumi.gitlab.GitlabFunctions.getProjectProtectedTagPlain
import com.pulumi.gitlab.GitlabFunctions.getProjectProtectedTagsPlain
import com.pulumi.gitlab.GitlabFunctions.getProjectTagPlain
import com.pulumi.gitlab.GitlabFunctions.getProjectTagsPlain
import com.pulumi.gitlab.GitlabFunctions.getProjectVariablePlain
import com.pulumi.gitlab.GitlabFunctions.getProjectVariablesPlain
import com.pulumi.gitlab.GitlabFunctions.getProjectsPlain
import com.pulumi.gitlab.GitlabFunctions.getReleaseLinkPlain
import com.pulumi.gitlab.GitlabFunctions.getReleaseLinksPlain
import com.pulumi.gitlab.GitlabFunctions.getReleasePlain
import com.pulumi.gitlab.GitlabFunctions.getRepositoryFilePlain
import com.pulumi.gitlab.GitlabFunctions.getRepositoryTreePlain
import com.pulumi.gitlab.GitlabFunctions.getUserPlain
import com.pulumi.gitlab.GitlabFunctions.getUserSshkeysPlain
import com.pulumi.gitlab.GitlabFunctions.getUsersPlain
import com.pulumi.gitlab.kotlin.inputs.GetApplicationPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetApplicationPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetBranchPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetBranchPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetClusterAgentPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetClusterAgentPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetClusterAgentsPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetClusterAgentsPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetComplianceFrameworkPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetComplianceFrameworkPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetGroupHookPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetGroupHookPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetGroupHooksPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetGroupHooksPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetGroupIdsPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetGroupIdsPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetGroupMembershipPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetGroupMembershipPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetGroupPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetGroupPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetGroupSubgroupsPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetGroupSubgroupsPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetGroupVariablePlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetGroupVariablePlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetGroupVariablesPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetGroupVariablesPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetGroupsPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetGroupsPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetInstanceDeployKeysPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetInstanceDeployKeysPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetInstanceVariablePlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetInstanceVariablePlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetPipelineSchedulePlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetPipelineSchedulePlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetPipelineSchedulesPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetPipelineSchedulesPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetProjectBranchesPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetProjectBranchesPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetProjectHookPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetProjectHookPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetProjectHooksPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetProjectHooksPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetProjectIdsPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetProjectIdsPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetProjectIssuePlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetProjectIssuePlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetProjectIssuesPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetProjectIssuesPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetProjectMembershipPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetProjectMembershipPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetProjectMilestonePlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetProjectMilestonePlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetProjectMilestonesPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetProjectMilestonesPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetProjectPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetProjectPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetProjectProtectedBranchMergeAccessLevel
import com.pulumi.gitlab.kotlin.inputs.GetProjectProtectedBranchPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetProjectProtectedBranchPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetProjectProtectedBranchPushAccessLevel
import com.pulumi.gitlab.kotlin.inputs.GetProjectProtectedBranchesPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetProjectProtectedBranchesPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetProjectProtectedBranchesProtectedBranch
import com.pulumi.gitlab.kotlin.inputs.GetProjectProtectedTagPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetProjectProtectedTagPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetProjectProtectedTagsPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetProjectProtectedTagsPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetProjectTagPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetProjectTagPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetProjectTagsPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetProjectTagsPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetProjectVariablePlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetProjectVariablePlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetProjectVariablesPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetProjectVariablesPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetProjectsPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetProjectsPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetReleaseAssets
import com.pulumi.gitlab.kotlin.inputs.GetReleaseLinkPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetReleaseLinkPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetReleaseLinksPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetReleaseLinksPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetReleasePlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetReleasePlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetRepositoryFilePlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetRepositoryFilePlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetRepositoryTreePlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetRepositoryTreePlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetUserPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetUserPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetUserSshkeysPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetUserSshkeysPlainArgsBuilder
import com.pulumi.gitlab.kotlin.inputs.GetUsersPlainArgs
import com.pulumi.gitlab.kotlin.inputs.GetUsersPlainArgsBuilder
import com.pulumi.gitlab.kotlin.outputs.GetApplicationResult
import com.pulumi.gitlab.kotlin.outputs.GetBranchResult
import com.pulumi.gitlab.kotlin.outputs.GetClusterAgentResult
import com.pulumi.gitlab.kotlin.outputs.GetClusterAgentsResult
import com.pulumi.gitlab.kotlin.outputs.GetComplianceFrameworkResult
import com.pulumi.gitlab.kotlin.outputs.GetCurrentUserResult
import com.pulumi.gitlab.kotlin.outputs.GetGroupHookResult
import com.pulumi.gitlab.kotlin.outputs.GetGroupHooksResult
import com.pulumi.gitlab.kotlin.outputs.GetGroupIdsResult
import com.pulumi.gitlab.kotlin.outputs.GetGroupMembershipResult
import com.pulumi.gitlab.kotlin.outputs.GetGroupResult
import com.pulumi.gitlab.kotlin.outputs.GetGroupSubgroupsResult
import com.pulumi.gitlab.kotlin.outputs.GetGroupVariableResult
import com.pulumi.gitlab.kotlin.outputs.GetGroupVariablesResult
import com.pulumi.gitlab.kotlin.outputs.GetGroupsResult
import com.pulumi.gitlab.kotlin.outputs.GetInstanceDeployKeysResult
import com.pulumi.gitlab.kotlin.outputs.GetInstanceVariableResult
import com.pulumi.gitlab.kotlin.outputs.GetInstanceVariablesResult
import com.pulumi.gitlab.kotlin.outputs.GetMetadataResult
import com.pulumi.gitlab.kotlin.outputs.GetPipelineScheduleResult
import com.pulumi.gitlab.kotlin.outputs.GetPipelineSchedulesResult
import com.pulumi.gitlab.kotlin.outputs.GetProjectBranchesResult
import com.pulumi.gitlab.kotlin.outputs.GetProjectHookResult
import com.pulumi.gitlab.kotlin.outputs.GetProjectHooksResult
import com.pulumi.gitlab.kotlin.outputs.GetProjectIdsResult
import com.pulumi.gitlab.kotlin.outputs.GetProjectIssueResult
import com.pulumi.gitlab.kotlin.outputs.GetProjectIssuesResult
import com.pulumi.gitlab.kotlin.outputs.GetProjectMembershipResult
import com.pulumi.gitlab.kotlin.outputs.GetProjectMilestoneResult
import com.pulumi.gitlab.kotlin.outputs.GetProjectMilestonesResult
import com.pulumi.gitlab.kotlin.outputs.GetProjectProtectedBranchResult
import com.pulumi.gitlab.kotlin.outputs.GetProjectProtectedBranchesResult
import com.pulumi.gitlab.kotlin.outputs.GetProjectProtectedTagResult
import com.pulumi.gitlab.kotlin.outputs.GetProjectProtectedTagsResult
import com.pulumi.gitlab.kotlin.outputs.GetProjectResult
import com.pulumi.gitlab.kotlin.outputs.GetProjectTagResult
import com.pulumi.gitlab.kotlin.outputs.GetProjectTagsResult
import com.pulumi.gitlab.kotlin.outputs.GetProjectVariableResult
import com.pulumi.gitlab.kotlin.outputs.GetProjectVariablesResult
import com.pulumi.gitlab.kotlin.outputs.GetProjectsResult
import com.pulumi.gitlab.kotlin.outputs.GetReleaseLinkResult
import com.pulumi.gitlab.kotlin.outputs.GetReleaseLinksResult
import com.pulumi.gitlab.kotlin.outputs.GetReleaseResult
import com.pulumi.gitlab.kotlin.outputs.GetRepositoryFileResult
import com.pulumi.gitlab.kotlin.outputs.GetRepositoryTreeResult
import com.pulumi.gitlab.kotlin.outputs.GetUserResult
import com.pulumi.gitlab.kotlin.outputs.GetUserSshkeysResult
import com.pulumi.gitlab.kotlin.outputs.GetUsersResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.gitlab.kotlin.outputs.GetApplicationResult.Companion.toKotlin as getApplicationResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetBranchResult.Companion.toKotlin as getBranchResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetClusterAgentResult.Companion.toKotlin as getClusterAgentResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetClusterAgentsResult.Companion.toKotlin as getClusterAgentsResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetComplianceFrameworkResult.Companion.toKotlin as getComplianceFrameworkResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetCurrentUserResult.Companion.toKotlin as getCurrentUserResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetGroupHookResult.Companion.toKotlin as getGroupHookResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetGroupHooksResult.Companion.toKotlin as getGroupHooksResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetGroupIdsResult.Companion.toKotlin as getGroupIdsResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetGroupMembershipResult.Companion.toKotlin as getGroupMembershipResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetGroupResult.Companion.toKotlin as getGroupResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetGroupSubgroupsResult.Companion.toKotlin as getGroupSubgroupsResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetGroupVariableResult.Companion.toKotlin as getGroupVariableResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetGroupVariablesResult.Companion.toKotlin as getGroupVariablesResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetGroupsResult.Companion.toKotlin as getGroupsResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetInstanceDeployKeysResult.Companion.toKotlin as getInstanceDeployKeysResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetInstanceVariableResult.Companion.toKotlin as getInstanceVariableResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetInstanceVariablesResult.Companion.toKotlin as getInstanceVariablesResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetMetadataResult.Companion.toKotlin as getMetadataResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetPipelineScheduleResult.Companion.toKotlin as getPipelineScheduleResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetPipelineSchedulesResult.Companion.toKotlin as getPipelineSchedulesResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetProjectBranchesResult.Companion.toKotlin as getProjectBranchesResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetProjectHookResult.Companion.toKotlin as getProjectHookResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetProjectHooksResult.Companion.toKotlin as getProjectHooksResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetProjectIdsResult.Companion.toKotlin as getProjectIdsResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetProjectIssueResult.Companion.toKotlin as getProjectIssueResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetProjectIssuesResult.Companion.toKotlin as getProjectIssuesResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetProjectMembershipResult.Companion.toKotlin as getProjectMembershipResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetProjectMilestoneResult.Companion.toKotlin as getProjectMilestoneResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetProjectMilestonesResult.Companion.toKotlin as getProjectMilestonesResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetProjectProtectedBranchResult.Companion.toKotlin as getProjectProtectedBranchResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetProjectProtectedBranchesResult.Companion.toKotlin as getProjectProtectedBranchesResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetProjectProtectedTagResult.Companion.toKotlin as getProjectProtectedTagResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetProjectProtectedTagsResult.Companion.toKotlin as getProjectProtectedTagsResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetProjectResult.Companion.toKotlin as getProjectResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetProjectTagResult.Companion.toKotlin as getProjectTagResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetProjectTagsResult.Companion.toKotlin as getProjectTagsResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetProjectVariableResult.Companion.toKotlin as getProjectVariableResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetProjectVariablesResult.Companion.toKotlin as getProjectVariablesResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetProjectsResult.Companion.toKotlin as getProjectsResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetReleaseLinkResult.Companion.toKotlin as getReleaseLinkResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetReleaseLinksResult.Companion.toKotlin as getReleaseLinksResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetReleaseResult.Companion.toKotlin as getReleaseResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetRepositoryFileResult.Companion.toKotlin as getRepositoryFileResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetRepositoryTreeResult.Companion.toKotlin as getRepositoryTreeResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetUserResult.Companion.toKotlin as getUserResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetUserSshkeysResult.Companion.toKotlin as getUserSshkeysResultToKotlin
import com.pulumi.gitlab.kotlin.outputs.GetUsersResult.Companion.toKotlin as getUsersResultToKotlin

public object GitlabFunctions {
    /**
     * The `gitlab.Application` data source retrieves information about a gitlab application.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/applications.html)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.gitlab.GitlabFunctions;
     * import com.pulumi.gitlab.inputs.GetApplicationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var oidc = GitlabFunctions.getApplication(GetApplicationArgs.builder()
     *             .applicationId(1)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   oidc:
     *     fn::invoke:
     *       Function: gitlab:getApplication
     *       Arguments:
     *         applicationId: 1
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getApplication.
     * @return A collection of values returned by getApplication.
     */
    public suspend fun getApplication(argument: GetApplicationPlainArgs): GetApplicationResult =
        getApplicationResultToKotlin(getApplicationPlain(argument.toJava()).await())

    /**
     * @see [getApplication].
     * @param id
     * @return A collection of values returned by getApplication.
     */
    public suspend fun getApplication(id: String): GetApplicationResult {
        val argument = GetApplicationPlainArgs(
            id = id,
        )
        return getApplicationResultToKotlin(getApplicationPlain(argument.toJava()).await())
    }

    /**
     * @see [getApplication].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetApplicationPlainArgs].
     * @return A collection of values returned by getApplication.
     */
    public suspend fun getApplication(argument: suspend GetApplicationPlainArgsBuilder.() -> Unit): GetApplicationResult {
        val builder = GetApplicationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApplicationResultToKotlin(getApplicationPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.Branch` data source allows details of a repository branch to be retrieved by its name and project.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/branches.html#get-single-repository-branch)
     * @param argument A collection of arguments for invoking getBranch.
     * @return A collection of values returned by getBranch.
     */
    public suspend fun getBranch(argument: GetBranchPlainArgs): GetBranchResult =
        getBranchResultToKotlin(getBranchPlain(argument.toJava()).await())

    /**
     * @see [getBranch].
     * @param name The name of the branch.
     * @param project The full path or id of the project.
     * @return A collection of values returned by getBranch.
     */
    public suspend fun getBranch(name: String, project: String): GetBranchResult {
        val argument = GetBranchPlainArgs(
            name = name,
            project = project,
        )
        return getBranchResultToKotlin(getBranchPlain(argument.toJava()).await())
    }

    /**
     * @see [getBranch].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetBranchPlainArgs].
     * @return A collection of values returned by getBranch.
     */
    public suspend fun getBranch(argument: suspend GetBranchPlainArgsBuilder.() -> Unit): GetBranchResult {
        val builder = GetBranchPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBranchResultToKotlin(getBranchPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.ClusterAgent` data source allows to retrieve details about a GitLab Agent for Kubernetes.
     * > Requires at least GitLab 14.10
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/cluster_agents.html)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as gitlab from "@pulumi/gitlab";
     * const example = gitlab.getClusterAgent({
     *     project: "12345",
     *     agentId: 1,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_gitlab as gitlab
     * example = gitlab.get_cluster_agent(project="12345",
     *     agent_id=1)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using GitLab = Pulumi.GitLab;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = GitLab.GetClusterAgent.Invoke(new()
     *     {
     *         Project = "12345",
     *         AgentId = 1,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := gitlab.LookupClusterAgent(ctx, &gitlab.LookupClusterAgentArgs{
     * 			Project: "12345",
     * 			AgentId: 1,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.gitlab.GitlabFunctions;
     * import com.pulumi.gitlab.inputs.GetClusterAgentArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = GitlabFunctions.getClusterAgent(GetClusterAgentArgs.builder()
     *             .project("12345")
     *             .agentId(1)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: gitlab:getClusterAgent
     *       Arguments:
     *         project: '12345'
     *         agentId: 1
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getClusterAgent.
     * @return A collection of values returned by getClusterAgent.
     */
    public suspend fun getClusterAgent(argument: GetClusterAgentPlainArgs): GetClusterAgentResult =
        getClusterAgentResultToKotlin(getClusterAgentPlain(argument.toJava()).await())

    /**
     * @see [getClusterAgent].
     * @param agentId The ID of the agent.
     * @param project ID or full path of the project maintained by the authenticated user.
     * @return A collection of values returned by getClusterAgent.
     */
    public suspend fun getClusterAgent(agentId: Int, project: String): GetClusterAgentResult {
        val argument = GetClusterAgentPlainArgs(
            agentId = agentId,
            project = project,
        )
        return getClusterAgentResultToKotlin(getClusterAgentPlain(argument.toJava()).await())
    }

    /**
     * @see [getClusterAgent].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetClusterAgentPlainArgs].
     * @return A collection of values returned by getClusterAgent.
     */
    public suspend fun getClusterAgent(argument: suspend GetClusterAgentPlainArgsBuilder.() -> Unit): GetClusterAgentResult {
        val builder = GetClusterAgentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterAgentResultToKotlin(getClusterAgentPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.getClusterAgents` data source allows details of GitLab Agents for Kubernetes in a project.
     * > Requires at least GitLab 14.10
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/cluster_agents.html)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as gitlab from "@pulumi/gitlab";
     * const agents = gitlab.getClusterAgents({
     *     project: "12345",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_gitlab as gitlab
     * agents = gitlab.get_cluster_agents(project="12345")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using GitLab = Pulumi.GitLab;
     * return await Deployment.RunAsync(() =>
     * {
     *     var agents = GitLab.GetClusterAgents.Invoke(new()
     *     {
     *         Project = "12345",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := gitlab.GetClusterAgents(ctx, &gitlab.GetClusterAgentsArgs{
     * 			Project: "12345",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.gitlab.GitlabFunctions;
     * import com.pulumi.gitlab.inputs.GetClusterAgentsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var agents = GitlabFunctions.getClusterAgents(GetClusterAgentsArgs.builder()
     *             .project("12345")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   agents:
     *     fn::invoke:
     *       Function: gitlab:getClusterAgents
     *       Arguments:
     *         project: '12345'
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getClusterAgents.
     * @return A collection of values returned by getClusterAgents.
     */
    public suspend fun getClusterAgents(argument: GetClusterAgentsPlainArgs): GetClusterAgentsResult =
        getClusterAgentsResultToKotlin(getClusterAgentsPlain(argument.toJava()).await())

    /**
     * @see [getClusterAgents].
     * @param project The ID or full path of the project owned by the authenticated user.
     * @return A collection of values returned by getClusterAgents.
     */
    public suspend fun getClusterAgents(project: String): GetClusterAgentsResult {
        val argument = GetClusterAgentsPlainArgs(
            project = project,
        )
        return getClusterAgentsResultToKotlin(getClusterAgentsPlain(argument.toJava()).await())
    }

    /**
     * @see [getClusterAgents].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetClusterAgentsPlainArgs].
     * @return A collection of values returned by getClusterAgents.
     */
    public suspend fun getClusterAgents(argument: suspend GetClusterAgentsPlainArgsBuilder.() -> Unit): GetClusterAgentsResult {
        val builder = GetClusterAgentsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterAgentsResultToKotlin(getClusterAgentsPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.ComplianceFramework` data source allows details of a compliance framework to be retrieved by its name and the namespace it belongs to.
     * **Upstream API**: [GitLab GraphQL API docs](https://docs.gitlab.com/ee/api/graphql/reference/#querynamespace)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as gitlab from "@pulumi/gitlab";
     * const example = gitlab.getComplianceFramework({
     *     namespacePath: "top-level-group",
     *     name: "HIPAA",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_gitlab as gitlab
     * example = gitlab.get_compliance_framework(namespace_path="top-level-group",
     *     name="HIPAA")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using GitLab = Pulumi.GitLab;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = GitLab.GetComplianceFramework.Invoke(new()
     *     {
     *         NamespacePath = "top-level-group",
     *         Name = "HIPAA",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := gitlab.LookupComplianceFramework(ctx, &gitlab.LookupComplianceFrameworkArgs{
     * 			NamespacePath: "top-level-group",
     * 			Name:          "HIPAA",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.gitlab.GitlabFunctions;
     * import com.pulumi.gitlab.inputs.GetComplianceFrameworkArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = GitlabFunctions.getComplianceFramework(GetComplianceFrameworkArgs.builder()
     *             .namespacePath("top-level-group")
     *             .name("HIPAA")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: gitlab:getComplianceFramework
     *       Arguments:
     *         namespacePath: top-level-group
     *         name: HIPAA
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getComplianceFramework.
     * @return A collection of values returned by getComplianceFramework.
     */
    public suspend fun getComplianceFramework(argument: GetComplianceFrameworkPlainArgs): GetComplianceFrameworkResult =
        getComplianceFrameworkResultToKotlin(getComplianceFrameworkPlain(argument.toJava()).await())

    /**
     * @see [getComplianceFramework].
     * @param name Name for the compliance framework.
     * @param namespacePath Full path of the namespace to where the compliance framework is.
     * @return A collection of values returned by getComplianceFramework.
     */
    public suspend fun getComplianceFramework(name: String, namespacePath: String): GetComplianceFrameworkResult {
        val argument = GetComplianceFrameworkPlainArgs(
            name = name,
            namespacePath = namespacePath,
        )
        return getComplianceFrameworkResultToKotlin(getComplianceFrameworkPlain(argument.toJava()).await())
    }

    /**
     * @see [getComplianceFramework].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetComplianceFrameworkPlainArgs].
     * @return A collection of values returned by getComplianceFramework.
     */
    public suspend fun getComplianceFramework(argument: suspend GetComplianceFrameworkPlainArgsBuilder.() -> Unit): GetComplianceFrameworkResult {
        val builder = GetComplianceFrameworkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getComplianceFrameworkResultToKotlin(getComplianceFrameworkPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.getCurrentUser` data source allows details of the current user (determined by `token` provider attribute) to be retrieved.
     * **Upstream API**: [GitLab GraphQL API docs](https://docs.gitlab.com/ee/api/graphql/reference/index.html#querycurrentuser)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as gitlab from "@pulumi/gitlab";
     * const example = gitlab.getCurrentUser({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_gitlab as gitlab
     * example = gitlab.get_current_user()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using GitLab = Pulumi.GitLab;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = GitLab.GetCurrentUser.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := gitlab.GetCurrentUser(ctx, map[string]interface{}{}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.gitlab.GitlabFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = GitlabFunctions.getCurrentUser();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: gitlab:getCurrentUser
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument The `gitlab.getCurrentUser` data source allows details of the current user (determined by `token` provider attribute) to be retrieved.
     * **Upstream API**: [GitLab GraphQL API docs](https://docs.gitlab.com/ee/api/graphql/reference/index.html#querycurrentuser)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as gitlab from "@pulumi/gitlab";
     * const example = gitlab.getCurrentUser({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_gitlab as gitlab
     * example = gitlab.get_current_user()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using GitLab = Pulumi.GitLab;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = GitLab.GetCurrentUser.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := gitlab.GetCurrentUser(ctx, map[string]interface{}{}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.gitlab.GitlabFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = GitlabFunctions.getCurrentUser();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: gitlab:getCurrentUser
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @return A collection of values returned by getCurrentUser.
     */
    public suspend fun getCurrentUser(): GetCurrentUserResult =
        getCurrentUserResultToKotlin(getCurrentUserPlain().await())

    /**
     * The `gitlab.Group` data source allows details of a group to be retrieved by its id or full path.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/groups.html#details-of-a-group)
     * @param argument A collection of arguments for invoking getGroup.
     * @return A collection of values returned by getGroup.
     */
    public suspend fun getGroup(argument: GetGroupPlainArgs): GetGroupResult =
        getGroupResultToKotlin(getGroupPlain(argument.toJava()).await())

    /**
     * @see [getGroup].
     * @param fullPath The full path of the group.
     * @param groupId The ID of the group.
     * @return A collection of values returned by getGroup.
     */
    public suspend fun getGroup(fullPath: String? = null, groupId: Int? = null): GetGroupResult {
        val argument = GetGroupPlainArgs(
            fullPath = fullPath,
            groupId = groupId,
        )
        return getGroupResultToKotlin(getGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getGroup].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetGroupPlainArgs].
     * @return A collection of values returned by getGroup.
     */
    public suspend fun getGroup(argument: suspend GetGroupPlainArgsBuilder.() -> Unit): GetGroupResult {
        val builder = GetGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGroupResultToKotlin(getGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.GroupHook` data source allows to retrieve details about a hook in a group.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/groups.html#get-group-hook)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.gitlab.GitlabFunctions;
     * import com.pulumi.gitlab.inputs.GetGroupArgs;
     * import com.pulumi.gitlab.inputs.GetGroupHookArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = GitlabFunctions.getGroup(GetGroupArgs.builder()
     *             .id("foo/bar/baz")
     *             .build());
     *         final var exampleGetGroupHook = GitlabFunctions.getGroupHook(GetGroupHookArgs.builder()
     *             .group(example.applyValue(getGroupResult -> getGroupResult.id()))
     *             .hookId(1)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: gitlab:getGroup
     *       Arguments:
     *         id: foo/bar/baz
     *   exampleGetGroupHook:
     *     fn::invoke:
     *       Function: gitlab:getGroupHook
     *       Arguments:
     *         group: ${example.id}
     *         hookId: 1
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGroupHook.
     * @return A collection of values returned by getGroupHook.
     */
    public suspend fun getGroupHook(argument: GetGroupHookPlainArgs): GetGroupHookResult =
        getGroupHookResultToKotlin(getGroupHookPlain(argument.toJava()).await())

    /**
     * @see [getGroupHook].
     * @param group The ID or full path of the group.
     * @param hookId The id of the group hook.
     * @return A collection of values returned by getGroupHook.
     */
    public suspend fun getGroupHook(group: String, hookId: Int): GetGroupHookResult {
        val argument = GetGroupHookPlainArgs(
            group = group,
            hookId = hookId,
        )
        return getGroupHookResultToKotlin(getGroupHookPlain(argument.toJava()).await())
    }

    /**
     * @see [getGroupHook].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetGroupHookPlainArgs].
     * @return A collection of values returned by getGroupHook.
     */
    public suspend fun getGroupHook(argument: suspend GetGroupHookPlainArgsBuilder.() -> Unit): GetGroupHookResult {
        val builder = GetGroupHookPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGroupHookResultToKotlin(getGroupHookPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.getGroupHooks` data source allows to retrieve details about hooks in a group.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/groups.html#list-group-hooks)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.gitlab.GitlabFunctions;
     * import com.pulumi.gitlab.inputs.GetGroupArgs;
     * import com.pulumi.gitlab.inputs.GetGroupHooksArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = GitlabFunctions.getGroup(GetGroupArgs.builder()
     *             .id("foo/bar/baz")
     *             .build());
     *         final var examples = GitlabFunctions.getGroupHooks(GetGroupHooksArgs.builder()
     *             .group(example.applyValue(getGroupResult -> getGroupResult.id()))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: gitlab:getGroup
     *       Arguments:
     *         id: foo/bar/baz
     *   examples:
     *     fn::invoke:
     *       Function: gitlab:getGroupHooks
     *       Arguments:
     *         group: ${example.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGroupHooks.
     * @return A collection of values returned by getGroupHooks.
     */
    public suspend fun getGroupHooks(argument: GetGroupHooksPlainArgs): GetGroupHooksResult =
        getGroupHooksResultToKotlin(getGroupHooksPlain(argument.toJava()).await())

    /**
     * @see [getGroupHooks].
     * @param group The ID or full path of the group.
     * @return A collection of values returned by getGroupHooks.
     */
    public suspend fun getGroupHooks(group: String): GetGroupHooksResult {
        val argument = GetGroupHooksPlainArgs(
            group = group,
        )
        return getGroupHooksResultToKotlin(getGroupHooksPlain(argument.toJava()).await())
    }

    /**
     * @see [getGroupHooks].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetGroupHooksPlainArgs].
     * @return A collection of values returned by getGroupHooks.
     */
    public suspend fun getGroupHooks(argument: suspend GetGroupHooksPlainArgsBuilder.() -> Unit): GetGroupHooksResult {
        val builder = GetGroupHooksPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGroupHooksResultToKotlin(getGroupHooksPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.getGroupIds` data source identification information for a given group, allowing a user to translate a full path or ID into the GraphQL ID of the group.
     * **Upstream API**: [GitLab GraphQL API docs](https://docs.gitlab.com/ee/api/graphql/reference/#querygroup)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as gitlab from "@pulumi/gitlab";
     * const newGroup = new gitlab.Group("new_group", {});
     * // use group IDs to get additional information, such as the GraphQL ID
     * // for other resources
     * const foo = gitlab.getGroupIds({
     *     group: "gitlab_group.new_group.id",
     * });
     * export const graphQLId = foo.then(foo => foo.groupGraphqlId);
     * ```
     * ```python
     * import pulumi
     * import pulumi_gitlab as gitlab
     * new_group = gitlab.Group("new_group")
     * # use group IDs to get additional information, such as the GraphQL ID
     * # for other resources
     * foo = gitlab.get_group_ids(group="gitlab_group.new_group.id")
     * pulumi.export("graphQLId", foo.group_graphql_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using GitLab = Pulumi.GitLab;
     * return await Deployment.RunAsync(() =>
     * {
     *     var newGroup = new GitLab.Group("new_group");
     *     // use group IDs to get additional information, such as the GraphQL ID
     *     // for other resources
     *     var foo = GitLab.GetGroupIds.Invoke(new()
     *     {
     *         Group = "gitlab_group.new_group.id",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["graphQLId"] = foo.Apply(getGroupIdsResult => getGroupIdsResult.GroupGraphqlId),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := gitlab.NewGroup(ctx, "new_group", nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		// use group IDs to get additional information, such as the GraphQL ID
     * 		// for other resources
     * 		foo, err := gitlab.GetGroupIds(ctx, &gitlab.GetGroupIdsArgs{
     * 			Group: "gitlab_group.new_group.id",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("graphQLId", foo.GroupGraphqlId)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.gitlab.Group;
     * import com.pulumi.gitlab.GitlabFunctions;
     * import com.pulumi.gitlab.inputs.GetGroupIdsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var newGroup = new Group("newGroup");
     *         // use group IDs to get additional information, such as the GraphQL ID
     *         // for other resources
     *         final var foo = GitlabFunctions.getGroupIds(GetGroupIdsArgs.builder()
     *             .group("gitlab_group.new_group.id")
     *             .build());
     *         ctx.export("graphQLId", foo.applyValue(getGroupIdsResult -> getGroupIdsResult.groupGraphqlId()));
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   newGroup:
     *     type: gitlab:Group
     *     name: new_group
     * variables:
     *   # use group IDs to get additional information, such as the GraphQL ID
     *   # // for other resources
     *   foo:
     *     fn::invoke:
     *       Function: gitlab:getGroupIds
     *       Arguments:
     *         group: gitlab_group.new_group.id
     * outputs:
     *   graphQLId: ${foo.groupGraphqlId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGroupIds.
     * @return A collection of values returned by getGroupIds.
     */
    public suspend fun getGroupIds(argument: GetGroupIdsPlainArgs): GetGroupIdsResult =
        getGroupIdsResultToKotlin(getGroupIdsPlain(argument.toJava()).await())

    /**
     * @see [getGroupIds].
     * @param group The ID or URL-encoded path of the group.
     * @return A collection of values returned by getGroupIds.
     */
    public suspend fun getGroupIds(group: String): GetGroupIdsResult {
        val argument = GetGroupIdsPlainArgs(
            group = group,
        )
        return getGroupIdsResultToKotlin(getGroupIdsPlain(argument.toJava()).await())
    }

    /**
     * @see [getGroupIds].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetGroupIdsPlainArgs].
     * @return A collection of values returned by getGroupIds.
     */
    public suspend fun getGroupIds(argument: suspend GetGroupIdsPlainArgsBuilder.() -> Unit): GetGroupIdsResult {
        val builder = GetGroupIdsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGroupIdsResultToKotlin(getGroupIdsPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.GroupMembership` data source allows to list and filter all members of a group specified by either its id or full path.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/members.html#list-all-members-of-a-group-or-project)
     * @param argument A collection of arguments for invoking getGroupMembership.
     * @return A collection of values returned by getGroupMembership.
     */
    public suspend fun getGroupMembership(argument: GetGroupMembershipPlainArgs): GetGroupMembershipResult =
        getGroupMembershipResultToKotlin(getGroupMembershipPlain(argument.toJava()).await())

    /**
     * @see [getGroupMembership].
     * @param accessLevel Only return members with the desired access level. Acceptable values are: `guest`, `reporter`, `developer`, `maintainer`, `owner`.
     * @param fullPath The full path of the group.
     * @param groupId The ID of the group.
     * @param inherited Return all project members including members through ancestor groups.
     * @return A collection of values returned by getGroupMembership.
     */
    public suspend fun getGroupMembership(
        accessLevel: String? = null,
        fullPath: String? = null,
        groupId: Int? = null,
        inherited: Boolean? = null,
    ): GetGroupMembershipResult {
        val argument = GetGroupMembershipPlainArgs(
            accessLevel = accessLevel,
            fullPath = fullPath,
            groupId = groupId,
            inherited = inherited,
        )
        return getGroupMembershipResultToKotlin(getGroupMembershipPlain(argument.toJava()).await())
    }

    /**
     * @see [getGroupMembership].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetGroupMembershipPlainArgs].
     * @return A collection of values returned by getGroupMembership.
     */
    public suspend fun getGroupMembership(argument: suspend GetGroupMembershipPlainArgsBuilder.() -> Unit): GetGroupMembershipResult {
        val builder = GetGroupMembershipPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGroupMembershipResultToKotlin(getGroupMembershipPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.getGroupSubgroups` data source allows to get subgroups of a group.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/groups.html#list-a-groups-subgroups)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as gitlab from "@pulumi/gitlab";
     * export = async () => {
     *     const subgroups = await gitlab.getGroupSubgroups({
     *         groupId: 123456,
     *     });
     *     return {
     *         subgroups: subgroups,
     *     };
     * }
     * ```
     * ```python
     * import pulumi
     * import pulumi_gitlab as gitlab
     * subgroups = gitlab.get_group_subgroups(group_id=123456)
     * pulumi.export("subgroups", subgroups)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using GitLab = Pulumi.GitLab;
     * return await Deployment.RunAsync(() =>
     * {
     *     var subgroups = GitLab.GetGroupSubgroups.Invoke(new()
     *     {
     *         GroupId = 123456,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["subgroups"] = subgroups,
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		subgroups, err := gitlab.GetGroupSubgroups(ctx, &gitlab.GetGroupSubgroupsArgs{
     * 			GroupId: 123456,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("subgroups", subgroups)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.gitlab.GitlabFunctions;
     * import com.pulumi.gitlab.inputs.GetGroupSubgroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var subgroups = GitlabFunctions.getGroupSubgroups(GetGroupSubgroupsArgs.builder()
     *             .groupId("123456")
     *             .build());
     *         ctx.export("subgroups", subgroups.applyValue(getGroupSubgroupsResult -> getGroupSubgroupsResult));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   subgroups:
     *     fn::invoke:
     *       Function: gitlab:getGroupSubgroups
     *       Arguments:
     *         groupId: '123456'
     * outputs:
     *   subgroups: ${subgroups}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGroupSubgroups.
     * @return A collection of values returned by getGroupSubgroups.
     */
    public suspend fun getGroupSubgroups(argument: GetGroupSubgroupsPlainArgs): GetGroupSubgroupsResult =
        getGroupSubgroupsResultToKotlin(getGroupSubgroupsPlain(argument.toJava()).await())

    /**
     * @see [getGroupSubgroups].
     * @param allAvailable Show all the groups you have access to.
     * @param groupId The ID of the group.
     * @param minAccessLevel Limit to groups where current user has at least this access level.
     * @param orderBy Order groups by name, path or id.
     * @param owned Limit to groups explicitly owned by the current user.
     * @param search Return the list of authorized groups matching the search criteria.
     * @param skipGroups Skip the group IDs passed.
     * @param sort Order groups in asc or desc order.
     * @param statistics Include group statistics (administrators only).
     * @param withCustomAttributes Include custom attributes in response (administrators only).
     * @return A collection of values returned by getGroupSubgroups.
     */
    public suspend fun getGroupSubgroups(
        allAvailable: Boolean? = null,
        groupId: Int,
        minAccessLevel: String? = null,
        orderBy: String? = null,
        owned: Boolean? = null,
        search: String? = null,
        skipGroups: List<Int>? = null,
        sort: String? = null,
        statistics: Boolean? = null,
        withCustomAttributes: Boolean? = null,
    ): GetGroupSubgroupsResult {
        val argument = GetGroupSubgroupsPlainArgs(
            allAvailable = allAvailable,
            groupId = groupId,
            minAccessLevel = minAccessLevel,
            orderBy = orderBy,
            owned = owned,
            search = search,
            skipGroups = skipGroups,
            sort = sort,
            statistics = statistics,
            withCustomAttributes = withCustomAttributes,
        )
        return getGroupSubgroupsResultToKotlin(getGroupSubgroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getGroupSubgroups].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetGroupSubgroupsPlainArgs].
     * @return A collection of values returned by getGroupSubgroups.
     */
    public suspend fun getGroupSubgroups(argument: suspend GetGroupSubgroupsPlainArgsBuilder.() -> Unit): GetGroupSubgroupsResult {
        val builder = GetGroupSubgroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGroupSubgroupsResultToKotlin(getGroupSubgroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.GroupVariable` data source allows to retrieve details about a group-level CI/CD variable.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/group_level_variables.html)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as gitlab from "@pulumi/gitlab";
     * const foo = gitlab.getGroupVariable({
     *     group: "my/example/group",
     *     key: "foo",
     * });
     * // Using an environment scope
     * const bar = gitlab.getGroupVariable({
     *     group: "my/example/group",
     *     key: "bar",
     *     environmentScope: "staging/*",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_gitlab as gitlab
     * foo = gitlab.get_group_variable(group="my/example/group",
     *     key="foo")
     * # Using an environment scope
     * bar = gitlab.get_group_variable(group="my/example/group",
     *     key="bar",
     *     environment_scope="staging/*")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using GitLab = Pulumi.GitLab;
     * return await Deployment.RunAsync(() =>
     * {
     *     var foo = GitLab.GetGroupVariable.Invoke(new()
     *     {
     *         Group = "my/example/group",
     *         Key = "foo",
     *     });
     *     // Using an environment scope
     *     var bar = GitLab.GetGroupVariable.Invoke(new()
     *     {
     *         Group = "my/example/group",
     *         Key = "bar",
     *         EnvironmentScope = "staging/*",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := gitlab.LookupGroupVariable(ctx, &gitlab.LookupGroupVariableArgs{
     * 			Group: "my/example/group",
     * 			Key:   "foo",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		// Using an environment scope
     * 		_, err = gitlab.LookupGroupVariable(ctx, &gitlab.LookupGroupVariableArgs{
     * 			Group:            "my/example/group",
     * 			Key:              "bar",
     * 			EnvironmentScope: pulumi.StringRef("staging/*"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.gitlab.GitlabFunctions;
     * import com.pulumi.gitlab.inputs.GetGroupVariableArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var foo = GitlabFunctions.getGroupVariable(GetGroupVariableArgs.builder()
     *             .group("my/example/group")
     *             .key("foo")
     *             .build());
     *         // Using an environment scope
     *         final var bar = GitlabFunctions.getGroupVariable(GetGroupVariableArgs.builder()
     *             .group("my/example/group")
     *             .key("bar")
     *             .environmentScope("staging/*")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   foo:
     *     fn::invoke:
     *       Function: gitlab:getGroupVariable
     *       Arguments:
     *         group: my/example/group
     *         key: foo
     *   # Using an environment scope
     *   bar:
     *     fn::invoke:
     *       Function: gitlab:getGroupVariable
     *       Arguments:
     *         group: my/example/group
     *         key: bar
     *         environmentScope: staging/*
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGroupVariable.
     * @return A collection of values returned by getGroupVariable.
     * */*/*/*/*/*/
     */
    public suspend fun getGroupVariable(argument: GetGroupVariablePlainArgs): GetGroupVariableResult =
        getGroupVariableResultToKotlin(getGroupVariablePlain(argument.toJava()).await())

    /**
     * @see [getGroupVariable].
     * @param environmentScope The environment scope of the variable. Defaults to all environment (`*`). Note that in Community Editions of Gitlab, values other than `*` will cause inconsistent plans.
     * @param group The name or id of the group.
     * @param key The name of the variable.
     * @return A collection of values returned by getGroupVariable.
     */
    public suspend fun getGroupVariable(
        environmentScope: String? = null,
        group: String,
        key: String,
    ): GetGroupVariableResult {
        val argument = GetGroupVariablePlainArgs(
            environmentScope = environmentScope,
            group = group,
            key = key,
        )
        return getGroupVariableResultToKotlin(getGroupVariablePlain(argument.toJava()).await())
    }

    /**
     * @see [getGroupVariable].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetGroupVariablePlainArgs].
     * @return A collection of values returned by getGroupVariable.
     */
    public suspend fun getGroupVariable(argument: suspend GetGroupVariablePlainArgsBuilder.() -> Unit): GetGroupVariableResult {
        val builder = GetGroupVariablePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGroupVariableResultToKotlin(getGroupVariablePlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.getGroupVariables` data source allows to retrieve all group-level CI/CD variables.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/group_level_variables.html)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as gitlab from "@pulumi/gitlab";
     * const vars = gitlab.getGroupVariables({
     *     group: "my/example/group",
     * });
     * // Using an environment scope
     * const stagingVars = gitlab.getGroupVariables({
     *     group: "my/example/group",
     *     environmentScope: "staging/*",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_gitlab as gitlab
     * vars = gitlab.get_group_variables(group="my/example/group")
     * # Using an environment scope
     * staging_vars = gitlab.get_group_variables(group="my/example/group",
     *     environment_scope="staging/*")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using GitLab = Pulumi.GitLab;
     * return await Deployment.RunAsync(() =>
     * {
     *     var vars = GitLab.GetGroupVariables.Invoke(new()
     *     {
     *         Group = "my/example/group",
     *     });
     *     // Using an environment scope
     *     var stagingVars = GitLab.GetGroupVariables.Invoke(new()
     *     {
     *         Group = "my/example/group",
     *         EnvironmentScope = "staging/*",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := gitlab.GetGroupVariables(ctx, &gitlab.GetGroupVariablesArgs{
     * 			Group: "my/example/group",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		// Using an environment scope
     * 		_, err = gitlab.GetGroupVariables(ctx, &gitlab.GetGroupVariablesArgs{
     * 			Group:            "my/example/group",
     * 			EnvironmentScope: pulumi.StringRef("staging/*"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.gitlab.GitlabFunctions;
     * import com.pulumi.gitlab.inputs.GetGroupVariablesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var vars = GitlabFunctions.getGroupVariables(GetGroupVariablesArgs.builder()
     *             .group("my/example/group")
     *             .build());
     *         // Using an environment scope
     *         final var stagingVars = GitlabFunctions.getGroupVariables(GetGroupVariablesArgs.builder()
     *             .group("my/example/group")
     *             .environmentScope("staging/*")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   vars:
     *     fn::invoke:
     *       Function: gitlab:getGroupVariables
     *       Arguments:
     *         group: my/example/group
     *   # Using an environment scope
     *   stagingVars:
     *     fn::invoke:
     *       Function: gitlab:getGroupVariables
     *       Arguments:
     *         group: my/example/group
     *         environmentScope: staging/*
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGroupVariables.
     * @return A collection of values returned by getGroupVariables.
     * */*/*/*/*/*/
     */
    public suspend fun getGroupVariables(argument: GetGroupVariablesPlainArgs): GetGroupVariablesResult =
        getGroupVariablesResultToKotlin(getGroupVariablesPlain(argument.toJava()).await())

    /**
     * @see [getGroupVariables].
     * @param environmentScope The environment scope of the variable. Defaults to all environment (`*`).
     * @param group The name or id of the group.
     * @return A collection of values returned by getGroupVariables.
     */
    public suspend fun getGroupVariables(environmentScope: String? = null, group: String): GetGroupVariablesResult {
        val argument = GetGroupVariablesPlainArgs(
            environmentScope = environmentScope,
            group = group,
        )
        return getGroupVariablesResultToKotlin(getGroupVariablesPlain(argument.toJava()).await())
    }

    /**
     * @see [getGroupVariables].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetGroupVariablesPlainArgs].
     * @return A collection of values returned by getGroupVariables.
     */
    public suspend fun getGroupVariables(argument: suspend GetGroupVariablesPlainArgsBuilder.() -> Unit): GetGroupVariablesResult {
        val builder = GetGroupVariablesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGroupVariablesResultToKotlin(getGroupVariablesPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.getGroups` data source allows details of multiple groups to be retrieved given some optional filter criteria.
     * > Some attributes might not be returned depending on if you're an admin or not.
     * > Some available options require administrator privileges.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/groups.html#list-groups)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as gitlab from "@pulumi/gitlab";
     * const example = gitlab.getGroups({
     *     sort: "desc",
     *     orderBy: "name",
     * });
     * const example-two = gitlab.getGroups({
     *     search: "GitLab",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_gitlab as gitlab
     * example = gitlab.get_groups(sort="desc",
     *     order_by="name")
     * example_two = gitlab.get_groups(search="GitLab")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using GitLab = Pulumi.GitLab;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = GitLab.GetGroups.Invoke(new()
     *     {
     *         Sort = "desc",
     *         OrderBy = "name",
     *     });
     *     var example_two = GitLab.GetGroups.Invoke(new()
     *     {
     *         Search = "GitLab",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := gitlab.GetGroups(ctx, &gitlab.GetGroupsArgs{
     * 			Sort:    pulumi.StringRef("desc"),
     * 			OrderBy: pulumi.StringRef("name"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = gitlab.GetGroups(ctx, &gitlab.GetGroupsArgs{
     * 			Search: pulumi.StringRef("GitLab"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.gitlab.GitlabFunctions;
     * import com.pulumi.gitlab.inputs.GetGroupsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = GitlabFunctions.getGroups(GetGroupsArgs.builder()
     *             .sort("desc")
     *             .orderBy("name")
     *             .build());
     *         final var example-two = GitlabFunctions.getGroups(GetGroupsArgs.builder()
     *             .search("GitLab")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: gitlab:getGroups
     *       Arguments:
     *         sort: desc
     *         orderBy: name
     *   example-two:
     *     fn::invoke:
     *       Function: gitlab:getGroups
     *       Arguments:
     *         search: GitLab
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGroups.
     * @return A collection of values returned by getGroups.
     */
    public suspend fun getGroups(argument: GetGroupsPlainArgs): GetGroupsResult =
        getGroupsResultToKotlin(getGroupsPlain(argument.toJava()).await())

    /**
     * @see [getGroups].
     * @param orderBy Order the groups' list by `id`, `name`, `path`, or `similarity`. (Requires administrator privileges)
     * @param search Search groups by name or path.
     * @param sort Sort groups' list in asc or desc order. (Requires administrator privileges)
     * @param topLevelOnly Limit to top level groups, excluding all subgroups.
     * @return A collection of values returned by getGroups.
     */
    public suspend fun getGroups(
        orderBy: String? = null,
        search: String? = null,
        sort: String? = null,
        topLevelOnly: Boolean? = null,
    ): GetGroupsResult {
        val argument = GetGroupsPlainArgs(
            orderBy = orderBy,
            search = search,
            sort = sort,
            topLevelOnly = topLevelOnly,
        )
        return getGroupsResultToKotlin(getGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getGroups].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetGroupsPlainArgs].
     * @return A collection of values returned by getGroups.
     */
    public suspend fun getGroups(argument: suspend GetGroupsPlainArgsBuilder.() -> Unit): GetGroupsResult {
        val builder = GetGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGroupsResultToKotlin(getGroupsPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.getInstanceDeployKeys` data source allows to retrieve a list of deploy keys for a GitLab instance.
     * > This data source requires administration privileges.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/deploy_keys.html#list-all-deploy-keys)
     * @param argument A collection of arguments for invoking getInstanceDeployKeys.
     * @return A collection of values returned by getInstanceDeployKeys.
     */
    public suspend fun getInstanceDeployKeys(argument: GetInstanceDeployKeysPlainArgs): GetInstanceDeployKeysResult =
        getInstanceDeployKeysResultToKotlin(getInstanceDeployKeysPlain(argument.toJava()).await())

    /**
     * @see [getInstanceDeployKeys].
     * @param public Only return deploy keys that are public.
     * @return A collection of values returned by getInstanceDeployKeys.
     */
    public suspend fun getInstanceDeployKeys(`public`: Boolean? = null): GetInstanceDeployKeysResult {
        val argument = GetInstanceDeployKeysPlainArgs(
            `public` = `public`,
        )
        return getInstanceDeployKeysResultToKotlin(getInstanceDeployKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstanceDeployKeys].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetInstanceDeployKeysPlainArgs].
     * @return A collection of values returned by getInstanceDeployKeys.
     */
    public suspend fun getInstanceDeployKeys(argument: suspend GetInstanceDeployKeysPlainArgsBuilder.() -> Unit): GetInstanceDeployKeysResult {
        val builder = GetInstanceDeployKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceDeployKeysResultToKotlin(getInstanceDeployKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.InstanceVariable` data source allows to retrieve details about an instance-level CI/CD variable.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/instance_level_ci_variables.html)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as gitlab from "@pulumi/gitlab";
     * const foo = gitlab.getInstanceVariable({
     *     key: "foo",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_gitlab as gitlab
     * foo = gitlab.get_instance_variable(key="foo")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using GitLab = Pulumi.GitLab;
     * return await Deployment.RunAsync(() =>
     * {
     *     var foo = GitLab.GetInstanceVariable.Invoke(new()
     *     {
     *         Key = "foo",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := gitlab.LookupInstanceVariable(ctx, &gitlab.LookupInstanceVariableArgs{
     * 			Key: "foo",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.gitlab.GitlabFunctions;
     * import com.pulumi.gitlab.inputs.GetInstanceVariableArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var foo = GitlabFunctions.getInstanceVariable(GetInstanceVariableArgs.builder()
     *             .key("foo")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   foo:
     *     fn::invoke:
     *       Function: gitlab:getInstanceVariable
     *       Arguments:
     *         key: foo
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstanceVariable.
     * @return A collection of values returned by getInstanceVariable.
     */
    public suspend fun getInstanceVariable(argument: GetInstanceVariablePlainArgs): GetInstanceVariableResult =
        getInstanceVariableResultToKotlin(getInstanceVariablePlain(argument.toJava()).await())

    /**
     * @see [getInstanceVariable].
     * @param key The name of the variable.
     * @return A collection of values returned by getInstanceVariable.
     */
    public suspend fun getInstanceVariable(key: String): GetInstanceVariableResult {
        val argument = GetInstanceVariablePlainArgs(
            key = key,
        )
        return getInstanceVariableResultToKotlin(getInstanceVariablePlain(argument.toJava()).await())
    }

    /**
     * @see [getInstanceVariable].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetInstanceVariablePlainArgs].
     * @return A collection of values returned by getInstanceVariable.
     */
    public suspend fun getInstanceVariable(argument: suspend GetInstanceVariablePlainArgsBuilder.() -> Unit): GetInstanceVariableResult {
        val builder = GetInstanceVariablePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceVariableResultToKotlin(getInstanceVariablePlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.getInstanceVariables` data source allows to retrieve all instance-level CI/CD variables.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/instance_level_ci_variables.html)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as gitlab from "@pulumi/gitlab";
     * const vars = gitlab.getInstanceVariables({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_gitlab as gitlab
     * vars = gitlab.get_instance_variables()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using GitLab = Pulumi.GitLab;
     * return await Deployment.RunAsync(() =>
     * {
     *     var vars = GitLab.GetInstanceVariables.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := gitlab.GetInstanceVariables(ctx, map[string]interface{}{}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.gitlab.GitlabFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var vars = GitlabFunctions.getInstanceVariables();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   vars:
     *     fn::invoke:
     *       Function: gitlab:getInstanceVariables
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument The `gitlab.getInstanceVariables` data source allows to retrieve all instance-level CI/CD variables.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/instance_level_ci_variables.html)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as gitlab from "@pulumi/gitlab";
     * const vars = gitlab.getInstanceVariables({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_gitlab as gitlab
     * vars = gitlab.get_instance_variables()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using GitLab = Pulumi.GitLab;
     * return await Deployment.RunAsync(() =>
     * {
     *     var vars = GitLab.GetInstanceVariables.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := gitlab.GetInstanceVariables(ctx, map[string]interface{}{}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.gitlab.GitlabFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var vars = GitlabFunctions.getInstanceVariables();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   vars:
     *     fn::invoke:
     *       Function: gitlab:getInstanceVariables
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @return A collection of values returned by getInstanceVariables.
     */
    public suspend fun getInstanceVariables(): GetInstanceVariablesResult =
        getInstanceVariablesResultToKotlin(getInstanceVariablesPlain().await())

    /**
     * The `gitlab.getMetadata` data source retrieves the metadata of the GitLab instance.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/metadata.html)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as gitlab from "@pulumi/gitlab";
     * const this = gitlab.getMetadata({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_gitlab as gitlab
     * this = gitlab.get_metadata()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using GitLab = Pulumi.GitLab;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @this = GitLab.GetMetadata.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := gitlab.GetMetadata(ctx, map[string]interface{}{}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.gitlab.GitlabFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var this = GitlabFunctions.getMetadata();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   this:
     *     fn::invoke:
     *       Function: gitlab:getMetadata
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument The `gitlab.getMetadata` data source retrieves the metadata of the GitLab instance.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/metadata.html)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as gitlab from "@pulumi/gitlab";
     * const this = gitlab.getMetadata({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_gitlab as gitlab
     * this = gitlab.get_metadata()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using GitLab = Pulumi.GitLab;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @this = GitLab.GetMetadata.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := gitlab.GetMetadata(ctx, map[string]interface{}{}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.gitlab.GitlabFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var this = GitlabFunctions.getMetadata();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   this:
     *     fn::invoke:
     *       Function: gitlab:getMetadata
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @return A collection of values returned by getMetadata.
     */
    public suspend fun getMetadata(): GetMetadataResult =
        getMetadataResultToKotlin(getMetadataPlain().await())

    /**
     * The `gitlab.PipelineSchedule` data source retrieves information about a gitlab pipeline schedule for a project.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/pipeline_schedules.html)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as gitlab from "@pulumi/gitlab";
     * const example = gitlab.getPipelineSchedule({
     *     project: "12345",
     *     pipelineScheduleId: 1,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_gitlab as gitlab
     * example = gitlab.get_pipeline_schedule(project="12345",
     *     pipeline_schedule_id=1)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using GitLab = Pulumi.GitLab;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = GitLab.GetPipelineSchedule.Invoke(new()
     *     {
     *         Project = "12345",
     *         PipelineScheduleId = 1,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := gitlab.LookupPipelineSchedule(ctx, &gitlab.LookupPipelineScheduleArgs{
     * 			Project:            "12345",
     * 			PipelineScheduleId: 1,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.gitlab.GitlabFunctions;
     * import com.pulumi.gitlab.inputs.GetPipelineScheduleArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = GitlabFunctions.getPipelineSchedule(GetPipelineScheduleArgs.builder()
     *             .project("12345")
     *             .pipelineScheduleId(1)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: gitlab:getPipelineSchedule
     *       Arguments:
     *         project: '12345'
     *         pipelineScheduleId: 1
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPipelineSchedule.
     * @return A collection of values returned by getPipelineSchedule.
     */
    public suspend fun getPipelineSchedule(argument: GetPipelineSchedulePlainArgs): GetPipelineScheduleResult =
        getPipelineScheduleResultToKotlin(getPipelineSchedulePlain(argument.toJava()).await())

    /**
     * @see [getPipelineSchedule].
     * @param cronTimezone The timezone.
     * @param pipelineScheduleId The pipeline schedule id.
     * @param project The name or id of the project to add the schedule to.
     * @return A collection of values returned by getPipelineSchedule.
     */
    public suspend fun getPipelineSchedule(
        cronTimezone: String? = null,
        pipelineScheduleId: Int,
        project: String,
    ): GetPipelineScheduleResult {
        val argument = GetPipelineSchedulePlainArgs(
            cronTimezone = cronTimezone,
            pipelineScheduleId = pipelineScheduleId,
            project = project,
        )
        return getPipelineScheduleResultToKotlin(getPipelineSchedulePlain(argument.toJava()).await())
    }

    /**
     * @see [getPipelineSchedule].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetPipelineSchedulePlainArgs].
     * @return A collection of values returned by getPipelineSchedule.
     */
    public suspend fun getPipelineSchedule(argument: suspend GetPipelineSchedulePlainArgsBuilder.() -> Unit): GetPipelineScheduleResult {
        val builder = GetPipelineSchedulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPipelineScheduleResultToKotlin(getPipelineSchedulePlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.PipelineSchedule` data source retrieves information about a gitlab pipeline schedule for a project.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/pipeline_schedules.html)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as gitlab from "@pulumi/gitlab";
     * const example = gitlab.getPipelineSchedules({
     *     project: "12345",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_gitlab as gitlab
     * example = gitlab.get_pipeline_schedules(project="12345")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using GitLab = Pulumi.GitLab;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = GitLab.GetPipelineSchedules.Invoke(new()
     *     {
     *         Project = "12345",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := gitlab.GetPipelineSchedules(ctx, &gitlab.GetPipelineSchedulesArgs{
     * 			Project: "12345",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.gitlab.GitlabFunctions;
     * import com.pulumi.gitlab.inputs.GetPipelineSchedulesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = GitlabFunctions.getPipelineSchedules(GetPipelineSchedulesArgs.builder()
     *             .project("12345")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: gitlab:getPipelineSchedules
     *       Arguments:
     *         project: '12345'
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPipelineSchedules.
     * @return A collection of values returned by getPipelineSchedules.
     */
    public suspend fun getPipelineSchedules(argument: GetPipelineSchedulesPlainArgs): GetPipelineSchedulesResult =
        getPipelineSchedulesResultToKotlin(getPipelineSchedulesPlain(argument.toJava()).await())

    /**
     * @see [getPipelineSchedules].
     * @param project The name or id of the project to add the schedule to.
     * @return A collection of values returned by getPipelineSchedules.
     */
    public suspend fun getPipelineSchedules(project: String): GetPipelineSchedulesResult {
        val argument = GetPipelineSchedulesPlainArgs(
            project = project,
        )
        return getPipelineSchedulesResultToKotlin(getPipelineSchedulesPlain(argument.toJava()).await())
    }

    /**
     * @see [getPipelineSchedules].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetPipelineSchedulesPlainArgs].
     * @return A collection of values returned by getPipelineSchedules.
     */
    public suspend fun getPipelineSchedules(argument: suspend GetPipelineSchedulesPlainArgsBuilder.() -> Unit): GetPipelineSchedulesResult {
        val builder = GetPipelineSchedulesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPipelineSchedulesResultToKotlin(getPipelineSchedulesPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.Project` data source allows details of a project to be retrieved by either its ID or its path with namespace.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/projects.html#get-single-project)
     * @param argument A collection of arguments for invoking getProject.
     * @return A collection of values returned by getProject.
     */
    public suspend fun getProject(argument: GetProjectPlainArgs): GetProjectResult =
        getProjectResultToKotlin(getProjectPlain(argument.toJava()).await())

    /**
     * @see [getProject].
     * @param ciDefaultGitDepth Default number of revisions for shallow cloning.
     * @param id The integer that uniquely identifies the project within the gitlab install.
     * @param pathWithNamespace The path of the repository with namespace.
     * @param publicBuilds If true, jobs can be viewed by non-project members.
     * @return A collection of values returned by getProject.
     */
    public suspend fun getProject(
        ciDefaultGitDepth: Int? = null,
        id: String? = null,
        pathWithNamespace: String? = null,
        publicBuilds: Boolean? = null,
    ): GetProjectResult {
        val argument = GetProjectPlainArgs(
            ciDefaultGitDepth = ciDefaultGitDepth,
            id = id,
            pathWithNamespace = pathWithNamespace,
            publicBuilds = publicBuilds,
        )
        return getProjectResultToKotlin(getProjectPlain(argument.toJava()).await())
    }

    /**
     * @see [getProject].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetProjectPlainArgs].
     * @return A collection of values returned by getProject.
     */
    public suspend fun getProject(argument: suspend GetProjectPlainArgsBuilder.() -> Unit): GetProjectResult {
        val builder = GetProjectPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProjectResultToKotlin(getProjectPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.getProjectBranches` data source allows details of the branches of a given project to be retrieved.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/branches.html#list-repository-branches)
     * @param argument A collection of arguments for invoking getProjectBranches.
     * @return A collection of values returned by getProjectBranches.
     */
    public suspend fun getProjectBranches(argument: GetProjectBranchesPlainArgs): GetProjectBranchesResult =
        getProjectBranchesResultToKotlin(getProjectBranchesPlain(argument.toJava()).await())

    /**
     * @see [getProjectBranches].
     * @param project ID or URL-encoded path of the project owned by the authenticated user.
     * @return A collection of values returned by getProjectBranches.
     */
    public suspend fun getProjectBranches(project: String): GetProjectBranchesResult {
        val argument = GetProjectBranchesPlainArgs(
            project = project,
        )
        return getProjectBranchesResultToKotlin(getProjectBranchesPlain(argument.toJava()).await())
    }

    /**
     * @see [getProjectBranches].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetProjectBranchesPlainArgs].
     * @return A collection of values returned by getProjectBranches.
     */
    public suspend fun getProjectBranches(argument: suspend GetProjectBranchesPlainArgsBuilder.() -> Unit): GetProjectBranchesResult {
        val builder = GetProjectBranchesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProjectBranchesResultToKotlin(getProjectBranchesPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.ProjectHook` data source allows to retrieve details about a hook in a project.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/projects.html#get-project-hook)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as gitlab from "@pulumi/gitlab";
     * const example = gitlab.getProject({
     *     id: "foo/bar/baz",
     * });
     * const exampleGetProjectHook = example.then(example => gitlab.getProjectHook({
     *     project: example.id,
     *     hookId: 1,
     * }));
     * ```
     * ```python
     * import pulumi
     * import pulumi_gitlab as gitlab
     * example = gitlab.get_project(id="foo/bar/baz")
     * example_get_project_hook = gitlab.get_project_hook(project=example.id,
     *     hook_id=1)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using GitLab = Pulumi.GitLab;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = GitLab.GetProject.Invoke(new()
     *     {
     *         Id = "foo/bar/baz",
     *     });
     *     var exampleGetProjectHook = GitLab.GetProjectHook.Invoke(new()
     *     {
     *         Project = example.Apply(getProjectResult => getProjectResult.Id),
     *         HookId = 1,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := gitlab.LookupProject(ctx, &gitlab.LookupProjectArgs{
     * 			Id: pulumi.StringRef("foo/bar/baz"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = gitlab.LookupProjectHook(ctx, &gitlab.LookupProjectHookArgs{
     * 			Project: example.Id,
     * 			HookId:  1,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.gitlab.GitlabFunctions;
     * import com.pulumi.gitlab.inputs.GetProjectArgs;
     * import com.pulumi.gitlab.inputs.GetProjectHookArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = GitlabFunctions.getProject(GetProjectArgs.builder()
     *             .id("foo/bar/baz")
     *             .build());
     *         final var exampleGetProjectHook = GitlabFunctions.getProjectHook(GetProjectHookArgs.builder()
     *             .project(example.applyValue(getProjectResult -> getProjectResult.id()))
     *             .hookId(1)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: gitlab:getProject
     *       Arguments:
     *         id: foo/bar/baz
     *   exampleGetProjectHook:
     *     fn::invoke:
     *       Function: gitlab:getProjectHook
     *       Arguments:
     *         project: ${example.id}
     *         hookId: 1
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getProjectHook.
     * @return A collection of values returned by getProjectHook.
     */
    public suspend fun getProjectHook(argument: GetProjectHookPlainArgs): GetProjectHookResult =
        getProjectHookResultToKotlin(getProjectHookPlain(argument.toJava()).await())

    /**
     * @see [getProjectHook].
     * @param hookId The id of the project hook.
     * @param project The name or id of the project to add the hook to.
     * @return A collection of values returned by getProjectHook.
     */
    public suspend fun getProjectHook(hookId: Int, project: String): GetProjectHookResult {
        val argument = GetProjectHookPlainArgs(
            hookId = hookId,
            project = project,
        )
        return getProjectHookResultToKotlin(getProjectHookPlain(argument.toJava()).await())
    }

    /**
     * @see [getProjectHook].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetProjectHookPlainArgs].
     * @return A collection of values returned by getProjectHook.
     */
    public suspend fun getProjectHook(argument: suspend GetProjectHookPlainArgsBuilder.() -> Unit): GetProjectHookResult {
        val builder = GetProjectHookPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProjectHookResultToKotlin(getProjectHookPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.getProjectHooks` data source allows to retrieve details about hooks in a project.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/projects.html#list-project-hooks)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as gitlab from "@pulumi/gitlab";
     * const example = gitlab.getProject({
     *     id: "foo/bar/baz",
     * });
     * const examples = example.then(example => gitlab.getProjectHooks({
     *     project: example.id,
     * }));
     * ```
     * ```python
     * import pulumi
     * import pulumi_gitlab as gitlab
     * example = gitlab.get_project(id="foo/bar/baz")
     * examples = gitlab.get_project_hooks(project=example.id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using GitLab = Pulumi.GitLab;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = GitLab.GetProject.Invoke(new()
     *     {
     *         Id = "foo/bar/baz",
     *     });
     *     var examples = GitLab.GetProjectHooks.Invoke(new()
     *     {
     *         Project = example.Apply(getProjectResult => getProjectResult.Id),
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := gitlab.LookupProject(ctx, &gitlab.LookupProjectArgs{
     * 			Id: pulumi.StringRef("foo/bar/baz"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = gitlab.GetProjectHooks(ctx, &gitlab.GetProjectHooksArgs{
     * 			Project: example.Id,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.gitlab.GitlabFunctions;
     * import com.pulumi.gitlab.inputs.GetProjectArgs;
     * import com.pulumi.gitlab.inputs.GetProjectHooksArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = GitlabFunctions.getProject(GetProjectArgs.builder()
     *             .id("foo/bar/baz")
     *             .build());
     *         final var examples = GitlabFunctions.getProjectHooks(GetProjectHooksArgs.builder()
     *             .project(example.applyValue(getProjectResult -> getProjectResult.id()))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: gitlab:getProject
     *       Arguments:
     *         id: foo/bar/baz
     *   examples:
     *     fn::invoke:
     *       Function: gitlab:getProjectHooks
     *       Arguments:
     *         project: ${example.id}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getProjectHooks.
     * @return A collection of values returned by getProjectHooks.
     */
    public suspend fun getProjectHooks(argument: GetProjectHooksPlainArgs): GetProjectHooksResult =
        getProjectHooksResultToKotlin(getProjectHooksPlain(argument.toJava()).await())

    /**
     * @see [getProjectHooks].
     * @param project The name or id of the project.
     * @return A collection of values returned by getProjectHooks.
     */
    public suspend fun getProjectHooks(project: String): GetProjectHooksResult {
        val argument = GetProjectHooksPlainArgs(
            project = project,
        )
        return getProjectHooksResultToKotlin(getProjectHooksPlain(argument.toJava()).await())
    }

    /**
     * @see [getProjectHooks].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetProjectHooksPlainArgs].
     * @return A collection of values returned by getProjectHooks.
     */
    public suspend fun getProjectHooks(argument: suspend GetProjectHooksPlainArgsBuilder.() -> Unit): GetProjectHooksResult {
        val builder = GetProjectHooksPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProjectHooksResultToKotlin(getProjectHooksPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.getProjectIds` data source identification information for a given project, allowing a user to translate a full path or ID into the GraphQL ID of the project.
     * **Upstream API**: [GitLab GraphQL API docs](https://docs.gitlab.com/ee/api/graphql/reference/#queryproject)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as gitlab from "@pulumi/gitlab";
     * const newProject = new gitlab.Project("new_project", {});
     * // use project IDs to get additional information, such as the GraphQL ID
     * // for other resources
     * const foo = gitlab.getProjectIds({
     *     project: "gitlab_project.new_project.id",
     * });
     * export const graphQLId = foo.then(foo => foo.projectGraphqlId);
     * ```
     * ```python
     * import pulumi
     * import pulumi_gitlab as gitlab
     * new_project = gitlab.Project("new_project")
     * # use project IDs to get additional information, such as the GraphQL ID
     * # for other resources
     * foo = gitlab.get_project_ids(project="gitlab_project.new_project.id")
     * pulumi.export("graphQLId", foo.project_graphql_id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using GitLab = Pulumi.GitLab;
     * return await Deployment.RunAsync(() =>
     * {
     *     var newProject = new GitLab.Project("new_project");
     *     // use project IDs to get additional information, such as the GraphQL ID
     *     // for other resources
     *     var foo = GitLab.GetProjectIds.Invoke(new()
     *     {
     *         Project = "gitlab_project.new_project.id",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["graphQLId"] = foo.Apply(getProjectIdsResult => getProjectIdsResult.ProjectGraphqlId),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := gitlab.NewProject(ctx, "new_project", nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		// use project IDs to get additional information, such as the GraphQL ID
     * 		// for other resources
     * 		foo, err := gitlab.GetProjectIds(ctx, &gitlab.GetProjectIdsArgs{
     * 			Project: "gitlab_project.new_project.id",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("graphQLId", foo.ProjectGraphqlId)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.gitlab.Project;
     * import com.pulumi.gitlab.GitlabFunctions;
     * import com.pulumi.gitlab.inputs.GetProjectIdsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var newProject = new Project("newProject");
     *         // use project IDs to get additional information, such as the GraphQL ID
     *         // for other resources
     *         final var foo = GitlabFunctions.getProjectIds(GetProjectIdsArgs.builder()
     *             .project("gitlab_project.new_project.id")
     *             .build());
     *         ctx.export("graphQLId", foo.applyValue(getProjectIdsResult -> getProjectIdsResult.projectGraphqlId()));
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   newProject:
     *     type: gitlab:Project
     *     name: new_project
     * variables:
     *   # use project IDs to get additional information, such as the GraphQL ID
     *   # // for other resources
     *   foo:
     *     fn::invoke:
     *       Function: gitlab:getProjectIds
     *       Arguments:
     *         project: gitlab_project.new_project.id
     * outputs:
     *   graphQLId: ${foo.projectGraphqlId}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getProjectIds.
     * @return A collection of values returned by getProjectIds.
     */
    public suspend fun getProjectIds(argument: GetProjectIdsPlainArgs): GetProjectIdsResult =
        getProjectIdsResultToKotlin(getProjectIdsPlain(argument.toJava()).await())

    /**
     * @see [getProjectIds].
     * @param project The ID or URL-encoded path of the project.
     * @return A collection of values returned by getProjectIds.
     */
    public suspend fun getProjectIds(project: String): GetProjectIdsResult {
        val argument = GetProjectIdsPlainArgs(
            project = project,
        )
        return getProjectIdsResultToKotlin(getProjectIdsPlain(argument.toJava()).await())
    }

    /**
     * @see [getProjectIds].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetProjectIdsPlainArgs].
     * @return A collection of values returned by getProjectIds.
     */
    public suspend fun getProjectIds(argument: suspend GetProjectIdsPlainArgsBuilder.() -> Unit): GetProjectIdsResult {
        val builder = GetProjectIdsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProjectIdsResultToKotlin(getProjectIdsPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.ProjectIssue` data source allows to retrieve details about an issue in a project.
     * **Upstream API**: [GitLab API docs](https://docs.gitlab.com/ee/api/issues.html)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as gitlab from "@pulumi/gitlab";
     * const foo = gitlab.getProject({
     *     pathWithNamespace: "foo/bar/baz",
     * });
     * const welcomeIssue = foo.then(foo => gitlab.getProjectIssue({
     *     project: foo.id,
     *     iid: 1,
     * }));
     * export const welcomeIssueWebUrl = webUrl;
     * ```
     * ```python
     * import pulumi
     * import pulumi_gitlab as gitlab
     * foo = gitlab.get_project(path_with_namespace="foo/bar/baz")
     * welcome_issue = gitlab.get_project_issue(project=foo.id,
     *     iid=1)
     * pulumi.export("welcomeIssueWebUrl", web_url)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using GitLab = Pulumi.GitLab;
     * return await Deployment.RunAsync(() =>
     * {
     *     var foo = GitLab.GetProject.Invoke(new()
     *     {
     *         PathWithNamespace = "foo/bar/baz",
     *     });
     *     var welcomeIssue = GitLab.GetProjectIssue.Invoke(new()
     *     {
     *         Project = foo.Apply(getProjectResult => getProjectResult.Id),
     *         Iid = 1,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["welcomeIssueWebUrl"] = webUrl,
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		foo, err := gitlab.LookupProject(ctx, &gitlab.LookupProjectArgs{
     * 			PathWithNamespace: pulumi.StringRef("foo/bar/baz"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = gitlab.LookupProjectIssue(ctx, &gitlab.LookupProjectIssueArgs{
     * 			Project: foo.Id,
     * 			Iid:     1,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("welcomeIssueWebUrl", webUrl)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.gitlab.GitlabFunctions;
     * import com.pulumi.gitlab.inputs.GetProjectArgs;
     * import com.pulumi.gitlab.inputs.GetProjectIssueArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var foo = GitlabFunctions.getProject(GetProjectArgs.builder()
     *             .pathWithNamespace("foo/bar/baz")
     *             .build());
     *         final var welcomeIssue = GitlabFunctions.getProjectIssue(GetProjectIssueArgs.builder()
     *             .project(foo.applyValue(getProjectResult -> getProjectResult.id()))
     *             .iid(1)
     *             .build());
     *         ctx.export("welcomeIssueWebUrl", webUrl);
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   foo:
     *     fn::invoke:
     *       Function: gitlab:getProject
     *       Arguments:
     *         pathWithNamespace: foo/bar/baz
     *   welcomeIssue:
     *     fn::invoke:
     *       Function: gitlab:getProjectIssue
     *       Arguments:
     *         project: ${foo.id}
     *         iid: 1
     * outputs:
     *   welcomeIssueWebUrl: ${webUrl}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getProjectIssue.
     * @return A collection of values returned by getProjectIssue.
     */
    public suspend fun getProjectIssue(argument: GetProjectIssuePlainArgs): GetProjectIssueResult =
        getProjectIssueResultToKotlin(getProjectIssuePlain(argument.toJava()).await())

    /**
     * @see [getProjectIssue].
     * @param iid The internal ID of the project's issue.
     * @param project The name or ID of the project.
     * @return A collection of values returned by getProjectIssue.
     */
    public suspend fun getProjectIssue(iid: Int, project: String): GetProjectIssueResult {
        val argument = GetProjectIssuePlainArgs(
            iid = iid,
            project = project,
        )
        return getProjectIssueResultToKotlin(getProjectIssuePlain(argument.toJava()).await())
    }

    /**
     * @see [getProjectIssue].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetProjectIssuePlainArgs].
     * @return A collection of values returned by getProjectIssue.
     */
    public suspend fun getProjectIssue(argument: suspend GetProjectIssuePlainArgsBuilder.() -> Unit): GetProjectIssueResult {
        val builder = GetProjectIssuePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProjectIssueResultToKotlin(getProjectIssuePlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.getProjectIssues` data source allows to retrieve details about issues in a project.
     * **Upstream API**: [GitLab API docs](https://docs.gitlab.com/ee/api/issues.html)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as gitlab from "@pulumi/gitlab";
     * const foo = gitlab.getProject({
     *     id: "foo/bar/baz",
     * });
     * const allWithFoo = foo.then(foo => gitlab.getProjectIssues({
     *     project: foo.id,
     *     search: "foo",
     * }));
     * ```
     * ```python
     * import pulumi
     * import pulumi_gitlab as gitlab
     * foo = gitlab.get_project(id="foo/bar/baz")
     * all_with_foo = gitlab.get_project_issues(project=foo.id,
     *     search="foo")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using GitLab = Pulumi.GitLab;
     * return await Deployment.RunAsync(() =>
     * {
     *     var foo = GitLab.GetProject.Invoke(new()
     *     {
     *         Id = "foo/bar/baz",
     *     });
     *     var allWithFoo = GitLab.GetProjectIssues.Invoke(new()
     *     {
     *         Project = foo.Apply(getProjectResult => getProjectResult.Id),
     *         Search = "foo",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		foo, err := gitlab.LookupProject(ctx, &gitlab.LookupProjectArgs{
     * 			Id: pulumi.StringRef("foo/bar/baz"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = gitlab.GetProjectIssues(ctx, &gitlab.GetProjectIssuesArgs{
     * 			Project: foo.Id,
     * 			Search:  pulumi.StringRef("foo"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.gitlab.GitlabFunctions;
     * import com.pulumi.gitlab.inputs.GetProjectArgs;
     * import com.pulumi.gitlab.inputs.GetProjectIssuesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var foo = GitlabFunctions.getProject(GetProjectArgs.builder()
     *             .id("foo/bar/baz")
     *             .build());
     *         final var allWithFoo = GitlabFunctions.getProjectIssues(GetProjectIssuesArgs.builder()
     *             .project(foo.applyValue(getProjectResult -> getProjectResult.id()))
     *             .search("foo")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   foo:
     *     fn::invoke:
     *       Function: gitlab:getProject
     *       Arguments:
     *         id: foo/bar/baz
     *   allWithFoo:
     *     fn::invoke:
     *       Function: gitlab:getProjectIssues
     *       Arguments:
     *         project: ${foo.id}
     *         search: foo
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getProjectIssues.
     * @return A collection of values returned by getProjectIssues.
     */
    public suspend fun getProjectIssues(argument: GetProjectIssuesPlainArgs): GetProjectIssuesResult =
        getProjectIssuesResultToKotlin(getProjectIssuesPlain(argument.toJava()).await())

    /**
     * @see [getProjectIssues].
     * @param assigneeId Return issues assigned to the given user id. Mutually exclusive with assignee_username. None returns unassigned issues. Any returns issues with an assignee.
     * @param assigneeUsername Return issues assigned to the given username. Similar to assignee*id and mutually exclusive with assignee*id. In GitLab CE, the assignee_username array should only contain a single value. Otherwise, an invalid parameter error is returned.
     * @param authorId Return issues created by the given user id. Combine with scope=all or scope=assigned*to*me.
     * @param confidential Filter confidential or public issues.
     * @param createdAfter Return issues created on or after the given time. Expected in ISO 8601 format (2019-03-15T08:00:00Z)
     * @param createdBefore Return issues created on or before the given time. Expected in ISO 8601 format (2019-03-15T08:00:00Z)
     * @param dueDate Return issues that have no due date, are overdue, or whose due date is this week, this month, or between two weeks ago and next month. Accepts: 0 (no due date), any, today, tomorrow, overdue, week, month, next*month*and*previous*two_weeks.
     * @param iids Return only the issues having the given iid
     * @param issueType Filter to a given type of issue. Valid values are [issue incident test_case]. (Introduced in GitLab 13.12)
     * @param labels Return issues with labels. Issues must have all labels to be returned. None lists all issues with no labels. Any lists all issues with at least one label. No+Label (Deprecated) lists all issues with no labels. Predefined names are case-insensitive.
     * @param milestone The milestone title. None lists all issues with no milestone. Any lists all issues that have an assigned milestone.
     * @param myReactionEmoji Return issues reacted by the authenticated user by the given emoji. None returns issues not given a reaction. Any returns issues given at least one reaction.
     * @param notAssigneeIds Return issues that do not match the assignee id.
     * @param notAuthorIds Return issues that do not match the author id.
     * @param notLabels Return issues that do not match the labels.
     * @param notMilestone Return issues that do not match the milestone.
     * @param notMyReactionEmojis Return issues not reacted by the authenticated user by the given emoji.
     * @param orderBy Return issues ordered by. Valid values are `created_at`, `updated_at`, `priority`, `due_date`, `relative_position`, `label_priority`, `milestone_due`, `popularity`, `weight`. Default is created_at
     * @param project The name or id of the project.
     * @param scope Return issues for the given scope. Valid values are `created_by_me`, `assigned_to_me`, `all`. Defaults to all.
     * @param search Search project issues against their title and description
     * @param sort Return issues sorted in asc or desc order. Default is desc
     * @param updatedAfter Return issues updated on or after the given time. Expected in ISO 8601 format (2019-03-15T08:00:00Z)
     * @param updatedBefore Return issues updated on or before the given time. Expected in ISO 8601 format (2019-03-15T08:00:00Z)
     * @param weight Return issues with the specified weight. None returns issues with no weight assigned. Any returns issues with a weight assigned.
     * @param withLabelsDetails If true, the response returns more details for each label in labels field: :name, :color, :description, :description*html, :text*color. Default is false. description_html was introduced in GitLab 12.7
     * @return A collection of values returned by getProjectIssues.
     */
    public suspend fun getProjectIssues(
        assigneeId: Int? = null,
        assigneeUsername: String? = null,
        authorId: Int? = null,
        confidential: Boolean? = null,
        createdAfter: String? = null,
        createdBefore: String? = null,
        dueDate: String? = null,
        iids: List<Int>? = null,
        issueType: String? = null,
        labels: List<String>? = null,
        milestone: String? = null,
        myReactionEmoji: String? = null,
        notAssigneeIds: List<Int>? = null,
        notAuthorIds: List<Int>? = null,
        notLabels: List<String>? = null,
        notMilestone: String? = null,
        notMyReactionEmojis: List<String>? = null,
        orderBy: String? = null,
        project: String,
        scope: String? = null,
        search: String? = null,
        sort: String? = null,
        updatedAfter: String? = null,
        updatedBefore: String? = null,
        weight: Int? = null,
        withLabelsDetails: Boolean? = null,
    ): GetProjectIssuesResult {
        val argument = GetProjectIssuesPlainArgs(
            assigneeId = assigneeId,
            assigneeUsername = assigneeUsername,
            authorId = authorId,
            confidential = confidential,
            createdAfter = createdAfter,
            createdBefore = createdBefore,
            dueDate = dueDate,
            iids = iids,
            issueType = issueType,
            labels = labels,
            milestone = milestone,
            myReactionEmoji = myReactionEmoji,
            notAssigneeIds = notAssigneeIds,
            notAuthorIds = notAuthorIds,
            notLabels = notLabels,
            notMilestone = notMilestone,
            notMyReactionEmojis = notMyReactionEmojis,
            orderBy = orderBy,
            project = project,
            scope = scope,
            search = search,
            sort = sort,
            updatedAfter = updatedAfter,
            updatedBefore = updatedBefore,
            weight = weight,
            withLabelsDetails = withLabelsDetails,
        )
        return getProjectIssuesResultToKotlin(getProjectIssuesPlain(argument.toJava()).await())
    }

    /**
     * @see [getProjectIssues].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetProjectIssuesPlainArgs].
     * @return A collection of values returned by getProjectIssues.
     */
    public suspend fun getProjectIssues(argument: suspend GetProjectIssuesPlainArgsBuilder.() -> Unit): GetProjectIssuesResult {
        val builder = GetProjectIssuesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProjectIssuesResultToKotlin(getProjectIssuesPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.ProjectMembership` data source allows to list and filter all members of a project specified by either its id or full path.
     * > **Note** exactly one of project_id or full_path must be provided.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/members.html#list-all-members-of-a-group-or-project)
     * @param argument A collection of arguments for invoking getProjectMembership.
     * @return A collection of values returned by getProjectMembership.
     */
    public suspend fun getProjectMembership(argument: GetProjectMembershipPlainArgs): GetProjectMembershipResult =
        getProjectMembershipResultToKotlin(getProjectMembershipPlain(argument.toJava()).await())

    /**
     * @see [getProjectMembership].
     * @param fullPath The full path of the project.
     * @param inherited Return all project members including members through ancestor groups
     * @param projectId The ID of the project.
     * @param query A query string to search for members
     * @return A collection of values returned by getProjectMembership.
     */
    public suspend fun getProjectMembership(
        fullPath: String? = null,
        inherited: Boolean? = null,
        projectId: Int? = null,
        query: String? = null,
    ): GetProjectMembershipResult {
        val argument = GetProjectMembershipPlainArgs(
            fullPath = fullPath,
            inherited = inherited,
            projectId = projectId,
            query = query,
        )
        return getProjectMembershipResultToKotlin(getProjectMembershipPlain(argument.toJava()).await())
    }

    /**
     * @see [getProjectMembership].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetProjectMembershipPlainArgs].
     * @return A collection of values returned by getProjectMembership.
     */
    public suspend fun getProjectMembership(argument: suspend GetProjectMembershipPlainArgsBuilder.() -> Unit): GetProjectMembershipResult {
        val builder = GetProjectMembershipPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProjectMembershipResultToKotlin(getProjectMembershipPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.ProjectMilestone` data source allows get details of a project milestone.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/milestones.html)
     * @param argument A collection of arguments for invoking getProjectMilestone.
     * @return A collection of values returned by getProjectMilestone.
     */
    public suspend fun getProjectMilestone(argument: GetProjectMilestonePlainArgs): GetProjectMilestoneResult =
        getProjectMilestoneResultToKotlin(getProjectMilestonePlain(argument.toJava()).await())

    /**
     * @see [getProjectMilestone].
     * @param milestoneId The instance-wide ID of the project’s milestone.
     * @param project The ID or URL-encoded path of the project owned by the authenticated user.
     * @return A collection of values returned by getProjectMilestone.
     */
    public suspend fun getProjectMilestone(milestoneId: Int, project: String): GetProjectMilestoneResult {
        val argument = GetProjectMilestonePlainArgs(
            milestoneId = milestoneId,
            project = project,
        )
        return getProjectMilestoneResultToKotlin(getProjectMilestonePlain(argument.toJava()).await())
    }

    /**
     * @see [getProjectMilestone].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetProjectMilestonePlainArgs].
     * @return A collection of values returned by getProjectMilestone.
     */
    public suspend fun getProjectMilestone(argument: suspend GetProjectMilestonePlainArgsBuilder.() -> Unit): GetProjectMilestoneResult {
        val builder = GetProjectMilestonePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProjectMilestoneResultToKotlin(getProjectMilestonePlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.getProjectMilestones` data source allows get details of a project milestones.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/milestones.html)
     * @param argument A collection of arguments for invoking getProjectMilestones.
     * @return A collection of values returned by getProjectMilestones.
     */
    public suspend fun getProjectMilestones(argument: GetProjectMilestonesPlainArgs): GetProjectMilestonesResult =
        getProjectMilestonesResultToKotlin(getProjectMilestonesPlain(argument.toJava()).await())

    /**
     * @see [getProjectMilestones].
     * @param iids Return only the milestones having the given `iid` (Note: ignored if `include_parent_milestones` is set as `true`).
     * @param includeParentMilestones Include group milestones from parent group and its ancestors. Introduced in GitLab 13.4.
     * @param project The ID or URL-encoded path of the project owned by the authenticated user.
     * @param search Return only milestones with a title or description matching the provided string.
     * @param state Return only `active` or `closed` milestones.
     * @param title Return only the milestones having the given `title`.
     * @return A collection of values returned by getProjectMilestones.
     */
    public suspend fun getProjectMilestones(
        iids: List<Int>? = null,
        includeParentMilestones: Boolean? = null,
        project: String,
        search: String? = null,
        state: String? = null,
        title: String? = null,
    ): GetProjectMilestonesResult {
        val argument = GetProjectMilestonesPlainArgs(
            iids = iids,
            includeParentMilestones = includeParentMilestones,
            project = project,
            search = search,
            state = state,
            title = title,
        )
        return getProjectMilestonesResultToKotlin(getProjectMilestonesPlain(argument.toJava()).await())
    }

    /**
     * @see [getProjectMilestones].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetProjectMilestonesPlainArgs].
     * @return A collection of values returned by getProjectMilestones.
     */
    public suspend fun getProjectMilestones(argument: suspend GetProjectMilestonesPlainArgsBuilder.() -> Unit): GetProjectMilestonesResult {
        val builder = GetProjectMilestonesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProjectMilestonesResultToKotlin(getProjectMilestonesPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.getProjectProtectedBranch` data source allows details of a protected branch to be retrieved by its name and the project it belongs to.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/protected_branches.html#get-a-single-protected-branch-or-wildcard-protected-branch)
     * @param argument A collection of arguments for invoking getProjectProtectedBranch.
     * @return A collection of values returned by getProjectProtectedBranch.
     */
    public suspend fun getProjectProtectedBranch(argument: GetProjectProtectedBranchPlainArgs): GetProjectProtectedBranchResult =
        getProjectProtectedBranchResultToKotlin(getProjectProtectedBranchPlain(argument.toJava()).await())

    /**
     * @see [getProjectProtectedBranch].
     * @param mergeAccessLevels Array of access levels and user(s)/group(s) allowed to merge to protected branch.
     * @param name The name of the protected branch.
     * @param projectId The integer or path with namespace that uniquely identifies the project.
     * @param pushAccessLevels Array of access levels and user(s)/group(s) allowed to push to protected branch.
     * @return A collection of values returned by getProjectProtectedBranch.
     */
    public suspend fun getProjectProtectedBranch(
        mergeAccessLevels: List<GetProjectProtectedBranchMergeAccessLevel>? = null,
        name: String,
        projectId: String,
        pushAccessLevels: List<GetProjectProtectedBranchPushAccessLevel>? = null,
    ): GetProjectProtectedBranchResult {
        val argument = GetProjectProtectedBranchPlainArgs(
            mergeAccessLevels = mergeAccessLevels,
            name = name,
            projectId = projectId,
            pushAccessLevels = pushAccessLevels,
        )
        return getProjectProtectedBranchResultToKotlin(getProjectProtectedBranchPlain(argument.toJava()).await())
    }

    /**
     * @see [getProjectProtectedBranch].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetProjectProtectedBranchPlainArgs].
     * @return A collection of values returned by getProjectProtectedBranch.
     */
    public suspend fun getProjectProtectedBranch(argument: suspend GetProjectProtectedBranchPlainArgsBuilder.() -> Unit): GetProjectProtectedBranchResult {
        val builder = GetProjectProtectedBranchPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProjectProtectedBranchResultToKotlin(getProjectProtectedBranchPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.getProjectProtectedBranches` data source allows details of the protected branches of a given project.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/protected_branches.html#list-protected-branches)
     * @param argument A collection of arguments for invoking getProjectProtectedBranches.
     * @return A collection of values returned by getProjectProtectedBranches.
     */
    public suspend fun getProjectProtectedBranches(argument: GetProjectProtectedBranchesPlainArgs): GetProjectProtectedBranchesResult =
        getProjectProtectedBranchesResultToKotlin(getProjectProtectedBranchesPlain(argument.toJava()).await())

    /**
     * @see [getProjectProtectedBranches].
     * @param projectId The integer or path with namespace that uniquely identifies the project.
     * @param protectedBranches A list of protected branches, as defined below.
     * @return A collection of values returned by getProjectProtectedBranches.
     */
    public suspend fun getProjectProtectedBranches(
        projectId: String,
        protectedBranches: List<GetProjectProtectedBranchesProtectedBranch>? = null,
    ): GetProjectProtectedBranchesResult {
        val argument = GetProjectProtectedBranchesPlainArgs(
            projectId = projectId,
            protectedBranches = protectedBranches,
        )
        return getProjectProtectedBranchesResultToKotlin(getProjectProtectedBranchesPlain(argument.toJava()).await())
    }

    /**
     * @see [getProjectProtectedBranches].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetProjectProtectedBranchesPlainArgs].
     * @return A collection of values returned by getProjectProtectedBranches.
     */
    public suspend fun getProjectProtectedBranches(argument: suspend GetProjectProtectedBranchesPlainArgsBuilder.() -> Unit): GetProjectProtectedBranchesResult {
        val builder = GetProjectProtectedBranchesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProjectProtectedBranchesResultToKotlin(getProjectProtectedBranchesPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.getProjectProtectedTag` data source allows details of a protected tag to be retrieved by its name and the project it belongs to.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/protected_tags.html#get-a-single-protected-tag-or-wildcard-protected-tag)
     * @param argument A collection of arguments for invoking getProjectProtectedTag.
     * @return A collection of values returned by getProjectProtectedTag.
     */
    public suspend fun getProjectProtectedTag(argument: GetProjectProtectedTagPlainArgs): GetProjectProtectedTagResult =
        getProjectProtectedTagResultToKotlin(getProjectProtectedTagPlain(argument.toJava()).await())

    /**
     * @see [getProjectProtectedTag].
     * @param project The integer or path with namespace that uniquely identifies the project.
     * @param tag The name of the protected tag.
     * @return A collection of values returned by getProjectProtectedTag.
     */
    public suspend fun getProjectProtectedTag(project: String, tag: String): GetProjectProtectedTagResult {
        val argument = GetProjectProtectedTagPlainArgs(
            project = project,
            tag = tag,
        )
        return getProjectProtectedTagResultToKotlin(getProjectProtectedTagPlain(argument.toJava()).await())
    }

    /**
     * @see [getProjectProtectedTag].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetProjectProtectedTagPlainArgs].
     * @return A collection of values returned by getProjectProtectedTag.
     */
    public suspend fun getProjectProtectedTag(argument: suspend GetProjectProtectedTagPlainArgsBuilder.() -> Unit): GetProjectProtectedTagResult {
        val builder = GetProjectProtectedTagPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProjectProtectedTagResultToKotlin(getProjectProtectedTagPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.getProjectProtectedTags` data source allows details of the protected tags of a given project.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/protected_tags.html#list-protected-tags)
     * @param argument A collection of arguments for invoking getProjectProtectedTags.
     * @return A collection of values returned by getProjectProtectedTags.
     */
    public suspend fun getProjectProtectedTags(argument: GetProjectProtectedTagsPlainArgs): GetProjectProtectedTagsResult =
        getProjectProtectedTagsResultToKotlin(getProjectProtectedTagsPlain(argument.toJava()).await())

    /**
     * @see [getProjectProtectedTags].
     * @param project The integer or path with namespace that uniquely identifies the project.
     * @return A collection of values returned by getProjectProtectedTags.
     */
    public suspend fun getProjectProtectedTags(project: String): GetProjectProtectedTagsResult {
        val argument = GetProjectProtectedTagsPlainArgs(
            project = project,
        )
        return getProjectProtectedTagsResultToKotlin(getProjectProtectedTagsPlain(argument.toJava()).await())
    }

    /**
     * @see [getProjectProtectedTags].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetProjectProtectedTagsPlainArgs].
     * @return A collection of values returned by getProjectProtectedTags.
     */
    public suspend fun getProjectProtectedTags(argument: suspend GetProjectProtectedTagsPlainArgsBuilder.() -> Unit): GetProjectProtectedTagsResult {
        val builder = GetProjectProtectedTagsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProjectProtectedTagsResultToKotlin(getProjectProtectedTagsPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.ProjectTag` data source allows details of a project tag to be retrieved by its name.
     * **Upstream API**: [GitLab API docs](https://docs.gitlab.com/ee/api/tags.html)
     * @param argument A collection of arguments for invoking getProjectTag.
     * @return A collection of values returned by getProjectTag.
     */
    public suspend fun getProjectTag(argument: GetProjectTagPlainArgs): GetProjectTagResult =
        getProjectTagResultToKotlin(getProjectTagPlain(argument.toJava()).await())

    /**
     * @see [getProjectTag].
     * @param name The name of a tag.
     * @param project The ID or URL-encoded path of the project owned by the authenticated user.
     * @return A collection of values returned by getProjectTag.
     */
    public suspend fun getProjectTag(name: String, project: String): GetProjectTagResult {
        val argument = GetProjectTagPlainArgs(
            name = name,
            project = project,
        )
        return getProjectTagResultToKotlin(getProjectTagPlain(argument.toJava()).await())
    }

    /**
     * @see [getProjectTag].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetProjectTagPlainArgs].
     * @return A collection of values returned by getProjectTag.
     */
    public suspend fun getProjectTag(argument: suspend GetProjectTagPlainArgsBuilder.() -> Unit): GetProjectTagResult {
        val builder = GetProjectTagPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProjectTagResultToKotlin(getProjectTagPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.getProjectTags` data source allows details of project tags to be retrieved by some search criteria.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/tags.html#list-project-repository-tags)
     * @param argument A collection of arguments for invoking getProjectTags.
     * @return A collection of values returned by getProjectTags.
     */
    public suspend fun getProjectTags(argument: GetProjectTagsPlainArgs): GetProjectTagsResult =
        getProjectTagsResultToKotlin(getProjectTagsPlain(argument.toJava()).await())

    /**
     * @see [getProjectTags].
     * @param orderBy Return tags ordered by `name` or `updated` fields. Default is `updated`.
     * @param project The ID or URL-encoded path of the project owned by the authenticated user.
     * @param search Return list of tags matching the search criteria. You can use `^term` and `term$` to find tags that begin and end with `term` respectively. No other regular expressions are supported.
     * @param sort Return tags sorted in `asc` or `desc` order. Default is `desc`.
     * @return A collection of values returned by getProjectTags.
     */
    public suspend fun getProjectTags(
        orderBy: String? = null,
        project: String,
        search: String? = null,
        sort: String? = null,
    ): GetProjectTagsResult {
        val argument = GetProjectTagsPlainArgs(
            orderBy = orderBy,
            project = project,
            search = search,
            sort = sort,
        )
        return getProjectTagsResultToKotlin(getProjectTagsPlain(argument.toJava()).await())
    }

    /**
     * @see [getProjectTags].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetProjectTagsPlainArgs].
     * @return A collection of values returned by getProjectTags.
     */
    public suspend fun getProjectTags(argument: suspend GetProjectTagsPlainArgsBuilder.() -> Unit): GetProjectTagsResult {
        val builder = GetProjectTagsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProjectTagsResultToKotlin(getProjectTagsPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.ProjectVariable` data source allows to retrieve details about a project-level CI/CD variable.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/project_level_variables.html)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as gitlab from "@pulumi/gitlab";
     * const foo = gitlab.getProjectVariable({
     *     project: "my/example/project",
     *     key: "foo",
     * });
     * // Using an environment scope
     * const bar = gitlab.getProjectVariable({
     *     project: "my/example/project",
     *     key: "bar",
     *     environmentScope: "staging/*",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_gitlab as gitlab
     * foo = gitlab.get_project_variable(project="my/example/project",
     *     key="foo")
     * # Using an environment scope
     * bar = gitlab.get_project_variable(project="my/example/project",
     *     key="bar",
     *     environment_scope="staging/*")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using GitLab = Pulumi.GitLab;
     * return await Deployment.RunAsync(() =>
     * {
     *     var foo = GitLab.GetProjectVariable.Invoke(new()
     *     {
     *         Project = "my/example/project",
     *         Key = "foo",
     *     });
     *     // Using an environment scope
     *     var bar = GitLab.GetProjectVariable.Invoke(new()
     *     {
     *         Project = "my/example/project",
     *         Key = "bar",
     *         EnvironmentScope = "staging/*",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := gitlab.LookupProjectVariable(ctx, &gitlab.LookupProjectVariableArgs{
     * 			Project: "my/example/project",
     * 			Key:     "foo",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		// Using an environment scope
     * 		_, err = gitlab.LookupProjectVariable(ctx, &gitlab.LookupProjectVariableArgs{
     * 			Project:          "my/example/project",
     * 			Key:              "bar",
     * 			EnvironmentScope: pulumi.StringRef("staging/*"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.gitlab.GitlabFunctions;
     * import com.pulumi.gitlab.inputs.GetProjectVariableArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var foo = GitlabFunctions.getProjectVariable(GetProjectVariableArgs.builder()
     *             .project("my/example/project")
     *             .key("foo")
     *             .build());
     *         // Using an environment scope
     *         final var bar = GitlabFunctions.getProjectVariable(GetProjectVariableArgs.builder()
     *             .project("my/example/project")
     *             .key("bar")
     *             .environmentScope("staging/*")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   foo:
     *     fn::invoke:
     *       Function: gitlab:getProjectVariable
     *       Arguments:
     *         project: my/example/project
     *         key: foo
     *   # Using an environment scope
     *   bar:
     *     fn::invoke:
     *       Function: gitlab:getProjectVariable
     *       Arguments:
     *         project: my/example/project
     *         key: bar
     *         environmentScope: staging/*
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getProjectVariable.
     * @return A collection of values returned by getProjectVariable.
     * */*/*/*/*/*/
     */
    public suspend fun getProjectVariable(argument: GetProjectVariablePlainArgs): GetProjectVariableResult =
        getProjectVariableResultToKotlin(getProjectVariablePlain(argument.toJava()).await())

    /**
     * @see [getProjectVariable].
     * @param environmentScope The environment scope of the variable. Defaults to all environment (`*`). Note that in Community Editions of Gitlab, values other than `*` will cause inconsistent plans.
     * @param key The name of the variable.
     * @param project The name or id of the project.
     * @return A collection of values returned by getProjectVariable.
     */
    public suspend fun getProjectVariable(
        environmentScope: String? = null,
        key: String,
        project: String,
    ): GetProjectVariableResult {
        val argument = GetProjectVariablePlainArgs(
            environmentScope = environmentScope,
            key = key,
            project = project,
        )
        return getProjectVariableResultToKotlin(getProjectVariablePlain(argument.toJava()).await())
    }

    /**
     * @see [getProjectVariable].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetProjectVariablePlainArgs].
     * @return A collection of values returned by getProjectVariable.
     */
    public suspend fun getProjectVariable(argument: suspend GetProjectVariablePlainArgsBuilder.() -> Unit): GetProjectVariableResult {
        val builder = GetProjectVariablePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProjectVariableResultToKotlin(getProjectVariablePlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.getProjectVariables` data source allows to retrieve all project-level CI/CD variables.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/project_level_variables.html)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as gitlab from "@pulumi/gitlab";
     * const vars = gitlab.getProjectVariables({
     *     project: "my/example/project",
     * });
     * // Using an environment scope
     * const stagingVars = gitlab.getProjectVariables({
     *     project: "my/example/project",
     *     environmentScope: "staging/*",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_gitlab as gitlab
     * vars = gitlab.get_project_variables(project="my/example/project")
     * # Using an environment scope
     * staging_vars = gitlab.get_project_variables(project="my/example/project",
     *     environment_scope="staging/*")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using GitLab = Pulumi.GitLab;
     * return await Deployment.RunAsync(() =>
     * {
     *     var vars = GitLab.GetProjectVariables.Invoke(new()
     *     {
     *         Project = "my/example/project",
     *     });
     *     // Using an environment scope
     *     var stagingVars = GitLab.GetProjectVariables.Invoke(new()
     *     {
     *         Project = "my/example/project",
     *         EnvironmentScope = "staging/*",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := gitlab.GetProjectVariables(ctx, &gitlab.GetProjectVariablesArgs{
     * 			Project: "my/example/project",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		// Using an environment scope
     * 		_, err = gitlab.GetProjectVariables(ctx, &gitlab.GetProjectVariablesArgs{
     * 			Project:          "my/example/project",
     * 			EnvironmentScope: pulumi.StringRef("staging/*"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.gitlab.GitlabFunctions;
     * import com.pulumi.gitlab.inputs.GetProjectVariablesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var vars = GitlabFunctions.getProjectVariables(GetProjectVariablesArgs.builder()
     *             .project("my/example/project")
     *             .build());
     *         // Using an environment scope
     *         final var stagingVars = GitlabFunctions.getProjectVariables(GetProjectVariablesArgs.builder()
     *             .project("my/example/project")
     *             .environmentScope("staging/*")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   vars:
     *     fn::invoke:
     *       Function: gitlab:getProjectVariables
     *       Arguments:
     *         project: my/example/project
     *   # Using an environment scope
     *   stagingVars:
     *     fn::invoke:
     *       Function: gitlab:getProjectVariables
     *       Arguments:
     *         project: my/example/project
     *         environmentScope: staging/*
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getProjectVariables.
     * @return A collection of values returned by getProjectVariables.
     * */*/*/*/*/*/
     */
    public suspend fun getProjectVariables(argument: GetProjectVariablesPlainArgs): GetProjectVariablesResult =
        getProjectVariablesResultToKotlin(getProjectVariablesPlain(argument.toJava()).await())

    /**
     * @see [getProjectVariables].
     * @param environmentScope The environment scope of the variable. Defaults to all environment (`*`).
     * @param project The name or id of the project.
     * @return A collection of values returned by getProjectVariables.
     */
    public suspend fun getProjectVariables(environmentScope: String? = null, project: String): GetProjectVariablesResult {
        val argument = GetProjectVariablesPlainArgs(
            environmentScope = environmentScope,
            project = project,
        )
        return getProjectVariablesResultToKotlin(getProjectVariablesPlain(argument.toJava()).await())
    }

    /**
     * @see [getProjectVariables].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetProjectVariablesPlainArgs].
     * @return A collection of values returned by getProjectVariables.
     */
    public suspend fun getProjectVariables(argument: suspend GetProjectVariablesPlainArgsBuilder.() -> Unit): GetProjectVariablesResult {
        val builder = GetProjectVariablesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProjectVariablesResultToKotlin(getProjectVariablesPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.getProjects` data source allows details of multiple projects to be retrieved. Optionally filtered by the set attributes.
     * > This data source supports all available filters exposed by the xanzy/go-gitlab package, which might not expose all available filters exposed by the Gitlab APIs.
     * > The owner sub-attributes are only populated if the Gitlab token used has an administrator scope.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/projects.html#list-all-projects)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as gitlab from "@pulumi/gitlab";
     * // List projects within a group tree
     * const mygroup = gitlab.getGroup({
     *     fullPath: "mygroup",
     * });
     * const groupProjects = mygroup.then(mygroup => gitlab.getProjects({
     *     groupId: mygroup.id,
     *     orderBy: "name",
     *     includeSubgroups: true,
     *     withShared: false,
     * }));
     * // List projects using the search syntax
     * const projects = gitlab.getProjects({
     *     search: "postgresql",
     *     visibility: "private",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_gitlab as gitlab
     * # List projects within a group tree
     * mygroup = gitlab.get_group(full_path="mygroup")
     * group_projects = gitlab.get_projects(group_id=mygroup.id,
     *     order_by="name",
     *     include_subgroups=True,
     *     with_shared=False)
     * # List projects using the search syntax
     * projects = gitlab.get_projects(search="postgresql",
     *     visibility="private")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using GitLab = Pulumi.GitLab;
     * return await Deployment.RunAsync(() =>
     * {
     *     // List projects within a group tree
     *     var mygroup = GitLab.GetGroup.Invoke(new()
     *     {
     *         FullPath = "mygroup",
     *     });
     *     var groupProjects = GitLab.GetProjects.Invoke(new()
     *     {
     *         GroupId = mygroup.Apply(getGroupResult => getGroupResult.Id),
     *         OrderBy = "name",
     *         IncludeSubgroups = true,
     *         WithShared = false,
     *     });
     *     // List projects using the search syntax
     *     var projects = GitLab.GetProjects.Invoke(new()
     *     {
     *         Search = "postgresql",
     *         Visibility = "private",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// List projects within a group tree
     * 		mygroup, err := gitlab.LookupGroup(ctx, &gitlab.LookupGroupArgs{
     * 			FullPath: pulumi.StringRef("mygroup"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = gitlab.GetProjects(ctx, &gitlab.GetProjectsArgs{
     * 			GroupId:          pulumi.IntRef(mygroup.Id),
     * 			OrderBy:          pulumi.StringRef("name"),
     * 			IncludeSubgroups: pulumi.BoolRef(true),
     * 			WithShared:       pulumi.BoolRef(false),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		// List projects using the search syntax
     * 		_, err = gitlab.GetProjects(ctx, &gitlab.GetProjectsArgs{
     * 			Search:     pulumi.StringRef("postgresql"),
     * 			Visibility: pulumi.StringRef("private"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.gitlab.GitlabFunctions;
     * import com.pulumi.gitlab.inputs.GetGroupArgs;
     * import com.pulumi.gitlab.inputs.GetProjectsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // List projects within a group tree
     *         final var mygroup = GitlabFunctions.getGroup(GetGroupArgs.builder()
     *             .fullPath("mygroup")
     *             .build());
     *         final var groupProjects = GitlabFunctions.getProjects(GetProjectsArgs.builder()
     *             .groupId(mygroup.applyValue(getGroupResult -> getGroupResult.id()))
     *             .orderBy("name")
     *             .includeSubgroups(true)
     *             .withShared(false)
     *             .build());
     *         // List projects using the search syntax
     *         final var projects = GitlabFunctions.getProjects(GetProjectsArgs.builder()
     *             .search("postgresql")
     *             .visibility("private")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # List projects within a group tree
     *   mygroup:
     *     fn::invoke:
     *       Function: gitlab:getGroup
     *       Arguments:
     *         fullPath: mygroup
     *   groupProjects:
     *     fn::invoke:
     *       Function: gitlab:getProjects
     *       Arguments:
     *         groupId: ${mygroup.id}
     *         orderBy: name
     *         includeSubgroups: true
     *         withShared: false
     *   # List projects using the search syntax
     *   projects:
     *     fn::invoke:
     *       Function: gitlab:getProjects
     *       Arguments:
     *         search: postgresql
     *         visibility: private
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getProjects.
     * @return A collection of values returned by getProjects.
     */
    public suspend fun getProjects(argument: GetProjectsPlainArgs): GetProjectsResult =
        getProjectsResultToKotlin(getProjectsPlain(argument.toJava()).await())

    /**
     * @see [getProjects].
     * @param archived Limit by archived status.
     * @param groupId The ID of the group owned by the authenticated user to look projects for within. Cannot be used with `min_access_level`, `with_programming_language` or `statistics`.
     * @param includeSubgroups Include projects in subgroups of this group. Default is `false`. Needs `group_id`.
     * @param maxQueryablePages The maximum number of project results pages that may be queried. Prevents overloading your Gitlab instance in case of a misconfiguration.
     * @param membership Limit by projects that the current user is a member of.
     * @param minAccessLevel Limit to projects where current user has at least this access level, refer to the [official documentation](https://docs.gitlab.com/ee/api/members.html) for values. Cannot be used with `group_id`.
     * @param orderBy Return projects ordered ordered by: `id`, `name`, `path`, `created_at`, `updated_at`, `last_activity_at`, `similarity`, `repository_size`, `storage_size`, `packages_size`, `wiki_size`. Some values or only available in certain circumstances. See [upstream docs](https://docs.gitlab.com/ee/api/projects.html#list-all-projects) for details.
     * @param owned Limit by projects owned by the current user.
     * @param page The first page to begin the query on.
     * @param perPage The number of results to return per page.
     * @param search Return list of authorized projects matching the search criteria.
     * @param simple Return only the ID, URL, name, and path of each project.
     * @param sort Return projects sorted in `asc` or `desc` order. Default is `desc`.
     * @param starred Limit by projects starred by the current user.
     * @param statistics Include project statistics. Cannot be used with `group_id`.
     * @param topics Limit by projects that have all of the given topics.
     * @param visibility Limit by visibility `public`, `internal`, or `private`.
     * @param withCustomAttributes Include custom attributes in response *(admins only)*.
     * @param withIssuesEnabled Limit by projects with issues feature enabled. Default is `false`.
     * @param withMergeRequestsEnabled Limit by projects with merge requests feature enabled. Default is `false`.
     * @param withProgrammingLanguage Limit by projects which use the given programming language. Cannot be used with `group_id`.
     * @param withShared Include projects shared to this group. Default is `true`. Needs `group_id`.
     * @return A collection of values returned by getProjects.
     */
    public suspend fun getProjects(
        archived: Boolean? = null,
        groupId: Int? = null,
        includeSubgroups: Boolean? = null,
        maxQueryablePages: Int? = null,
        membership: Boolean? = null,
        minAccessLevel: Int? = null,
        orderBy: String? = null,
        owned: Boolean? = null,
        page: Int? = null,
        perPage: Int? = null,
        search: String? = null,
        simple: Boolean? = null,
        sort: String? = null,
        starred: Boolean? = null,
        statistics: Boolean? = null,
        topics: List<String>? = null,
        visibility: String? = null,
        withCustomAttributes: Boolean? = null,
        withIssuesEnabled: Boolean? = null,
        withMergeRequestsEnabled: Boolean? = null,
        withProgrammingLanguage: String? = null,
        withShared: Boolean? = null,
    ): GetProjectsResult {
        val argument = GetProjectsPlainArgs(
            archived = archived,
            groupId = groupId,
            includeSubgroups = includeSubgroups,
            maxQueryablePages = maxQueryablePages,
            membership = membership,
            minAccessLevel = minAccessLevel,
            orderBy = orderBy,
            owned = owned,
            page = page,
            perPage = perPage,
            search = search,
            simple = simple,
            sort = sort,
            starred = starred,
            statistics = statistics,
            topics = topics,
            visibility = visibility,
            withCustomAttributes = withCustomAttributes,
            withIssuesEnabled = withIssuesEnabled,
            withMergeRequestsEnabled = withMergeRequestsEnabled,
            withProgrammingLanguage = withProgrammingLanguage,
            withShared = withShared,
        )
        return getProjectsResultToKotlin(getProjectsPlain(argument.toJava()).await())
    }

    /**
     * @see [getProjects].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetProjectsPlainArgs].
     * @return A collection of values returned by getProjects.
     */
    public suspend fun getProjects(argument: suspend GetProjectsPlainArgsBuilder.() -> Unit): GetProjectsResult {
        val builder = GetProjectsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProjectsResultToKotlin(getProjectsPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.getRelease` data source retrieves information about a gitlab release for a project.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/releases/)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as gitlab from "@pulumi/gitlab";
     * // By project ID and tag_name
     * const example = gitlab.getRelease({
     *     projectId: "1234",
     *     tagName: "v1.0",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_gitlab as gitlab
     * # By project ID and tag_name
     * example = gitlab.get_release(project_id="1234",
     *     tag_name="v1.0")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using GitLab = Pulumi.GitLab;
     * return await Deployment.RunAsync(() =>
     * {
     *     // By project ID and tag_name
     *     var example = GitLab.GetRelease.Invoke(new()
     *     {
     *         ProjectId = "1234",
     *         TagName = "v1.0",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		// By project ID and tag_name
     * 		_, err := gitlab.GetRelease(ctx, &gitlab.GetReleaseArgs{
     * 			ProjectId: "1234",
     * 			TagName:   "v1.0",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.gitlab.GitlabFunctions;
     * import com.pulumi.gitlab.inputs.GetReleaseArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         // By project ID and tag_name
     *         final var example = GitlabFunctions.getRelease(GetReleaseArgs.builder()
     *             .projectId(1234)
     *             .tagName("v1.0")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   # By project ID and tag_name
     *   example:
     *     fn::invoke:
     *       Function: gitlab:getRelease
     *       Arguments:
     *         projectId: 1234
     *         tagName: v1.0
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRelease.
     * @return A collection of values returned by getRelease.
     */
    public suspend fun getRelease(argument: GetReleasePlainArgs): GetReleaseResult =
        getReleaseResultToKotlin(getReleasePlain(argument.toJava()).await())

    /**
     * @see [getRelease].
     * @param assets The assets for a release
     * @param projectId The ID or URL-encoded path of the project.
     * @param tagName The Git tag the release is associated with.
     * @return A collection of values returned by getRelease.
     */
    public suspend fun getRelease(
        assets: GetReleaseAssets? = null,
        projectId: String,
        tagName: String,
    ): GetReleaseResult {
        val argument = GetReleasePlainArgs(
            assets = assets,
            projectId = projectId,
            tagName = tagName,
        )
        return getReleaseResultToKotlin(getReleasePlain(argument.toJava()).await())
    }

    /**
     * @see [getRelease].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetReleasePlainArgs].
     * @return A collection of values returned by getRelease.
     */
    public suspend fun getRelease(argument: suspend GetReleasePlainArgsBuilder.() -> Unit): GetReleaseResult {
        val builder = GetReleasePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReleaseResultToKotlin(getReleasePlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.ReleaseLink` data source allows get details of a release link.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/releases/links.html)
     * @param argument A collection of arguments for invoking getReleaseLink.
     * @return A collection of values returned by getReleaseLink.
     */
    public suspend fun getReleaseLink(argument: GetReleaseLinkPlainArgs): GetReleaseLinkResult =
        getReleaseLinkResultToKotlin(getReleaseLinkPlain(argument.toJava()).await())

    /**
     * @see [getReleaseLink].
     * @param linkId The ID of the link.
     * @param project The ID or [URL-encoded path of the project](https://docs.gitlab.com/ee/api/index.html#namespaced-path-encoding).
     * @param tagName The tag associated with the Release.
     * @return A collection of values returned by getReleaseLink.
     */
    public suspend fun getReleaseLink(
        linkId: Int,
        project: String,
        tagName: String,
    ): GetReleaseLinkResult {
        val argument = GetReleaseLinkPlainArgs(
            linkId = linkId,
            project = project,
            tagName = tagName,
        )
        return getReleaseLinkResultToKotlin(getReleaseLinkPlain(argument.toJava()).await())
    }

    /**
     * @see [getReleaseLink].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetReleaseLinkPlainArgs].
     * @return A collection of values returned by getReleaseLink.
     */
    public suspend fun getReleaseLink(argument: suspend GetReleaseLinkPlainArgsBuilder.() -> Unit): GetReleaseLinkResult {
        val builder = GetReleaseLinkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReleaseLinkResultToKotlin(getReleaseLinkPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.getReleaseLinks` data source allows get details of release links.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/releases/links.html)
     * @param argument A collection of arguments for invoking getReleaseLinks.
     * @return A collection of values returned by getReleaseLinks.
     */
    public suspend fun getReleaseLinks(argument: GetReleaseLinksPlainArgs): GetReleaseLinksResult =
        getReleaseLinksResultToKotlin(getReleaseLinksPlain(argument.toJava()).await())

    /**
     * @see [getReleaseLinks].
     * @param project The ID or full path to the project.
     * @param tagName The tag associated with the Release.
     * @return A collection of values returned by getReleaseLinks.
     */
    public suspend fun getReleaseLinks(project: String, tagName: String): GetReleaseLinksResult {
        val argument = GetReleaseLinksPlainArgs(
            project = project,
            tagName = tagName,
        )
        return getReleaseLinksResultToKotlin(getReleaseLinksPlain(argument.toJava()).await())
    }

    /**
     * @see [getReleaseLinks].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetReleaseLinksPlainArgs].
     * @return A collection of values returned by getReleaseLinks.
     */
    public suspend fun getReleaseLinks(argument: suspend GetReleaseLinksPlainArgsBuilder.() -> Unit): GetReleaseLinksResult {
        val builder = GetReleaseLinksPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReleaseLinksResultToKotlin(getReleaseLinksPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.RepositoryFile` data source allows details of a file in a repository to be retrieved.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/repository_files.html)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as gitlab from "@pulumi/gitlab";
     * const example = gitlab.getRepositoryFile({
     *     project: "example",
     *     ref: "main",
     *     filePath: "README.md",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_gitlab as gitlab
     * example = gitlab.get_repository_file(project="example",
     *     ref="main",
     *     file_path="README.md")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using GitLab = Pulumi.GitLab;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = GitLab.GetRepositoryFile.Invoke(new()
     *     {
     *         Project = "example",
     *         Ref = "main",
     *         FilePath = "README.md",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := gitlab.LookupRepositoryFile(ctx, &gitlab.LookupRepositoryFileArgs{
     * 			Project:  "example",
     * 			Ref:      "main",
     * 			FilePath: "README.md",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.gitlab.GitlabFunctions;
     * import com.pulumi.gitlab.inputs.GetRepositoryFileArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = GitlabFunctions.getRepositoryFile(GetRepositoryFileArgs.builder()
     *             .project("example")
     *             .ref("main")
     *             .filePath("README.md")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: gitlab:getRepositoryFile
     *       Arguments:
     *         project: example
     *         ref: main
     *         filePath: README.md
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRepositoryFile.
     * @return A collection of values returned by getRepositoryFile.
     */
    public suspend fun getRepositoryFile(argument: GetRepositoryFilePlainArgs): GetRepositoryFileResult =
        getRepositoryFileResultToKotlin(getRepositoryFilePlain(argument.toJava()).await())

    /**
     * @see [getRepositoryFile].
     * @param filePath The full path of the file. It must be relative to the root of the project without a leading slash `/` or `./`.
     * @param project The name or ID of the project.
     * @param ref The name of branch, tag or commit.
     * @return A collection of values returned by getRepositoryFile.
     */
    public suspend fun getRepositoryFile(
        filePath: String,
        project: String,
        ref: String,
    ): GetRepositoryFileResult {
        val argument = GetRepositoryFilePlainArgs(
            filePath = filePath,
            project = project,
            ref = ref,
        )
        return getRepositoryFileResultToKotlin(getRepositoryFilePlain(argument.toJava()).await())
    }

    /**
     * @see [getRepositoryFile].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetRepositoryFilePlainArgs].
     * @return A collection of values returned by getRepositoryFile.
     */
    public suspend fun getRepositoryFile(argument: suspend GetRepositoryFilePlainArgsBuilder.() -> Unit): GetRepositoryFileResult {
        val builder = GetRepositoryFilePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRepositoryFileResultToKotlin(getRepositoryFilePlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.getRepositoryTree` data source allows details of directories and files in a repository to be retrieved.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/repositories.html#list-repository-tree)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as gitlab from "@pulumi/gitlab";
     * const this = gitlab.getRepositoryTree({
     *     project: "example",
     *     ref: "main",
     *     path: "ExampleSubFolder",
     *     recursive: true,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_gitlab as gitlab
     * this = gitlab.get_repository_tree(project="example",
     *     ref="main",
     *     path="ExampleSubFolder",
     *     recursive=True)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using GitLab = Pulumi.GitLab;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @this = GitLab.GetRepositoryTree.Invoke(new()
     *     {
     *         Project = "example",
     *         Ref = "main",
     *         Path = "ExampleSubFolder",
     *         Recursive = true,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := gitlab.GetRepositoryTree(ctx, &gitlab.GetRepositoryTreeArgs{
     * 			Project:   "example",
     * 			Ref:       "main",
     * 			Path:      pulumi.StringRef("ExampleSubFolder"),
     * 			Recursive: pulumi.BoolRef(true),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.gitlab.GitlabFunctions;
     * import com.pulumi.gitlab.inputs.GetRepositoryTreeArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var this = GitlabFunctions.getRepositoryTree(GetRepositoryTreeArgs.builder()
     *             .project("example")
     *             .ref("main")
     *             .path("ExampleSubFolder")
     *             .recursive(true)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   this:
     *     fn::invoke:
     *       Function: gitlab:getRepositoryTree
     *       Arguments:
     *         project: example
     *         ref: main
     *         path: ExampleSubFolder
     *         recursive: true
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getRepositoryTree.
     * @return A collection of values returned by getRepositoryTree.
     */
    public suspend fun getRepositoryTree(argument: GetRepositoryTreePlainArgs): GetRepositoryTreeResult =
        getRepositoryTreeResultToKotlin(getRepositoryTreePlain(argument.toJava()).await())

    /**
     * @see [getRepositoryTree].
     * @param path The path inside repository. Used to get content of subdirectories.
     * @param project The ID or full path of the project owned by the authenticated user.
     * @param recursive Boolean value used to get a recursive tree (false by default).
     * @param ref The name of a repository branch or tag.
     * @return A collection of values returned by getRepositoryTree.
     */
    public suspend fun getRepositoryTree(
        path: String? = null,
        project: String,
        recursive: Boolean? = null,
        ref: String,
    ): GetRepositoryTreeResult {
        val argument = GetRepositoryTreePlainArgs(
            path = path,
            project = project,
            recursive = recursive,
            ref = ref,
        )
        return getRepositoryTreeResultToKotlin(getRepositoryTreePlain(argument.toJava()).await())
    }

    /**
     * @see [getRepositoryTree].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetRepositoryTreePlainArgs].
     * @return A collection of values returned by getRepositoryTree.
     */
    public suspend fun getRepositoryTree(argument: suspend GetRepositoryTreePlainArgsBuilder.() -> Unit): GetRepositoryTreeResult {
        val builder = GetRepositoryTreePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRepositoryTreeResultToKotlin(getRepositoryTreePlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.User` data source allows details of a user to be retrieved by either the user ID, username or email address.
     * > Some attributes might not be returned depending on if you're an admin or not.
     * > When using the `email` attribute, an exact match is not guaranteed. The most related match will be returned. Starting with GitLab 16.6,
     * the most related match will prioritize an exact match if one is available.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/users.html#single-user)
     * @param argument A collection of arguments for invoking getUser.
     * @return A collection of values returned by getUser.
     */
    public suspend fun getUser(argument: GetUserPlainArgs): GetUserResult =
        getUserResultToKotlin(getUserPlain(argument.toJava()).await())

    /**
     * @see [getUser].
     * @param email The public email address of the user. **Note**: before GitLab 14.8 the lookup was based on the users primary email address.
     * @param namespaceId The ID of the user's namespace. Requires admin token to access this field. Available since GitLab 14.10.
     * @param userId The ID of the user.
     * @param username The username of the user.
     * @return A collection of values returned by getUser.
     */
    public suspend fun getUser(
        email: String? = null,
        namespaceId: Int? = null,
        userId: Int? = null,
        username: String? = null,
    ): GetUserResult {
        val argument = GetUserPlainArgs(
            email = email,
            namespaceId = namespaceId,
            userId = userId,
            username = username,
        )
        return getUserResultToKotlin(getUserPlain(argument.toJava()).await())
    }

    /**
     * @see [getUser].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetUserPlainArgs].
     * @return A collection of values returned by getUser.
     */
    public suspend fun getUser(argument: suspend GetUserPlainArgsBuilder.() -> Unit): GetUserResult {
        val builder = GetUserPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUserResultToKotlin(getUserPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.getUserSshkeys` data source allows a list of SSH keys to be retrieved by either the user ID or username.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/users.html#list-ssh-keys-for-user)
     * @param argument A collection of arguments for invoking getUserSshkeys.
     * @return A collection of values returned by getUserSshkeys.
     */
    public suspend fun getUserSshkeys(argument: GetUserSshkeysPlainArgs): GetUserSshkeysResult =
        getUserSshkeysResultToKotlin(getUserSshkeysPlain(argument.toJava()).await())

    /**
     * @see [getUserSshkeys].
     * @param userId ID of the user to get the SSH keys for.
     * @param username Username of the user to get the SSH keys for.
     * @return A collection of values returned by getUserSshkeys.
     */
    public suspend fun getUserSshkeys(userId: Int? = null, username: String? = null): GetUserSshkeysResult {
        val argument = GetUserSshkeysPlainArgs(
            userId = userId,
            username = username,
        )
        return getUserSshkeysResultToKotlin(getUserSshkeysPlain(argument.toJava()).await())
    }

    /**
     * @see [getUserSshkeys].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetUserSshkeysPlainArgs].
     * @return A collection of values returned by getUserSshkeys.
     */
    public suspend fun getUserSshkeys(argument: suspend GetUserSshkeysPlainArgsBuilder.() -> Unit): GetUserSshkeysResult {
        val builder = GetUserSshkeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUserSshkeysResultToKotlin(getUserSshkeysPlain(builtArgument.toJava()).await())
    }

    /**
     * The `gitlab.getUsers` data source allows details of multiple users to be retrieved given some optional filter criteria.
     * > Some attributes might not be returned depending on if you're an admin or not.
     * > Some available options require administrator privileges.
     * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ce/api/users.html#list-users)
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as gitlab from "@pulumi/gitlab";
     * const example = gitlab.getUsers({
     *     sort: "desc",
     *     orderBy: "name",
     *     createdBefore: "2019-01-01",
     * });
     * const example-two = gitlab.getUsers({
     *     search: "username",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_gitlab as gitlab
     * example = gitlab.get_users(sort="desc",
     *     order_by="name",
     *     created_before="2019-01-01")
     * example_two = gitlab.get_users(search="username")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using GitLab = Pulumi.GitLab;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = GitLab.GetUsers.Invoke(new()
     *     {
     *         Sort = "desc",
     *         OrderBy = "name",
     *         CreatedBefore = "2019-01-01",
     *     });
     *     var example_two = GitLab.GetUsers.Invoke(new()
     *     {
     *         Search = "username",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := gitlab.GetUsers(ctx, &gitlab.GetUsersArgs{
     * 			Sort:          pulumi.StringRef("desc"),
     * 			OrderBy:       pulumi.StringRef("name"),
     * 			CreatedBefore: pulumi.StringRef("2019-01-01"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = gitlab.GetUsers(ctx, &gitlab.GetUsersArgs{
     * 			Search: pulumi.StringRef("username"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.gitlab.GitlabFunctions;
     * import com.pulumi.gitlab.inputs.GetUsersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = GitlabFunctions.getUsers(GetUsersArgs.builder()
     *             .sort("desc")
     *             .orderBy("name")
     *             .createdBefore("2019-01-01")
     *             .build());
     *         final var example-two = GitlabFunctions.getUsers(GetUsersArgs.builder()
     *             .search("username")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: gitlab:getUsers
     *       Arguments:
     *         sort: desc
     *         orderBy: name
     *         createdBefore: 2019-01-01
     *   example-two:
     *     fn::invoke:
     *       Function: gitlab:getUsers
     *       Arguments:
     *         search: username
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getUsers.
     * @return A collection of values returned by getUsers.
     */
    public suspend fun getUsers(argument: GetUsersPlainArgs): GetUsersResult =
        getUsersResultToKotlin(getUsersPlain(argument.toJava()).await())

    /**
     * @see [getUsers].
     * @param active Filter users that are active.
     * @param blocked Filter users that are blocked.
     * @param createdAfter Search for users created after a specific date. (Requires administrator privileges)
     * @param createdBefore Search for users created before a specific date. (Requires administrator privileges)
     * @param externProvider Lookup users by external provider. (Requires administrator privileges)
     * @param externUid Lookup users by external UID. (Requires administrator privileges)
     * @param orderBy Order the users' list by `id`, `name`, `username`, `created_at` or `updated_at`. (Requires administrator privileges)
     * @param search Search users by username, name or email.
     * @param sort Sort users' list in asc or desc order. (Requires administrator privileges)
     * @return A collection of values returned by getUsers.
     */
    public suspend fun getUsers(
        active: Boolean? = null,
        blocked: Boolean? = null,
        createdAfter: String? = null,
        createdBefore: String? = null,
        externProvider: String? = null,
        externUid: String? = null,
        orderBy: String? = null,
        search: String? = null,
        sort: String? = null,
    ): GetUsersResult {
        val argument = GetUsersPlainArgs(
            active = active,
            blocked = blocked,
            createdAfter = createdAfter,
            createdBefore = createdBefore,
            externProvider = externProvider,
            externUid = externUid,
            orderBy = orderBy,
            search = search,
            sort = sort,
        )
        return getUsersResultToKotlin(getUsersPlain(argument.toJava()).await())
    }

    /**
     * @see [getUsers].
     * @param argument Builder for [com&#46;pulumi&#46;gitlab&#46;kotlin&#46;inputs&#46;GetUsersPlainArgs].
     * @return A collection of values returned by getUsers.
     */
    public suspend fun getUsers(argument: suspend GetUsersPlainArgsBuilder.() -> Unit): GetUsersResult {
        val builder = GetUsersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getUsersResultToKotlin(getUsersPlain(builtArgument.toJava()).await())
    }
}
