@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.gitlab.Provider
import com.pulumi.kotlin.KotlinProviderResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [GitlabProvider].
 */
@PulumiTagMarker
public class GitlabProviderResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProviderArgs = ProviderArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProviderArgsBuilder.() -> Unit) {
        val builder = ProviderArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GitlabProvider {
        val builtJavaResource = Provider(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GitlabProvider(builtJavaResource)
    }
}

/**
 * The provider type for the gitlab package. By default, resources use package-wide configuration
 * settings, however an explicit `Provider` instance may be created and passed during resource
 * construction to achieve fine-grained programmatic control over provider settings. See the
 * [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.
 */
public class GitlabProvider internal constructor(
    override val javaResource: Provider,
) : KotlinProviderResource(javaResource, GitlabProviderMapper) {
    /**
     * This is the target GitLab base API endpoint. Providing a value is a requirement when working with GitLab CE or GitLab
     * Enterprise e.g. `https://my.gitlab.server/api/v4/`. It is optional to provide this value and it can also be sourced from
     * the `GITLAB_BASE_URL` environment variable. The value must end with a slash.
     */
    public val baseUrl: Output<String>?
        get() = javaResource.baseUrl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * This is a file containing the ca cert to verify the gitlab instance. This is available for use when working with GitLab
     * CE or Gitlab Enterprise with a locally-issued or self-signed certificate chain.
     */
    public val cacertFile: Output<String>?
        get() = javaResource.cacertFile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * File path to client certificate when GitLab instance is behind company proxy. File must contain PEM encoded data.
     */
    public val clientCert: Output<String>?
        get() = javaResource.clientCert().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * File path to client key when GitLab instance is behind company proxy. File must contain PEM encoded data. Required when
     * `client_cert` is set.
     */
    public val clientKey: Output<String>?
        get() = javaResource.clientKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The OAuth2 Token, Project, Group, Personal Access Token or CI Job Token used to connect to GitLab. The OAuth method is
     * used in this provider for authentication (using Bearer authorization token). See
     * https://docs.gitlab.com/ee/api/#authentication for details. It may be sourced from the `GITLAB_TOKEN` environment
     * variable.
     */
    public val token: Output<String>?
        get() = javaResource.token().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object GitlabProviderMapper : ResourceMapper<GitlabProvider> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        Provider::class == javaResource::class

    override fun map(javaResource: Resource): GitlabProvider = GitlabProvider(
        javaResource as
            Provider,
    )
}

/**
 * @see [Provider].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GitlabProvider].
 */
public suspend fun gitlabProvider(
    name: String,
    block: suspend GitlabProviderResourceBuilder.() -> Unit,
): GitlabProvider {
    val builder = GitlabProviderResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Provider].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gitlabProvider(name: String): GitlabProvider {
    val builder = GitlabProviderResourceBuilder()
    builder.name(name)
    return builder.build()
}
