@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [GlobalLevelNotifications].
 */
@PulumiTagMarker
public class GlobalLevelNotificationsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GlobalLevelNotificationsArgs = GlobalLevelNotificationsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GlobalLevelNotificationsArgsBuilder.() -> Unit) {
        val builder = GlobalLevelNotificationsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GlobalLevelNotifications {
        val builtJavaResource = com.pulumi.gitlab.GlobalLevelNotifications(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GlobalLevelNotifications(builtJavaResource)
    }
}

/**
 * The `gitlab.GlobalLevelNotifications` resource allows to manage global notifications.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/notification_settings.html#group--project-level-notification-settings)
 * ## Import
 * Note: You can import a global notification state using "gitlab" as the ID.
 * The ID will always be gitlab, because the global notificatio only exists
 * once per user
 * ```sh
 * $ pulumi import gitlab:index/globalLevelNotifications:GlobalLevelNotifications example gitlab
 * ```
 */
public class GlobalLevelNotifications internal constructor(
    override val javaResource: com.pulumi.gitlab.GlobalLevelNotifications,
) : KotlinCustomResource(javaResource, GlobalLevelNotificationsMapper) {
    /**
     * Enable notifications for closed issues. Can only be used when `level` is `custom`.
     */
    public val closeIssue: Output<Boolean>
        get() = javaResource.closeIssue().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for closed merge requests. Can only be used when `level` is `custom`.
     */
    public val closeMergeRequest: Output<Boolean>
        get() = javaResource.closeMergeRequest().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for failed pipelines. Can only be used when `level` is `custom`.
     */
    public val failedPipeline: Output<Boolean>
        get() = javaResource.failedPipeline().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for fixed pipelines. Can only be used when `level` is `custom`.
     */
    public val fixedPipeline: Output<Boolean>
        get() = javaResource.fixedPipeline().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for due issues. Can only be used when `level` is `custom`.
     */
    public val issueDue: Output<Boolean>
        get() = javaResource.issueDue().applyValue({ args0 -> args0 })

    /**
     * The level of the notification. Valid values are: `disabled`, `participating`, `watch`, `global`, `mention`, `custom`.
     */
    public val level: Output<String>
        get() = javaResource.level().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for merged merge requests. Can only be used when `level` is `custom`.
     */
    public val mergeMergeRequest: Output<Boolean>
        get() = javaResource.mergeMergeRequest().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for merged merge requests when the pipeline succeeds. Can only be used when `level` is `custom`.
     */
    public val mergeWhenPipelineSucceeds: Output<Boolean>
        get() = javaResource.mergeWhenPipelineSucceeds().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for moved projects. Can only be used when `level` is `custom`.
     */
    public val movedProject: Output<Boolean>
        get() = javaResource.movedProject().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for new issues. Can only be used when `level` is `custom`.
     */
    public val newIssue: Output<Boolean>
        get() = javaResource.newIssue().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for new merge requests. Can only be used when `level` is `custom`.
     */
    public val newMergeRequest: Output<Boolean>
        get() = javaResource.newMergeRequest().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for new notes on merge requests. Can only be used when `level` is `custom`.
     */
    public val newNote: Output<Boolean>
        get() = javaResource.newNote().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for push to merge request branches. Can only be used when `level` is `custom`.
     */
    public val pushToMergeRequest: Output<Boolean>
        get() = javaResource.pushToMergeRequest().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for issue reassignments. Can only be used when `level` is `custom`.
     */
    public val reassignIssue: Output<Boolean>
        get() = javaResource.reassignIssue().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for merge request reassignments. Can only be used when `level` is `custom`.
     */
    public val reassignMergeRequest: Output<Boolean>
        get() = javaResource.reassignMergeRequest().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for reopened issues. Can only be used when `level` is `custom`.
     */
    public val reopenIssue: Output<Boolean>
        get() = javaResource.reopenIssue().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for reopened merge requests. Can only be used when `level` is `custom`.
     */
    public val reopenMergeRequest: Output<Boolean>
        get() = javaResource.reopenMergeRequest().applyValue({ args0 -> args0 })

    /**
     * Enable notifications for successful pipelines. Can only be used when `level` is `custom`.
     */
    public val successPipeline: Output<Boolean>
        get() = javaResource.successPipeline().applyValue({ args0 -> args0 })
}

public object GlobalLevelNotificationsMapper : ResourceMapper<GlobalLevelNotifications> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.GlobalLevelNotifications::class == javaResource::class

    override fun map(javaResource: Resource): GlobalLevelNotifications =
        GlobalLevelNotifications(javaResource as com.pulumi.gitlab.GlobalLevelNotifications)
}

/**
 * @see [GlobalLevelNotifications].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GlobalLevelNotifications].
 */
public suspend fun globalLevelNotifications(
    name: String,
    block: suspend GlobalLevelNotificationsResourceBuilder.() -> Unit,
): GlobalLevelNotifications {
    val builder = GlobalLevelNotificationsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GlobalLevelNotifications].
 * @param name The _unique_ name of the resulting resource.
 */
public fun globalLevelNotifications(name: String): GlobalLevelNotifications {
    val builder = GlobalLevelNotificationsResourceBuilder()
    builder.name(name)
    return builder.build()
}
