@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.GlobalLevelNotificationsArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.GlobalLevelNotifications` resource allows to manage global notifications.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/notification_settings.html#group--project-level-notification-settings)
 * ## Import
 * Note: You can import a global notification state using "gitlab" as the ID.
 * The ID will always be gitlab, because the global notificatio only exists
 * once per user
 * ```sh
 * $ pulumi import gitlab:index/globalLevelNotifications:GlobalLevelNotifications example gitlab
 * ```
 * @property closeIssue Enable notifications for closed issues. Can only be used when `level` is `custom`.
 * @property closeMergeRequest Enable notifications for closed merge requests. Can only be used when `level` is `custom`.
 * @property failedPipeline Enable notifications for failed pipelines. Can only be used when `level` is `custom`.
 * @property fixedPipeline Enable notifications for fixed pipelines. Can only be used when `level` is `custom`.
 * @property issueDue Enable notifications for due issues. Can only be used when `level` is `custom`.
 * @property level The level of the notification. Valid values are: `disabled`, `participating`, `watch`, `global`, `mention`, `custom`.
 * @property mergeMergeRequest Enable notifications for merged merge requests. Can only be used when `level` is `custom`.
 * @property mergeWhenPipelineSucceeds Enable notifications for merged merge requests when the pipeline succeeds. Can only be used when `level` is `custom`.
 * @property movedProject Enable notifications for moved projects. Can only be used when `level` is `custom`.
 * @property newIssue Enable notifications for new issues. Can only be used when `level` is `custom`.
 * @property newMergeRequest Enable notifications for new merge requests. Can only be used when `level` is `custom`.
 * @property newNote Enable notifications for new notes on merge requests. Can only be used when `level` is `custom`.
 * @property pushToMergeRequest Enable notifications for push to merge request branches. Can only be used when `level` is `custom`.
 * @property reassignIssue Enable notifications for issue reassignments. Can only be used when `level` is `custom`.
 * @property reassignMergeRequest Enable notifications for merge request reassignments. Can only be used when `level` is `custom`.
 * @property reopenIssue Enable notifications for reopened issues. Can only be used when `level` is `custom`.
 * @property reopenMergeRequest Enable notifications for reopened merge requests. Can only be used when `level` is `custom`.
 * @property successPipeline Enable notifications for successful pipelines. Can only be used when `level` is `custom`.
 */
public data class GlobalLevelNotificationsArgs(
    public val closeIssue: Output<Boolean>? = null,
    public val closeMergeRequest: Output<Boolean>? = null,
    public val failedPipeline: Output<Boolean>? = null,
    public val fixedPipeline: Output<Boolean>? = null,
    public val issueDue: Output<Boolean>? = null,
    public val level: Output<String>? = null,
    public val mergeMergeRequest: Output<Boolean>? = null,
    public val mergeWhenPipelineSucceeds: Output<Boolean>? = null,
    public val movedProject: Output<Boolean>? = null,
    public val newIssue: Output<Boolean>? = null,
    public val newMergeRequest: Output<Boolean>? = null,
    public val newNote: Output<Boolean>? = null,
    public val pushToMergeRequest: Output<Boolean>? = null,
    public val reassignIssue: Output<Boolean>? = null,
    public val reassignMergeRequest: Output<Boolean>? = null,
    public val reopenIssue: Output<Boolean>? = null,
    public val reopenMergeRequest: Output<Boolean>? = null,
    public val successPipeline: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.GlobalLevelNotificationsArgs> {
    override fun toJava(): com.pulumi.gitlab.GlobalLevelNotificationsArgs =
        com.pulumi.gitlab.GlobalLevelNotificationsArgs.builder()
            .closeIssue(closeIssue?.applyValue({ args0 -> args0 }))
            .closeMergeRequest(closeMergeRequest?.applyValue({ args0 -> args0 }))
            .failedPipeline(failedPipeline?.applyValue({ args0 -> args0 }))
            .fixedPipeline(fixedPipeline?.applyValue({ args0 -> args0 }))
            .issueDue(issueDue?.applyValue({ args0 -> args0 }))
            .level(level?.applyValue({ args0 -> args0 }))
            .mergeMergeRequest(mergeMergeRequest?.applyValue({ args0 -> args0 }))
            .mergeWhenPipelineSucceeds(mergeWhenPipelineSucceeds?.applyValue({ args0 -> args0 }))
            .movedProject(movedProject?.applyValue({ args0 -> args0 }))
            .newIssue(newIssue?.applyValue({ args0 -> args0 }))
            .newMergeRequest(newMergeRequest?.applyValue({ args0 -> args0 }))
            .newNote(newNote?.applyValue({ args0 -> args0 }))
            .pushToMergeRequest(pushToMergeRequest?.applyValue({ args0 -> args0 }))
            .reassignIssue(reassignIssue?.applyValue({ args0 -> args0 }))
            .reassignMergeRequest(reassignMergeRequest?.applyValue({ args0 -> args0 }))
            .reopenIssue(reopenIssue?.applyValue({ args0 -> args0 }))
            .reopenMergeRequest(reopenMergeRequest?.applyValue({ args0 -> args0 }))
            .successPipeline(successPipeline?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GlobalLevelNotificationsArgs].
 */
@PulumiTagMarker
public class GlobalLevelNotificationsArgsBuilder internal constructor() {
    private var closeIssue: Output<Boolean>? = null

    private var closeMergeRequest: Output<Boolean>? = null

    private var failedPipeline: Output<Boolean>? = null

    private var fixedPipeline: Output<Boolean>? = null

    private var issueDue: Output<Boolean>? = null

    private var level: Output<String>? = null

    private var mergeMergeRequest: Output<Boolean>? = null

    private var mergeWhenPipelineSucceeds: Output<Boolean>? = null

    private var movedProject: Output<Boolean>? = null

    private var newIssue: Output<Boolean>? = null

    private var newMergeRequest: Output<Boolean>? = null

    private var newNote: Output<Boolean>? = null

    private var pushToMergeRequest: Output<Boolean>? = null

    private var reassignIssue: Output<Boolean>? = null

    private var reassignMergeRequest: Output<Boolean>? = null

    private var reopenIssue: Output<Boolean>? = null

    private var reopenMergeRequest: Output<Boolean>? = null

    private var successPipeline: Output<Boolean>? = null

    /**
     * @param value Enable notifications for closed issues. Can only be used when `level` is `custom`.
     */
    @JvmName("nootitbdinsimctn")
    public suspend fun closeIssue(`value`: Output<Boolean>) {
        this.closeIssue = value
    }

    /**
     * @param value Enable notifications for closed merge requests. Can only be used when `level` is `custom`.
     */
    @JvmName("cimqsehflwsouflp")
    public suspend fun closeMergeRequest(`value`: Output<Boolean>) {
        this.closeMergeRequest = value
    }

    /**
     * @param value Enable notifications for failed pipelines. Can only be used when `level` is `custom`.
     */
    @JvmName("ryblqfkebormplks")
    public suspend fun failedPipeline(`value`: Output<Boolean>) {
        this.failedPipeline = value
    }

    /**
     * @param value Enable notifications for fixed pipelines. Can only be used when `level` is `custom`.
     */
    @JvmName("vmtmbonwtjuswjyh")
    public suspend fun fixedPipeline(`value`: Output<Boolean>) {
        this.fixedPipeline = value
    }

    /**
     * @param value Enable notifications for due issues. Can only be used when `level` is `custom`.
     */
    @JvmName("funmkblnqcavgmdg")
    public suspend fun issueDue(`value`: Output<Boolean>) {
        this.issueDue = value
    }

    /**
     * @param value The level of the notification. Valid values are: `disabled`, `participating`, `watch`, `global`, `mention`, `custom`.
     */
    @JvmName("uvoynjabvdoxawfa")
    public suspend fun level(`value`: Output<String>) {
        this.level = value
    }

    /**
     * @param value Enable notifications for merged merge requests. Can only be used when `level` is `custom`.
     */
    @JvmName("puaxnsnuyebbliar")
    public suspend fun mergeMergeRequest(`value`: Output<Boolean>) {
        this.mergeMergeRequest = value
    }

    /**
     * @param value Enable notifications for merged merge requests when the pipeline succeeds. Can only be used when `level` is `custom`.
     */
    @JvmName("vokyepmclsejicyq")
    public suspend fun mergeWhenPipelineSucceeds(`value`: Output<Boolean>) {
        this.mergeWhenPipelineSucceeds = value
    }

    /**
     * @param value Enable notifications for moved projects. Can only be used when `level` is `custom`.
     */
    @JvmName("tccmahwbiwylsuwe")
    public suspend fun movedProject(`value`: Output<Boolean>) {
        this.movedProject = value
    }

    /**
     * @param value Enable notifications for new issues. Can only be used when `level` is `custom`.
     */
    @JvmName("euixsmmostpdqjng")
    public suspend fun newIssue(`value`: Output<Boolean>) {
        this.newIssue = value
    }

    /**
     * @param value Enable notifications for new merge requests. Can only be used when `level` is `custom`.
     */
    @JvmName("ylekbsnbiuttocea")
    public suspend fun newMergeRequest(`value`: Output<Boolean>) {
        this.newMergeRequest = value
    }

    /**
     * @param value Enable notifications for new notes on merge requests. Can only be used when `level` is `custom`.
     */
    @JvmName("ggevtpikeasikrxi")
    public suspend fun newNote(`value`: Output<Boolean>) {
        this.newNote = value
    }

    /**
     * @param value Enable notifications for push to merge request branches. Can only be used when `level` is `custom`.
     */
    @JvmName("wgtuxolkaxuysoij")
    public suspend fun pushToMergeRequest(`value`: Output<Boolean>) {
        this.pushToMergeRequest = value
    }

    /**
     * @param value Enable notifications for issue reassignments. Can only be used when `level` is `custom`.
     */
    @JvmName("dnanctfwgwwjocmq")
    public suspend fun reassignIssue(`value`: Output<Boolean>) {
        this.reassignIssue = value
    }

    /**
     * @param value Enable notifications for merge request reassignments. Can only be used when `level` is `custom`.
     */
    @JvmName("gkgonwretxcesmfr")
    public suspend fun reassignMergeRequest(`value`: Output<Boolean>) {
        this.reassignMergeRequest = value
    }

    /**
     * @param value Enable notifications for reopened issues. Can only be used when `level` is `custom`.
     */
    @JvmName("ggjwvymmnqomvjjv")
    public suspend fun reopenIssue(`value`: Output<Boolean>) {
        this.reopenIssue = value
    }

    /**
     * @param value Enable notifications for reopened merge requests. Can only be used when `level` is `custom`.
     */
    @JvmName("ldrdprkaddtvrvlm")
    public suspend fun reopenMergeRequest(`value`: Output<Boolean>) {
        this.reopenMergeRequest = value
    }

    /**
     * @param value Enable notifications for successful pipelines. Can only be used when `level` is `custom`.
     */
    @JvmName("ywfeprqiuywwxdmv")
    public suspend fun successPipeline(`value`: Output<Boolean>) {
        this.successPipeline = value
    }

    /**
     * @param value Enable notifications for closed issues. Can only be used when `level` is `custom`.
     */
    @JvmName("nomyyejkeoegryfx")
    public suspend fun closeIssue(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.closeIssue = mapped
    }

    /**
     * @param value Enable notifications for closed merge requests. Can only be used when `level` is `custom`.
     */
    @JvmName("aniuxxftcettrtle")
    public suspend fun closeMergeRequest(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.closeMergeRequest = mapped
    }

    /**
     * @param value Enable notifications for failed pipelines. Can only be used when `level` is `custom`.
     */
    @JvmName("lewlnwojgaugvkxc")
    public suspend fun failedPipeline(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failedPipeline = mapped
    }

    /**
     * @param value Enable notifications for fixed pipelines. Can only be used when `level` is `custom`.
     */
    @JvmName("ttwseesumogkdvbt")
    public suspend fun fixedPipeline(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fixedPipeline = mapped
    }

    /**
     * @param value Enable notifications for due issues. Can only be used when `level` is `custom`.
     */
    @JvmName("aghjemocmcdhqrmf")
    public suspend fun issueDue(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issueDue = mapped
    }

    /**
     * @param value The level of the notification. Valid values are: `disabled`, `participating`, `watch`, `global`, `mention`, `custom`.
     */
    @JvmName("cfdxsxcgamtqbqmt")
    public suspend fun level(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.level = mapped
    }

    /**
     * @param value Enable notifications for merged merge requests. Can only be used when `level` is `custom`.
     */
    @JvmName("ugpugxcrdcrktcfd")
    public suspend fun mergeMergeRequest(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mergeMergeRequest = mapped
    }

    /**
     * @param value Enable notifications for merged merge requests when the pipeline succeeds. Can only be used when `level` is `custom`.
     */
    @JvmName("xyrxcndqtidbhorq")
    public suspend fun mergeWhenPipelineSucceeds(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mergeWhenPipelineSucceeds = mapped
    }

    /**
     * @param value Enable notifications for moved projects. Can only be used when `level` is `custom`.
     */
    @JvmName("vvtowommqergucqa")
    public suspend fun movedProject(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.movedProject = mapped
    }

    /**
     * @param value Enable notifications for new issues. Can only be used when `level` is `custom`.
     */
    @JvmName("tlbrrlawbfplhanr")
    public suspend fun newIssue(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.newIssue = mapped
    }

    /**
     * @param value Enable notifications for new merge requests. Can only be used when `level` is `custom`.
     */
    @JvmName("pmngpfghusafqclj")
    public suspend fun newMergeRequest(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.newMergeRequest = mapped
    }

    /**
     * @param value Enable notifications for new notes on merge requests. Can only be used when `level` is `custom`.
     */
    @JvmName("gcuonpqwagagcxmb")
    public suspend fun newNote(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.newNote = mapped
    }

    /**
     * @param value Enable notifications for push to merge request branches. Can only be used when `level` is `custom`.
     */
    @JvmName("uqlhvlyrgqjrcqec")
    public suspend fun pushToMergeRequest(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pushToMergeRequest = mapped
    }

    /**
     * @param value Enable notifications for issue reassignments. Can only be used when `level` is `custom`.
     */
    @JvmName("qytpxrlbjwpgvvtp")
    public suspend fun reassignIssue(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reassignIssue = mapped
    }

    /**
     * @param value Enable notifications for merge request reassignments. Can only be used when `level` is `custom`.
     */
    @JvmName("gfkurerqnmudkfhm")
    public suspend fun reassignMergeRequest(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reassignMergeRequest = mapped
    }

    /**
     * @param value Enable notifications for reopened issues. Can only be used when `level` is `custom`.
     */
    @JvmName("epflavocsgkbljvb")
    public suspend fun reopenIssue(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reopenIssue = mapped
    }

    /**
     * @param value Enable notifications for reopened merge requests. Can only be used when `level` is `custom`.
     */
    @JvmName("dpvwkfkvxtljfhft")
    public suspend fun reopenMergeRequest(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reopenMergeRequest = mapped
    }

    /**
     * @param value Enable notifications for successful pipelines. Can only be used when `level` is `custom`.
     */
    @JvmName("puonqrpximyraven")
    public suspend fun successPipeline(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.successPipeline = mapped
    }

    internal fun build(): GlobalLevelNotificationsArgs = GlobalLevelNotificationsArgs(
        closeIssue = closeIssue,
        closeMergeRequest = closeMergeRequest,
        failedPipeline = failedPipeline,
        fixedPipeline = fixedPipeline,
        issueDue = issueDue,
        level = level,
        mergeMergeRequest = mergeMergeRequest,
        mergeWhenPipelineSucceeds = mergeWhenPipelineSucceeds,
        movedProject = movedProject,
        newIssue = newIssue,
        newMergeRequest = newMergeRequest,
        newNote = newNote,
        pushToMergeRequest = pushToMergeRequest,
        reassignIssue = reassignIssue,
        reassignMergeRequest = reassignMergeRequest,
        reopenIssue = reopenIssue,
        reopenMergeRequest = reopenMergeRequest,
        successPipeline = successPipeline,
    )
}
