@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.gitlab.kotlin.outputs.GroupDefaultBranchProtectionDefaults
import com.pulumi.gitlab.kotlin.outputs.GroupPushRules
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.gitlab.kotlin.outputs.GroupDefaultBranchProtectionDefaults.Companion.toKotlin as groupDefaultBranchProtectionDefaultsToKotlin
import com.pulumi.gitlab.kotlin.outputs.GroupPushRules.Companion.toKotlin as groupPushRulesToKotlin

/**
 * Builder for [Group].
 */
@PulumiTagMarker
public class GroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GroupArgs = GroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GroupArgsBuilder.() -> Unit) {
        val builder = GroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Group {
        val builtJavaResource = com.pulumi.gitlab.Group(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Group(builtJavaResource)
    }
}

/**
 * The `gitlab.Group` resource allows to manage the lifecycle of a group.
 * > On GitLab SaaS, you must use the GitLab UI to create groups without a parent group. You cannot use this provider nor the API to do this.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/groups.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const example = new gitlab.Group("example", {
 *     name: "example",
 *     path: "example",
 *     description: "An example group",
 * });
 * // Create a project in the example group
 * const exampleProject = new gitlab.Project("example", {
 *     name: "example",
 *     description: "An example project",
 *     namespaceId: example.id,
 * });
 * // Group with custom push rules
 * const example_two = new gitlab.Group("example-two", {
 *     name: "example-two",
 *     path: "example-two",
 *     description: "An example group with push rules",
 *     pushRules: {
 *         authorEmailRegex: "@example\\.com$",
 *         commitCommitterCheck: true,
 *         memberCheck: true,
 *         preventSecrets: true,
 *     },
 * });
 * // Group with custom default branch protection defaults
 * const example_three = new gitlab.Group("example-three", {
 *     name: "example-three",
 *     path: "example-three",
 *     description: "An example group with default branch protection defaults",
 *     defaultBranchProtectionDefaults: {
 *         allowedToPushes: ["developer"],
 *         allowForcePush: true,
 *         allowedToMerges: [
 *             "developer",
 *             "maintainer",
 *         ],
 *         developerCanInitialPush: true,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * example = gitlab.Group("example",
 *     name="example",
 *     path="example",
 *     description="An example group")
 * # Create a project in the example group
 * example_project = gitlab.Project("example",
 *     name="example",
 *     description="An example project",
 *     namespace_id=example.id)
 * # Group with custom push rules
 * example_two = gitlab.Group("example-two",
 *     name="example-two",
 *     path="example-two",
 *     description="An example group with push rules",
 *     push_rules={
 *         "author_email_regex": "@example\\.com$",
 *         "commit_committer_check": True,
 *         "member_check": True,
 *         "prevent_secrets": True,
 *     })
 * # Group with custom default branch protection defaults
 * example_three = gitlab.Group("example-three",
 *     name="example-three",
 *     path="example-three",
 *     description="An example group with default branch protection defaults",
 *     default_branch_protection_defaults={
 *         "allowed_to_pushes": ["developer"],
 *         "allow_force_push": True,
 *         "allowed_to_merges": [
 *             "developer",
 *             "maintainer",
 *         ],
 *         "developer_can_initial_push": True,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new GitLab.Group("example", new()
 *     {
 *         Name = "example",
 *         Path = "example",
 *         Description = "An example group",
 *     });
 *     // Create a project in the example group
 *     var exampleProject = new GitLab.Project("example", new()
 *     {
 *         Name = "example",
 *         Description = "An example project",
 *         NamespaceId = example.Id,
 *     });
 *     // Group with custom push rules
 *     var example_two = new GitLab.Group("example-two", new()
 *     {
 *         Name = "example-two",
 *         Path = "example-two",
 *         Description = "An example group with push rules",
 *         PushRules = new GitLab.Inputs.GroupPushRulesArgs
 *         {
 *             AuthorEmailRegex = "@example\\.com$",
 *             CommitCommitterCheck = true,
 *             MemberCheck = true,
 *             PreventSecrets = true,
 *         },
 *     });
 *     // Group with custom default branch protection defaults
 *     var example_three = new GitLab.Group("example-three", new()
 *     {
 *         Name = "example-three",
 *         Path = "example-three",
 *         Description = "An example group with default branch protection defaults",
 *         DefaultBranchProtectionDefaults = new GitLab.Inputs.GroupDefaultBranchProtectionDefaultsArgs
 *         {
 *             AllowedToPushes = new[]
 *             {
 *                 "developer",
 *             },
 *             AllowForcePush = true,
 *             AllowedToMerges = new[]
 *             {
 *                 "developer",
 *                 "maintainer",
 *             },
 *             DeveloperCanInitialPush = true,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := gitlab.NewGroup(ctx, "example", &gitlab.GroupArgs{
 * 			Name:        pulumi.String("example"),
 * 			Path:        pulumi.String("example"),
 * 			Description: pulumi.String("An example group"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Create a project in the example group
 * 		_, err = gitlab.NewProject(ctx, "example", &gitlab.ProjectArgs{
 * 			Name:        pulumi.String("example"),
 * 			Description: pulumi.String("An example project"),
 * 			NamespaceId: example.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Group with custom push rules
 * 		_, err = gitlab.NewGroup(ctx, "example-two", &gitlab.GroupArgs{
 * 			Name:        pulumi.String("example-two"),
 * 			Path:        pulumi.String("example-two"),
 * 			Description: pulumi.String("An example group with push rules"),
 * 			PushRules: &gitlab.GroupPushRulesArgs{
 * 				AuthorEmailRegex:     pulumi.String("@example\\.com$"),
 * 				CommitCommitterCheck: pulumi.Bool(true),
 * 				MemberCheck:          pulumi.Bool(true),
 * 				PreventSecrets:       pulumi.Bool(true),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Group with custom default branch protection defaults
 * 		_, err = gitlab.NewGroup(ctx, "example-three", &gitlab.GroupArgs{
 * 			Name:        pulumi.String("example-three"),
 * 			Path:        pulumi.String("example-three"),
 * 			Description: pulumi.String("An example group with default branch protection defaults"),
 * 			DefaultBranchProtectionDefaults: &gitlab.GroupDefaultBranchProtectionDefaultsArgs{
 * 				AllowedToPushes: pulumi.StringArray{
 * 					pulumi.String("developer"),
 * 				},
 * 				AllowForcePush: pulumi.Bool(true),
 * 				AllowedToMerges: pulumi.StringArray{
 * 					pulumi.String("developer"),
 * 					pulumi.String("maintainer"),
 * 				},
 * 				DeveloperCanInitialPush: pulumi.Bool(true),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Group;
 * import com.pulumi.gitlab.GroupArgs;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.inputs.GroupPushRulesArgs;
 * import com.pulumi.gitlab.inputs.GroupDefaultBranchProtectionDefaultsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Group("example", GroupArgs.builder()
 *             .name("example")
 *             .path("example")
 *             .description("An example group")
 *             .build());
 *         // Create a project in the example group
 *         var exampleProject = new Project("exampleProject", ProjectArgs.builder()
 *             .name("example")
 *             .description("An example project")
 *             .namespaceId(example.id())
 *             .build());
 *         // Group with custom push rules
 *         var example_two = new Group("example-two", GroupArgs.builder()
 *             .name("example-two")
 *             .path("example-two")
 *             .description("An example group with push rules")
 *             .pushRules(GroupPushRulesArgs.builder()
 *                 .authorEmailRegex("@example\\.com$")
 *                 .commitCommitterCheck(true)
 *                 .memberCheck(true)
 *                 .preventSecrets(true)
 *                 .build())
 *             .build());
 *         // Group with custom default branch protection defaults
 *         var example_three = new Group("example-three", GroupArgs.builder()
 *             .name("example-three")
 *             .path("example-three")
 *             .description("An example group with default branch protection defaults")
 *             .defaultBranchProtectionDefaults(GroupDefaultBranchProtectionDefaultsArgs.builder()
 *                 .allowedToPushes("developer")
 *                 .allowForcePush(true)
 *                 .allowedToMerges(
 *                     "developer",
 *                     "maintainer")
 *                 .developerCanInitialPush(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: gitlab:Group
 *     properties:
 *       name: example
 *       path: example
 *       description: An example group
 *   # Create a project in the example group
 *   exampleProject:
 *     type: gitlab:Project
 *     name: example
 *     properties:
 *       name: example
 *       description: An example project
 *       namespaceId: ${example.id}
 *   # Group with custom push rules
 *   example-two:
 *     type: gitlab:Group
 *     properties:
 *       name: example-two
 *       path: example-two
 *       description: An example group with push rules
 *       pushRules:
 *         authorEmailRegex: '@example\.com$'
 *         commitCommitterCheck: true
 *         memberCheck: true
 *         preventSecrets: true
 *   # Group with custom default branch protection defaults
 *   example-three:
 *     type: gitlab:Group
 *     properties:
 *       name: example-three
 *       path: example-three
 *       description: An example group with default branch protection defaults
 *       defaultBranchProtectionDefaults:
 *         allowedToPushes:
 *           - developer
 *         allowForcePush: true
 *         allowedToMerges:
 *           - developer
 *           - maintainer
 *         developerCanInitialPush: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * ```sh
 * $ pulumi import gitlab:index/group:Group You can import a group state using `<resource> <id>`. The
 * ```
 * `id` can be whatever the [details of a group][details_of_a_group] api takes for
 * its `:id` value, so for example:
 * ```sh
 * $ pulumi import gitlab:index/group:Group example example
 * ```
 */
public class Group internal constructor(
    override val javaResource: com.pulumi.gitlab.Group,
) : KotlinCustomResource(javaResource, GroupMapper) {
    /**
     * Default to Auto DevOps pipeline for all projects within this group.
     */
    public val autoDevopsEnabled: Output<Boolean>
        get() = javaResource.autoDevopsEnabled().applyValue({ args0 -> args0 })

    /**
     * A local path to the avatar image to upload. **Note**: not available for imported resources.
     */
    public val avatar: Output<String>?
        get() = javaResource.avatar().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The hash of the avatar image. Use `filesha256("path/to/avatar.png")` whenever possible. **Note**: this is used to trigger an update of the avatar. If it's not given, but an avatar is given, the avatar will be updated each time.
     */
    public val avatarHash: Output<String>
        get() = javaResource.avatarHash().applyValue({ args0 -> args0 })

    /**
     * The URL of the avatar image.
     */
    public val avatarUrl: Output<String>
        get() = javaResource.avatarUrl().applyValue({ args0 -> args0 })

    /**
     * See https://docs.gitlab.com/ee/api/groups.html#options-for-default*branch*protection. Valid values are: `0`, `1`, `2`, `3`, `4`.
     */
    @Deprecated(
        message = """
  Deprecated in GitLab 17.0. Use default_branch_protection_defaults instead.
  """,
    )
    public val defaultBranchProtection: Output<Int>
        get() = javaResource.defaultBranchProtection().applyValue({ args0 -> args0 })

    /**
     * The default branch protection defaults
     */
    public val defaultBranchProtectionDefaults: Output<GroupDefaultBranchProtectionDefaults>
        get() = javaResource.defaultBranchProtectionDefaults().applyValue({ args0 ->
            args0.let({ args0 ->
                groupDefaultBranchProtectionDefaultsToKotlin(args0)
            })
        })

    /**
     * The group's description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable email notifications.
     */
    public val emailsEnabled: Output<Boolean>
        get() = javaResource.emailsEnabled().applyValue({ args0 -> args0 })

    /**
     * Can be set by administrators only. Additional CI/CD minutes for this group.
     */
    public val extraSharedRunnersMinutesLimit: Output<Int>
        get() = javaResource.extraSharedRunnersMinutesLimit().applyValue({ args0 -> args0 })

    /**
     * The full name of the group.
     */
    public val fullName: Output<String>
        get() = javaResource.fullName().applyValue({ args0 -> args0 })

    /**
     * The full path of the group.
     */
    public val fullPath: Output<String>
        get() = javaResource.fullPath().applyValue({ args0 -> args0 })

    /**
     * A list of IP addresses or subnet masks to restrict group access. Will be concatenated together into a comma separated string. Only allowed on top level groups.
     */
    public val ipRestrictionRanges: Output<List<String>>?
        get() = javaResource.ipRestrictionRanges().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Enable/disable Large File Storage (LFS) for the projects in this group.
     */
    public val lfsEnabled: Output<Boolean>
        get() = javaResource.lfsEnabled().applyValue({ args0 -> args0 })

    /**
     * Users cannot be added to projects in this group.
     */
    public val membershipLock: Output<Boolean>?
        get() = javaResource.membershipLock().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Disable the capability of a group from getting mentioned.
     */
    public val mentionsDisabled: Output<Boolean>
        get() = javaResource.mentionsDisabled().applyValue({ args0 -> args0 })

    /**
     * The name of the group.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Id of the parent group (creates a nested group).
     */
    public val parentId: Output<Int>
        get() = javaResource.parentId().applyValue({ args0 -> args0 })

    /**
     * The path of the group.
     */
    public val path: Output<String>
        get() = javaResource.path().applyValue({ args0 -> args0 })

    /**
     * Whether the group should be permanently removed during a `delete` operation. This only works with subgroups. Must be configured via an `apply` before the `destroy` is run.
     */
    public val permanentlyRemoveOnDelete: Output<Boolean>?
        get() = javaResource.permanentlyRemoveOnDelete().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Defaults to false. When enabled, users can not fork projects from this group to external namespaces.
     */
    public val preventForkingOutsideGroup: Output<Boolean>
        get() = javaResource.preventForkingOutsideGroup().applyValue({ args0 -> args0 })

    /**
     * Determine if developers can create projects in the group. Valid values are: `noone`, `maintainer`, `developer`
     */
    public val projectCreationLevel: Output<String>
        get() = javaResource.projectCreationLevel().applyValue({ args0 -> args0 })

    /**
     * Push rules for the group.
     */
    public val pushRules: Output<GroupPushRules>
        get() = javaResource.pushRules().applyValue({ args0 ->
            args0.let({ args0 ->
                groupPushRulesToKotlin(args0)
            })
        })

    /**
     * Allow users to request member access.
     */
    public val requestAccessEnabled: Output<Boolean>
        get() = javaResource.requestAccessEnabled().applyValue({ args0 -> args0 })

    /**
     * Require all users in this group to setup Two-factor authentication.
     */
    public val requireTwoFactorAuthentication: Output<Boolean>
        get() = javaResource.requireTwoFactorAuthentication().applyValue({ args0 -> args0 })

    /**
     * The group level registration token to use during runner setup.
     */
    public val runnersToken: Output<String>
        get() = javaResource.runnersToken().applyValue({ args0 -> args0 })

    /**
     * Prevent sharing a project with another group within this group.
     */
    public val shareWithGroupLock: Output<Boolean>
        get() = javaResource.shareWithGroupLock().applyValue({ args0 -> args0 })

    /**
     * Can be set by administrators only. Maximum number of monthly CI/CD minutes for this group. Can be nil (default; inherit system default), 0 (unlimited), or > 0.
     */
    public val sharedRunnersMinutesLimit: Output<Int>
        get() = javaResource.sharedRunnersMinutesLimit().applyValue({ args0 -> args0 })

    /**
     * Enable or disable shared runners for a group’s subgroups and projects. Valid values are: `enabled`, `disabled_and_overridable`, `disabled_and_unoverridable`, `disabled_with_override`.
     */
    public val sharedRunnersSetting: Output<String>
        get() = javaResource.sharedRunnersSetting().applyValue({ args0 -> args0 })

    /**
     * Allowed to create subgroups. Valid values are: `owner`, `maintainer`.
     */
    public val subgroupCreationLevel: Output<String>
        get() = javaResource.subgroupCreationLevel().applyValue({ args0 -> args0 })

    /**
     * Defaults to 48. Time before Two-factor authentication is enforced (in hours).
     */
    public val twoFactorGracePeriod: Output<Int>
        get() = javaResource.twoFactorGracePeriod().applyValue({ args0 -> args0 })

    /**
     * The group's visibility. Can be `private`, `internal`, or `public`. Valid values are: `private`, `internal`, `public`.
     */
    public val visibilityLevel: Output<String>
        get() = javaResource.visibilityLevel().applyValue({ args0 -> args0 })

    /**
     * Web URL of the group.
     */
    public val webUrl: Output<String>
        get() = javaResource.webUrl().applyValue({ args0 -> args0 })

    /**
     * The group's wiki access level. Only available on Premium and Ultimate plans. Valid values are `disabled`, `private`, `enabled`.
     */
    public val wikiAccessLevel: Output<String>
        get() = javaResource.wikiAccessLevel().applyValue({ args0 -> args0 })
}

public object GroupMapper : ResourceMapper<Group> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.Group::class == javaResource::class

    override fun map(javaResource: Resource): Group = Group(javaResource as com.pulumi.gitlab.Group)
}

/**
 * @see [Group].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Group].
 */
public suspend fun group(name: String, block: suspend GroupResourceBuilder.() -> Unit): Group {
    val builder = GroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Group].
 * @param name The _unique_ name of the resulting resource.
 */
public fun group(name: String): Group {
    val builder = GroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
