@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.gitlab.kotlin.outputs.GroupAccessTokenRotationConfiguration
import com.pulumi.gitlab.kotlin.outputs.GroupAccessTokenRotationConfiguration.Companion.toKotlin
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [GroupAccessToken].
 */
@PulumiTagMarker
public class GroupAccessTokenResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GroupAccessTokenArgs = GroupAccessTokenArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GroupAccessTokenArgsBuilder.() -> Unit) {
        val builder = GroupAccessTokenArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GroupAccessToken {
        val builtJavaResource = com.pulumi.gitlab.GroupAccessToken(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GroupAccessToken(builtJavaResource)
    }
}

/**
 * The `gitlab.GroupAccessToken` resource allows to manage the lifecycle of a group access token.
 * > Observability scopes are in beta and may not work on all instances. See more details in [the documentation](https://docs.gitlab.com/ee/operations/tracing.html)
 * > Use `rotation_configuration` to automatically rotate tokens instead of using `timestamp()` as timestamp will cause changes with every plan. `pulumi up` must still be run to rotate the token.
 * > Due to [Automatic reuse detection](https://docs.gitlab.com/ee/api/group_access_tokens.html#automatic-reuse-detection) it's possible that a new Group Access Token will immediately be revoked. Check if an old process using the old token is running if this happens.
 * **Upstream API**: [GitLab REST API](https://docs.gitlab.com/ee/api/group_access_tokens.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const example = new gitlab.GroupAccessToken("example", {
 *     group: "25",
 *     name: "Example group access token",
 *     expiresAt: "2020-03-14",
 *     accessLevel: "developer",
 *     scopes: ["api"],
 * });
 * const exampleGroupVariable = new gitlab.GroupVariable("example", {
 *     group: "25",
 *     key: "gat",
 *     value: example.token,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * example = gitlab.GroupAccessToken("example",
 *     group="25",
 *     name="Example group access token",
 *     expires_at="2020-03-14",
 *     access_level="developer",
 *     scopes=["api"])
 * example_group_variable = gitlab.GroupVariable("example",
 *     group="25",
 *     key="gat",
 *     value=example.token)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new GitLab.GroupAccessToken("example", new()
 *     {
 *         Group = "25",
 *         Name = "Example group access token",
 *         ExpiresAt = "2020-03-14",
 *         AccessLevel = "developer",
 *         Scopes = new[]
 *         {
 *             "api",
 *         },
 *     });
 *     var exampleGroupVariable = new GitLab.GroupVariable("example", new()
 *     {
 *         Group = "25",
 *         Key = "gat",
 *         Value = example.Token,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := gitlab.NewGroupAccessToken(ctx, "example", &gitlab.GroupAccessTokenArgs{
 * 			Group:       pulumi.String("25"),
 * 			Name:        pulumi.String("Example group access token"),
 * 			ExpiresAt:   pulumi.String("2020-03-14"),
 * 			AccessLevel: pulumi.String("developer"),
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("api"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewGroupVariable(ctx, "example", &gitlab.GroupVariableArgs{
 * 			Group: pulumi.String("25"),
 * 			Key:   pulumi.String("gat"),
 * 			Value: example.Token,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.GroupAccessToken;
 * import com.pulumi.gitlab.GroupAccessTokenArgs;
 * import com.pulumi.gitlab.GroupVariable;
 * import com.pulumi.gitlab.GroupVariableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GroupAccessToken("example", GroupAccessTokenArgs.builder()
 *             .group("25")
 *             .name("Example group access token")
 *             .expiresAt("2020-03-14")
 *             .accessLevel("developer")
 *             .scopes("api")
 *             .build());
 *         var exampleGroupVariable = new GroupVariable("exampleGroupVariable", GroupVariableArgs.builder()
 *             .group("25")
 *             .key("gat")
 *             .value(example.token())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: gitlab:GroupAccessToken
 *     properties:
 *       group: '25'
 *       name: Example group access token
 *       expiresAt: 2020-03-14
 *       accessLevel: developer
 *       scopes:
 *         - api
 *   exampleGroupVariable:
 *     type: gitlab:GroupVariable
 *     name: example
 *     properties:
 *       group: '25'
 *       key: gat
 *       value: ${example.token}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * A GitLab Group Access Token can be imported using a key composed of `<group-id>:<token-id>`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/groupAccessToken:GroupAccessToken example "12345:1"
 * ```
 * ATTENTION: the `token` resource attribute is not available for imported resources as this information cannot be read from the GitLab API.
 */
public class GroupAccessToken internal constructor(
    override val javaResource: com.pulumi.gitlab.GroupAccessToken,
) : KotlinCustomResource(javaResource, GroupAccessTokenMapper) {
    /**
     * The access level for the group access token. Valid values are: `no one`, `minimal`, `guest`, `reporter`, `developer`, `maintainer`, `owner`. Default is `maintainer`.
     */
    public val accessLevel: Output<String>
        get() = javaResource.accessLevel().applyValue({ args0 -> args0 })

    /**
     * True if the token is active.
     */
    public val active: Output<Boolean>
        get() = javaResource.active().applyValue({ args0 -> args0 })

    /**
     * Time the token has been created, RFC3339 format.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * When the token will expire, YYYY-MM-DD format.
     */
    public val expiresAt: Output<String>
        get() = javaResource.expiresAt().applyValue({ args0 -> args0 })

    /**
     * The ID or full path of the group.
     */
    public val group: Output<String>
        get() = javaResource.group().applyValue({ args0 -> args0 })

    /**
     * The name of the group access token.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * True if the token is revoked.
     */
    public val revoked: Output<Boolean>
        get() = javaResource.revoked().applyValue({ args0 -> args0 })

    /**
     * The configuration for when to rotate a token automatically. Will not rotate a token until `pulumi up` is run.
     */
    public val rotationConfiguration: Output<GroupAccessTokenRotationConfiguration>?
        get() = javaResource.rotationConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The scopes of the group access token. Valid values are: `api`, `read_api`, `read_registry`, `write_registry`, `read_repository`, `write_repository`, `create_runner`, `manage_runner`, `ai_features`, `k8s_proxy`, `read_observability`, `write_observability`
     */
    public val scopes: Output<List<String>>
        get() = javaResource.scopes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The token of the group access token. **Note**: the token is not available for imported resources.
     */
    public val token: Output<String>
        get() = javaResource.token().applyValue({ args0 -> args0 })

    /**
     * The user_id associated to the token.
     */
    public val userId: Output<Int>
        get() = javaResource.userId().applyValue({ args0 -> args0 })
}

public object GroupAccessTokenMapper : ResourceMapper<GroupAccessToken> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.GroupAccessToken::class == javaResource::class

    override fun map(javaResource: Resource): GroupAccessToken = GroupAccessToken(
        javaResource as
            com.pulumi.gitlab.GroupAccessToken,
    )
}

/**
 * @see [GroupAccessToken].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GroupAccessToken].
 */
public suspend fun groupAccessToken(
    name: String,
    block: suspend GroupAccessTokenResourceBuilder.() -> Unit,
): GroupAccessToken {
    val builder = GroupAccessTokenResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GroupAccessToken].
 * @param name The _unique_ name of the resulting resource.
 */
public fun groupAccessToken(name: String): GroupAccessToken {
    val builder = GroupAccessTokenResourceBuilder()
    builder.name(name)
    return builder.build()
}
