@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.GroupAccessTokenArgs.builder
import com.pulumi.gitlab.kotlin.inputs.GroupAccessTokenRotationConfigurationArgs
import com.pulumi.gitlab.kotlin.inputs.GroupAccessTokenRotationConfigurationArgsBuilder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The `gitlab.GroupAccessToken` resource allows to manage the lifecycle of a group access token.
 * > Observability scopes are in beta and may not work on all instances. See more details in [the documentation](https://docs.gitlab.com/ee/operations/tracing.html)
 * > Use `rotation_configuration` to automatically rotate tokens instead of using `timestamp()` as timestamp will cause changes with every plan. `pulumi up` must still be run to rotate the token.
 * > Due to [Automatic reuse detection](https://docs.gitlab.com/ee/api/group_access_tokens.html#automatic-reuse-detection) it's possible that a new Group Access Token will immediately be revoked. Check if an old process using the old token is running if this happens.
 * **Upstream API**: [GitLab REST API](https://docs.gitlab.com/ee/api/group_access_tokens.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const example = new gitlab.GroupAccessToken("example", {
 *     group: "25",
 *     name: "Example group access token",
 *     expiresAt: "2020-03-14",
 *     accessLevel: "developer",
 *     scopes: ["api"],
 * });
 * const exampleGroupVariable = new gitlab.GroupVariable("example", {
 *     group: "25",
 *     key: "gat",
 *     value: example.token,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * example = gitlab.GroupAccessToken("example",
 *     group="25",
 *     name="Example group access token",
 *     expires_at="2020-03-14",
 *     access_level="developer",
 *     scopes=["api"])
 * example_group_variable = gitlab.GroupVariable("example",
 *     group="25",
 *     key="gat",
 *     value=example.token)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new GitLab.GroupAccessToken("example", new()
 *     {
 *         Group = "25",
 *         Name = "Example group access token",
 *         ExpiresAt = "2020-03-14",
 *         AccessLevel = "developer",
 *         Scopes = new[]
 *         {
 *             "api",
 *         },
 *     });
 *     var exampleGroupVariable = new GitLab.GroupVariable("example", new()
 *     {
 *         Group = "25",
 *         Key = "gat",
 *         Value = example.Token,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := gitlab.NewGroupAccessToken(ctx, "example", &gitlab.GroupAccessTokenArgs{
 * 			Group:       pulumi.String("25"),
 * 			Name:        pulumi.String("Example group access token"),
 * 			ExpiresAt:   pulumi.String("2020-03-14"),
 * 			AccessLevel: pulumi.String("developer"),
 * 			Scopes: pulumi.StringArray{
 * 				pulumi.String("api"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewGroupVariable(ctx, "example", &gitlab.GroupVariableArgs{
 * 			Group: pulumi.String("25"),
 * 			Key:   pulumi.String("gat"),
 * 			Value: example.Token,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.GroupAccessToken;
 * import com.pulumi.gitlab.GroupAccessTokenArgs;
 * import com.pulumi.gitlab.GroupVariable;
 * import com.pulumi.gitlab.GroupVariableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GroupAccessToken("example", GroupAccessTokenArgs.builder()
 *             .group("25")
 *             .name("Example group access token")
 *             .expiresAt("2020-03-14")
 *             .accessLevel("developer")
 *             .scopes("api")
 *             .build());
 *         var exampleGroupVariable = new GroupVariable("exampleGroupVariable", GroupVariableArgs.builder()
 *             .group("25")
 *             .key("gat")
 *             .value(example.token())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: gitlab:GroupAccessToken
 *     properties:
 *       group: '25'
 *       name: Example group access token
 *       expiresAt: 2020-03-14
 *       accessLevel: developer
 *       scopes:
 *         - api
 *   exampleGroupVariable:
 *     type: gitlab:GroupVariable
 *     name: example
 *     properties:
 *       group: '25'
 *       key: gat
 *       value: ${example.token}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * A GitLab Group Access Token can be imported using a key composed of `<group-id>:<token-id>`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/groupAccessToken:GroupAccessToken example "12345:1"
 * ```
 * ATTENTION: the `token` resource attribute is not available for imported resources as this information cannot be read from the GitLab API.
 * @property accessLevel The access level for the group access token. Valid values are: `no one`, `minimal`, `guest`, `reporter`, `developer`, `maintainer`, `owner`. Default is `maintainer`.
 * @property expiresAt When the token will expire, YYYY-MM-DD format.
 * @property group The ID or full path of the group.
 * @property name The name of the group access token.
 * @property rotationConfiguration The configuration for when to rotate a token automatically. Will not rotate a token until `pulumi up` is run.
 * @property scopes The scopes of the group access token. Valid values are: `api`, `read_api`, `read_registry`, `write_registry`, `read_repository`, `write_repository`, `create_runner`, `manage_runner`, `ai_features`, `k8s_proxy`, `read_observability`, `write_observability`
 */
public data class GroupAccessTokenArgs(
    public val accessLevel: Output<String>? = null,
    public val expiresAt: Output<String>? = null,
    public val group: Output<String>? = null,
    public val name: Output<String>? = null,
    public val rotationConfiguration: Output<GroupAccessTokenRotationConfigurationArgs>? = null,
    public val scopes: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.GroupAccessTokenArgs> {
    override fun toJava(): com.pulumi.gitlab.GroupAccessTokenArgs =
        com.pulumi.gitlab.GroupAccessTokenArgs.builder()
            .accessLevel(accessLevel?.applyValue({ args0 -> args0 }))
            .expiresAt(expiresAt?.applyValue({ args0 -> args0 }))
            .group(group?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .rotationConfiguration(
                rotationConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .scopes(scopes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GroupAccessTokenArgs].
 */
@PulumiTagMarker
public class GroupAccessTokenArgsBuilder internal constructor() {
    private var accessLevel: Output<String>? = null

    private var expiresAt: Output<String>? = null

    private var group: Output<String>? = null

    private var name: Output<String>? = null

    private var rotationConfiguration: Output<GroupAccessTokenRotationConfigurationArgs>? = null

    private var scopes: Output<List<String>>? = null

    /**
     * @param value The access level for the group access token. Valid values are: `no one`, `minimal`, `guest`, `reporter`, `developer`, `maintainer`, `owner`. Default is `maintainer`.
     */
    @JvmName("pvkjoktfyhlrxkxa")
    public suspend fun accessLevel(`value`: Output<String>) {
        this.accessLevel = value
    }

    /**
     * @param value When the token will expire, YYYY-MM-DD format.
     */
    @JvmName("ntfsnwrpvxhtyrhs")
    public suspend fun expiresAt(`value`: Output<String>) {
        this.expiresAt = value
    }

    /**
     * @param value The ID or full path of the group.
     */
    @JvmName("xmtocgkqnuuncwml")
    public suspend fun group(`value`: Output<String>) {
        this.group = value
    }

    /**
     * @param value The name of the group access token.
     */
    @JvmName("mwrkgfatakweuwdy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The configuration for when to rotate a token automatically. Will not rotate a token until `pulumi up` is run.
     */
    @JvmName("bxdccrloqavexrpr")
    public suspend fun rotationConfiguration(`value`: Output<GroupAccessTokenRotationConfigurationArgs>) {
        this.rotationConfiguration = value
    }

    /**
     * @param value The scopes of the group access token. Valid values are: `api`, `read_api`, `read_registry`, `write_registry`, `read_repository`, `write_repository`, `create_runner`, `manage_runner`, `ai_features`, `k8s_proxy`, `read_observability`, `write_observability`
     */
    @JvmName("iiucqpxluyioruub")
    public suspend fun scopes(`value`: Output<List<String>>) {
        this.scopes = value
    }

    @JvmName("gigqsucxtkowggxv")
    public suspend fun scopes(vararg values: Output<String>) {
        this.scopes = Output.all(values.asList())
    }

    /**
     * @param values The scopes of the group access token. Valid values are: `api`, `read_api`, `read_registry`, `write_registry`, `read_repository`, `write_repository`, `create_runner`, `manage_runner`, `ai_features`, `k8s_proxy`, `read_observability`, `write_observability`
     */
    @JvmName("wcdokrqqdntsebcq")
    public suspend fun scopes(values: List<Output<String>>) {
        this.scopes = Output.all(values)
    }

    /**
     * @param value The access level for the group access token. Valid values are: `no one`, `minimal`, `guest`, `reporter`, `developer`, `maintainer`, `owner`. Default is `maintainer`.
     */
    @JvmName("yjqrbdusqcblcpku")
    public suspend fun accessLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessLevel = mapped
    }

    /**
     * @param value When the token will expire, YYYY-MM-DD format.
     */
    @JvmName("ppearguajvpxxfod")
    public suspend fun expiresAt(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiresAt = mapped
    }

    /**
     * @param value The ID or full path of the group.
     */
    @JvmName("trtagxnsfwaqtueo")
    public suspend fun group(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.group = mapped
    }

    /**
     * @param value The name of the group access token.
     */
    @JvmName("vmfncolhxjitlngr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The configuration for when to rotate a token automatically. Will not rotate a token until `pulumi up` is run.
     */
    @JvmName("wpmjogqjxtlltfsw")
    public suspend fun rotationConfiguration(`value`: GroupAccessTokenRotationConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rotationConfiguration = mapped
    }

    /**
     * @param argument The configuration for when to rotate a token automatically. Will not rotate a token until `pulumi up` is run.
     */
    @JvmName("kdkrpcvfrbyhspme")
    public suspend fun rotationConfiguration(argument: suspend GroupAccessTokenRotationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = GroupAccessTokenRotationConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.rotationConfiguration = mapped
    }

    /**
     * @param value The scopes of the group access token. Valid values are: `api`, `read_api`, `read_registry`, `write_registry`, `read_repository`, `write_repository`, `create_runner`, `manage_runner`, `ai_features`, `k8s_proxy`, `read_observability`, `write_observability`
     */
    @JvmName("itdidesgpdtleixb")
    public suspend fun scopes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    /**
     * @param values The scopes of the group access token. Valid values are: `api`, `read_api`, `read_registry`, `write_registry`, `read_repository`, `write_repository`, `create_runner`, `manage_runner`, `ai_features`, `k8s_proxy`, `read_observability`, `write_observability`
     */
    @JvmName("amwfdtqjfqjkfeup")
    public suspend fun scopes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scopes = mapped
    }

    internal fun build(): GroupAccessTokenArgs = GroupAccessTokenArgs(
        accessLevel = accessLevel,
        expiresAt = expiresAt,
        group = group,
        name = name,
        rotationConfiguration = rotationConfiguration,
        scopes = scopes,
    )
}
