@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [GroupBadge].
 */
@PulumiTagMarker
public class GroupBadgeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GroupBadgeArgs = GroupBadgeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GroupBadgeArgsBuilder.() -> Unit) {
        val builder = GroupBadgeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GroupBadge {
        val builtJavaResource = com.pulumi.gitlab.GroupBadge(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GroupBadge(builtJavaResource)
    }
}

/**
 * The `gitlab.GroupBadge` resource allows to manage the lifecycle of group badges.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/user/project/badges.html#group-badges)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const foo = new gitlab.Group("foo", {name: "foo-group"});
 * const example = new gitlab.GroupBadge("example", {
 *     group: foo.id,
 *     linkUrl: "https://example.com/badge-123",
 *     imageUrl: "https://example.com/badge-123.svg",
 * });
 * // Pipeline status badges with placeholders will be enabled for each project
 * const gitlabPipeline = new gitlab.GroupBadge("gitlab_pipeline", {
 *     group: foo.id,
 *     linkUrl: "https://gitlab.example.com/%{project_path}/-/pipelines?ref=%{default_branch}",
 *     imageUrl: "https://gitlab.example.com/%{project_path}/badges/%{default_branch}/pipeline.svg",
 * });
 * // Test coverage report badges with placeholders will be enabled for each project
 * const gitlabCoverage = new gitlab.GroupBadge("gitlab_coverage", {
 *     group: foo.id,
 *     linkUrl: "https://gitlab.example.com/%{project_path}/-/jobs",
 *     imageUrl: "https://gitlab.example.com/%{project_path}/badges/%{default_branch}/coverage.svg",
 * });
 * // Latest release badges with placeholders will be enabled for each project
 * const gitlabRelease = new gitlab.GroupBadge("gitlab_release", {
 *     group: foo.id,
 *     linkUrl: "https://gitlab.example.com/%{project_path}/-/releases",
 *     imageUrl: "https://gitlab.example.com/%{project_path}/-/badges/release.svg",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * foo = gitlab.Group("foo", name="foo-group")
 * example = gitlab.GroupBadge("example",
 *     group=foo.id,
 *     link_url="https://example.com/badge-123",
 *     image_url="https://example.com/badge-123.svg")
 * # Pipeline status badges with placeholders will be enabled for each project
 * gitlab_pipeline = gitlab.GroupBadge("gitlab_pipeline",
 *     group=foo.id,
 *     link_url="https://gitlab.example.com/%{project_path}/-/pipelines?ref=%{default_branch}",
 *     image_url="https://gitlab.example.com/%{project_path}/badges/%{default_branch}/pipeline.svg")
 * # Test coverage report badges with placeholders will be enabled for each project
 * gitlab_coverage = gitlab.GroupBadge("gitlab_coverage",
 *     group=foo.id,
 *     link_url="https://gitlab.example.com/%{project_path}/-/jobs",
 *     image_url="https://gitlab.example.com/%{project_path}/badges/%{default_branch}/coverage.svg")
 * # Latest release badges with placeholders will be enabled for each project
 * gitlab_release = gitlab.GroupBadge("gitlab_release",
 *     group=foo.id,
 *     link_url="https://gitlab.example.com/%{project_path}/-/releases",
 *     image_url="https://gitlab.example.com/%{project_path}/-/badges/release.svg")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new GitLab.Group("foo", new()
 *     {
 *         Name = "foo-group",
 *     });
 *     var example = new GitLab.GroupBadge("example", new()
 *     {
 *         Group = foo.Id,
 *         LinkUrl = "https://example.com/badge-123",
 *         ImageUrl = "https://example.com/badge-123.svg",
 *     });
 *     // Pipeline status badges with placeholders will be enabled for each project
 *     var gitlabPipeline = new GitLab.GroupBadge("gitlab_pipeline", new()
 *     {
 *         Group = foo.Id,
 *         LinkUrl = "https://gitlab.example.com/%{project_path}/-/pipelines?ref=%{default_branch}",
 *         ImageUrl = "https://gitlab.example.com/%{project_path}/badges/%{default_branch}/pipeline.svg",
 *     });
 *     // Test coverage report badges with placeholders will be enabled for each project
 *     var gitlabCoverage = new GitLab.GroupBadge("gitlab_coverage", new()
 *     {
 *         Group = foo.Id,
 *         LinkUrl = "https://gitlab.example.com/%{project_path}/-/jobs",
 *         ImageUrl = "https://gitlab.example.com/%{project_path}/badges/%{default_branch}/coverage.svg",
 *     });
 *     // Latest release badges with placeholders will be enabled for each project
 *     var gitlabRelease = new GitLab.GroupBadge("gitlab_release", new()
 *     {
 *         Group = foo.Id,
 *         LinkUrl = "https://gitlab.example.com/%{project_path}/-/releases",
 *         ImageUrl = "https://gitlab.example.com/%{project_path}/-/badges/release.svg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		foo, err := gitlab.NewGroup(ctx, "foo", &gitlab.GroupArgs{
 * 			Name: pulumi.String("foo-group"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewGroupBadge(ctx, "example", &gitlab.GroupBadgeArgs{
 * 			Group:    foo.ID(),
 * 			LinkUrl:  pulumi.String("https://example.com/badge-123"),
 * 			ImageUrl: pulumi.String("https://example.com/badge-123.svg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Pipeline status badges with placeholders will be enabled for each project
 * 		_, err = gitlab.NewGroupBadge(ctx, "gitlab_pipeline", &gitlab.GroupBadgeArgs{
 * 			Group:    foo.ID(),
 * 			LinkUrl:  pulumi.String("https://gitlab.example.com/%{project_path}/-/pipelines?ref=%{default_branch}"),
 * 			ImageUrl: pulumi.String("https://gitlab.example.com/%{project_path}/badges/%{default_branch}/pipeline.svg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Test coverage report badges with placeholders will be enabled for each project
 * 		_, err = gitlab.NewGroupBadge(ctx, "gitlab_coverage", &gitlab.GroupBadgeArgs{
 * 			Group:    foo.ID(),
 * 			LinkUrl:  pulumi.String("https://gitlab.example.com/%{project_path}/-/jobs"),
 * 			ImageUrl: pulumi.String("https://gitlab.example.com/%{project_path}/badges/%{default_branch}/coverage.svg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Latest release badges with placeholders will be enabled for each project
 * 		_, err = gitlab.NewGroupBadge(ctx, "gitlab_release", &gitlab.GroupBadgeArgs{
 * 			Group:    foo.ID(),
 * 			LinkUrl:  pulumi.String("https://gitlab.example.com/%{project_path}/-/releases"),
 * 			ImageUrl: pulumi.String("https://gitlab.example.com/%{project_path}/-/badges/release.svg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Group;
 * import com.pulumi.gitlab.GroupArgs;
 * import com.pulumi.gitlab.GroupBadge;
 * import com.pulumi.gitlab.GroupBadgeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Group("foo", GroupArgs.builder()
 *             .name("foo-group")
 *             .build());
 *         var example = new GroupBadge("example", GroupBadgeArgs.builder()
 *             .group(foo.id())
 *             .linkUrl("https://example.com/badge-123")
 *             .imageUrl("https://example.com/badge-123.svg")
 *             .build());
 *         // Pipeline status badges with placeholders will be enabled for each project
 *         var gitlabPipeline = new GroupBadge("gitlabPipeline", GroupBadgeArgs.builder()
 *             .group(foo.id())
 *             .linkUrl("https://gitlab.example.com/%{project_path}/-/pipelines?ref=%{default_branch}")
 *             .imageUrl("https://gitlab.example.com/%{project_path}/badges/%{default_branch}/pipeline.svg")
 *             .build());
 *         // Test coverage report badges with placeholders will be enabled for each project
 *         var gitlabCoverage = new GroupBadge("gitlabCoverage", GroupBadgeArgs.builder()
 *             .group(foo.id())
 *             .linkUrl("https://gitlab.example.com/%{project_path}/-/jobs")
 *             .imageUrl("https://gitlab.example.com/%{project_path}/badges/%{default_branch}/coverage.svg")
 *             .build());
 *         // Latest release badges with placeholders will be enabled for each project
 *         var gitlabRelease = new GroupBadge("gitlabRelease", GroupBadgeArgs.builder()
 *             .group(foo.id())
 *             .linkUrl("https://gitlab.example.com/%{project_path}/-/releases")
 *             .imageUrl("https://gitlab.example.com/%{project_path}/-/badges/release.svg")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: gitlab:Group
 *     properties:
 *       name: foo-group
 *   example:
 *     type: gitlab:GroupBadge
 *     properties:
 *       group: ${foo.id}
 *       linkUrl: https://example.com/badge-123
 *       imageUrl: https://example.com/badge-123.svg
 *   # Pipeline status badges with placeholders will be enabled for each project
 *   gitlabPipeline:
 *     type: gitlab:GroupBadge
 *     name: gitlab_pipeline
 *     properties:
 *       group: ${foo.id}
 *       linkUrl: https://gitlab.example.com/%{project_path}/-/pipelines?ref=%{default_branch}
 *       imageUrl: https://gitlab.example.com/%{project_path}/badges/%{default_branch}/pipeline.svg
 *   # Test coverage report badges with placeholders will be enabled for each project
 *   gitlabCoverage:
 *     type: gitlab:GroupBadge
 *     name: gitlab_coverage
 *     properties:
 *       group: ${foo.id}
 *       linkUrl: https://gitlab.example.com/%{project_path}/-/jobs
 *       imageUrl: https://gitlab.example.com/%{project_path}/badges/%{default_branch}/coverage.svg
 *   # Latest release badges with placeholders will be enabled for each project
 *   gitlabRelease:
 *     type: gitlab:GroupBadge
 *     name: gitlab_release
 *     properties:
 *       group: ${foo.id}
 *       linkUrl: https://gitlab.example.com/%{project_path}/-/releases
 *       imageUrl: https://gitlab.example.com/%{project_path}/-/badges/release.svg
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab group badges can be imported using an id made up of `{group_id}:{badge_id}`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/groupBadge:GroupBadge foo 1:3
 * ```
 */
public class GroupBadge internal constructor(
    override val javaResource: com.pulumi.gitlab.GroupBadge,
) : KotlinCustomResource(javaResource, GroupBadgeMapper) {
    /**
     * The id of the group to add the badge to.
     */
    public val group: Output<String>
        get() = javaResource.group().applyValue({ args0 -> args0 })

    /**
     * The image url which will be presented on group overview.
     */
    public val imageUrl: Output<String>
        get() = javaResource.imageUrl().applyValue({ args0 -> args0 })

    /**
     * The url linked with the badge.
     */
    public val linkUrl: Output<String>
        get() = javaResource.linkUrl().applyValue({ args0 -> args0 })

    /**
     * The name of the badge.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The image_url argument rendered (in case of use of placeholders).
     */
    public val renderedImageUrl: Output<String>
        get() = javaResource.renderedImageUrl().applyValue({ args0 -> args0 })

    /**
     * The link_url argument rendered (in case of use of placeholders).
     */
    public val renderedLinkUrl: Output<String>
        get() = javaResource.renderedLinkUrl().applyValue({ args0 -> args0 })
}

public object GroupBadgeMapper : ResourceMapper<GroupBadge> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.GroupBadge::class == javaResource::class

    override fun map(javaResource: Resource): GroupBadge = GroupBadge(
        javaResource as
            com.pulumi.gitlab.GroupBadge,
    )
}

/**
 * @see [GroupBadge].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GroupBadge].
 */
public suspend fun groupBadge(name: String, block: suspend GroupBadgeResourceBuilder.() -> Unit): GroupBadge {
    val builder = GroupBadgeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GroupBadge].
 * @param name The _unique_ name of the resulting resource.
 */
public fun groupBadge(name: String): GroupBadge {
    val builder = GroupBadgeResourceBuilder()
    builder.name(name)
    return builder.build()
}
