@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [GroupCluster].
 */
@PulumiTagMarker
public class GroupClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GroupClusterArgs = GroupClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GroupClusterArgsBuilder.() -> Unit) {
        val builder = GroupClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GroupCluster {
        val builtJavaResource = com.pulumi.gitlab.GroupCluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GroupCluster(builtJavaResource)
    }
}

/**
 * The `gitlab.GroupCluster` resource allows to manage the lifecycle of a group cluster.
 * > This is deprecated GitLab feature since 14.5
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/group_clusters.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const foo = new gitlab.Group("foo", {
 *     name: "foo-group",
 *     path: "foo-path",
 * });
 * const bar = new gitlab.GroupCluster("bar", {
 *     group: foo.id,
 *     name: "bar-cluster",
 *     domain: "example.com",
 *     enabled: true,
 *     kubernetesApiUrl: "https://124.124.124",
 *     kubernetesToken: "some-token",
 *     kubernetesCaCert: "some-cert",
 *     kubernetesAuthorizationType: "rbac",
 *     environmentScope: "*",
 *     managementProjectId: "123456",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * foo = gitlab.Group("foo",
 *     name="foo-group",
 *     path="foo-path")
 * bar = gitlab.GroupCluster("bar",
 *     group=foo.id,
 *     name="bar-cluster",
 *     domain="example.com",
 *     enabled=True,
 *     kubernetes_api_url="https://124.124.124",
 *     kubernetes_token="some-token",
 *     kubernetes_ca_cert="some-cert",
 *     kubernetes_authorization_type="rbac",
 *     environment_scope="*",
 *     management_project_id="123456")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new GitLab.Group("foo", new()
 *     {
 *         Name = "foo-group",
 *         Path = "foo-path",
 *     });
 *     var bar = new GitLab.GroupCluster("bar", new()
 *     {
 *         Group = foo.Id,
 *         Name = "bar-cluster",
 *         Domain = "example.com",
 *         Enabled = true,
 *         KubernetesApiUrl = "https://124.124.124",
 *         KubernetesToken = "some-token",
 *         KubernetesCaCert = "some-cert",
 *         KubernetesAuthorizationType = "rbac",
 *         EnvironmentScope = "*",
 *         ManagementProjectId = "123456",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		foo, err := gitlab.NewGroup(ctx, "foo", &gitlab.GroupArgs{
 * 			Name: pulumi.String("foo-group"),
 * 			Path: pulumi.String("foo-path"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewGroupCluster(ctx, "bar", &gitlab.GroupClusterArgs{
 * 			Group:                       foo.ID(),
 * 			Name:                        pulumi.String("bar-cluster"),
 * 			Domain:                      pulumi.String("example.com"),
 * 			Enabled:                     pulumi.Bool(true),
 * 			KubernetesApiUrl:            pulumi.String("https://124.124.124"),
 * 			KubernetesToken:             pulumi.String("some-token"),
 * 			KubernetesCaCert:            pulumi.String("some-cert"),
 * 			KubernetesAuthorizationType: pulumi.String("rbac"),
 * 			EnvironmentScope:            pulumi.String("*"),
 * 			ManagementProjectId:         pulumi.String("123456"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Group;
 * import com.pulumi.gitlab.GroupArgs;
 * import com.pulumi.gitlab.GroupCluster;
 * import com.pulumi.gitlab.GroupClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Group("foo", GroupArgs.builder()
 *             .name("foo-group")
 *             .path("foo-path")
 *             .build());
 *         var bar = new GroupCluster("bar", GroupClusterArgs.builder()
 *             .group(foo.id())
 *             .name("bar-cluster")
 *             .domain("example.com")
 *             .enabled(true)
 *             .kubernetesApiUrl("https://124.124.124")
 *             .kubernetesToken("some-token")
 *             .kubernetesCaCert("some-cert")
 *             .kubernetesAuthorizationType("rbac")
 *             .environmentScope("*")
 *             .managementProjectId("123456")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: gitlab:Group
 *     properties:
 *       name: foo-group
 *       path: foo-path
 *   bar:
 *     type: gitlab:GroupCluster
 *     properties:
 *       group: ${foo.id}
 *       name: bar-cluster
 *       domain: example.com
 *       enabled: true
 *       kubernetesApiUrl: https://124.124.124
 *       kubernetesToken: some-token
 *       kubernetesCaCert: some-cert
 *       kubernetesAuthorizationType: rbac
 *       environmentScope: '*'
 *       managementProjectId: '123456'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab group clusters can be imported using an id made up of `groupid:clusterid`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/groupCluster:GroupCluster bar 123:321
 * ```
 */
public class GroupCluster internal constructor(
    override val javaResource: com.pulumi.gitlab.GroupCluster,
) : KotlinCustomResource(javaResource, GroupClusterMapper) {
    /**
     * Cluster type.
     */
    public val clusterType: Output<String>
        get() = javaResource.clusterType().applyValue({ args0 -> args0 })

    /**
     * Create time.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * The base domain of the cluster.
     */
    public val domain: Output<String>?
        get() = javaResource.domain().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Determines if cluster is active or not. Defaults to `true`. This attribute cannot be read.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The associated environment to the cluster. Defaults to `*`.
     */
    public val environmentScope: Output<String>?
        get() = javaResource.environmentScope().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The id of the group to add the cluster to.
     */
    public val group: Output<String>
        get() = javaResource.group().applyValue({ args0 -> args0 })

    /**
     * The URL to access the Kubernetes API.
     */
    public val kubernetesApiUrl: Output<String>
        get() = javaResource.kubernetesApiUrl().applyValue({ args0 -> args0 })

    /**
     * The cluster authorization type. Valid values are `rbac`, `abac`, `unknown_authorization`. Defaults to `rbac`.
     */
    public val kubernetesAuthorizationType: Output<String>?
        get() = javaResource.kubernetesAuthorizationType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * TLS certificate (needed if API is using a self-signed TLS certificate).
     */
    public val kubernetesCaCert: Output<String>?
        get() = javaResource.kubernetesCaCert().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The token to authenticate against Kubernetes.
     */
    public val kubernetesToken: Output<String>
        get() = javaResource.kubernetesToken().applyValue({ args0 -> args0 })

    /**
     * Determines if cluster is managed by gitlab or not. Defaults to `true`. This attribute cannot be read.
     */
    public val managed: Output<Boolean>?
        get() = javaResource.managed().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ID of the management project for the cluster.
     */
    public val managementProjectId: Output<String>?
        get() = javaResource.managementProjectId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of cluster.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Platform type.
     */
    public val platformType: Output<String>
        get() = javaResource.platformType().applyValue({ args0 -> args0 })

    /**
     * Provider type.
     */
    public val providerType: Output<String>
        get() = javaResource.providerType().applyValue({ args0 -> args0 })
}

public object GroupClusterMapper : ResourceMapper<GroupCluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.GroupCluster::class == javaResource::class

    override fun map(javaResource: Resource): GroupCluster = GroupCluster(
        javaResource as
            com.pulumi.gitlab.GroupCluster,
    )
}

/**
 * @see [GroupCluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GroupCluster].
 */
public suspend fun groupCluster(
    name: String,
    block: suspend GroupClusterResourceBuilder.() -> Unit,
): GroupCluster {
    val builder = GroupClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GroupCluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun groupCluster(name: String): GroupCluster {
    val builder = GroupClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
