@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [GroupCustomAttribute].
 */
@PulumiTagMarker
public class GroupCustomAttributeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GroupCustomAttributeArgs = GroupCustomAttributeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GroupCustomAttributeArgsBuilder.() -> Unit) {
        val builder = GroupCustomAttributeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GroupCustomAttribute {
        val builtJavaResource = com.pulumi.gitlab.GroupCustomAttribute(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GroupCustomAttribute(builtJavaResource)
    }
}

/**
 * The `gitlab.GroupCustomAttribute` resource allows to manage custom attributes for a group.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/custom_attributes.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const attr = new gitlab.GroupCustomAttribute("attr", {
 *     group: 42,
 *     key: "location",
 *     value: "Greenland",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * attr = gitlab.GroupCustomAttribute("attr",
 *     group=42,
 *     key="location",
 *     value="Greenland")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var attr = new GitLab.GroupCustomAttribute("attr", new()
 *     {
 *         Group = 42,
 *         Key = "location",
 *         Value = "Greenland",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewGroupCustomAttribute(ctx, "attr", &gitlab.GroupCustomAttributeArgs{
 * 			Group: pulumi.Int(42),
 * 			Key:   pulumi.String("location"),
 * 			Value: pulumi.String("Greenland"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.GroupCustomAttribute;
 * import com.pulumi.gitlab.GroupCustomAttributeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var attr = new GroupCustomAttribute("attr", GroupCustomAttributeArgs.builder()
 *             .group("42")
 *             .key("location")
 *             .value("Greenland")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   attr:
 *     type: gitlab:GroupCustomAttribute
 *     properties:
 *       group: '42'
 *       key: location
 *       value: Greenland
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You can import a group custom attribute using the an id made up of `{group-id}:{key}`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/groupCustomAttribute:GroupCustomAttribute attr 42:location
 * ```
 */
public class GroupCustomAttribute internal constructor(
    override val javaResource: com.pulumi.gitlab.GroupCustomAttribute,
) : KotlinCustomResource(javaResource, GroupCustomAttributeMapper) {
    /**
     * The id of the group.
     */
    public val group: Output<Int>
        get() = javaResource.group().applyValue({ args0 -> args0 })

    /**
     * Key for the Custom Attribute.
     */
    public val key: Output<String>
        get() = javaResource.key().applyValue({ args0 -> args0 })

    /**
     * Value for the Custom Attribute.
     */
    public val `value`: Output<String>
        get() = javaResource.`value`().applyValue({ args0 -> args0 })
}

public object GroupCustomAttributeMapper : ResourceMapper<GroupCustomAttribute> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.GroupCustomAttribute::class == javaResource::class

    override fun map(javaResource: Resource): GroupCustomAttribute = GroupCustomAttribute(
        javaResource
            as com.pulumi.gitlab.GroupCustomAttribute,
    )
}

/**
 * @see [GroupCustomAttribute].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GroupCustomAttribute].
 */
public suspend fun groupCustomAttribute(
    name: String,
    block: suspend GroupCustomAttributeResourceBuilder.() -> Unit,
): GroupCustomAttribute {
    val builder = GroupCustomAttributeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GroupCustomAttribute].
 * @param name The _unique_ name of the resulting resource.
 */
public fun groupCustomAttribute(name: String): GroupCustomAttribute {
    val builder = GroupCustomAttributeResourceBuilder()
    builder.name(name)
    return builder.build()
}
