@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.GroupCustomAttributeArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.GroupCustomAttribute` resource allows to manage custom attributes for a group.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/custom_attributes.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const attr = new gitlab.GroupCustomAttribute("attr", {
 *     group: 42,
 *     key: "location",
 *     value: "Greenland",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * attr = gitlab.GroupCustomAttribute("attr",
 *     group=42,
 *     key="location",
 *     value="Greenland")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var attr = new GitLab.GroupCustomAttribute("attr", new()
 *     {
 *         Group = 42,
 *         Key = "location",
 *         Value = "Greenland",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewGroupCustomAttribute(ctx, "attr", &gitlab.GroupCustomAttributeArgs{
 * 			Group: pulumi.Int(42),
 * 			Key:   pulumi.String("location"),
 * 			Value: pulumi.String("Greenland"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.GroupCustomAttribute;
 * import com.pulumi.gitlab.GroupCustomAttributeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var attr = new GroupCustomAttribute("attr", GroupCustomAttributeArgs.builder()
 *             .group("42")
 *             .key("location")
 *             .value("Greenland")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   attr:
 *     type: gitlab:GroupCustomAttribute
 *     properties:
 *       group: '42'
 *       key: location
 *       value: Greenland
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You can import a group custom attribute using the an id made up of `{group-id}:{key}`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/groupCustomAttribute:GroupCustomAttribute attr 42:location
 * ```
 * @property group The id of the group.
 * @property key Key for the Custom Attribute.
 * @property value Value for the Custom Attribute.
 */
public data class GroupCustomAttributeArgs(
    public val group: Output<Int>? = null,
    public val key: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.GroupCustomAttributeArgs> {
    override fun toJava(): com.pulumi.gitlab.GroupCustomAttributeArgs =
        com.pulumi.gitlab.GroupCustomAttributeArgs.builder()
            .group(group?.applyValue({ args0 -> args0 }))
            .key(key?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupCustomAttributeArgs].
 */
@PulumiTagMarker
public class GroupCustomAttributeArgsBuilder internal constructor() {
    private var group: Output<Int>? = null

    private var key: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The id of the group.
     */
    @JvmName("nitkkdswumqyjawh")
    public suspend fun group(`value`: Output<Int>) {
        this.group = value
    }

    /**
     * @param value Key for the Custom Attribute.
     */
    @JvmName("uxdhwvfqdiavuqwg")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Value for the Custom Attribute.
     */
    @JvmName("yftwogncewgnnuxu")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The id of the group.
     */
    @JvmName("hcahbxqgqgcrxyix")
    public suspend fun group(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.group = mapped
    }

    /**
     * @param value Key for the Custom Attribute.
     */
    @JvmName("xxkuiejejpinpgms")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Value for the Custom Attribute.
     */
    @JvmName("eudswhyxgmdoxcdy")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): GroupCustomAttributeArgs = GroupCustomAttributeArgs(
        group = group,
        key = key,
        `value` = `value`,
    )
}
