@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.GroupEpicBoardArgs.builder
import com.pulumi.gitlab.kotlin.inputs.GroupEpicBoardListArgs
import com.pulumi.gitlab.kotlin.inputs.GroupEpicBoardListArgsBuilder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The `gitlab.GroupEpicBoard` resource allows to manage the lifecycle of a epic board in a group.
 * > Multiple epic boards on one group requires a GitLab Premium or above License.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/group_boards.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const example = new gitlab.Group("example", {
 *     name: "test_group",
 *     path: "test_group",
 *     description: "An example group",
 * });
 * const label1 = new gitlab.GroupLabel("label_1", {
 *     group: example.id,
 *     color: "#FF0000",
 *     name: "red-label",
 * });
 * const label3 = new gitlab.GroupLabel("label_3", {
 *     group: example.id,
 *     name: "label-3",
 *     color: "#003000",
 * });
 * const epicBoard = new gitlab.GroupEpicBoard("epic_board", {
 *     name: "epic board 6",
 *     group: example.path,
 *     lists: [{
 *         labelId: label1.labelId,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * example = gitlab.Group("example",
 *     name="test_group",
 *     path="test_group",
 *     description="An example group")
 * label1 = gitlab.GroupLabel("label_1",
 *     group=example.id,
 *     color="#FF0000",
 *     name="red-label")
 * label3 = gitlab.GroupLabel("label_3",
 *     group=example.id,
 *     name="label-3",
 *     color="#003000")
 * epic_board = gitlab.GroupEpicBoard("epic_board",
 *     name="epic board 6",
 *     group=example.path,
 *     lists=[{
 *         "label_id": label1.label_id,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new GitLab.Group("example", new()
 *     {
 *         Name = "test_group",
 *         Path = "test_group",
 *         Description = "An example group",
 *     });
 *     var label1 = new GitLab.GroupLabel("label_1", new()
 *     {
 *         Group = example.Id,
 *         Color = "#FF0000",
 *         Name = "red-label",
 *     });
 *     var label3 = new GitLab.GroupLabel("label_3", new()
 *     {
 *         Group = example.Id,
 *         Name = "label-3",
 *         Color = "#003000",
 *     });
 *     var epicBoard = new GitLab.GroupEpicBoard("epic_board", new()
 *     {
 *         Name = "epic board 6",
 *         Group = example.Path,
 *         Lists = new[]
 *         {
 *             new GitLab.Inputs.GroupEpicBoardListArgs
 *             {
 *                 LabelId = label1.LabelId,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := gitlab.NewGroup(ctx, "example", &gitlab.GroupArgs{
 * 			Name:        pulumi.String("test_group"),
 * 			Path:        pulumi.String("test_group"),
 * 			Description: pulumi.String("An example group"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		label1, err := gitlab.NewGroupLabel(ctx, "label_1", &gitlab.GroupLabelArgs{
 * 			Group: example.ID(),
 * 			Color: pulumi.String("#FF0000"),
 * 			Name:  pulumi.String("red-label"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewGroupLabel(ctx, "label_3", &gitlab.GroupLabelArgs{
 * 			Group: example.ID(),
 * 			Name:  pulumi.String("label-3"),
 * 			Color: pulumi.String("#003000"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewGroupEpicBoard(ctx, "epic_board", &gitlab.GroupEpicBoardArgs{
 * 			Name:  pulumi.String("epic board 6"),
 * 			Group: example.Path,
 * 			Lists: gitlab.GroupEpicBoardListArray{
 * 				&gitlab.GroupEpicBoardListArgs{
 * 					LabelId: label1.LabelId,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Group;
 * import com.pulumi.gitlab.GroupArgs;
 * import com.pulumi.gitlab.GroupLabel;
 * import com.pulumi.gitlab.GroupLabelArgs;
 * import com.pulumi.gitlab.GroupEpicBoard;
 * import com.pulumi.gitlab.GroupEpicBoardArgs;
 * import com.pulumi.gitlab.inputs.GroupEpicBoardListArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Group("example", GroupArgs.builder()
 *             .name("test_group")
 *             .path("test_group")
 *             .description("An example group")
 *             .build());
 *         var label1 = new GroupLabel("label1", GroupLabelArgs.builder()
 *             .group(example.id())
 *             .color("#FF0000")
 *             .name("red-label")
 *             .build());
 *         var label3 = new GroupLabel("label3", GroupLabelArgs.builder()
 *             .group(example.id())
 *             .name("label-3")
 *             .color("#003000")
 *             .build());
 *         var epicBoard = new GroupEpicBoard("epicBoard", GroupEpicBoardArgs.builder()
 *             .name("epic board 6")
 *             .group(example.path())
 *             .lists(GroupEpicBoardListArgs.builder()
 *                 .labelId(label1.labelId())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: gitlab:Group
 *     properties:
 *       name: test_group
 *       path: test_group
 *       description: An example group
 *   label1:
 *     type: gitlab:GroupLabel
 *     name: label_1
 *     properties:
 *       group: ${example.id}
 *       color: '#FF0000'
 *       name: red-label
 *   label3:
 *     type: gitlab:GroupLabel
 *     name: label_3
 *     properties:
 *       group: ${example.id}
 *       name: label-3
 *       color: '#003000'
 *   epicBoard:
 *     type: gitlab:GroupEpicBoard
 *     name: epic_board
 *     properties:
 *       name: epic board 6
 *       group: ${example.path}
 *       lists:
 *         - labelId: ${label1.labelId}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * You can import this resource with an id made up of `{group-id}:{epic-board-id}`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/groupEpicBoard:GroupEpicBoard agile 70:156
 * ```
 * @property group The ID or URL-encoded path of the group owned by the authenticated user.
 * @property lists The list of epic board lists.
 * @property name The name of the board.
 */
public data class GroupEpicBoardArgs(
    public val group: Output<String>? = null,
    public val lists: Output<List<GroupEpicBoardListArgs>>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.GroupEpicBoardArgs> {
    override fun toJava(): com.pulumi.gitlab.GroupEpicBoardArgs =
        com.pulumi.gitlab.GroupEpicBoardArgs.builder()
            .group(group?.applyValue({ args0 -> args0 }))
            .lists(lists?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupEpicBoardArgs].
 */
@PulumiTagMarker
public class GroupEpicBoardArgsBuilder internal constructor() {
    private var group: Output<String>? = null

    private var lists: Output<List<GroupEpicBoardListArgs>>? = null

    private var name: Output<String>? = null

    /**
     * @param value The ID or URL-encoded path of the group owned by the authenticated user.
     */
    @JvmName("wmrlsheoqlmpapfq")
    public suspend fun group(`value`: Output<String>) {
        this.group = value
    }

    /**
     * @param value The list of epic board lists.
     */
    @JvmName("omclsvlgqvtaxlsn")
    public suspend fun lists(`value`: Output<List<GroupEpicBoardListArgs>>) {
        this.lists = value
    }

    @JvmName("ujflxecuwdsqccin")
    public suspend fun lists(vararg values: Output<GroupEpicBoardListArgs>) {
        this.lists = Output.all(values.asList())
    }

    /**
     * @param values The list of epic board lists.
     */
    @JvmName("dlyoqbbtqhsftaql")
    public suspend fun lists(values: List<Output<GroupEpicBoardListArgs>>) {
        this.lists = Output.all(values)
    }

    /**
     * @param value The name of the board.
     */
    @JvmName("radsavskekqwidym")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ID or URL-encoded path of the group owned by the authenticated user.
     */
    @JvmName("rcmxofyelbkvvelu")
    public suspend fun group(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.group = mapped
    }

    /**
     * @param value The list of epic board lists.
     */
    @JvmName("xitudxgmwsvflvjk")
    public suspend fun lists(`value`: List<GroupEpicBoardListArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lists = mapped
    }

    /**
     * @param argument The list of epic board lists.
     */
    @JvmName("vppgxacecigdxqla")
    public suspend fun lists(argument: List<suspend GroupEpicBoardListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GroupEpicBoardListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lists = mapped
    }

    /**
     * @param argument The list of epic board lists.
     */
    @JvmName("gsurtqiokuupeuoe")
    public suspend fun lists(vararg argument: suspend GroupEpicBoardListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GroupEpicBoardListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lists = mapped
    }

    /**
     * @param argument The list of epic board lists.
     */
    @JvmName("spaqvyotopslgsdt")
    public suspend fun lists(argument: suspend GroupEpicBoardListArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(GroupEpicBoardListArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.lists = mapped
    }

    /**
     * @param values The list of epic board lists.
     */
    @JvmName("icweyjqmctttvyvm")
    public suspend fun lists(vararg values: GroupEpicBoardListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lists = mapped
    }

    /**
     * @param value The name of the board.
     */
    @JvmName("igrpydbwhmknnvtr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): GroupEpicBoardArgs = GroupEpicBoardArgs(
        group = group,
        lists = lists,
        name = name,
    )
}
