@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [GroupHook].
 */
@PulumiTagMarker
public class GroupHookResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GroupHookArgs = GroupHookArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GroupHookArgsBuilder.() -> Unit) {
        val builder = GroupHookArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GroupHook {
        val builtJavaResource = com.pulumi.gitlab.GroupHook(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GroupHook(builtJavaResource)
    }
}

/**
 * The `gitlab.GroupHook` resource allows to manage the lifecycle of a group hook.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/groups.html#hooks)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const example = new gitlab.GroupHook("example", {
 *     group: "example/hooked",
 *     url: "https://example.com/hook/example",
 *     mergeRequestsEvents: true,
 * });
 * // Setting all attributes
 * const allAttributes = new gitlab.GroupHook("all_attributes", {
 *     group: "1",
 *     url: "http://example.com",
 *     token: "supersecret",
 *     enableSslVerification: false,
 *     pushEvents: true,
 *     pushEventsBranchFilter: "devel",
 *     issuesEvents: false,
 *     confidentialIssuesEvents: false,
 *     mergeRequestsEvents: true,
 *     tagPushEvents: true,
 *     noteEvents: true,
 *     confidentialNoteEvents: true,
 *     jobEvents: true,
 *     pipelineEvents: true,
 *     wikiPageEvents: true,
 *     deploymentEvents: true,
 *     releasesEvents: true,
 *     subgroupEvents: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * example = gitlab.GroupHook("example",
 *     group="example/hooked",
 *     url="https://example.com/hook/example",
 *     merge_requests_events=True)
 * # Setting all attributes
 * all_attributes = gitlab.GroupHook("all_attributes",
 *     group="1",
 *     url="http://example.com",
 *     token="supersecret",
 *     enable_ssl_verification=False,
 *     push_events=True,
 *     push_events_branch_filter="devel",
 *     issues_events=False,
 *     confidential_issues_events=False,
 *     merge_requests_events=True,
 *     tag_push_events=True,
 *     note_events=True,
 *     confidential_note_events=True,
 *     job_events=True,
 *     pipeline_events=True,
 *     wiki_page_events=True,
 *     deployment_events=True,
 *     releases_events=True,
 *     subgroup_events=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new GitLab.GroupHook("example", new()
 *     {
 *         Group = "example/hooked",
 *         Url = "https://example.com/hook/example",
 *         MergeRequestsEvents = true,
 *     });
 *     // Setting all attributes
 *     var allAttributes = new GitLab.GroupHook("all_attributes", new()
 *     {
 *         Group = "1",
 *         Url = "http://example.com",
 *         Token = "supersecret",
 *         EnableSslVerification = false,
 *         PushEvents = true,
 *         PushEventsBranchFilter = "devel",
 *         IssuesEvents = false,
 *         ConfidentialIssuesEvents = false,
 *         MergeRequestsEvents = true,
 *         TagPushEvents = true,
 *         NoteEvents = true,
 *         ConfidentialNoteEvents = true,
 *         JobEvents = true,
 *         PipelineEvents = true,
 *         WikiPageEvents = true,
 *         DeploymentEvents = true,
 *         ReleasesEvents = true,
 *         SubgroupEvents = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewGroupHook(ctx, "example", &gitlab.GroupHookArgs{
 * 			Group:               pulumi.String("example/hooked"),
 * 			Url:                 pulumi.String("https://example.com/hook/example"),
 * 			MergeRequestsEvents: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Setting all attributes
 * 		_, err = gitlab.NewGroupHook(ctx, "all_attributes", &gitlab.GroupHookArgs{
 * 			Group:                    pulumi.String("1"),
 * 			Url:                      pulumi.String("http://example.com"),
 * 			Token:                    pulumi.String("supersecret"),
 * 			EnableSslVerification:    pulumi.Bool(false),
 * 			PushEvents:               pulumi.Bool(true),
 * 			PushEventsBranchFilter:   pulumi.String("devel"),
 * 			IssuesEvents:             pulumi.Bool(false),
 * 			ConfidentialIssuesEvents: pulumi.Bool(false),
 * 			MergeRequestsEvents:      pulumi.Bool(true),
 * 			TagPushEvents:            pulumi.Bool(true),
 * 			NoteEvents:               pulumi.Bool(true),
 * 			ConfidentialNoteEvents:   pulumi.Bool(true),
 * 			JobEvents:                pulumi.Bool(true),
 * 			PipelineEvents:           pulumi.Bool(true),
 * 			WikiPageEvents:           pulumi.Bool(true),
 * 			DeploymentEvents:         pulumi.Bool(true),
 * 			ReleasesEvents:           pulumi.Bool(true),
 * 			SubgroupEvents:           pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.GroupHook;
 * import com.pulumi.gitlab.GroupHookArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GroupHook("example", GroupHookArgs.builder()
 *             .group("example/hooked")
 *             .url("https://example.com/hook/example")
 *             .mergeRequestsEvents(true)
 *             .build());
 *         // Setting all attributes
 *         var allAttributes = new GroupHook("allAttributes", GroupHookArgs.builder()
 *             .group(1)
 *             .url("http://example.com")
 *             .token("supersecret")
 *             .enableSslVerification(false)
 *             .pushEvents(true)
 *             .pushEventsBranchFilter("devel")
 *             .issuesEvents(false)
 *             .confidentialIssuesEvents(false)
 *             .mergeRequestsEvents(true)
 *             .tagPushEvents(true)
 *             .noteEvents(true)
 *             .confidentialNoteEvents(true)
 *             .jobEvents(true)
 *             .pipelineEvents(true)
 *             .wikiPageEvents(true)
 *             .deploymentEvents(true)
 *             .releasesEvents(true)
 *             .subgroupEvents(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: gitlab:GroupHook
 *     properties:
 *       group: example/hooked
 *       url: https://example.com/hook/example
 *       mergeRequestsEvents: true
 *   # Setting all attributes
 *   allAttributes:
 *     type: gitlab:GroupHook
 *     name: all_attributes
 *     properties:
 *       group: 1
 *       url: http://example.com
 *       token: supersecret
 *       enableSslVerification: false
 *       pushEvents: true
 *       pushEventsBranchFilter: devel
 *       issuesEvents: false
 *       confidentialIssuesEvents: false
 *       mergeRequestsEvents: true
 *       tagPushEvents: true
 *       noteEvents: true
 *       confidentialNoteEvents: true
 *       jobEvents: true
 *       pipelineEvents: true
 *       wikiPageEvents: true
 *       deploymentEvents: true
 *       releasesEvents: true
 *       subgroupEvents: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * A GitLab Group Hook can be imported using a key composed of `<group-id>:<hook-id>`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/groupHook:GroupHook example "12345:1"
 * ```
 * NOTE: the `token` resource attribute is not available for imported resources as this information cannot be read from the GitLab API.
 */
public class GroupHook internal constructor(
    override val javaResource: com.pulumi.gitlab.GroupHook,
) : KotlinCustomResource(javaResource, GroupHookMapper) {
    /**
     * Invoke the hook for confidential issues events.
     */
    public val confidentialIssuesEvents: Output<Boolean>?
        get() = javaResource.confidentialIssuesEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Invoke the hook for confidential notes events.
     */
    public val confidentialNoteEvents: Output<Boolean>?
        get() = javaResource.confidentialNoteEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Set a custom webhook template.
     */
    public val customWebhookTemplate: Output<String>?
        get() = javaResource.customWebhookTemplate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Invoke the hook for deployment events.
     */
    public val deploymentEvents: Output<Boolean>?
        get() = javaResource.deploymentEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Enable ssl verification when invoking the hook.
     */
    public val enableSslVerification: Output<Boolean>?
        get() = javaResource.enableSslVerification().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID or full path of the group.
     */
    public val group: Output<String>
        get() = javaResource.group().applyValue({ args0 -> args0 })

    /**
     * The id of the group for the hook.
     */
    public val groupId: Output<Int>
        get() = javaResource.groupId().applyValue({ args0 -> args0 })

    /**
     * The id of the group hook.
     */
    public val hookId: Output<Int>
        get() = javaResource.hookId().applyValue({ args0 -> args0 })

    /**
     * Invoke the hook for issues events.
     */
    public val issuesEvents: Output<Boolean>?
        get() = javaResource.issuesEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Invoke the hook for job events.
     */
    public val jobEvents: Output<Boolean>?
        get() = javaResource.jobEvents().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Invoke the hook for merge requests.
     */
    public val mergeRequestsEvents: Output<Boolean>?
        get() = javaResource.mergeRequestsEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Invoke the hook for notes events.
     */
    public val noteEvents: Output<Boolean>?
        get() = javaResource.noteEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Invoke the hook for pipeline events.
     */
    public val pipelineEvents: Output<Boolean>?
        get() = javaResource.pipelineEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Invoke the hook for push events.
     */
    public val pushEvents: Output<Boolean>?
        get() = javaResource.pushEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Invoke the hook for push events on matching branches only.
     */
    public val pushEventsBranchFilter: Output<String>?
        get() = javaResource.pushEventsBranchFilter().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Invoke the hook for releases events.
     */
    public val releasesEvents: Output<Boolean>?
        get() = javaResource.releasesEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Invoke the hook for subgroup events.
     */
    public val subgroupEvents: Output<Boolean>?
        get() = javaResource.subgroupEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Invoke the hook for tag push events.
     */
    public val tagPushEvents: Output<Boolean>?
        get() = javaResource.tagPushEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A token to present when invoking the hook. The token is not available for imported resources.
     */
    public val token: Output<String>?
        get() = javaResource.token().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The url of the hook to invoke.
     */
    public val url: Output<String>
        get() = javaResource.url().applyValue({ args0 -> args0 })

    /**
     * Invoke the hook for wiki page events.
     */
    public val wikiPageEvents: Output<Boolean>?
        get() = javaResource.wikiPageEvents().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object GroupHookMapper : ResourceMapper<GroupHook> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.GroupHook::class == javaResource::class

    override fun map(javaResource: Resource): GroupHook = GroupHook(
        javaResource as
            com.pulumi.gitlab.GroupHook,
    )
}

/**
 * @see [GroupHook].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GroupHook].
 */
public suspend fun groupHook(name: String, block: suspend GroupHookResourceBuilder.() -> Unit): GroupHook {
    val builder = GroupHookResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GroupHook].
 * @param name The _unique_ name of the resulting resource.
 */
public fun groupHook(name: String): GroupHook {
    val builder = GroupHookResourceBuilder()
    builder.name(name)
    return builder.build()
}
