@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.GroupHookArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.GroupHook` resource allows to manage the lifecycle of a group hook.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/groups.html#hooks)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const example = new gitlab.GroupHook("example", {
 *     group: "example/hooked",
 *     url: "https://example.com/hook/example",
 *     mergeRequestsEvents: true,
 * });
 * // Setting all attributes
 * const allAttributes = new gitlab.GroupHook("all_attributes", {
 *     group: "1",
 *     url: "http://example.com",
 *     token: "supersecret",
 *     enableSslVerification: false,
 *     pushEvents: true,
 *     pushEventsBranchFilter: "devel",
 *     issuesEvents: false,
 *     confidentialIssuesEvents: false,
 *     mergeRequestsEvents: true,
 *     tagPushEvents: true,
 *     noteEvents: true,
 *     confidentialNoteEvents: true,
 *     jobEvents: true,
 *     pipelineEvents: true,
 *     wikiPageEvents: true,
 *     deploymentEvents: true,
 *     releasesEvents: true,
 *     subgroupEvents: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * example = gitlab.GroupHook("example",
 *     group="example/hooked",
 *     url="https://example.com/hook/example",
 *     merge_requests_events=True)
 * # Setting all attributes
 * all_attributes = gitlab.GroupHook("all_attributes",
 *     group="1",
 *     url="http://example.com",
 *     token="supersecret",
 *     enable_ssl_verification=False,
 *     push_events=True,
 *     push_events_branch_filter="devel",
 *     issues_events=False,
 *     confidential_issues_events=False,
 *     merge_requests_events=True,
 *     tag_push_events=True,
 *     note_events=True,
 *     confidential_note_events=True,
 *     job_events=True,
 *     pipeline_events=True,
 *     wiki_page_events=True,
 *     deployment_events=True,
 *     releases_events=True,
 *     subgroup_events=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new GitLab.GroupHook("example", new()
 *     {
 *         Group = "example/hooked",
 *         Url = "https://example.com/hook/example",
 *         MergeRequestsEvents = true,
 *     });
 *     // Setting all attributes
 *     var allAttributes = new GitLab.GroupHook("all_attributes", new()
 *     {
 *         Group = "1",
 *         Url = "http://example.com",
 *         Token = "supersecret",
 *         EnableSslVerification = false,
 *         PushEvents = true,
 *         PushEventsBranchFilter = "devel",
 *         IssuesEvents = false,
 *         ConfidentialIssuesEvents = false,
 *         MergeRequestsEvents = true,
 *         TagPushEvents = true,
 *         NoteEvents = true,
 *         ConfidentialNoteEvents = true,
 *         JobEvents = true,
 *         PipelineEvents = true,
 *         WikiPageEvents = true,
 *         DeploymentEvents = true,
 *         ReleasesEvents = true,
 *         SubgroupEvents = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewGroupHook(ctx, "example", &gitlab.GroupHookArgs{
 * 			Group:               pulumi.String("example/hooked"),
 * 			Url:                 pulumi.String("https://example.com/hook/example"),
 * 			MergeRequestsEvents: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		// Setting all attributes
 * 		_, err = gitlab.NewGroupHook(ctx, "all_attributes", &gitlab.GroupHookArgs{
 * 			Group:                    pulumi.String("1"),
 * 			Url:                      pulumi.String("http://example.com"),
 * 			Token:                    pulumi.String("supersecret"),
 * 			EnableSslVerification:    pulumi.Bool(false),
 * 			PushEvents:               pulumi.Bool(true),
 * 			PushEventsBranchFilter:   pulumi.String("devel"),
 * 			IssuesEvents:             pulumi.Bool(false),
 * 			ConfidentialIssuesEvents: pulumi.Bool(false),
 * 			MergeRequestsEvents:      pulumi.Bool(true),
 * 			TagPushEvents:            pulumi.Bool(true),
 * 			NoteEvents:               pulumi.Bool(true),
 * 			ConfidentialNoteEvents:   pulumi.Bool(true),
 * 			JobEvents:                pulumi.Bool(true),
 * 			PipelineEvents:           pulumi.Bool(true),
 * 			WikiPageEvents:           pulumi.Bool(true),
 * 			DeploymentEvents:         pulumi.Bool(true),
 * 			ReleasesEvents:           pulumi.Bool(true),
 * 			SubgroupEvents:           pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.GroupHook;
 * import com.pulumi.gitlab.GroupHookArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GroupHook("example", GroupHookArgs.builder()
 *             .group("example/hooked")
 *             .url("https://example.com/hook/example")
 *             .mergeRequestsEvents(true)
 *             .build());
 *         // Setting all attributes
 *         var allAttributes = new GroupHook("allAttributes", GroupHookArgs.builder()
 *             .group(1)
 *             .url("http://example.com")
 *             .token("supersecret")
 *             .enableSslVerification(false)
 *             .pushEvents(true)
 *             .pushEventsBranchFilter("devel")
 *             .issuesEvents(false)
 *             .confidentialIssuesEvents(false)
 *             .mergeRequestsEvents(true)
 *             .tagPushEvents(true)
 *             .noteEvents(true)
 *             .confidentialNoteEvents(true)
 *             .jobEvents(true)
 *             .pipelineEvents(true)
 *             .wikiPageEvents(true)
 *             .deploymentEvents(true)
 *             .releasesEvents(true)
 *             .subgroupEvents(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: gitlab:GroupHook
 *     properties:
 *       group: example/hooked
 *       url: https://example.com/hook/example
 *       mergeRequestsEvents: true
 *   # Setting all attributes
 *   allAttributes:
 *     type: gitlab:GroupHook
 *     name: all_attributes
 *     properties:
 *       group: 1
 *       url: http://example.com
 *       token: supersecret
 *       enableSslVerification: false
 *       pushEvents: true
 *       pushEventsBranchFilter: devel
 *       issuesEvents: false
 *       confidentialIssuesEvents: false
 *       mergeRequestsEvents: true
 *       tagPushEvents: true
 *       noteEvents: true
 *       confidentialNoteEvents: true
 *       jobEvents: true
 *       pipelineEvents: true
 *       wikiPageEvents: true
 *       deploymentEvents: true
 *       releasesEvents: true
 *       subgroupEvents: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * A GitLab Group Hook can be imported using a key composed of `<group-id>:<hook-id>`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/groupHook:GroupHook example "12345:1"
 * ```
 * NOTE: the `token` resource attribute is not available for imported resources as this information cannot be read from the GitLab API.
 * @property confidentialIssuesEvents Invoke the hook for confidential issues events.
 * @property confidentialNoteEvents Invoke the hook for confidential notes events.
 * @property customWebhookTemplate Set a custom webhook template.
 * @property deploymentEvents Invoke the hook for deployment events.
 * @property enableSslVerification Enable ssl verification when invoking the hook.
 * @property group The ID or full path of the group.
 * @property issuesEvents Invoke the hook for issues events.
 * @property jobEvents Invoke the hook for job events.
 * @property mergeRequestsEvents Invoke the hook for merge requests.
 * @property noteEvents Invoke the hook for notes events.
 * @property pipelineEvents Invoke the hook for pipeline events.
 * @property pushEvents Invoke the hook for push events.
 * @property pushEventsBranchFilter Invoke the hook for push events on matching branches only.
 * @property releasesEvents Invoke the hook for releases events.
 * @property subgroupEvents Invoke the hook for subgroup events.
 * @property tagPushEvents Invoke the hook for tag push events.
 * @property token A token to present when invoking the hook. The token is not available for imported resources.
 * @property url The url of the hook to invoke.
 * @property wikiPageEvents Invoke the hook for wiki page events.
 */
public data class GroupHookArgs(
    public val confidentialIssuesEvents: Output<Boolean>? = null,
    public val confidentialNoteEvents: Output<Boolean>? = null,
    public val customWebhookTemplate: Output<String>? = null,
    public val deploymentEvents: Output<Boolean>? = null,
    public val enableSslVerification: Output<Boolean>? = null,
    public val group: Output<String>? = null,
    public val issuesEvents: Output<Boolean>? = null,
    public val jobEvents: Output<Boolean>? = null,
    public val mergeRequestsEvents: Output<Boolean>? = null,
    public val noteEvents: Output<Boolean>? = null,
    public val pipelineEvents: Output<Boolean>? = null,
    public val pushEvents: Output<Boolean>? = null,
    public val pushEventsBranchFilter: Output<String>? = null,
    public val releasesEvents: Output<Boolean>? = null,
    public val subgroupEvents: Output<Boolean>? = null,
    public val tagPushEvents: Output<Boolean>? = null,
    public val token: Output<String>? = null,
    public val url: Output<String>? = null,
    public val wikiPageEvents: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.GroupHookArgs> {
    override fun toJava(): com.pulumi.gitlab.GroupHookArgs = com.pulumi.gitlab.GroupHookArgs.builder()
        .confidentialIssuesEvents(confidentialIssuesEvents?.applyValue({ args0 -> args0 }))
        .confidentialNoteEvents(confidentialNoteEvents?.applyValue({ args0 -> args0 }))
        .customWebhookTemplate(customWebhookTemplate?.applyValue({ args0 -> args0 }))
        .deploymentEvents(deploymentEvents?.applyValue({ args0 -> args0 }))
        .enableSslVerification(enableSslVerification?.applyValue({ args0 -> args0 }))
        .group(group?.applyValue({ args0 -> args0 }))
        .issuesEvents(issuesEvents?.applyValue({ args0 -> args0 }))
        .jobEvents(jobEvents?.applyValue({ args0 -> args0 }))
        .mergeRequestsEvents(mergeRequestsEvents?.applyValue({ args0 -> args0 }))
        .noteEvents(noteEvents?.applyValue({ args0 -> args0 }))
        .pipelineEvents(pipelineEvents?.applyValue({ args0 -> args0 }))
        .pushEvents(pushEvents?.applyValue({ args0 -> args0 }))
        .pushEventsBranchFilter(pushEventsBranchFilter?.applyValue({ args0 -> args0 }))
        .releasesEvents(releasesEvents?.applyValue({ args0 -> args0 }))
        .subgroupEvents(subgroupEvents?.applyValue({ args0 -> args0 }))
        .tagPushEvents(tagPushEvents?.applyValue({ args0 -> args0 }))
        .token(token?.applyValue({ args0 -> args0 }))
        .url(url?.applyValue({ args0 -> args0 }))
        .wikiPageEvents(wikiPageEvents?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupHookArgs].
 */
@PulumiTagMarker
public class GroupHookArgsBuilder internal constructor() {
    private var confidentialIssuesEvents: Output<Boolean>? = null

    private var confidentialNoteEvents: Output<Boolean>? = null

    private var customWebhookTemplate: Output<String>? = null

    private var deploymentEvents: Output<Boolean>? = null

    private var enableSslVerification: Output<Boolean>? = null

    private var group: Output<String>? = null

    private var issuesEvents: Output<Boolean>? = null

    private var jobEvents: Output<Boolean>? = null

    private var mergeRequestsEvents: Output<Boolean>? = null

    private var noteEvents: Output<Boolean>? = null

    private var pipelineEvents: Output<Boolean>? = null

    private var pushEvents: Output<Boolean>? = null

    private var pushEventsBranchFilter: Output<String>? = null

    private var releasesEvents: Output<Boolean>? = null

    private var subgroupEvents: Output<Boolean>? = null

    private var tagPushEvents: Output<Boolean>? = null

    private var token: Output<String>? = null

    private var url: Output<String>? = null

    private var wikiPageEvents: Output<Boolean>? = null

    /**
     * @param value Invoke the hook for confidential issues events.
     */
    @JvmName("fplxlflviynawbkx")
    public suspend fun confidentialIssuesEvents(`value`: Output<Boolean>) {
        this.confidentialIssuesEvents = value
    }

    /**
     * @param value Invoke the hook for confidential notes events.
     */
    @JvmName("wmusilraykssuvin")
    public suspend fun confidentialNoteEvents(`value`: Output<Boolean>) {
        this.confidentialNoteEvents = value
    }

    /**
     * @param value Set a custom webhook template.
     */
    @JvmName("vhfvxyyyikefkduc")
    public suspend fun customWebhookTemplate(`value`: Output<String>) {
        this.customWebhookTemplate = value
    }

    /**
     * @param value Invoke the hook for deployment events.
     */
    @JvmName("xssiaffagojbouvn")
    public suspend fun deploymentEvents(`value`: Output<Boolean>) {
        this.deploymentEvents = value
    }

    /**
     * @param value Enable ssl verification when invoking the hook.
     */
    @JvmName("fcacjtoyvvsoujev")
    public suspend fun enableSslVerification(`value`: Output<Boolean>) {
        this.enableSslVerification = value
    }

    /**
     * @param value The ID or full path of the group.
     */
    @JvmName("xipvgkmxjkilgfsd")
    public suspend fun group(`value`: Output<String>) {
        this.group = value
    }

    /**
     * @param value Invoke the hook for issues events.
     */
    @JvmName("iacejrgnhgwwgkis")
    public suspend fun issuesEvents(`value`: Output<Boolean>) {
        this.issuesEvents = value
    }

    /**
     * @param value Invoke the hook for job events.
     */
    @JvmName("vlkhucjwsnveoacm")
    public suspend fun jobEvents(`value`: Output<Boolean>) {
        this.jobEvents = value
    }

    /**
     * @param value Invoke the hook for merge requests.
     */
    @JvmName("gwbkvwdkdeufgcpc")
    public suspend fun mergeRequestsEvents(`value`: Output<Boolean>) {
        this.mergeRequestsEvents = value
    }

    /**
     * @param value Invoke the hook for notes events.
     */
    @JvmName("ojmiwnqldxfgknva")
    public suspend fun noteEvents(`value`: Output<Boolean>) {
        this.noteEvents = value
    }

    /**
     * @param value Invoke the hook for pipeline events.
     */
    @JvmName("gixfiekyaimwggat")
    public suspend fun pipelineEvents(`value`: Output<Boolean>) {
        this.pipelineEvents = value
    }

    /**
     * @param value Invoke the hook for push events.
     */
    @JvmName("qbpxvsjdkmgxtkoy")
    public suspend fun pushEvents(`value`: Output<Boolean>) {
        this.pushEvents = value
    }

    /**
     * @param value Invoke the hook for push events on matching branches only.
     */
    @JvmName("jciavklfjrkmbfhp")
    public suspend fun pushEventsBranchFilter(`value`: Output<String>) {
        this.pushEventsBranchFilter = value
    }

    /**
     * @param value Invoke the hook for releases events.
     */
    @JvmName("haokughteyaetprm")
    public suspend fun releasesEvents(`value`: Output<Boolean>) {
        this.releasesEvents = value
    }

    /**
     * @param value Invoke the hook for subgroup events.
     */
    @JvmName("cqyikewmrhaltywa")
    public suspend fun subgroupEvents(`value`: Output<Boolean>) {
        this.subgroupEvents = value
    }

    /**
     * @param value Invoke the hook for tag push events.
     */
    @JvmName("djukfaeqhattelem")
    public suspend fun tagPushEvents(`value`: Output<Boolean>) {
        this.tagPushEvents = value
    }

    /**
     * @param value A token to present when invoking the hook. The token is not available for imported resources.
     */
    @JvmName("bcdcnohqjjjbnhdk")
    public suspend fun token(`value`: Output<String>) {
        this.token = value
    }

    /**
     * @param value The url of the hook to invoke.
     */
    @JvmName("qwytynjppsvunwwi")
    public suspend fun url(`value`: Output<String>) {
        this.url = value
    }

    /**
     * @param value Invoke the hook for wiki page events.
     */
    @JvmName("ufsxvkuhyivdbkeq")
    public suspend fun wikiPageEvents(`value`: Output<Boolean>) {
        this.wikiPageEvents = value
    }

    /**
     * @param value Invoke the hook for confidential issues events.
     */
    @JvmName("kvxvaqtheqwhnybu")
    public suspend fun confidentialIssuesEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.confidentialIssuesEvents = mapped
    }

    /**
     * @param value Invoke the hook for confidential notes events.
     */
    @JvmName("jnnpmxtnsfiblaxs")
    public suspend fun confidentialNoteEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.confidentialNoteEvents = mapped
    }

    /**
     * @param value Set a custom webhook template.
     */
    @JvmName("monjlocxvuuhcnml")
    public suspend fun customWebhookTemplate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customWebhookTemplate = mapped
    }

    /**
     * @param value Invoke the hook for deployment events.
     */
    @JvmName("tfoasrbhcfqbjsjt")
    public suspend fun deploymentEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentEvents = mapped
    }

    /**
     * @param value Enable ssl verification when invoking the hook.
     */
    @JvmName("omocbfhgtbjryojo")
    public suspend fun enableSslVerification(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableSslVerification = mapped
    }

    /**
     * @param value The ID or full path of the group.
     */
    @JvmName("klhrbiwgiynckdqd")
    public suspend fun group(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.group = mapped
    }

    /**
     * @param value Invoke the hook for issues events.
     */
    @JvmName("ybbbqtdaxxmukequ")
    public suspend fun issuesEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issuesEvents = mapped
    }

    /**
     * @param value Invoke the hook for job events.
     */
    @JvmName("ocsjtsoberljgcgp")
    public suspend fun jobEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobEvents = mapped
    }

    /**
     * @param value Invoke the hook for merge requests.
     */
    @JvmName("wehvvsmaiknurulx")
    public suspend fun mergeRequestsEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mergeRequestsEvents = mapped
    }

    /**
     * @param value Invoke the hook for notes events.
     */
    @JvmName("baqutrgiwgvyoxjh")
    public suspend fun noteEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noteEvents = mapped
    }

    /**
     * @param value Invoke the hook for pipeline events.
     */
    @JvmName("upkjaqeujdrjkvsy")
    public suspend fun pipelineEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineEvents = mapped
    }

    /**
     * @param value Invoke the hook for push events.
     */
    @JvmName("lemsylmfmslsxhwj")
    public suspend fun pushEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pushEvents = mapped
    }

    /**
     * @param value Invoke the hook for push events on matching branches only.
     */
    @JvmName("shaxbbeqkceafadm")
    public suspend fun pushEventsBranchFilter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pushEventsBranchFilter = mapped
    }

    /**
     * @param value Invoke the hook for releases events.
     */
    @JvmName("tdgjfupgonsujami")
    public suspend fun releasesEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.releasesEvents = mapped
    }

    /**
     * @param value Invoke the hook for subgroup events.
     */
    @JvmName("kmfpfnvbvugkqwbo")
    public suspend fun subgroupEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subgroupEvents = mapped
    }

    /**
     * @param value Invoke the hook for tag push events.
     */
    @JvmName("mjctowamlajxpqhf")
    public suspend fun tagPushEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagPushEvents = mapped
    }

    /**
     * @param value A token to present when invoking the hook. The token is not available for imported resources.
     */
    @JvmName("mmfnckjdmfwqvryf")
    public suspend fun token(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.token = mapped
    }

    /**
     * @param value The url of the hook to invoke.
     */
    @JvmName("wowmkamkavwaceud")
    public suspend fun url(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.url = mapped
    }

    /**
     * @param value Invoke the hook for wiki page events.
     */
    @JvmName("qpjoynbwnawmgarl")
    public suspend fun wikiPageEvents(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wikiPageEvents = mapped
    }

    internal fun build(): GroupHookArgs = GroupHookArgs(
        confidentialIssuesEvents = confidentialIssuesEvents,
        confidentialNoteEvents = confidentialNoteEvents,
        customWebhookTemplate = customWebhookTemplate,
        deploymentEvents = deploymentEvents,
        enableSslVerification = enableSslVerification,
        group = group,
        issuesEvents = issuesEvents,
        jobEvents = jobEvents,
        mergeRequestsEvents = mergeRequestsEvents,
        noteEvents = noteEvents,
        pipelineEvents = pipelineEvents,
        pushEvents = pushEvents,
        pushEventsBranchFilter = pushEventsBranchFilter,
        releasesEvents = releasesEvents,
        subgroupEvents = subgroupEvents,
        tagPushEvents = tagPushEvents,
        token = token,
        url = url,
        wikiPageEvents = wikiPageEvents,
    )
}
