@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.gitlab.kotlin.outputs.GroupIssueBoardList
import com.pulumi.gitlab.kotlin.outputs.GroupIssueBoardList.Companion.toKotlin
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [GroupIssueBoard].
 */
@PulumiTagMarker
public class GroupIssueBoardResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GroupIssueBoardArgs = GroupIssueBoardArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GroupIssueBoardArgsBuilder.() -> Unit) {
        val builder = GroupIssueBoardArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GroupIssueBoard {
        val builtJavaResource = com.pulumi.gitlab.GroupIssueBoard(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GroupIssueBoard(builtJavaResource)
    }
}

/**
 * The `gitlab.GroupIssueBoard` resource allows to manage the lifecycle of a issue board in a group.
 * > Multiple issue boards on one group requires a GitLab Premium or above License.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/group_boards.html)
 */
public class GroupIssueBoard internal constructor(
    override val javaResource: com.pulumi.gitlab.GroupIssueBoard,
) : KotlinCustomResource(javaResource, GroupIssueBoardMapper) {
    /**
     * The ID or URL-encoded path of the group owned by the authenticated user.
     */
    public val group: Output<String>
        get() = javaResource.group().applyValue({ args0 -> args0 })

    /**
     * The list of label names which the board should be scoped to.
     */
    public val labels: Output<List<String>>?
        get() = javaResource.labels().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The list of issue board lists.
     */
    public val lists: Output<List<GroupIssueBoardList>>?
        get() = javaResource.lists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The milestone the board should be scoped to.
     */
    public val milestoneId: Output<Int>?
        get() = javaResource.milestoneId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the board.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object GroupIssueBoardMapper : ResourceMapper<GroupIssueBoard> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.GroupIssueBoard::class == javaResource::class

    override fun map(javaResource: Resource): GroupIssueBoard = GroupIssueBoard(
        javaResource as
            com.pulumi.gitlab.GroupIssueBoard,
    )
}

/**
 * @see [GroupIssueBoard].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GroupIssueBoard].
 */
public suspend fun groupIssueBoard(
    name: String,
    block: suspend GroupIssueBoardResourceBuilder.() -> Unit,
): GroupIssueBoard {
    val builder = GroupIssueBoardResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GroupIssueBoard].
 * @param name The _unique_ name of the resulting resource.
 */
public fun groupIssueBoard(name: String): GroupIssueBoard {
    val builder = GroupIssueBoardResourceBuilder()
    builder.name(name)
    return builder.build()
}
