@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.GroupIssueBoardArgs.builder
import com.pulumi.gitlab.kotlin.inputs.GroupIssueBoardListArgs
import com.pulumi.gitlab.kotlin.inputs.GroupIssueBoardListArgsBuilder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The `gitlab.GroupIssueBoard` resource allows to manage the lifecycle of a issue board in a group.
 * > Multiple issue boards on one group requires a GitLab Premium or above License.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/group_boards.html)
 * @property group The ID or URL-encoded path of the group owned by the authenticated user.
 * @property labels The list of label names which the board should be scoped to.
 * @property lists The list of issue board lists.
 * @property milestoneId The milestone the board should be scoped to.
 * @property name The name of the board.
 */
public data class GroupIssueBoardArgs(
    public val group: Output<String>? = null,
    public val labels: Output<List<String>>? = null,
    public val lists: Output<List<GroupIssueBoardListArgs>>? = null,
    public val milestoneId: Output<Int>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.GroupIssueBoardArgs> {
    override fun toJava(): com.pulumi.gitlab.GroupIssueBoardArgs =
        com.pulumi.gitlab.GroupIssueBoardArgs.builder()
            .group(group?.applyValue({ args0 -> args0 }))
            .labels(labels?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .lists(lists?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .milestoneId(milestoneId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupIssueBoardArgs].
 */
@PulumiTagMarker
public class GroupIssueBoardArgsBuilder internal constructor() {
    private var group: Output<String>? = null

    private var labels: Output<List<String>>? = null

    private var lists: Output<List<GroupIssueBoardListArgs>>? = null

    private var milestoneId: Output<Int>? = null

    private var name: Output<String>? = null

    /**
     * @param value The ID or URL-encoded path of the group owned by the authenticated user.
     */
    @JvmName("gogeftblrhfrsdic")
    public suspend fun group(`value`: Output<String>) {
        this.group = value
    }

    /**
     * @param value The list of label names which the board should be scoped to.
     */
    @JvmName("qbeokncafxiswsxa")
    public suspend fun labels(`value`: Output<List<String>>) {
        this.labels = value
    }

    @JvmName("igsuntrglnkrjblf")
    public suspend fun labels(vararg values: Output<String>) {
        this.labels = Output.all(values.asList())
    }

    /**
     * @param values The list of label names which the board should be scoped to.
     */
    @JvmName("ehlywboaxsjaddvt")
    public suspend fun labels(values: List<Output<String>>) {
        this.labels = Output.all(values)
    }

    /**
     * @param value The list of issue board lists.
     */
    @JvmName("fjopycsdpapenoib")
    public suspend fun lists(`value`: Output<List<GroupIssueBoardListArgs>>) {
        this.lists = value
    }

    @JvmName("vaesukmauudjsqxv")
    public suspend fun lists(vararg values: Output<GroupIssueBoardListArgs>) {
        this.lists = Output.all(values.asList())
    }

    /**
     * @param values The list of issue board lists.
     */
    @JvmName("cioocbqyuhhjjevu")
    public suspend fun lists(values: List<Output<GroupIssueBoardListArgs>>) {
        this.lists = Output.all(values)
    }

    /**
     * @param value The milestone the board should be scoped to.
     */
    @JvmName("oaowvctgwwidtgih")
    public suspend fun milestoneId(`value`: Output<Int>) {
        this.milestoneId = value
    }

    /**
     * @param value The name of the board.
     */
    @JvmName("nkiwjirgydgryusf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ID or URL-encoded path of the group owned by the authenticated user.
     */
    @JvmName("exwljkbmayudrcpd")
    public suspend fun group(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.group = mapped
    }

    /**
     * @param value The list of label names which the board should be scoped to.
     */
    @JvmName("bjliwjhrgerhajtc")
    public suspend fun labels(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param values The list of label names which the board should be scoped to.
     */
    @JvmName("acvlllmsywslogrn")
    public suspend fun labels(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param value The list of issue board lists.
     */
    @JvmName("vameahhquonbmeom")
    public suspend fun lists(`value`: List<GroupIssueBoardListArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lists = mapped
    }

    /**
     * @param argument The list of issue board lists.
     */
    @JvmName("bgtloslrkhqrvvkr")
    public suspend fun lists(argument: List<suspend GroupIssueBoardListArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GroupIssueBoardListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lists = mapped
    }

    /**
     * @param argument The list of issue board lists.
     */
    @JvmName("kragasvcjolwmxae")
    public suspend fun lists(vararg argument: suspend GroupIssueBoardListArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GroupIssueBoardListArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lists = mapped
    }

    /**
     * @param argument The list of issue board lists.
     */
    @JvmName("qxlqpxetbdffyuhf")
    public suspend fun lists(argument: suspend GroupIssueBoardListArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(GroupIssueBoardListArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.lists = mapped
    }

    /**
     * @param values The list of issue board lists.
     */
    @JvmName("sjfystfqlprqycws")
    public suspend fun lists(vararg values: GroupIssueBoardListArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lists = mapped
    }

    /**
     * @param value The milestone the board should be scoped to.
     */
    @JvmName("ggupjvyvgygpvvin")
    public suspend fun milestoneId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.milestoneId = mapped
    }

    /**
     * @param value The name of the board.
     */
    @JvmName("qwursyfgethpapuo")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): GroupIssueBoardArgs = GroupIssueBoardArgs(
        group = group,
        labels = labels,
        lists = lists,
        milestoneId = milestoneId,
        name = name,
    )
}
