@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [GroupLabel].
 */
@PulumiTagMarker
public class GroupLabelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GroupLabelArgs = GroupLabelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GroupLabelArgsBuilder.() -> Unit) {
        val builder = GroupLabelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GroupLabel {
        val builtJavaResource = com.pulumi.gitlab.GroupLabel(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GroupLabel(builtJavaResource)
    }
}

/**
 * The `gitlab.GroupLabel` resource allows to manage the lifecycle of labels within a group.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/user/project/labels.html#group-labels)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const fixme = new gitlab.GroupLabel("fixme", {
 *     group: "example",
 *     name: "fixme",
 *     description: "issue with failing tests",
 *     color: "#ffcc00",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * fixme = gitlab.GroupLabel("fixme",
 *     group="example",
 *     name="fixme",
 *     description="issue with failing tests",
 *     color="#ffcc00")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fixme = new GitLab.GroupLabel("fixme", new()
 *     {
 *         Group = "example",
 *         Name = "fixme",
 *         Description = "issue with failing tests",
 *         Color = "#ffcc00",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewGroupLabel(ctx, "fixme", &gitlab.GroupLabelArgs{
 * 			Group:       pulumi.String("example"),
 * 			Name:        pulumi.String("fixme"),
 * 			Description: pulumi.String("issue with failing tests"),
 * 			Color:       pulumi.String("#ffcc00"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.GroupLabel;
 * import com.pulumi.gitlab.GroupLabelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fixme = new GroupLabel("fixme", GroupLabelArgs.builder()
 *             .group("example")
 *             .name("fixme")
 *             .description("issue with failing tests")
 *             .color("#ffcc00")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   fixme:
 *     type: gitlab:GroupLabel
 *     properties:
 *       group: example
 *       name: fixme
 *       description: issue with failing tests
 *       color: '#ffcc00'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Gitlab group labels can be imported using an id made up of `{group_id}:{group_label_id}`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/groupLabel:GroupLabel example 12345:fixme
 * ```
 */
public class GroupLabel internal constructor(
    override val javaResource: com.pulumi.gitlab.GroupLabel,
) : KotlinCustomResource(javaResource, GroupLabelMapper) {
    /**
     * The color of the label given in 6-digit hex notation with leading '#' sign (e.g. #FFAABB) or one of the [CSS color names](https://developer.mozilla.org/en-US/docs/Web/CSS/color_value#Color_keywords).
     */
    public val color: Output<String>
        get() = javaResource.color().applyValue({ args0 -> args0 })

    /**
     * The description of the label.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name or id of the group to add the label to.
     */
    public val group: Output<String>
        get() = javaResource.group().applyValue({ args0 -> args0 })

    /**
     * The id of the group label.
     */
    public val labelId: Output<Int>
        get() = javaResource.labelId().applyValue({ args0 -> args0 })

    /**
     * The name of the label.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object GroupLabelMapper : ResourceMapper<GroupLabel> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.GroupLabel::class == javaResource::class

    override fun map(javaResource: Resource): GroupLabel = GroupLabel(
        javaResource as
            com.pulumi.gitlab.GroupLabel,
    )
}

/**
 * @see [GroupLabel].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GroupLabel].
 */
public suspend fun groupLabel(name: String, block: suspend GroupLabelResourceBuilder.() -> Unit): GroupLabel {
    val builder = GroupLabelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GroupLabel].
 * @param name The _unique_ name of the resulting resource.
 */
public fun groupLabel(name: String): GroupLabel {
    val builder = GroupLabelResourceBuilder()
    builder.name(name)
    return builder.build()
}
