@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.GroupLabelArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.GroupLabel` resource allows to manage the lifecycle of labels within a group.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/user/project/labels.html#group-labels)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const fixme = new gitlab.GroupLabel("fixme", {
 *     group: "example",
 *     name: "fixme",
 *     description: "issue with failing tests",
 *     color: "#ffcc00",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * fixme = gitlab.GroupLabel("fixme",
 *     group="example",
 *     name="fixme",
 *     description="issue with failing tests",
 *     color="#ffcc00")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fixme = new GitLab.GroupLabel("fixme", new()
 *     {
 *         Group = "example",
 *         Name = "fixme",
 *         Description = "issue with failing tests",
 *         Color = "#ffcc00",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewGroupLabel(ctx, "fixme", &gitlab.GroupLabelArgs{
 * 			Group:       pulumi.String("example"),
 * 			Name:        pulumi.String("fixme"),
 * 			Description: pulumi.String("issue with failing tests"),
 * 			Color:       pulumi.String("#ffcc00"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.GroupLabel;
 * import com.pulumi.gitlab.GroupLabelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fixme = new GroupLabel("fixme", GroupLabelArgs.builder()
 *             .group("example")
 *             .name("fixme")
 *             .description("issue with failing tests")
 *             .color("#ffcc00")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   fixme:
 *     type: gitlab:GroupLabel
 *     properties:
 *       group: example
 *       name: fixme
 *       description: issue with failing tests
 *       color: '#ffcc00'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Gitlab group labels can be imported using an id made up of `{group_id}:{group_label_id}`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/groupLabel:GroupLabel example 12345:fixme
 * ```
 * @property color The color of the label given in 6-digit hex notation with leading '#' sign (e.g. #FFAABB) or one of the [CSS color names](https://developer.mozilla.org/en-US/docs/Web/CSS/color_value#Color_keywords).
 * @property description The description of the label.
 * @property group The name or id of the group to add the label to.
 * @property name The name of the label.
 */
public data class GroupLabelArgs(
    public val color: Output<String>? = null,
    public val description: Output<String>? = null,
    public val group: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.GroupLabelArgs> {
    override fun toJava(): com.pulumi.gitlab.GroupLabelArgs =
        com.pulumi.gitlab.GroupLabelArgs.builder()
            .color(color?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .group(group?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupLabelArgs].
 */
@PulumiTagMarker
public class GroupLabelArgsBuilder internal constructor() {
    private var color: Output<String>? = null

    private var description: Output<String>? = null

    private var group: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The color of the label given in 6-digit hex notation with leading '#' sign (e.g. #FFAABB) or one of the [CSS color names](https://developer.mozilla.org/en-US/docs/Web/CSS/color_value#Color_keywords).
     */
    @JvmName("ybbwvccwpousxxnf")
    public suspend fun color(`value`: Output<String>) {
        this.color = value
    }

    /**
     * @param value The description of the label.
     */
    @JvmName("tcwagvgidfnlfjtq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name or id of the group to add the label to.
     */
    @JvmName("yebcwpgwgohyplty")
    public suspend fun group(`value`: Output<String>) {
        this.group = value
    }

    /**
     * @param value The name of the label.
     */
    @JvmName("updyxgqlriwgtero")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The color of the label given in 6-digit hex notation with leading '#' sign (e.g. #FFAABB) or one of the [CSS color names](https://developer.mozilla.org/en-US/docs/Web/CSS/color_value#Color_keywords).
     */
    @JvmName("lfinhhppacxbtble")
    public suspend fun color(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.color = mapped
    }

    /**
     * @param value The description of the label.
     */
    @JvmName("utkohlrbspeywjss")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name or id of the group to add the label to.
     */
    @JvmName("gnctylmtlyrebrvc")
    public suspend fun group(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.group = mapped
    }

    /**
     * @param value The name of the label.
     */
    @JvmName("mbetqhwvvbxqpbau")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): GroupLabelArgs = GroupLabelArgs(
        color = color,
        description = description,
        group = group,
        name = name,
    )
}
