@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [GroupMembership].
 */
@PulumiTagMarker
public class GroupMembershipResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GroupMembershipArgs = GroupMembershipArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GroupMembershipArgsBuilder.() -> Unit) {
        val builder = GroupMembershipArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GroupMembership {
        val builtJavaResource = com.pulumi.gitlab.GroupMembership(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GroupMembership(builtJavaResource)
    }
}

/**
 * The `gitlab.GroupMembership` resource allows to manage the lifecycle of a users group membership.
 * > If a group should grant membership to another group use the `gitlab.GroupShareGroup` resource instead.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/members.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const test = new gitlab.GroupMembership("test", {
 *     groupId: "12345",
 *     userId: 1337,
 *     accessLevel: "guest",
 *     expiresAt: "2020-12-31",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * test = gitlab.GroupMembership("test",
 *     group_id="12345",
 *     user_id=1337,
 *     access_level="guest",
 *     expires_at="2020-12-31")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new GitLab.GroupMembership("test", new()
 *     {
 *         GroupId = "12345",
 *         UserId = 1337,
 *         AccessLevel = "guest",
 *         ExpiresAt = "2020-12-31",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewGroupMembership(ctx, "test", &gitlab.GroupMembershipArgs{
 * 			GroupId:     pulumi.String("12345"),
 * 			UserId:      pulumi.Int(1337),
 * 			AccessLevel: pulumi.String("guest"),
 * 			ExpiresAt:   pulumi.String("2020-12-31"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.GroupMembership;
 * import com.pulumi.gitlab.GroupMembershipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new GroupMembership("test", GroupMembershipArgs.builder()
 *             .groupId("12345")
 *             .userId(1337)
 *             .accessLevel("guest")
 *             .expiresAt("2020-12-31")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: gitlab:GroupMembership
 *     properties:
 *       groupId: '12345'
 *       userId: 1337
 *       accessLevel: guest
 *       expiresAt: 2020-12-31
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab group membership can be imported using an id made up of `group_id:user_id`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/groupMembership:GroupMembership test "12345:1337"
 * ```
 */
public class GroupMembership internal constructor(
    override val javaResource: com.pulumi.gitlab.GroupMembership,
) : KotlinCustomResource(javaResource, GroupMembershipMapper) {
    /**
     * Access level for the member. Valid values are: `no one`, `minimal`, `guest`, `reporter`, `developer`, `maintainer`, `owner`.
     */
    public val accessLevel: Output<String>
        get() = javaResource.accessLevel().applyValue({ args0 -> args0 })

    /**
     * Expiration date for the group membership. Format: `YYYY-MM-DD`
     */
    public val expiresAt: Output<String>?
        get() = javaResource.expiresAt().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The id of the group.
     */
    public val groupId: Output<String>
        get() = javaResource.groupId().applyValue({ args0 -> args0 })

    /**
     * The ID of a custom member role. Only available for Ultimate instances.
     */
    public val memberRoleId: Output<Int>?
        get() = javaResource.memberRoleId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether the deletion of direct memberships of the removed member in subgroups and projects should be skipped. Only used during a destroy.
     */
    public val skipSubresourcesOnDestroy: Output<Boolean>?
        get() = javaResource.skipSubresourcesOnDestroy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether the removed member should be unassigned from any issues or merge requests inside a given group or project. Only used during a destroy.
     */
    public val unassignIssuablesOnDestroy: Output<Boolean>?
        get() = javaResource.unassignIssuablesOnDestroy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The id of the user.
     */
    public val userId: Output<Int>
        get() = javaResource.userId().applyValue({ args0 -> args0 })
}

public object GroupMembershipMapper : ResourceMapper<GroupMembership> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.GroupMembership::class == javaResource::class

    override fun map(javaResource: Resource): GroupMembership = GroupMembership(
        javaResource as
            com.pulumi.gitlab.GroupMembership,
    )
}

/**
 * @see [GroupMembership].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GroupMembership].
 */
public suspend fun groupMembership(
    name: String,
    block: suspend GroupMembershipResourceBuilder.() -> Unit,
): GroupMembership {
    val builder = GroupMembershipResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GroupMembership].
 * @param name The _unique_ name of the resulting resource.
 */
public fun groupMembership(name: String): GroupMembership {
    val builder = GroupMembershipResourceBuilder()
    builder.name(name)
    return builder.build()
}
