@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.GroupMembershipArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.GroupMembership` resource allows to manage the lifecycle of a users group membership.
 * > If a group should grant membership to another group use the `gitlab.GroupShareGroup` resource instead.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/members.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const test = new gitlab.GroupMembership("test", {
 *     groupId: "12345",
 *     userId: 1337,
 *     accessLevel: "guest",
 *     expiresAt: "2020-12-31",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * test = gitlab.GroupMembership("test",
 *     group_id="12345",
 *     user_id=1337,
 *     access_level="guest",
 *     expires_at="2020-12-31")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new GitLab.GroupMembership("test", new()
 *     {
 *         GroupId = "12345",
 *         UserId = 1337,
 *         AccessLevel = "guest",
 *         ExpiresAt = "2020-12-31",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := gitlab.NewGroupMembership(ctx, "test", &gitlab.GroupMembershipArgs{
 * 			GroupId:     pulumi.String("12345"),
 * 			UserId:      pulumi.Int(1337),
 * 			AccessLevel: pulumi.String("guest"),
 * 			ExpiresAt:   pulumi.String("2020-12-31"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.GroupMembership;
 * import com.pulumi.gitlab.GroupMembershipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new GroupMembership("test", GroupMembershipArgs.builder()
 *             .groupId("12345")
 *             .userId(1337)
 *             .accessLevel("guest")
 *             .expiresAt("2020-12-31")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: gitlab:GroupMembership
 *     properties:
 *       groupId: '12345'
 *       userId: 1337
 *       accessLevel: guest
 *       expiresAt: 2020-12-31
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * GitLab group membership can be imported using an id made up of `group_id:user_id`, e.g.
 * ```sh
 * $ pulumi import gitlab:index/groupMembership:GroupMembership test "12345:1337"
 * ```
 * @property accessLevel Access level for the member. Valid values are: `no one`, `minimal`, `guest`, `reporter`, `developer`, `maintainer`, `owner`.
 * @property expiresAt Expiration date for the group membership. Format: `YYYY-MM-DD`
 * @property groupId The id of the group.
 * @property memberRoleId The ID of a custom member role. Only available for Ultimate instances.
 * @property skipSubresourcesOnDestroy Whether the deletion of direct memberships of the removed member in subgroups and projects should be skipped. Only used during a destroy.
 * @property unassignIssuablesOnDestroy Whether the removed member should be unassigned from any issues or merge requests inside a given group or project. Only used during a destroy.
 * @property userId The id of the user.
 */
public data class GroupMembershipArgs(
    public val accessLevel: Output<String>? = null,
    public val expiresAt: Output<String>? = null,
    public val groupId: Output<String>? = null,
    public val memberRoleId: Output<Int>? = null,
    public val skipSubresourcesOnDestroy: Output<Boolean>? = null,
    public val unassignIssuablesOnDestroy: Output<Boolean>? = null,
    public val userId: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.GroupMembershipArgs> {
    override fun toJava(): com.pulumi.gitlab.GroupMembershipArgs =
        com.pulumi.gitlab.GroupMembershipArgs.builder()
            .accessLevel(accessLevel?.applyValue({ args0 -> args0 }))
            .expiresAt(expiresAt?.applyValue({ args0 -> args0 }))
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .memberRoleId(memberRoleId?.applyValue({ args0 -> args0 }))
            .skipSubresourcesOnDestroy(skipSubresourcesOnDestroy?.applyValue({ args0 -> args0 }))
            .unassignIssuablesOnDestroy(unassignIssuablesOnDestroy?.applyValue({ args0 -> args0 }))
            .userId(userId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupMembershipArgs].
 */
@PulumiTagMarker
public class GroupMembershipArgsBuilder internal constructor() {
    private var accessLevel: Output<String>? = null

    private var expiresAt: Output<String>? = null

    private var groupId: Output<String>? = null

    private var memberRoleId: Output<Int>? = null

    private var skipSubresourcesOnDestroy: Output<Boolean>? = null

    private var unassignIssuablesOnDestroy: Output<Boolean>? = null

    private var userId: Output<Int>? = null

    /**
     * @param value Access level for the member. Valid values are: `no one`, `minimal`, `guest`, `reporter`, `developer`, `maintainer`, `owner`.
     */
    @JvmName("ftqbfsylgqbrlwns")
    public suspend fun accessLevel(`value`: Output<String>) {
        this.accessLevel = value
    }

    /**
     * @param value Expiration date for the group membership. Format: `YYYY-MM-DD`
     */
    @JvmName("wnatobpawbwedqmm")
    public suspend fun expiresAt(`value`: Output<String>) {
        this.expiresAt = value
    }

    /**
     * @param value The id of the group.
     */
    @JvmName("ucxemiworqqxgnjv")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value The ID of a custom member role. Only available for Ultimate instances.
     */
    @JvmName("lmamieajmqqafrxm")
    public suspend fun memberRoleId(`value`: Output<Int>) {
        this.memberRoleId = value
    }

    /**
     * @param value Whether the deletion of direct memberships of the removed member in subgroups and projects should be skipped. Only used during a destroy.
     */
    @JvmName("uovadbcwokoglvfg")
    public suspend fun skipSubresourcesOnDestroy(`value`: Output<Boolean>) {
        this.skipSubresourcesOnDestroy = value
    }

    /**
     * @param value Whether the removed member should be unassigned from any issues or merge requests inside a given group or project. Only used during a destroy.
     */
    @JvmName("qxkchqtqfyviocsb")
    public suspend fun unassignIssuablesOnDestroy(`value`: Output<Boolean>) {
        this.unassignIssuablesOnDestroy = value
    }

    /**
     * @param value The id of the user.
     */
    @JvmName("bdiiaqailovrjdex")
    public suspend fun userId(`value`: Output<Int>) {
        this.userId = value
    }

    /**
     * @param value Access level for the member. Valid values are: `no one`, `minimal`, `guest`, `reporter`, `developer`, `maintainer`, `owner`.
     */
    @JvmName("ccyywboddnrtndck")
    public suspend fun accessLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessLevel = mapped
    }

    /**
     * @param value Expiration date for the group membership. Format: `YYYY-MM-DD`
     */
    @JvmName("yrdfjvofnrhfrulf")
    public suspend fun expiresAt(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiresAt = mapped
    }

    /**
     * @param value The id of the group.
     */
    @JvmName("clhftgqxbtysvhkf")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value The ID of a custom member role. Only available for Ultimate instances.
     */
    @JvmName("axvohggwwhctqicp")
    public suspend fun memberRoleId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memberRoleId = mapped
    }

    /**
     * @param value Whether the deletion of direct memberships of the removed member in subgroups and projects should be skipped. Only used during a destroy.
     */
    @JvmName("ptuteltbwgfuvvvs")
    public suspend fun skipSubresourcesOnDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipSubresourcesOnDestroy = mapped
    }

    /**
     * @param value Whether the removed member should be unassigned from any issues or merge requests inside a given group or project. Only used during a destroy.
     */
    @JvmName("rkkpsdorrvspasdl")
    public suspend fun unassignIssuablesOnDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unassignIssuablesOnDestroy = mapped
    }

    /**
     * @param value The id of the user.
     */
    @JvmName("oerhberohofmhjmo")
    public suspend fun userId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userId = mapped
    }

    internal fun build(): GroupMembershipArgs = GroupMembershipArgs(
        accessLevel = accessLevel,
        expiresAt = expiresAt,
        groupId = groupId,
        memberRoleId = memberRoleId,
        skipSubresourcesOnDestroy = skipSubresourcesOnDestroy,
        unassignIssuablesOnDestroy = unassignIssuablesOnDestroy,
        userId = userId,
    )
}
