@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [GroupProjectFileTemplate].
 */
@PulumiTagMarker
public class GroupProjectFileTemplateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GroupProjectFileTemplateArgs = GroupProjectFileTemplateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GroupProjectFileTemplateArgsBuilder.() -> Unit) {
        val builder = GroupProjectFileTemplateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GroupProjectFileTemplate {
        val builtJavaResource = com.pulumi.gitlab.GroupProjectFileTemplate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GroupProjectFileTemplate(builtJavaResource)
    }
}

/**
 * The `gitlab.GroupProjectFileTemplate` resource allows setting a project from which
 * custom file templates will be loaded. In order to use this resource, the project selected must be a direct child of
 * the group selected. After the resource has run, `gitlab_project_template.template_project_id` is available for use.
 * For more information about which file types are available as templates, view
 * [GitLab's documentation](https://docs.gitlab.com/ee/user/group/custom_project_templates.html)
 * > This resource requires a GitLab Enterprise instance with a Premium license.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/groups.html#update-group)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const foo = new gitlab.Group("foo", {
 *     name: "group",
 *     path: "group",
 *     description: "An example group",
 * });
 * const bar = new gitlab.Project("bar", {
 *     name: "template project",
 *     description: "contains file templates",
 *     visibilityLevel: "public",
 *     namespaceId: foo.id,
 * });
 * const templateLink = new gitlab.GroupProjectFileTemplate("template_link", {
 *     groupId: foo.id,
 *     fileTemplateProjectId: bar.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * foo = gitlab.Group("foo",
 *     name="group",
 *     path="group",
 *     description="An example group")
 * bar = gitlab.Project("bar",
 *     name="template project",
 *     description="contains file templates",
 *     visibility_level="public",
 *     namespace_id=foo.id)
 * template_link = gitlab.GroupProjectFileTemplate("template_link",
 *     group_id=foo.id,
 *     file_template_project_id=bar.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new GitLab.Group("foo", new()
 *     {
 *         Name = "group",
 *         Path = "group",
 *         Description = "An example group",
 *     });
 *     var bar = new GitLab.Project("bar", new()
 *     {
 *         Name = "template project",
 *         Description = "contains file templates",
 *         VisibilityLevel = "public",
 *         NamespaceId = foo.Id,
 *     });
 *     var templateLink = new GitLab.GroupProjectFileTemplate("template_link", new()
 *     {
 *         GroupId = foo.Id,
 *         FileTemplateProjectId = bar.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		foo, err := gitlab.NewGroup(ctx, "foo", &gitlab.GroupArgs{
 * 			Name:        pulumi.String("group"),
 * 			Path:        pulumi.String("group"),
 * 			Description: pulumi.String("An example group"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		bar, err := gitlab.NewProject(ctx, "bar", &gitlab.ProjectArgs{
 * 			Name:            pulumi.String("template project"),
 * 			Description:     pulumi.String("contains file templates"),
 * 			VisibilityLevel: pulumi.String("public"),
 * 			NamespaceId:     foo.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewGroupProjectFileTemplate(ctx, "template_link", &gitlab.GroupProjectFileTemplateArgs{
 * 			GroupId:               foo.ID(),
 * 			FileTemplateProjectId: bar.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Group;
 * import com.pulumi.gitlab.GroupArgs;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.GroupProjectFileTemplate;
 * import com.pulumi.gitlab.GroupProjectFileTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Group("foo", GroupArgs.builder()
 *             .name("group")
 *             .path("group")
 *             .description("An example group")
 *             .build());
 *         var bar = new Project("bar", ProjectArgs.builder()
 *             .name("template project")
 *             .description("contains file templates")
 *             .visibilityLevel("public")
 *             .namespaceId(foo.id())
 *             .build());
 *         var templateLink = new GroupProjectFileTemplate("templateLink", GroupProjectFileTemplateArgs.builder()
 *             .groupId(foo.id())
 *             .fileTemplateProjectId(bar.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: gitlab:Group
 *     properties:
 *       name: group
 *       path: group
 *       description: An example group
 *   bar:
 *     type: gitlab:Project
 *     properties:
 *       name: template project
 *       description: contains file templates
 *       visibilityLevel: public
 *       namespaceId: ${foo.id}
 *   templateLink:
 *     type: gitlab:GroupProjectFileTemplate
 *     name: template_link
 *     properties:
 *       groupId: ${foo.id}
 *       fileTemplateProjectId: ${bar.id}
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class GroupProjectFileTemplate internal constructor(
    override val javaResource: com.pulumi.gitlab.GroupProjectFileTemplate,
) : KotlinCustomResource(javaResource, GroupProjectFileTemplateMapper) {
    /**
     * The ID of the project that will be used for file templates. This project must be the direct
     * 			child of the project defined by the group_id
     */
    public val fileTemplateProjectId: Output<Int>
        get() = javaResource.fileTemplateProjectId().applyValue({ args0 -> args0 })

    /**
     * The ID of the group that will use the file template project. This group must be the direct
     *             parent of the project defined by project_id
     */
    public val groupId: Output<Int>
        get() = javaResource.groupId().applyValue({ args0 -> args0 })
}

public object GroupProjectFileTemplateMapper : ResourceMapper<GroupProjectFileTemplate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.gitlab.GroupProjectFileTemplate::class == javaResource::class

    override fun map(javaResource: Resource): GroupProjectFileTemplate =
        GroupProjectFileTemplate(javaResource as com.pulumi.gitlab.GroupProjectFileTemplate)
}

/**
 * @see [GroupProjectFileTemplate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GroupProjectFileTemplate].
 */
public suspend fun groupProjectFileTemplate(
    name: String,
    block: suspend GroupProjectFileTemplateResourceBuilder.() -> Unit,
): GroupProjectFileTemplate {
    val builder = GroupProjectFileTemplateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GroupProjectFileTemplate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun groupProjectFileTemplate(name: String): GroupProjectFileTemplate {
    val builder = GroupProjectFileTemplateResourceBuilder()
    builder.name(name)
    return builder.build()
}
