@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.gitlab.kotlin

import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.gitlab.GroupProjectFileTemplateArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The `gitlab.GroupProjectFileTemplate` resource allows setting a project from which
 * custom file templates will be loaded. In order to use this resource, the project selected must be a direct child of
 * the group selected. After the resource has run, `gitlab_project_template.template_project_id` is available for use.
 * For more information about which file types are available as templates, view
 * [GitLab's documentation](https://docs.gitlab.com/ee/user/group/custom_project_templates.html)
 * > This resource requires a GitLab Enterprise instance with a Premium license.
 * **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/ee/api/groups.html#update-group)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as gitlab from "@pulumi/gitlab";
 * const foo = new gitlab.Group("foo", {
 *     name: "group",
 *     path: "group",
 *     description: "An example group",
 * });
 * const bar = new gitlab.Project("bar", {
 *     name: "template project",
 *     description: "contains file templates",
 *     visibilityLevel: "public",
 *     namespaceId: foo.id,
 * });
 * const templateLink = new gitlab.GroupProjectFileTemplate("template_link", {
 *     groupId: foo.id,
 *     fileTemplateProjectId: bar.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_gitlab as gitlab
 * foo = gitlab.Group("foo",
 *     name="group",
 *     path="group",
 *     description="An example group")
 * bar = gitlab.Project("bar",
 *     name="template project",
 *     description="contains file templates",
 *     visibility_level="public",
 *     namespace_id=foo.id)
 * template_link = gitlab.GroupProjectFileTemplate("template_link",
 *     group_id=foo.id,
 *     file_template_project_id=bar.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using GitLab = Pulumi.GitLab;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new GitLab.Group("foo", new()
 *     {
 *         Name = "group",
 *         Path = "group",
 *         Description = "An example group",
 *     });
 *     var bar = new GitLab.Project("bar", new()
 *     {
 *         Name = "template project",
 *         Description = "contains file templates",
 *         VisibilityLevel = "public",
 *         NamespaceId = foo.Id,
 *     });
 *     var templateLink = new GitLab.GroupProjectFileTemplate("template_link", new()
 *     {
 *         GroupId = foo.Id,
 *         FileTemplateProjectId = bar.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-gitlab/sdk/v8/go/gitlab"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		foo, err := gitlab.NewGroup(ctx, "foo", &gitlab.GroupArgs{
 * 			Name:        pulumi.String("group"),
 * 			Path:        pulumi.String("group"),
 * 			Description: pulumi.String("An example group"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		bar, err := gitlab.NewProject(ctx, "bar", &gitlab.ProjectArgs{
 * 			Name:            pulumi.String("template project"),
 * 			Description:     pulumi.String("contains file templates"),
 * 			VisibilityLevel: pulumi.String("public"),
 * 			NamespaceId:     foo.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = gitlab.NewGroupProjectFileTemplate(ctx, "template_link", &gitlab.GroupProjectFileTemplateArgs{
 * 			GroupId:               foo.ID(),
 * 			FileTemplateProjectId: bar.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.gitlab.Group;
 * import com.pulumi.gitlab.GroupArgs;
 * import com.pulumi.gitlab.Project;
 * import com.pulumi.gitlab.ProjectArgs;
 * import com.pulumi.gitlab.GroupProjectFileTemplate;
 * import com.pulumi.gitlab.GroupProjectFileTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new Group("foo", GroupArgs.builder()
 *             .name("group")
 *             .path("group")
 *             .description("An example group")
 *             .build());
 *         var bar = new Project("bar", ProjectArgs.builder()
 *             .name("template project")
 *             .description("contains file templates")
 *             .visibilityLevel("public")
 *             .namespaceId(foo.id())
 *             .build());
 *         var templateLink = new GroupProjectFileTemplate("templateLink", GroupProjectFileTemplateArgs.builder()
 *             .groupId(foo.id())
 *             .fileTemplateProjectId(bar.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: gitlab:Group
 *     properties:
 *       name: group
 *       path: group
 *       description: An example group
 *   bar:
 *     type: gitlab:Project
 *     properties:
 *       name: template project
 *       description: contains file templates
 *       visibilityLevel: public
 *       namespaceId: ${foo.id}
 *   templateLink:
 *     type: gitlab:GroupProjectFileTemplate
 *     name: template_link
 *     properties:
 *       groupId: ${foo.id}
 *       fileTemplateProjectId: ${bar.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * @property fileTemplateProjectId The ID of the project that will be used for file templates. This project must be the direct
 * 			child of the project defined by the group_id
 * @property groupId The ID of the group that will use the file template project. This group must be the direct
 *             parent of the project defined by project_id
 */
public data class GroupProjectFileTemplateArgs(
    public val fileTemplateProjectId: Output<Int>? = null,
    public val groupId: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.gitlab.GroupProjectFileTemplateArgs> {
    override fun toJava(): com.pulumi.gitlab.GroupProjectFileTemplateArgs =
        com.pulumi.gitlab.GroupProjectFileTemplateArgs.builder()
            .fileTemplateProjectId(fileTemplateProjectId?.applyValue({ args0 -> args0 }))
            .groupId(groupId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupProjectFileTemplateArgs].
 */
@PulumiTagMarker
public class GroupProjectFileTemplateArgsBuilder internal constructor() {
    private var fileTemplateProjectId: Output<Int>? = null

    private var groupId: Output<Int>? = null

    /**
     * @param value The ID of the project that will be used for file templates. This project must be the direct
     * 			child of the project defined by the group_id
     */
    @JvmName("ivhxtomgsdmidtyc")
    public suspend fun fileTemplateProjectId(`value`: Output<Int>) {
        this.fileTemplateProjectId = value
    }

    /**
     * @param value The ID of the group that will use the file template project. This group must be the direct
     *             parent of the project defined by project_id
     */
    @JvmName("ooxmyvcumkiqyeaf")
    public suspend fun groupId(`value`: Output<Int>) {
        this.groupId = value
    }

    /**
     * @param value The ID of the project that will be used for file templates. This project must be the direct
     * 			child of the project defined by the group_id
     */
    @JvmName("ypgonnunmhfxuijh")
    public suspend fun fileTemplateProjectId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileTemplateProjectId = mapped
    }

    /**
     * @param value The ID of the group that will use the file template project. This group must be the direct
     *             parent of the project defined by project_id
     */
    @JvmName("fqwssumfmvayrxls")
    public suspend fun groupId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    internal fun build(): GroupProjectFileTemplateArgs = GroupProjectFileTemplateArgs(
        fileTemplateProjectId = fileTemplateProjectId,
        groupId = groupId,
    )
}
